/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.sqlscrapbook.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorConnectionInfo;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class AbstractConnectionInfoComposite
extends Composite {
    public static final int STYLE_CREATE_PROFILE = 1;
    public static final int STYLE_SHOW_STATUS = 2;
    public static final int STYLE_MULTI_LINE = 4;
    public static final int STYLE_SEPARATE_TYPE_NAME = 8;
    public static final int STYLE_SINGLE_GROUP = 16;
    public static final int STYLE_LABEL_GROUP = 32;
    public static final int STYLE_MUST_CONNECT = 64;
    public static final int STYLE_LAZY_INIT = 128;
    protected static final DatabaseVendorDefinitionId DATABASE_VENDOR_DEFINITION_ID = SQLToolsFacade.getNonSpecificDatabaseVendorDefinitionId();
    protected String _profileName = null;
    protected String _dbName = null;
    protected DatabaseVendorDefinitionId _dbVendorId = DATABASE_VENDOR_DEFINITION_ID;
    protected ISQLEditorConnectionInfo _connInfo = null;
    protected Listener _listener;
    protected int _style = 42;
    protected Collection _supportedDBDefinitionNames = null;
    protected Collection _supportedDBDefinitionIds = null;

    public AbstractConnectionInfoComposite(Composite parent, int style) {
        super(parent, style);
    }

    public AbstractConnectionInfoComposite(Composite parent, int style, Listener listener, ISQLEditorConnectionInfo connInfo, Collection supportedDBDefinitionNames, int infoStyle) {
        super(parent, style);
        if (connInfo != null) {
            this._profileName = connInfo.getConnectionProfileName();
            this._dbName = connInfo.getDatabaseName();
            this._dbVendorId = connInfo.getDatabaseVendorDefinitionId() == null ? DATABASE_VENDOR_DEFINITION_ID : connInfo.getDatabaseVendorDefinitionId();
        }
        this._listener = listener;
        this.setSupportedDBDefinitionNames(supportedDBDefinitionNames);
        this._style = infoStyle;
    }

    protected void updateFields() {
        this.readControlValues();
        this._connInfo = new SQLEditorConnectionInfo(this._dbVendorId, this._profileName, this._dbName);
    }

    protected void initDBNames() {
        this.getDbNamesControl().removeAll();
        if (this._profileName != null) {
            List list = ProfileUtil.getDatabaseList((String)this._profileName, (boolean)false);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String dbname = iterator.next().toString();
                this.getDbNamesControl().add(dbname);
            }
        }
        if (this._dbName != null) {
            if (this.getDbNamesControl().getItemCount() == 0) {
                this.getDbNamesControl().add(this._dbName);
            }
            this.getDbNamesControl().setText(this._dbName);
        }
        this.getDbNamesControl().add("", 0);
    }

    protected void readControlValues() {
        this._dbVendorId = this.getProfileTypeControl().getText() != null && !"".equals(this.getProfileTypeControl().getText()) ? new DatabaseVendorDefinitionId(this.getProfileTypeControl().getText()) : DATABASE_VENDOR_DEFINITION_ID;
        this._profileName = this.getProfileNamesControl().getText() != null && !"".equals(this.getProfileNamesControl().getText()) ? this.getProfileNamesControl().getText() : null;
        this._dbName = this.getDbNamesControl() != null && this.getDbNamesControl().getText() != null && !"".equals(this.getDbNamesControl().getText()) ? this.getDbNamesControl().getText() : null;
    }

    public void setInfoStyle(int style) {
        this._style = style;
    }

    public int getInfoStyle() {
        return this._style;
    }

    public ISQLEditorConnectionInfo getConnectionInfo() {
        return this._connInfo;
    }

    protected void notifyListener() {
        if (this._listener != null) {
            Event changeEvent = new Event();
            changeEvent.type = 13;
            changeEvent.widget = this;
            this._listener.handleEvent(changeEvent);
        }
    }

    public void init() {
        this.init(this._dbVendorId.toString(), this._profileName, this._dbName);
    }

    public void init(String dbVendorName, String initialProfName, String initialDBName) {
        this.setConnectionInfo(dbVendorName, initialProfName, initialDBName);
        if (this._supportedDBDefinitionNames == null) {
            this.setSupportedDBDefinitionNames(SQLToolsFacade.getAllAvailableDBDefinitionNames());
        }
        this.getProfileTypeControl().setItems(this._supportedDBDefinitionNames.toArray(new String[0]));
        this.getProfileTypeControl().add("", 0);
        if (this._profileName != null) {
            this.initTypebyProfile(this._profileName);
        } else if (this._supportedDBDefinitionNames.contains(this._dbVendorId.toString())) {
            this.getProfileTypeControl().setText(this._dbVendorId.toString());
        } else if (this._supportedDBDefinitionNames.size() > 0) {
            this.getProfileTypeControl().select(0);
        }
        this.initProfileNames(this._dbVendorId.toString(), this._profileName);
        IConnectionProfile connectionProfile = ProfileManager.getInstance().getProfileByName(this._profileName);
        if (ProfileUtil.isDatabaseProfile((IConnectionProfile)connectionProfile)) {
            this.getDbNamesControl().setEnabled(true);
        } else {
            this.getDbNamesControl().setEnabled(false);
        }
        this.initDBNames();
    }

    protected void initTypebyProfile(String profileName) {
        DatabaseVendorDefinitionId currentDbId;
        if (profileName == null || profileName.equals("")) {
            return;
        }
        DatabaseVendorDefinitionId cacheId = ProfileUtil.getDatabaseVendorDefinitionId((String)profileName, (boolean)true, (boolean)true);
        if (!cacheId.equals((Object)(currentDbId = new DatabaseVendorDefinitionId(this.getProfileTypeControl().getText())))) {
            DatabaseVendorDefinitionId matchId = this.findDatabaseVendorDefinitionId(cacheId);
            if (matchId != null) {
                this.getProfileTypeControl().setText(matchId.toString());
            } else {
                DatabaseVendorDefinitionId driverId = ProfileUtil.getDatabaseVendorDefinitionId((String)profileName, (boolean)false, (boolean)false);
                matchId = this.findDatabaseVendorDefinitionId(driverId);
                if (matchId != null) {
                    this.getProfileTypeControl().setText(matchId.toString());
                }
            }
        }
    }

    protected DatabaseVendorDefinitionId findDatabaseVendorDefinitionId(DatabaseVendorDefinitionId dbId) {
        String dbIdName = dbId.toString();
        Iterator it = this._supportedDBDefinitionIds.iterator();
        while (it.hasNext()) {
            DatabaseVendorDefinitionId existId = (DatabaseVendorDefinitionId)it.next();
            if (!existId.equals((Object)dbId)) continue;
            return existId;
        }
        return null;
    }

    protected void initProfileNames(String dbVendorName, String initialProfName) {
        ArrayList<String> rightProfiles = new ArrayList<String>();
        IConnectionProfile[] profiles = ProfileUtil.getProfiles();
        if (dbVendorName == null || dbVendorName.equals("") || dbVendorName.equals(DATABASE_VENDOR_DEFINITION_ID.toString())) {
            for (int i = 0; i < profiles.length; ++i) {
                rightProfiles.add(profiles[i].getName());
            }
        } else {
            DatabaseVendorDefinitionId selectedDbVendorId = new DatabaseVendorDefinitionId(dbVendorName);
            for (int i = 0; i < profiles.length; ++i) {
                DatabaseVendorDefinitionId cacheId = ProfileUtil.getDatabaseVendorDefinitionId((IConnectionProfile)profiles[i], (boolean)true, (boolean)true);
                DatabaseVendorDefinitionId driverId = ProfileUtil.getDatabaseVendorDefinitionId((IConnectionProfile)profiles[i], (boolean)false, (boolean)false);
                if (selectedDbVendorId.equals((Object)cacheId)) {
                    rightProfiles.add(profiles[i].getName());
                    continue;
                }
                if (!selectedDbVendorId.equals((Object)driverId) || this._supportedDBDefinitionIds.contains(cacheId)) continue;
                rightProfiles.add(profiles[i].getName());
            }
        }
        Collections.sort(rightProfiles);
        rightProfiles.add(0, new String(""));
        this.getProfileNamesControl().setItems(rightProfiles.toArray(new String[0]));
        if (initialProfName != null) {
            Iterator iter = rightProfiles.iterator();
            while (iter.hasNext()) {
                if (!iter.next().equals(initialProfName)) continue;
                this.getProfileNamesControl().setText(initialProfName);
                break;
            }
        }
    }

    protected void setConnectionInfo(String dbVendorName, String initialProfName, String initialDBName) {
        this._profileName = initialProfName;
        this._dbName = initialDBName;
        this._dbVendorId = dbVendorName == null ? DATABASE_VENDOR_DEFINITION_ID : new DatabaseVendorDefinitionId(dbVendorName);
        this._connInfo = new SQLEditorConnectionInfo(this._dbVendorId, this._profileName, this._dbName);
    }

    public abstract Combo getProfileTypeControl();

    public abstract Combo getProfileNamesControl();

    public abstract Button getCreateButton();

    public abstract Combo getDbNamesControl();

    protected String[] getCurrentProfileNames() {
        IConnectionProfile[] profiles = ProfileUtil.getProfiles();
        String[] currentNames = new String[profiles.length];
        for (int i = 0; i < profiles.length; ++i) {
            currentNames[i] = profiles[i].getName();
        }
        return currentNames;
    }

    protected String getNewProfileName(String[] currentNames, String[] newNames) {
        if (currentNames != null && newNames != null) {
            for (int i = 0; i < newNames.length; ++i) {
                boolean found = false;
                for (int j = 0; j < currentNames.length; ++j) {
                    if (!newNames[i].equals(currentNames[j])) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return newNames[i];
            }
        }
        if (currentNames == null && newNames != null && newNames.length > 0) {
            return newNames[0];
        }
        return null;
    }

    public void refreshConnectionStatus() {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.readControlValues();
        if (e.widget == this.getProfileTypeControl()) {
            this.initProfileNames(this.getProfileTypeControl().getText(), null);
        } else if (e.widget == this.getProfileNamesControl()) {
            this.initTypebyProfile(this._profileName);
            if (this.getProfileNamesControl().getSelectionIndex() != -1) {
                if (this.getDbNamesControl() != null) {
                    this.getDbNamesControl().removeAll();
                    this._dbName = null;
                    if (this._profileName != null) {
                        IConnectionProfile connectionProfile = ProfileManager.getInstance().getProfileByName(this._profileName);
                        if (ProfileUtil.isDatabaseProfile((IConnectionProfile)connectionProfile)) {
                            this.getDbNamesControl().setEnabled(true);
                        } else {
                            this.getDbNamesControl().setEnabled(false);
                        }
                    } else {
                        this.getDbNamesControl().setEnabled(false);
                    }
                }
            } else if (this.getDbNamesControl() != null) {
                this.getDbNamesControl().removeAll();
                this.getDbNamesControl().setEnabled(false);
            }
            if (this.getDbNamesControl() != null && this.getDbNamesControl().isEnabled()) {
                this.initDBNames();
            }
        }
        this.updateFields();
        this.notifyListener();
    }

    public void handleEvent(Event event) {
        if (event.widget == this.getCreateButton()) {
            SQLDevToolsConfiguration f = SQLToolsFacade.getConfigurationByVendorIdentifier((DatabaseVendorDefinitionId)this._dbVendorId);
            if (f == null) {
                return;
            }
            IWizard wizard = f.getUIComponentService().getProfileWizard();
            String[] currentNames = this.getCurrentProfileNames();
            WizardDialog dlg = new WizardDialog(this.getShell(), wizard);
            int id = dlg.open();
            if (id != 1) {
                String[] newNames = this.getCurrentProfileNames();
                String newProfile = this.getNewProfileName(currentNames, newNames);
                if (newProfile != null) {
                    ProfileUtil.connectProfile((String)newProfile);
                    this.init(this._dbVendorId.toString(), newProfile, null);
                    this.updateFields();
                }
                this.notifyListener();
            }
        }
    }

    protected void setSupportedDBDefinitionNames(Collection names) {
        if (names == null) {
            names = SQLToolsFacade.getAllAvailableDBDefinitionNames();
        }
        this._supportedDBDefinitionNames = names;
        this._supportedDBDefinitionIds = new HashSet();
        Iterator it = names.iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            DatabaseVendorDefinitionId id = new DatabaseVendorDefinitionId(name);
            this._supportedDBDefinitionIds.add(id);
        }
    }
}

