/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.preference;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.datatools.sqltools.result.export.IResultConstants;
import org.eclipse.datatools.sqltools.result.internal.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.datatools.sqltools.result.internal.utils.UIUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ExportFormatPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static String XML_EXPORT_FORMAT;
    private static String ADD_XML_HEADER;
    private static String XML_HEADER;
    private static String ADD_XML_ROOT_TAG;
    private static String XML_ROOT_TAG;
    private static String DEFAULT_COLUMN_DELIMITER;
    private static String OUTPUT_FORMAT;
    private static String DELIMINTER;
    private static String COLUMN_ALIGNED;
    private static String COMMA_SEPARATED;
    private static String TAB_DELIMITED;
    private static String USER_DEFINED;
    private static String DEFAULT_FILE_ENCODING;
    private static String DEFAULT_ENCODING;
    private static String DEFAULT_ENCODING_STR;
    private static String OTHER_ENCODING;
    private String[] OUTPUT_FORMATS = new String[]{COLUMN_ALIGNED, COMMA_SEPARATED, TAB_DELIMITED, USER_DEFINED};
    Button _addXMLHeader = null;
    Label _xmlHeaderLabel = null;
    Text _xmlHeader = null;
    Label _xmlRootTagLabel = null;
    Button _addXMLRootTag = null;
    Text _xmlRootTag = null;
    Combo _outputFormat = null;
    Label _outputFormatLabel = null;
    Text _delimiter = null;
    Label _delimiterLabel = null;
    Button _defaultEncoding = null;
    Button _otherEncoding = null;
    Combo _fileEncoding = null;

    public ExportFormatPreferencePage() {
        super(Messages.ExportFormatPage_title);
        this.setPreferenceStore(ResultsViewPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        this.createXMLExportFormat(parent);
        this.createDelimiterGroup(parent);
        this.createEncodingGroup(parent);
        this.initializeValues();
        this.updateEnablement();
        return new Composite(parent, 0);
    }

    private void createXMLExportFormat(Composite parent) {
        Group xmlGroup = UIUtil.createGroup(parent, XML_EXPORT_FORMAT, 2);
        this._addXMLHeader = UIUtil.createCheckBox((Composite)xmlGroup, ADD_XML_HEADER, 2);
        this._addXMLHeader.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportFormatPreferencePage.this.updateXMLExportFormatEnablement();
            }
        });
        this._xmlHeaderLabel = UIUtil.createLabel((Composite)xmlGroup, XML_HEADER, 1, 20);
        this._xmlHeader = UIUtil.createTextBox((Composite)xmlGroup, 1);
        this._xmlHeader.setEditable(false);
        this._xmlHeader.setLayoutData((Object)new GridData(768));
        this._addXMLRootTag = UIUtil.createCheckBox((Composite)xmlGroup, ADD_XML_ROOT_TAG, 2);
        this._addXMLRootTag.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportFormatPreferencePage.this.updateXMLExportFormatEnablement();
            }
        });
        this._xmlRootTagLabel = UIUtil.createLabel((Composite)xmlGroup, XML_ROOT_TAG, 1, 20);
        this._xmlRootTag = UIUtil.createTextBox((Composite)xmlGroup, 1);
        this._xmlRootTag.setLayoutData((Object)new GridData(768));
    }

    private void createDelimiterGroup(Composite parent) {
        Group delimiterGroup = UIUtil.createGroup(parent, DEFAULT_COLUMN_DELIMITER, 2);
        this._outputFormatLabel = UIUtil.createLabel((Composite)delimiterGroup, OUTPUT_FORMAT, 1);
        this._outputFormat = UIUtil.createCombo((Composite)delimiterGroup, this.OUTPUT_FORMATS, 1, 90);
        GridData gd = new GridData(768);
        this._outputFormat.setLayoutData((Object)gd);
        this._outputFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportFormatPreferencePage.this.updateDelimiter();
            }
        });
        this._delimiterLabel = UIUtil.createLabel((Composite)delimiterGroup, DELIMINTER, 1);
        this._delimiter = UIUtil.createTextBox((Composite)delimiterGroup, 1);
        gd = new GridData(768);
        this._delimiter.setLayoutData((Object)gd);
    }

    private void createEncodingGroup(Composite parent) {
        String enc;
        boolean isDefault;
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        GridData data = new GridData(768);
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setText(DEFAULT_FILE_ENCODING);
        group.setFont(font);
        SelectionAdapter buttonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportFormatPreferencePage.this.updateEncodingState(ExportFormatPreferencePage.this._defaultEncoding.getSelection());
            }
        };
        this._defaultEncoding = new Button((Composite)group, 16);
        String defaultEnc = DEFAULT_ENCODING_STR;
        this._defaultEncoding.setText(NLS.bind((String)DEFAULT_ENCODING, (Object[])new String[]{defaultEnc}));
        data = new GridData();
        data.horizontalSpan = 2;
        this._defaultEncoding.setLayoutData((Object)data);
        this._defaultEncoding.addSelectionListener((SelectionListener)buttonListener);
        this._defaultEncoding.setFont(font);
        this._otherEncoding = new Button((Composite)group, 16);
        this._otherEncoding.setText(OTHER_ENCODING);
        this._otherEncoding.addSelectionListener((SelectionListener)buttonListener);
        this._otherEncoding.setFont(font);
        this._fileEncoding = new Combo((Composite)group, 0);
        data = new GridData();
        data.widthHint = this.convertWidthInCharsToPixels(15);
        this._fileEncoding.setFont(font);
        this._fileEncoding.setLayoutData((Object)data);
        this._fileEncoding.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportFormatPreferencePage.this.updateValidState();
                if (!ExportFormatPreferencePage.this._defaultEncoding.getSelection()) {
                    String xmlHeaderFormat = Messages.ExportFormatPage_xmlexportformat_xmlheader_text;
                    String xmlHeader = NLS.bind((String)xmlHeaderFormat, (Object[])new String[]{ExportFormatPreferencePage.this._fileEncoding.getText()});
                    ExportFormatPreferencePage.this._xmlHeader.setText(xmlHeader);
                }
            }
        });
        this._fileEncoding.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String xmlHeaderFormat = Messages.ExportFormatPage_xmlexportformat_xmlheader_text;
                String xmlHeader = NLS.bind((String)xmlHeaderFormat, (Object[])new String[]{ExportFormatPreferencePage.this._fileEncoding.getText()});
                ExportFormatPreferencePage.this._xmlHeader.setText(xmlHeader);
            }
        });
        ArrayList<String> encodings = new ArrayList<String>();
        int n = 0;
        try {
            n = Integer.parseInt(Messages.ExportFormatPage_fileencoding_numDefaultEncodings);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        for (int i = 0; i < n; ++i) {
            String enc2 = Messages.getString("ExportFormatPage_fileencoding_defaultEncoding" + (i + 1));
            if (enc2 == null) continue;
            encodings.add(enc2);
        }
        if (!encodings.contains(defaultEnc)) {
            encodings.add(defaultEnc);
        }
        boolean bl = isDefault = (enc = this.getPreferenceStore().getString("org.eclipse.datatools.sqltools.result.preferences.exportformat.pref_encoding")) == null || enc.length() == 0;
        if (!isDefault && !encodings.contains(enc)) {
            encodings.add(enc);
        }
        Collections.sort(encodings);
        for (int i = 0; i < encodings.size(); ++i) {
            this._fileEncoding.add((String)encodings.get(i));
        }
        this._fileEncoding.setText(isDefault ? defaultEnc : enc);
        this.updateEncodingState(isDefault);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return ResultsViewPlugin.getDefault().getPreferenceStore();
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore store = this.getPreferenceStore();
        this._addXMLHeader.setSelection(store.getDefaultBoolean("org.eclipse.datatools.sqltools.result.preferences.exportformat.addxmlheader"));
        this._xmlHeader.setText(store.getDefaultString("org.eclipse.datatools.sqltools.result.preferences.exportformat.xmlheader"));
        this._addXMLRootTag.setSelection(store.getDefaultBoolean("org.eclipse.datatools.sqltools.result.preferences.exportformat.addxmlroottag"));
        this._xmlRootTag.setText(store.getDefaultString("org.eclipse.datatools.sqltools.result.preferences.exportformat.xmlroottag"));
        this._outputFormat.select(store.getDefaultInt("org.eclipse.datatools.sqltools.result.preferences.exportformat.outputformat"));
        this._delimiter.setText(store.getDefaultString("org.eclipse.datatools.sqltools.result.preferences.exportformat.delimiter"));
        this._defaultEncoding.setSelection(store.getDefaultBoolean("org.eclipse.datatools.sqltools.result.preferences.exportformat.defalut"));
        this._otherEncoding.setSelection(store.getDefaultBoolean("org.eclipse.datatools.sqltools.result.preferences.exportformat.other"));
        this._fileEncoding.select(store.getDefaultInt("org.eclipse.datatools.sqltools.result.preferences.exportformat.other.selection"));
        store.setValue("org.eclipse.datatools.sqltools.result.preferences.exportformat.delimiter", IResultConstants.DEFAULT_USER_DEFINED_DEMILITER);
        this.updateEnablement();
    }

    private void updateEnablement() {
        this.updateXMLExportFormatEnablement();
        this.updateDelimiter();
        this.updateEncodingEnablement();
    }

    private void updateXMLExportFormatEnablement() {
        boolean enabled = this._addXMLHeader.getSelection();
        this._xmlHeader.setEnabled(enabled);
        this._xmlHeaderLabel.setEnabled(enabled);
        enabled = this._addXMLRootTag.getSelection();
        this._xmlRootTag.setEnabled(enabled);
        this._xmlRootTagLabel.setEnabled(enabled);
    }

    private void updateDelimiter() {
        int delimiterIndex = this._outputFormat.getSelectionIndex();
        switch (delimiterIndex) {
            case 0: {
                this._delimiter.setEditable(false);
                this._delimiter.setTextLimit(20);
                this._delimiter.setText("<column>");
                break;
            }
            case 1: {
                this._delimiter.setText(",");
                this._delimiter.setEditable(false);
                break;
            }
            case 2: {
                this._delimiter.setEditable(false);
                this._delimiter.setTextLimit(20);
                this._delimiter.setText("<tab>");
                break;
            }
            case 3: {
                this._delimiter.setEditable(true);
                this._delimiter.setTextLimit(5);
                this._delimiter.setText(ResultsViewPlugin.getDefault().getPreferenceStore().getString("org.eclipse.datatools.sqltools.result.preferences.exportformat.delimiter"));
                break;
            }
            default: {
                this._delimiter.setEditable(true);
                this._delimiter.setTextLimit(20);
                this._delimiter.setText("<column>");
            }
        }
    }

    private void updateEncodingEnablement() {
        boolean enabled = this._defaultEncoding.getSelection();
        this._fileEncoding.setEnabled(!enabled);
    }

    private void updateEncodingState(boolean useDefault) {
        this._defaultEncoding.setSelection(useDefault);
        this._otherEncoding.setSelection(!useDefault);
        this._fileEncoding.setEnabled(!useDefault);
        if (useDefault) {
            String xmlHeaderFormat = Messages.ExportFormatPage_xmlexportformat_xmlheader_text;
            String xmlHeader = NLS.bind((String)xmlHeaderFormat, (Object[])new String[]{DEFAULT_ENCODING_STR});
            this._xmlHeader.setText(xmlHeader);
        } else {
            String xmlHeaderFormat = Messages.ExportFormatPage_xmlexportformat_xmlheader_text;
            String xmlHeader = NLS.bind((String)xmlHeaderFormat, (Object[])new String[]{this._fileEncoding.getText()});
            this._xmlHeader.setText(xmlHeader);
        }
    }

    public void init(IWorkbench workbench) {
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this._addXMLHeader.setSelection(store.getBoolean("org.eclipse.datatools.sqltools.result.preferences.exportformat.addxmlheader"));
        this._xmlHeader.setText(store.getString("org.eclipse.datatools.sqltools.result.preferences.exportformat.xmlheader"));
        this._addXMLRootTag.setSelection(store.getBoolean("org.eclipse.datatools.sqltools.result.preferences.exportformat.addxmlroottag"));
        this._xmlRootTag.setText(store.getString("org.eclipse.datatools.sqltools.result.preferences.exportformat.xmlroottag"));
        this._outputFormat.select(store.getInt("org.eclipse.datatools.sqltools.result.preferences.exportformat.outputformat"));
        this._delimiter.setText(store.getString("org.eclipse.datatools.sqltools.result.preferences.exportformat.delimiter"));
        this._otherEncoding.setSelection(store.getBoolean("org.eclipse.datatools.sqltools.result.preferences.exportformat.other"));
        this._fileEncoding.select(store.getInt("org.eclipse.datatools.sqltools.result.preferences.exportformat.other.selection"));
        this._defaultEncoding.setSelection(store.getBoolean("org.eclipse.datatools.sqltools.result.preferences.exportformat.defalut"));
        this._xmlHeader.setText(store.getString("org.eclipse.datatools.sqltools.result.preferences.exportformat.xmlheader"));
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("org.eclipse.datatools.sqltools.result.preferences.exportformat.addxmlheader", this._addXMLHeader.getSelection());
        store.setValue("org.eclipse.datatools.sqltools.result.preferences.exportformat.xmlheader", this._xmlHeader.getText());
        store.setValue("org.eclipse.datatools.sqltools.result.preferences.exportformat.addxmlroottag", this._addXMLRootTag.getSelection());
        store.setValue("org.eclipse.datatools.sqltools.result.preferences.exportformat.xmlroottag", this._xmlRootTag.getText());
        store.setValue("org.eclipse.datatools.sqltools.result.preferences.exportformat.outputformat", this._outputFormat.getSelectionIndex());
        if (this._outputFormat.getText().equals(USER_DEFINED)) {
            store.setValue("org.eclipse.datatools.sqltools.result.preferences.exportformat.delimiter", this._delimiter.getText());
        }
        store.setValue("org.eclipse.datatools.sqltools.result.preferences.exportformat.defalut", this._defaultEncoding.getSelection());
        store.setValue("org.eclipse.datatools.sqltools.result.preferences.exportformat.other", this._otherEncoding.getSelection());
        store.setValue("org.eclipse.datatools.sqltools.result.preferences.exportformat.other.selection", this._fileEncoding.getSelectionIndex());
        store.setValue("org.eclipse.datatools.sqltools.result.preferences.exportformat.pref_encoding", this._fileEncoding.getText());
        if (this._defaultEncoding.getSelection()) {
            store.setValue("org.eclipse.datatools.sqltools.result.preferences.exportformat.pref_encoding", DEFAULT_ENCODING_STR);
        }
        return super.performOk();
    }

    protected void updateValidState() {
        if (!this.isEncodingValid()) {
            this.setErrorMessage(Messages.ExportFormatPage_fileencoding_unsupportedEncoding);
            this.setValid(false);
        } else {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }

    private boolean isEncodingValid() {
        return this._defaultEncoding.getSelection() || this.isValidEncoding(this._fileEncoding.getText());
    }

    private boolean isValidEncoding(String enc) {
        try {
            new String(new byte[0], enc);
            return true;
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
    }

    static {
        DEFAULT_ENCODING_STR = "UTF-8";
        XML_EXPORT_FORMAT = Messages.ExportFormatPage_xmlexportformat_group;
        ADD_XML_HEADER = Messages.ExportFormatPage_xmlexportformat_addxmlheader;
        XML_HEADER = Messages.ExportFormatPage_xmlexportformat_xmlheader;
        ADD_XML_ROOT_TAG = Messages.ExportFormatPage_xmlexportformat_addxmlroottag;
        XML_ROOT_TAG = Messages.ExportFormatPage_xmlexportformat_xmlroottag;
        DEFAULT_COLUMN_DELIMITER = Messages.ExportFormatPage_columndelimiter_group;
        OUTPUT_FORMAT = Messages.ExportFormatPage_columndelimiter_outputformat;
        DELIMINTER = Messages.ExportFormatPage_columndelimiter_delimiter;
        COLUMN_ALIGNED = Messages.ExportFormatPage_columndelimiter_items_columnaligned;
        COMMA_SEPARATED = Messages.ExportFormatPage_columndelimiter_items_commaseparated;
        TAB_DELIMITED = Messages.ExportFormatPage_columndelimiter_items_tabdelimited;
        USER_DEFINED = Messages.ExportFormatPage_columndelimiter_items_userdefined;
        DEFAULT_FILE_ENCODING = Messages.ExportFormatPage_fileencoding_group;
        DEFAULT_ENCODING = Messages.ExportFormatPage_fileencoding_defaultencoding;
        OTHER_ENCODING = Messages.ExportFormatPage_fileencoding_otherencoding;
    }
}

