/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.export;

import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.export.AbstractOutputter;
import org.eclipse.datatools.sqltools.result.export.IResultConstants;
import org.eclipse.datatools.sqltools.result.internal.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.ui.export.ResultFormatWizardPage;
import org.eclipse.datatools.sqltools.result.internal.utils.Images;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class ResultExportWizard
extends Wizard {
    ResultFormatWizardPage _formatPage;
    IResultSetObject _resultObject;
    IResultInstance _instance;

    public ResultExportWizard(IResultSetObject result) {
        this._resultObject = result;
        this.setWindowTitle(Messages.ResultExportWizard_exportResult_title);
        this._formatPage = new ResultFormatWizardPage(result);
        this._formatPage.setImageDescriptor(Images.DESC_EXPORT_RESULT);
    }

    public ResultExportWizard(IResultInstance result) {
        this._instance = result;
        this.setWindowTitle(Messages.ResultExportWizard_exportAllResults_title);
        this._formatPage = new ResultFormatWizardPage(result);
    }

    public void addPages() {
        this._formatPage.setImageDescriptor(Images.DESC_EXPORT_RESULT);
        this.addPage((IWizardPage)this._formatPage);
    }

    public boolean performFinish() {
        final String pathName = this._formatPage.getFileName();
        if (pathName == null || pathName.length() < 1) {
            return false;
        }
        IPath path = new Path(pathName).makeAbsolute();
        if (path.toFile().exists()) {
            String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
            String question = NLS.bind((String)Messages.ResultExportWizard_overwrite, (Object[])new Object[]{path.toOSString()});
            MessageDialog d = new MessageDialog(this.getShell(), Messages.ResultExportWizard_question, null, question, 3, buttons, 0);
            int overwrite = d.open();
            switch (overwrite) {
                case 0: {
                    break;
                }
                case 1: {
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        try {
            Runnable exportRunnable;
            final Properties options = new Properties();
            final AbstractOutputter outputter = this._formatPage.getOutputterDesp().getOutputter();
            if (this._formatPage.getDelimiter().equals(IResultConstants.USER_DEFINED)) {
                options.setProperty("userdefined_delimiter", this._formatPage.getUserDefinedDelimiter());
            }
            options.setProperty("delimiter", this._formatPage.getDelimiter());
            options.setProperty("encoding", this._formatPage.getEncoding());
            if (this._resultObject != null) {
                exportRunnable = new Runnable(){

                    public void run() {
                        try {
                            outputter.output(ResultExportWizard.this._resultObject, options, pathName);
                        }
                        catch (Exception e) {
                            ResultExportWizard.this.getContainer().getShell().getDisplay().syncExec(new Runnable(this, e){
                                private final /* synthetic */ Exception val$e;
                                private final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$e = val$e;
                                }

                                public void run() {
                                    ErrorDialog.openError((Shell)1.access$000(this.this$1).getShell(), (String)Messages.ResultExportWizard_export_error, (String)Messages.ResultExportWizard_failed_to_export_result_set, (IStatus)new Status(4, ResultsViewPlugin.getPluginId(), 0, this.val$e.getMessage(), (Throwable)this.val$e));
                                }
                            });
                        }
                    }

                    static /* synthetic */ ResultExportWizard access$000(1 x0) {
                        return x0.ResultExportWizard.this;
                    }
                };
                Thread exportThread = new Thread(exportRunnable);
                exportThread.start();
            }
            if (this._instance != null) {
                exportRunnable = new Runnable(){

                    public void run() {
                        try {
                            outputter.output(ResultExportWizard.this._instance, options, pathName);
                        }
                        catch (Exception e) {
                            ResultExportWizard.this.getContainer().getShell().getDisplay().syncExec(new Runnable(this, e){
                                private final /* synthetic */ Exception val$e;
                                private final /* synthetic */ 3 this$1;
                                {
                                    this.this$1 = this$1;
                                    this.val$e = val$e;
                                }

                                public void run() {
                                    ErrorDialog.openError((Shell)3.access$100(this.this$1).getShell(), (String)Messages.ResultExportWizard_export_error, (String)Messages.ResultExportWizard_failed_to_export_result_set, (IStatus)new Status(4, ResultsViewPlugin.getPluginId(), 0, this.val$e.getMessage(), (Throwable)this.val$e));
                                }
                            });
                        }
                    }

                    static /* synthetic */ ResultExportWizard access$100(3 x0) {
                        return x0.ResultExportWizard.this;
                    }
                };
                Thread exportThread = new Thread(exportRunnable);
                exportThread.start();
            }
            return true;
        }
        catch (Exception ex) {
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ResultExportWizard_export_error, (String)Messages.ResultExportWizard_failed_to_export_result_set, (IStatus)new Status(4, ResultsViewPlugin.getPluginId(), 0, ex.getMessage(), (Throwable)ex));
            return false;
        }
    }

    class ExportJob
    extends Job {
        public ExportJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            return null;
        }
    }
}

