/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core.dbitem;

import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;

public class ParameterDescriptor {
    String _name;
    String _typeName;
    String _comment;
    int _sqlDataType;
    short _nullable;
    int _parmType;
    int _precision;
    short _scale;
    DatabaseIdentifier _databaseIdentifier;
    String _defaultValue;
    String _sqlTypeNameFromParser;

    public ParameterDescriptor(DatabaseIdentifier databaseIdentifier, String name, int parmType, int sqlDataType, int precision, short scale, String typeName, short nullable, String comment) {
        this._name = name;
        this._parmType = parmType;
        this._sqlDataType = sqlDataType;
        this._typeName = typeName;
        this._nullable = nullable;
        this._comment = comment;
        this._precision = precision;
        this._scale = scale;
        this._databaseIdentifier = databaseIdentifier;
    }

    public String getName() {
        return this._name;
    }

    protected int getNullable() {
        return this._nullable;
    }

    public boolean canBeNull() {
        return this._nullable != 0;
    }

    public int getParmType() {
        return this._parmType;
    }

    public void setParmType(int paramType) {
        this._parmType = paramType;
    }

    public int getSqlDataType() {
        return this._sqlDataType;
    }

    public String getTypeName() {
        return this._typeName;
    }

    public int getPrecision() {
        return this._precision;
    }

    public short getScale() {
        return this._scale;
    }

    public String getParamTypeAsString() {
        switch (this._parmType) {
            case 1: {
                return "INPUT";
            }
            case 2: {
                return "IN/OUT";
            }
            case 4: {
                return "OUTPUT";
            }
            case 3: {
                return "RESULT";
            }
            case 5: {
                return "RETURN";
            }
        }
        return "UNKNOWN";
    }

    public boolean isStringType() {
        return this._sqlDataType == 1 || this._sqlDataType == 12 || this._sqlDataType == -1 || this._sqlDataType == 91 || this._sqlDataType == 92 || this._sqlDataType == 93;
    }

    public boolean isOutput() {
        return this._parmType == 4 || this._parmType == 5;
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    public void setDefaultValue(String value) {
        this._defaultValue = value;
    }

    public DatabaseIdentifier getDatabaseIdentifier() {
        return this._databaseIdentifier;
    }

    public String getSqlTypeNameFromParser() {
        return this._sqlTypeNameFromParser;
    }

    public void setSqlTypeNameFromParser(String typeNameFromParser) {
        this._sqlTypeNameFromParser = typeNameFromParser;
    }
}

