/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.sqlscrapbook.connection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.db.generic.ui.NewConnectionProfileWizard;
import org.eclipse.datatools.sqltools.common.ui.util.SWTUtils;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.connection.Messages;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorConnectionInfo;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ConnectionInfoGroup
extends Composite
implements SelectionListener,
Listener {
    private Label _labelName = null;
    private Combo _comboProfileName = null;
    private Combo _comboType = null;
    private Label _labelType = null;
    private Label _labelDbName = null;
    private Combo _combodbName = null;
    private Button _checkBoxConnect = null;
    private Text _textWarning = null;
    private Button _create = null;
    private String _profileName = null;
    private String _dbName = null;
    private DatabaseVendorDefinitionId _dbVendorId = SQLDevToolsConfiguration.getDefaultInstance().getDatabaseVendorDefinitionId();
    private boolean _isConnected = false;
    private boolean _showWarning = true;
    private boolean _mustConnect = true;
    private Listener _listener;
    private ISQLEditorConnectionInfo _connInfo = null;

    public ConnectionInfoGroup(Composite parent, Listener listener, boolean showWarning) {
        this(parent, listener, null, null, showWarning, false);
    }

    public ConnectionInfoGroup(Composite parent, Listener listener, String profileName, String dbName, boolean showWarning, boolean mustConnect) {
        this(parent, listener, null, showWarning, false);
    }

    public ConnectionInfoGroup(Composite parent, Listener listener, ISQLEditorConnectionInfo connInfo, boolean showWarning, boolean mustConnect) {
        super(parent, 0);
        if (connInfo != null) {
            this._profileName = connInfo.getConnectionProfileName();
            this._dbName = connInfo.getDatabaseName();
            this._dbVendorId = connInfo.getDatabaseVendorDefinitionId();
        }
        this._listener = listener;
        this._showWarning = showWarning;
        this._mustConnect = mustConnect;
        this.createContents();
        this.updateFields();
    }

    public ISQLEditorConnectionInfo getConnectionInfo() {
        return this._connInfo;
    }

    public boolean isConnected() {
        return this._isConnected;
    }

    protected Control createContents() {
        GridLayout gridLayout1 = new GridLayout();
        GridLayout gridLayout2 = new GridLayout();
        GridData gridData2 = new GridData();
        GridData gridData3 = new GridData();
        GridData gridData6 = new GridData();
        this.setLayoutData(new GridData(1808));
        gridLayout1.marginWidth = 0;
        gridLayout1.numColumns = 2;
        this.setLayout((Layout)gridLayout1);
        this._labelType = new Label((Composite)this, 0);
        this._labelType.setText(Messages.SelectProfileDialog_profile_type);
        this.createComboType(this);
        this._labelName = new Label((Composite)this, 0);
        this._labelName.setText(Messages.SelectProfileDialog_profile_name);
        this.createComboProfileName(this);
        this._labelDbName = new Label((Composite)this, 0);
        this._labelDbName.setText(Messages.ConnectionInfoGroup_database_name);
        this.createComboDbName(this);
        if (!this._mustConnect) {
            this._checkBoxConnect = new Button((Composite)this, 32);
            gridData2.horizontalSpan = 2;
            this._checkBoxConnect.setLayoutData((Object)gridData2);
            this._checkBoxConnect.setText(Messages.SelectProfileDialog_donot_connect);
            this._checkBoxConnect.addListener(13, (Listener)this);
            if (this._listener != null) {
                this._checkBoxConnect.addListener(13, this._listener);
            }
        }
        if (this._showWarning) {
            this._textWarning = new Text((Composite)this, 66);
            gridData6.grabExcessHorizontalSpace = true;
            gridData6.horizontalAlignment = 4;
            gridData6.verticalAlignment = 2;
            gridData6.horizontalSpan = 2;
            gridData6.verticalSpan = 2;
            this._textWarning.setLayoutData((Object)gridData6);
            this._textWarning.setEditable(false);
            this._textWarning.setText(Messages.SelectProfileDialog_warning);
            this._textWarning.setVisible(false);
            this.setSize(new Point(460, 469));
        }
        return this;
    }

    public void finish() {
        this.updateFields();
        if (!this.canFinish()) {
            return;
        }
        this._connInfo = new SQLEditorConnectionInfo(this._dbVendorId, this._profileName, this._dbName);
        if (!this._mustConnect && this._checkBoxConnect.getSelection()) {
            this._isConnected = false;
        } else if (!SWTUtils.notEmpty((Combo)this._comboProfileName)) {
            this._isConnected = false;
        } else {
            IConnectionProfile profile = ProfileManager.getInstance().getProfileByName(this._profileName);
            if (profile == null) {
                return;
            }
            try {
                ProfileUtil.getReusableConnection((DatabaseIdentifier)new DatabaseIdentifier(this._profileName, this._dbName));
                this._isConnected = true;
            }
            catch (Exception e) {
                String statusmsg = e.getMessage();
                if (statusmsg == null) {
                    statusmsg = "";
                }
                Status status = new Status(4, "org.eclipse.datatools.sqltools.editor.core", 0, statusmsg, (Throwable)e);
                Shell shell = this.getShell();
                String title = Messages.SelectProfileDialog_error_jdbc_title;
                String msg = Messages.SelectProfileDialog_error_jdbc_message;
                ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)status);
                return;
            }
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this._comboType) {
            this.refreshProfileNames(this._comboType.getText(), null);
        } else if (e.widget == this._comboProfileName) {
            this.canFinish();
        }
        this.updateFields();
        this.notifyListener();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void handleEvent(Event event) {
        if (event.widget == this._create) {
            SQLDevToolsConfiguration f = SQLToolsFacade.getConfigurationByDBDefName((String)this._comboType.getText());
            if (f == null) {
                return;
            }
            NewConnectionProfileWizard wizard = new NewConnectionProfileWizard();
            String[] currentNames = this.getCurrentProfileNames();
            WizardDialog dlg = new WizardDialog(this.getShell(), (IWizard)wizard);
            int id = dlg.open();
            if (id != 1) {
                String[] newNames = this.getCurrentProfileNames();
                String newProfile = this.getNewProfileName(currentNames, newNames);
                if (newProfile != null) {
                    this.selectTypebyProfile(newProfile);
                    this.refreshProfileNames(this._comboType.getText(), newProfile);
                    this.canFinish();
                }
                this.notifyListener();
            }
        } else if (event.widget == this._checkBoxConnect) {
            boolean bl = this._isConnected = !this._checkBoxConnect.getSelection();
            if (this._showWarning) {
                this._textWarning.setVisible(this._checkBoxConnect.getSelection());
            }
        }
    }

    public boolean canFinish() {
        IConnectionProfile connectionProfile = ProfileManager.getInstance().getProfileByName(this._profileName);
        if (SWTUtils.notEmpty((Combo)this._comboType) && !SWTUtils.notEmpty((Combo)this._comboProfileName)) {
            return true;
        }
        if (SWTUtils.notEmpty((Combo)this._comboProfileName) && SWTUtils.notEmpty((Combo)this._combodbName)) {
            return true;
        }
        return SWTUtils.notEmpty((Combo)this._comboType) && !ProfileUtil.isDatabaseProfile((IConnectionProfile)connectionProfile);
    }

    public String getWarning() {
        if (!this._mustConnect && this._checkBoxConnect.getSelection()) {
            return Messages.SelectProfileDialog_warning;
        }
        return null;
    }

    private String getNewProfileName(String[] currentNames, String[] newNames) {
        if (currentNames != null && newNames != null) {
            for (int i = 0; i < newNames.length; ++i) {
                boolean found = false;
                for (int j = 0; j < currentNames.length; ++j) {
                    if (!newNames[i].equals(currentNames[j])) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return newNames[i];
            }
        }
        if (currentNames == null && newNames != null && newNames.length > 0) {
            return newNames[0];
        }
        return null;
    }

    private String[] getCurrentProfileNames() {
        IConnectionProfile[] profiles = ProfileManager.getInstance().getProfiles();
        String[] currentNames = new String[profiles.length];
        for (int i = 0; i < profiles.length; ++i) {
            currentNames[i] = profiles[i].getName();
        }
        return currentNames;
    }

    private void updateFields() {
        if (this._comboType.getText() != null && !"".equals(this._comboType.getText())) {
            this._dbVendorId = new DatabaseVendorDefinitionId(this._comboType.getText());
        }
        this._profileName = this._comboProfileName.getText() != null && !"".equals(this._comboProfileName.getText()) ? this._comboProfileName.getText() : null;
        if (this._combodbName != null && this._combodbName.getText() != null && !"".equals(this._combodbName.getText())) {
            this._dbName = this._combodbName.getText();
        }
    }

    private void notifyListener() {
        if (this._listener != null) {
            Event changeEvent = new Event();
            changeEvent.type = 13;
            changeEvent.widget = this;
            this._listener.handleEvent(changeEvent);
        }
    }

    private void createComboProfileName(Composite composite) {
        GridData gridData5 = new GridData();
        this._comboProfileName = new Combo(composite, 8);
        gridData5.horizontalAlignment = 4;
        gridData5.verticalAlignment = 2;
        gridData5.grabExcessHorizontalSpace = true;
        this._comboProfileName.setLayoutData((Object)gridData5);
        this._comboProfileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ConnectionInfoGroup.this._comboProfileName.getSelectionIndex() != -1) {
                    if (ConnectionInfoGroup.this._combodbName != null) {
                        ConnectionInfoGroup.this._combodbName.removeAll();
                        String profileName = ConnectionInfoGroup.this._comboProfileName.getText();
                        IConnectionProfile connectionProfile = ProfileManager.getInstance().getProfileByName(profileName);
                        if (ProfileUtil.isDatabaseProfile((IConnectionProfile)connectionProfile)) {
                            ConnectionInfoGroup.this._combodbName.setEnabled(true);
                        } else {
                            ConnectionInfoGroup.this._combodbName.setEnabled(false);
                        }
                    }
                } else if (ConnectionInfoGroup.this._combodbName != null) {
                    ConnectionInfoGroup.this._combodbName.removeAll();
                    ConnectionInfoGroup.this._combodbName.setEnabled(false);
                }
            }
        });
        this.refreshProfileNames(this._comboType.getText(), this._profileName);
        this._comboProfileName.addSelectionListener((SelectionListener)this);
    }

    private void createComboDbName(Composite composite) {
        GridData gridData5 = new GridData();
        this._combodbName = new Combo(composite, 0);
        gridData5.horizontalAlignment = 4;
        gridData5.verticalAlignment = 2;
        gridData5.grabExcessHorizontalSpace = true;
        this._combodbName.setVisibleItemCount(20);
        this._combodbName.setLayoutData((Object)gridData5);
        if (this._comboProfileName.getSelectionIndex() == -1) {
            this._combodbName.setEnabled(false);
        }
        this._combodbName.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ConnectionInfoGroup.this._combodbName.removeAll();
                String profileName = ConnectionInfoGroup.this._comboProfileName.getText();
                if (profileName != null) {
                    ConnectionInfoGroup.this._combodbName.removeAll();
                    List list = ProfileUtil.getDatabaseList((String)profileName);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        String dbname = iterator.next().toString();
                        ConnectionInfoGroup.this._combodbName.add(dbname);
                    }
                }
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this._combodbName.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                ConnectionInfoGroup.this.updateFields();
                ConnectionInfoGroup.this.notifyListener();
            }
        });
        String profileName = this._comboProfileName.getText();
        if (profileName != null) {
            IConnectionProfile connectionProfile = ProfileManager.getInstance().getProfileByName(profileName);
            if (ProfileUtil.isDatabaseProfile((IConnectionProfile)connectionProfile)) {
                this._combodbName.setEnabled(true);
            } else {
                this._combodbName.setEnabled(false);
            }
        }
        this._combodbName.addSelectionListener((SelectionListener)this);
        if (this._dbName != null) {
            this._combodbName.add(this._dbName);
            this._combodbName.setText(this._dbName);
        }
    }

    private void createComboType(Composite composite) {
        GridData gridData4 = new GridData();
        this._comboType = new Combo(composite, 8);
        gridData4.horizontalAlignment = 4;
        gridData4.verticalAlignment = 2;
        gridData4.grabExcessHorizontalSpace = true;
        this._comboType.setLayoutData((Object)gridData4);
        Collection supportedDBDefinitionNames = SQLToolsFacade.getSupportedDBDefinitionNames();
        this._comboType.setItems(supportedDBDefinitionNames.toArray(new String[0]));
        if (this._profileName != null) {
            this.selectTypebyProfile(this._profileName);
        } else if (supportedDBDefinitionNames.contains(this._dbVendorId.toString())) {
            this._comboType.setText(this._dbVendorId.toString());
        } else if (supportedDBDefinitionNames.size() > 0) {
            this._comboType.setText((String)supportedDBDefinitionNames.iterator().next());
        }
        this._comboType.addSelectionListener((SelectionListener)this);
    }

    private void selectTypebyProfile(String profileName) {
        SQLDevToolsConfiguration factory = SQLToolsFacade.getConfigurationByProfileName((String)profileName);
        if (factory != null) {
            String dbDefName = factory.getDatabaseVendorDefinitionId().toString();
            this._comboType.setText(dbDefName);
        }
    }

    private void refreshProfileNames(String dbVendorName, String initialProfName) {
        SQLDevToolsConfiguration defaultConfig;
        if (dbVendorName == null || dbVendorName.equals("")) {
            return;
        }
        DatabaseVendorDefinitionId selectedDbVendorId = new DatabaseVendorDefinitionId(dbVendorName);
        SQLDevToolsConfiguration selectedConfig = SQLToolsFacade.getConfiguration(null, (DatabaseVendorDefinitionId)selectedDbVendorId);
        boolean isDefault = selectedConfig == (defaultConfig = SQLToolsFacade.getDefaultConfiguration());
        IConnectionProfile[] profiles = ProfileManager.getInstance().getProfiles();
        ArrayList<String> rightProfiles = new ArrayList<String>();
        for (int i = 0; i < profiles.length; ++i) {
            SQLDevToolsConfiguration config;
            DatabaseVendorDefinitionId dbVendorId = ProfileUtil.getDatabaseVendorDefinitionId((String)profiles[i].getName());
            if (selectedDbVendorId.equals((Object)dbVendorId)) {
                rightProfiles.add(profiles[i].getName());
                continue;
            }
            if (!isDefault || selectedConfig != (config = SQLToolsFacade.getConfiguration(null, (DatabaseVendorDefinitionId)dbVendorId))) continue;
            rightProfiles.add(profiles[i].getName());
        }
        Collections.sort(rightProfiles);
        rightProfiles.add(0, new String(""));
        this._comboProfileName.setItems(rightProfiles.toArray(new String[0]));
        if (initialProfName != null) {
            Iterator iter = rightProfiles.iterator();
            while (iter.hasNext()) {
                if (!iter.next().equals(initialProfName)) continue;
                this._comboProfileName.setText(initialProfName);
                break;
            }
        }
        this.updateFields();
        this.canFinish();
    }
}

