/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.sqlscrapbook.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorFileEditorInput;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class SQLScrapbookEditorInput
extends SQLEditorFileEditorInput
implements IPropertyChangeListener {
    private String statementSQL;
    private IAction connectionAction;
    private IEditorSite editorSite;

    public SQLScrapbookEditorInput(IFile file) {
        super(file);
        String encodedConnection = null;
        if (file != null) {
            try {
                encodedConnection = file.getPersistentProperty(new QualifiedName("org.eclipse.datatools.sqltools.sqlscrapbook", "encodedConnection"));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        SQLEditorConnectionInfo connectionInfo = encodedConnection != null && !encodedConnection.trim().equals("") ? SQLEditorConnectionInfo.decode((String)encodedConnection) : SQLEditorConnectionInfo.DEFAULT_SQLEDITOR_CONNECTION_INFO;
        this.setConnectionInfo((ISQLEditorConnectionInfo)connectionInfo);
    }

    public SQLScrapbookEditorInput(IFile file, ISQLEditorConnectionInfo connectionInfo) {
        super(file);
        this.setConnectionInfo(connectionInfo);
    }

    public SQLScrapbookEditorInput(IFile file, String statementSQL) {
        super(file);
        this.statementSQL = statementSQL;
    }

    public ISQLEditorConnectionInfo getConnectionInfo(boolean dialog) {
        ISQLEditorConnectionInfo connectionInfo = this.getConnectionInfo();
        if (connectionInfo == null && this.connectionAction != null && dialog) {
            this.connectionAction.run();
        }
        return connectionInfo;
    }

    public void setStatementSQL(String statementSQL) {
        this.statementSQL = statementSQL;
    }

    public String getStatementSQL() {
        return this.statementSQL;
    }

    public IEditorSite getEditorSite() {
        return this.editorSite;
    }

    public void setEditorSite(IEditorSite editorSite) {
        this.editorSite = editorSite;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("Connection")) {
            ISQLEditorConnectionInfo connectionInfo = (ISQLEditorConnectionInfo)event.getNewValue();
            this.setConnectionInfo(connectionInfo);
        }
        IEditorPart editor = null;
        IWorkbenchPage page = this.editorSite.getPage();
        if (page != null) {
            editor = page.getActiveEditor();
        }
        if (editor != null && editor instanceof ITextEditor) {
            ((AbstractDocumentProvider)((ITextEditor)editor).getDocumentProvider()).setCanSaveDocument((Object)this);
        }
        this.showMessageConnection();
    }

    public void showMessageConnection() {
        IActionBars bars = this.editorSite.getActionBars();
        ISQLEditorConnectionInfo connectionInfo = this.getConnectionInfo();
        if (bars != null && connectionInfo != null && connectionInfo.getConnectionProfile() != null && connectionInfo.getDatabaseName() != null) {
            bars.getStatusLineManager().setErrorMessage(null);
            bars.getStatusLineManager().setMessage(connectionInfo.getConnectionProfile().getName() + " (" + connectionInfo.getDatabaseName() + ")");
            bars.updateActionBars();
        } else if (bars != null && connectionInfo == null) {
            bars.getStatusLineManager().setErrorMessage("No connection!");
        }
    }

    public IAction getConnectionAction() {
        return this.connectionAction;
    }

    public void setConnectionAction(IAction setConnectionAction) {
        this.connectionAction = setConnectionAction;
    }
}

