/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.plan.internal.ui.view;

import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.datatools.sqltools.plan.IPlanDrawer;
import org.eclipse.datatools.sqltools.plan.IPlanParser;
import org.eclipse.datatools.sqltools.plan.IPlanService;
import org.eclipse.datatools.sqltools.plan.PlanServiceRegistry;
import org.eclipse.datatools.sqltools.plan.internal.IPlanInstance;
import org.eclipse.datatools.sqltools.plan.internal.IPlanManagerListener;
import org.eclipse.datatools.sqltools.plan.internal.PlanViewPlugin;
import org.eclipse.datatools.sqltools.plan.internal.ui.actions.LoadPlanAction;
import org.eclipse.datatools.sqltools.plan.internal.ui.actions.PlanDropDownAction;
import org.eclipse.datatools.sqltools.plan.internal.ui.actions.RemoveAllPlansAction;
import org.eclipse.datatools.sqltools.plan.internal.ui.actions.RemovePlanAction;
import org.eclipse.datatools.sqltools.plan.internal.ui.actions.SavePlanAction;
import org.eclipse.datatools.sqltools.plan.internal.ui.view.GraphicsPlanControl;
import org.eclipse.datatools.sqltools.plan.internal.ui.view.HorizontalLayoutAction;
import org.eclipse.datatools.sqltools.plan.internal.ui.view.Messages;
import org.eclipse.datatools.sqltools.plan.internal.ui.view.VerticalLayoutAction;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;

public class PlanView
extends ViewPart {
    public static final String GROUP_NAVIGATE = "group.navigate";
    public static final String GROUP_REMOVE = "group.remove";
    public static final String GROUP_IO = "group.io";
    public static final String GROUP_HISTORY = "group.history";
    private Text _textPlan;
    private PageBook _fPagebook;
    private Label _fNoPlanShownLabel;
    private Label _fWorkingLabel;
    private GraphicsPlanControl _graphicsControl;
    private IPlanInstance _currentPlan;
    private PlanDropDownAction _plansDropDownAction;
    private RemovePlanAction _removePlanAction;
    private RemoveAllPlansAction _removeAllPlansAction;
    private SavePlanAction _savePlanAction;
    private LoadPlanAction _loadPlanAction;
    private Action _preferenceAction;
    private static final String _LINE_BREAK = System.getProperty("line.separator");
    private VerticalLayoutAction _vLayoutAction;
    private HorizontalLayoutAction _hLayoutAction;
    private static final String ORIENTATION_GROUP = "orientation";
    private static final String FONT_STYLE = "Courier New";
    private static final int FONT_SIZE = 10;
    IPlanManagerListener _listener = new IPlanManagerListener(){

        public void planInstanceCreated(IPlanInstance plan) {
            PlanView.this.showPlan(plan);
        }

        public void planInstanceRemoved(IPlanInstance plan) {
            if (PlanView.this._currentPlan == plan) {
                PlanView.this.showPlan(null);
            }
        }

        public void planInstancesRemoved() {
            PlanView.this._plansDropDownAction.disposeMenu();
            PlanView.this.showPlan(null);
        }

        public void planInstanceFinished(IPlanInstance instance) {
            if (PlanView.this._currentPlan == instance) {
                PlanView.this.showPlan(instance);
            }
        }
    };

    public void createPartControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HelpUtil.getContextId((String)"plan_view", (String)PlanViewPlugin.getDefault().getBundle().getSymbolicName()));
        this._fPagebook = new PageBook(parent, 0);
        this._fNoPlanShownLabel = new Label((Composite)this._fPagebook, 16576);
        this._fNoPlanShownLabel.setText(Messages.getString("PlanView.no.plan.shown"));
        this._fWorkingLabel = new Label((Composite)this._fPagebook, 16576);
        this._fWorkingLabel.setText(Messages.getString("PlanView.working"));
        this._textPlan = new Text((Composite)this._fPagebook, 770);
        this._textPlan.setEditable(false);
        this._textPlan.setBackground(ColorConstants.white);
        FontData fd = new FontData(FONT_STYLE, 10, 0);
        final Font font = new Font((Device)this._textPlan.getDisplay(), fd);
        this._textPlan.setFont(font);
        this._textPlan.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (font != null && !font.isDisposed()) {
                    font.dispose();
                }
            }
        });
        this._graphicsControl = new GraphicsPlanControl((Composite)this._fPagebook, 0);
        this._fPagebook.showPage((Control)this._fNoPlanShownLabel);
        this.createActions();
        this.initializeToolBar();
        MenuManager menuBar = (MenuManager)this.getViewSite().getActionBars().getMenuManager();
        menuBar.add((IAction)this._preferenceAction);
        menuBar.add((IContributionItem)new Separator(ORIENTATION_GROUP));
        menuBar.appendToGroup(ORIENTATION_GROUP, (IAction)this._vLayoutAction);
        menuBar.appendToGroup(ORIENTATION_GROUP, (IAction)this._hLayoutAction);
        PlanViewPlugin.getPlanManager().addPlanManagerListener(this._listener);
    }

    public static void createStandardGroups(IContributionManager menu) {
        menu.add((IContributionItem)new Separator(GROUP_NAVIGATE));
        menu.add((IContributionItem)new GroupMarker(GROUP_REMOVE));
        menu.add((IContributionItem)new Separator(GROUP_IO));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator(GROUP_HISTORY));
    }

    private void initializeToolBar() {
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        PlanView.createStandardGroups((IContributionManager)tbm);
        tbm.appendToGroup(GROUP_REMOVE, (IAction)this._removePlanAction);
        tbm.appendToGroup(GROUP_REMOVE, (IAction)this._removeAllPlansAction);
        tbm.appendToGroup(GROUP_IO, (IAction)this._savePlanAction);
        tbm.appendToGroup(GROUP_IO, (IAction)this._loadPlanAction);
        tbm.appendToGroup(GROUP_HISTORY, (IAction)this._plansDropDownAction);
        this._preferenceAction = new Action(Messages.getString("PlanView.preference")){

            public void run() {
                String[] preferencePages = new String[]{"org.eclipse.datatools.sqltools.plan.executionPlanPage"};
                PreferencesUtil.createPreferenceDialogOn(null, (String)preferencePages[0], (String[])preferencePages, null).open();
            }
        };
        this._vLayoutAction = new VerticalLayoutAction(this._graphicsControl.getSash());
        this._hLayoutAction = new HorizontalLayoutAction(this._graphicsControl.getSash());
        this.configPlanLayout();
        this.getViewSite().getActionBars().updateActionBars();
    }

    private void createActions() {
        this._removePlanAction = new RemovePlanAction(this);
        this._removeAllPlansAction = new RemoveAllPlansAction();
        this._plansDropDownAction = new PlanDropDownAction(this);
        this._savePlanAction = new SavePlanAction();
        this._loadPlanAction = new LoadPlanAction();
        this.updateActions();
    }

    private void updateActions() {
        this._removePlanAction.update();
        this._removeAllPlansAction.update();
        this._plansDropDownAction.update();
        this._savePlanAction.update();
    }

    public void dispose() {
        super.dispose();
    }

    public void setFocus() {
    }

    public IPlanInstance getCurrentPlan() {
        return this._currentPlan;
    }

    private void configPlanLayout() {
        if (PlanViewPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.datatools.sqltools.plan.preferences.VerticalLayoutPlanView")) {
            this._vLayoutAction.setChecked(true);
            this._hLayoutAction.setChecked(false);
            this._vLayoutAction.run();
        } else {
            this._hLayoutAction.setChecked(true);
            this._vLayoutAction.setChecked(false);
            this._hLayoutAction.run();
        }
    }

    public void showPlan(final IPlanInstance instance) {
        if (this._fPagebook.isDisposed()) {
            return;
        }
        this._currentPlan = instance;
        this._fPagebook.getDisplay().syncExec(new Runnable(){

            public void run() {
                PlanView.this.configPlanLayout();
                Object control = PlanView.this._textPlan;
                String label = "";
                if (instance == null) {
                    control = PlanView.this._fNoPlanShownLabel;
                }
                if (instance != null) {
                    if (!instance.isFinished()) {
                        control = PlanView.this._fWorkingLabel;
                    } else if (instance.getStatus() == 1) {
                        String rawPlan = instance.getRawPlan();
                        int planType = instance.getPlanRequest().getPlanType();
                        IPlanService service = PlanServiceRegistry.getInstance().getPlanService(instance.getPlanRequest().getDatabaseDefinitionId());
                        boolean isGraphicPlan = service.getPlanOption().isGraphicPlan(planType);
                        if (isGraphicPlan) {
                            if (rawPlan == null || rawPlan.trim().equals("")) {
                                control = PlanView.this._fNoPlanShownLabel;
                            } else {
                                if (!PlanView.this.isGraphicPlanSupported(instance)) {
                                    return;
                                }
                                PlanView.this._graphicsControl.setPlan(instance);
                                PlanView.this._graphicsControl.update();
                                control = PlanView.this._graphicsControl;
                            }
                        } else {
                            control = PlanView.this._textPlan;
                            PlanView.this._textPlan.setText(String.valueOf(Messages.getString("PlanView.sql")) + "\n" + instance.getPlanRequest().getSql() + "\n" + rawPlan);
                        }
                    } else if (instance.getStatus() == 2) {
                        String errorMsg = instance.getFailThrowable().getMessage();
                        PlanView.this._textPlan.setText(errorMsg);
                        control = PlanView.this._textPlan;
                    }
                    label = String.valueOf(Messages.getString("PlanView.sql")) + " " + instance.getPlanRequest().getSql();
                    label = label.trim();
                    label = label.replaceAll(_LINE_BREAK, " ");
                    label = label.replaceAll("\n", " ");
                }
                PlanView.this.setContentDescription(label);
                PlanView.this._fPagebook.showPage((Control)control);
            }
        });
        this.updateActions();
    }

    public boolean isGraphicPlanSupported(IPlanInstance instance) {
        IPlanService planService = PlanServiceRegistry.getInstance().getPlanService(instance.getPlanRequest().getDatabaseDefinitionId());
        if (planService == null) {
            Exception noExtensionFound = new Exception(Messages.getString("ExecutionPlansDrawer.no.extension", instance.getPlanRequest().getDatabaseDefinitionId(), instance.getPlanRequest().getDatabaseDefinitionId(), "org.eclipse.datatools.sqltools.plan", "planService"));
            instance.finishFail(noExtensionFound);
            return false;
        }
        IPlanDrawer drawer = planService.getPlanDrawer();
        if (drawer == null) {
            Exception noDrawerFound = new Exception(Messages.getString("ExecutionPlansDrawer.no.drawer", instance.getPlanRequest().getDatabaseDefinitionId()));
            instance.finishFail(noDrawerFound);
            return false;
        }
        IPlanParser parser = planService.getPlanParser();
        if (parser == null) {
            Exception noParserFound = new Exception(Messages.getString("ExecutionPlansDrawer.no.parser", instance.getPlanRequest().getDatabaseDefinitionId()));
            instance.finishFail(noParserFound);
            return false;
        }
        return true;
    }
}

