/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.IDriverInstancePropertyDescriptor;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.models.OverrideTemplateDescriptor;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class DriverInstancePropertySource
implements IPropertySource {
    private static final String P_NAME = "name";
    private static final String P_ID = "id";
    private static final String P_VISIBLE = "visible";
    private static final String P_CATEGORY = "category";
    private static final String P_CUSTOM_PROPERTY_DESCRIPTOR = "customPropertyDescriptor";
    private DriverInstance mDI;
    private TemplateDescriptor descriptor = null;

    public DriverInstancePropertySource(DriverInstance di) {
        this.mDI = di;
        this.descriptor = this.mDI.getTemplate();
    }

    public Object getEditableValue() {
        return this.mDI;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<Object> descList = new ArrayList<Object>();
        if (this.descriptor != null) {
            IConfigurationElement[] props = this.descriptor.getProperties();
            ArrayList<IConfigurationElement> list = new ArrayList<IConfigurationElement>();
            OverrideTemplateDescriptor[] otds = OverrideTemplateDescriptor.getByDriverTemplate((String)this.descriptor.getId());
            for (int i = 0; i < props.length; ++i) {
                String temp;
                String id = props[i].getAttribute(P_ID);
                String visible = props[i].getAttribute(P_VISIBLE);
                if (otds != null && otds.length > 0 && (temp = otds[0].getPropertyVisibleFromId(id)) != null && temp.length() > 0) {
                    visible = temp;
                }
                boolean propvisible = true;
                if (visible != null && visible.equalsIgnoreCase(Boolean.toString(false))) {
                    propvisible = false;
                }
                if (!propvisible) continue;
                list.add(props[i]);
            }
            if (list.size() > 0) {
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    String temp;
                    String temp2;
                    String temp3;
                    IConfigurationElement ice = (IConfigurationElement)iter.next();
                    String id = ice.getAttribute(P_ID);
                    String name = ice.getAttribute(P_NAME);
                    if (otds != null && otds.length > 0 && (temp3 = otds[0].getPropertyNameFromId(id)) != null && temp3.length() > 0) {
                        name = temp3;
                    }
                    String ctceClass = ice.getAttribute(P_CUSTOM_PROPERTY_DESCRIPTOR);
                    if (otds != null && otds.length > 0 && (temp2 = otds[0].getPropertyCustomPropDescriptorFromId(id)) != null && temp2.length() > 0) {
                        ctceClass = temp2;
                    }
                    String category = ice.getAttribute(P_CATEGORY);
                    if (otds != null && otds.length > 0 && (temp = otds[0].getPropertyCategoryFromId(id)) != null && temp.length() > 0) {
                        category = temp;
                    }
                    if (category == null) {
                        category = ConnectivityUIPlugin.getDefault().getResourceString("properties.category.general");
                    }
                    if (ctceClass != null) {
                        if (ctceClass == null) continue;
                        try {
                            PropertyDescriptor pd = (PropertyDescriptor)ice.createExecutableExtension(P_CUSTOM_PROPERTY_DESCRIPTOR);
                            if (category != null) {
                                pd.setCategory(category);
                            }
                            if (pd instanceof IDriverInstancePropertyDescriptor) {
                                ((IDriverInstancePropertyDescriptor)pd).setDriverInstance(this.mDI);
                            }
                            descList.add(pd);
                        }
                        catch (SecurityException e) {
                            ExceptionHandler.showException(new Shell(), ConnectivityUIPlugin.getDefault().getResourceString("PropertyDescriptor.error.title"), e.getLocalizedMessage(), e);
                            e.printStackTrace();
                        }
                        catch (IllegalArgumentException e) {
                            ExceptionHandler.showException(new Shell(), ConnectivityUIPlugin.getDefault().getResourceString("PropertyDescriptor.error.title"), e.getLocalizedMessage(), e);
                            e.printStackTrace();
                        }
                        catch (CoreException e) {
                            ExceptionHandler.showException(new Shell(), ConnectivityUIPlugin.getDefault().getResourceString("PropertyDescriptor.error.title"), e.getLocalizedMessage(), e);
                            e.printStackTrace();
                        }
                        continue;
                    }
                    TextPropertyDescriptor tpd = new TextPropertyDescriptor((Object)id, name);
                    if (category != null) {
                        tpd.setCategory(category);
                    }
                    descList.add(tpd);
                }
            }
            if (descList.size() > 0) {
                IPropertyDescriptor[] pdArray = descList.toArray(new IPropertyDescriptor[descList.size()]);
                Arrays.sort(pdArray, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        IPropertyDescriptor pd1 = (IPropertyDescriptor)o1;
                        IPropertyDescriptor pd2 = (IPropertyDescriptor)o2;
                        return pd1.getDisplayName().compareTo(pd2.getDisplayName());
                    }
                });
                return pdArray;
            }
        }
        return new IPropertyDescriptor[0];
    }

    public Object getPropertyValue(Object id) {
        if (this.descriptor != null) {
            String idStr = (String)id;
            IPropertySet propSet = this.mDI.getPropertySet();
            String propval = propSet.getBaseProperties().getProperty(idStr);
            if (propval != null && propval.length() > 0) {
                return propval;
            }
        }
        return "";
    }

    public boolean isPropertySet(Object id) {
        return true;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        String strid = (String)id;
        if (this.mDI.getPropertySet() != null) {
            this.mDI.getPropertySet().getBaseProperties().setProperty(strid, (String)value);
        }
    }
}

