/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileRule;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.progress.UIJob;

public class RefreshProfileJob
extends UIJob {
    private IConnectionProfile mProfile;
    private TreeViewer mViewer;
    private static final Map sProfileToJobsMap = new HashMap();
    private static IJobChangeListener sJobListener = new JobChangeAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void running(IJobChangeEvent event) {
            RefreshProfileJob job = (RefreshProfileJob)event.getJob();
            Map map = sProfileToJobsMap;
            synchronized (map) {
                List jobs = (List)sProfileToJobsMap.get(job.mProfile);
                jobs.remove((Object)job);
                if (jobs.isEmpty()) {
                    sProfileToJobsMap.remove(job.mProfile);
                }
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleRefreshProfileJob(IConnectionProfile profile, TreeViewer viewer) {
        RefreshProfileJob newJob;
        Map map = sProfileToJobsMap;
        synchronized (map) {
            List<RefreshProfileJob> jobs;
            if (sProfileToJobsMap.containsKey(profile)) {
                jobs = (List)sProfileToJobsMap.get(profile);
                Iterator it = jobs.iterator();
                while (it.hasNext()) {
                    RefreshProfileJob job = (RefreshProfileJob)((Object)it.next());
                    if (job.mViewer != viewer) continue;
                    return;
                }
            } else {
                jobs = new ArrayList();
                sProfileToJobsMap.put(profile, jobs);
            }
            newJob = new RefreshProfileJob(profile, viewer);
            jobs.add(newJob);
        }
        newJob.addJobChangeListener(sJobListener);
        newJob.schedule();
    }

    private RefreshProfileJob(IConnectionProfile profile, TreeViewer viewer) {
        super(ConnectivityPlugin.getDefault().getResourceString("actions.connect.uijob"));
        this.setRule((ISchedulingRule)new ProfileRule(profile));
        this.setSystem(false);
        this.setUser(true);
        if (!viewer.getTree().isDisposed()) {
            this.setDisplay(viewer.getTree().getDisplay());
        }
        this.mProfile = profile;
        this.mViewer = viewer;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        monitor.beginTask(this.getName(), 1);
        if (this.mViewer != null && !this.mViewer.getTree().isDisposed()) {
            this.mViewer.refresh((Object)this.mProfile);
            this.mViewer.setExpandedState((Object)this.mProfile, true);
        }
        monitor.worked(1);
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        if (family instanceof IConnectionProfile) {
            return this.mProfile.equals(family);
        }
        if (family instanceof TreeViewer) {
            return family == this.mViewer;
        }
        return super.belongsTo(family);
    }
}

