/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.export.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.IResultSetRow;
import org.eclipse.datatools.sqltools.result.internal.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ColumnAlignedResultItem;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class CopyRowsAction
extends Action {
    private TableViewer _table;
    private IResultSetObject _resultObj;

    public CopyRowsAction(String text, TableViewer table, IResultSetObject resultObj) {
        super(text);
        this._table = table;
        this._resultObj = resultObj;
    }

    public void run() {
        ArrayList<IResultSetRow> rows = new ArrayList<IResultSetRow>();
        if (this._table == null || this._resultObj == null) {
            return;
        }
        ISelection s = this._table.getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)s;
        Iterator i = ss.iterator();
        while (i.hasNext()) {
            IResultSetRow row;
            Object object = i.next();
            if (!(object instanceof Integer) || (row = this._resultObj.getRowData((Integer)object)) == null) continue;
            rows.add(row);
        }
        if (rows.size() == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer("");
        Iterator iter = rows.iterator();
        while (iter.hasNext()) {
            IResultSetRow row = (IResultSetRow)iter.next();
            sb.append(ColumnAlignedResultItem.getDisplayData(this._resultObj, row, ResultsViewPlugin.getDefault().getPreferenceStore().getString("org.eclipse.datatools.sqltools.result.preferences.display.nulldisplaystr")));
            sb.append(ColumnAlignedResultItem.getLineSeparator());
        }
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        Transfer[] transfer = new Transfer[]{TextTransfer.getInstance()};
        clipboard.setContents(new Object[]{sb.toString()}, transfer);
    }
}

