/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.filters;

import java.util.ArrayList;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.datatools.sqltools.result.internal.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.filters.ResultsFilterHelper;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.datatools.sqltools.result.internal.utils.ProfileUtil;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ResultsFilterDialog
extends TrayDialog
implements IContextProvider {
    private static final String PROVIDER_NAME_POSTFIX = "Connection Profile";
    private Table _profilesTable;
    private Button _unknownProfiles;
    private Group _resultStatusGrp;
    private Button _success;
    private Button _failed;
    private Button _terminated;
    private Button _warning;
    private Button _criticalError;
    private Button _numCheck;
    private Text _resultsNum;
    private static final int NAME_COLUMN = 0;
    private static final int PROVIDER_COLUMN = 1;
    private static final int DESC_COLUMN = 2;
    private IPreferenceStore _store;
    private static final int TABLE_WITDH = 380;
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(ResultsViewPlugin.getDefault().getBundle().getSymbolicName());

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }

    public ResultsFilterDialog(Shell parentShell) {
        super(parentShell);
        this._store = ResultsViewPlugin.getDefault().getPreferenceStore();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)parent, (String)HelpUtil.getContextId((String)"dialog_results_filter", (String)ResultsViewPlugin.getDefault().getBundle().getSymbolicName()));
        Composite parentComp = (Composite)super.createDialogArea(parent);
        Composite comp = new Composite(parentComp, 0);
        comp.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        comp.setLayout((Layout)layout);
        this.createProfilesTable(comp);
        Composite limitationComp = new Composite(comp, 0);
        limitationComp.setLayoutData((Object)new GridData(768));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        limitationComp.setLayout((Layout)layout);
        this._numCheck = new Button(limitationComp, 32);
        this._numCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ResultsFilterDialog.this._numCheck.getSelection()) {
                    ResultsFilterDialog.this._resultsNum.setEnabled(true);
                } else {
                    ResultsFilterDialog.this._resultsNum.setEnabled(false);
                    ResultsFilterDialog.this.getButton(0).setEnabled(true);
                }
            }
        });
        this._numCheck.setSelection(this._store.getBoolean("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.limitcheck"));
        this._numCheck.setToolTipText(Messages.ResultsFilterDialog_limit_tip);
        this._numCheck.setText(Messages.ResultsFilterDialog_limit);
        this._resultsNum = new Text(limitationComp, 2052);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this._resultsNum.setLayoutData((Object)gd);
        this._resultsNum.setText(Integer.toString(this._store.getInt("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.limitnum")));
        this._resultsNum.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int limit = 0;
                try {
                    limit = Integer.parseInt(ResultsFilterDialog.this._resultsNum.getText().trim());
                    if (limit < 0) {
                        ResultsFilterDialog.this.getButton(0).setEnabled(false);
                    } else {
                        ResultsFilterDialog.this.getButton(0).setEnabled(true);
                    }
                }
                catch (Exception exception) {
                    ResultsFilterDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        if (!this._numCheck.getSelection()) {
            this._resultsNum.setEnabled(false);
        }
        Composite unkownComp = new Composite(comp, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        unkownComp.setLayout((Layout)layout);
        unkownComp.setLayoutData((Object)new GridData(768));
        this._unknownProfiles = new Button(unkownComp, 32);
        this._unknownProfiles.setText(Messages.ResultsFilterDialog_unknownprofile);
        this._unknownProfiles.setToolTipText(Messages.ResultsFilterDialog_unknownprofile_tooltip);
        this._unknownProfiles.setSelection(this._store.getBoolean("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.unknownProfile"));
        this._resultStatusGrp = new Group(comp, 0);
        this._resultStatusGrp.setLayoutData((Object)new GridData(768));
        this._resultStatusGrp.setText(Messages.ResultsFilterDialog_finishstatus);
        layout = new GridLayout();
        layout.numColumns = 3;
        this._resultStatusGrp.setLayout((Layout)layout);
        this._success = new Button((Composite)this._resultStatusGrp, 32);
        this._success.setText(Messages.ResultsFilterDialog_succeeded);
        this._success.setSelection(this._store.getBoolean("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.success"));
        this._success.setToolTipText(Messages.ResultsFilterDialog_succeeded_tip);
        this._failed = new Button((Composite)this._resultStatusGrp, 32);
        this._failed.setText(Messages.ResultsFilterDialog_failed);
        this._failed.setSelection(this._store.getBoolean("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.failed"));
        this._failed.setToolTipText(Messages.ResultsFilterDialog_failed_tip);
        this._terminated = new Button((Composite)this._resultStatusGrp, 32);
        this._terminated.setText(Messages.ResultsFilterDialog_terminated);
        this._terminated.setSelection(this._store.getBoolean("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.terminated"));
        this._terminated.setToolTipText(Messages.ResultsFilterDialog_terminated_tip);
        this._warning = new Button((Composite)this._resultStatusGrp, 32);
        this._warning.setText(Messages.ResultsFilterDialog_warning);
        this._warning.setSelection(this._store.getBoolean("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.warning"));
        this._warning.setToolTipText(Messages.ResultsFilterDialog_warning_tooltip);
        this._criticalError = new Button((Composite)this._resultStatusGrp, 32);
        this._criticalError.setText(Messages.ResultsFilterDialog_criticalerror);
        this._criticalError.setSelection(this._store.getBoolean("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.critical"));
        this._criticalError.setToolTipText(Messages.ResultsFilterDialog_criticalerror_tooltip);
        return comp;
    }

    private void createProfilesTable(Composite comp) {
        this._profilesTable = new Table(comp, 2592);
        this._profilesTable.setHeaderVisible(true);
        this._profilesTable.setLinesVisible(true);
        this._profilesTable.setToolTipText(Messages.ResultsFilterDialog_profiles_tip);
        TableColumn nameColumn = new TableColumn(this._profilesTable, 0);
        nameColumn.setText(Messages.ResultsFilterDialog_profilename);
        TableColumn typeColumn = new TableColumn(this._profilesTable, 0);
        typeColumn.setText(Messages.ResultsFilterDialog_profileprovider);
        TableColumn descColumn = new TableColumn(this._profilesTable, 0);
        descColumn.setText(Messages.ResultsFilterDialog_profiledesc);
        IConnectionProfile[] profiles = ProfileUtil.getProfiles();
        int i = 0;
        while (i < profiles.length) {
            TableItem item = new TableItem(this._profilesTable, 0);
            item.setText(0, profiles[i].getName());
            String providerName = profiles[i].getProviderName();
            if (providerName.indexOf(PROVIDER_NAME_POSTFIX) != -1) {
                providerName = providerName.substring(0, providerName.length() - PROVIDER_NAME_POSTFIX.length());
            }
            item.setText(1, providerName);
            item.setText(2, profiles[i].getDescription());
            item.setChecked(!ResultsFilterHelper.isFilteredOut(profiles[i].getName()));
            ++i;
        }
        GridData gd = new GridData(768);
        if (this._profilesTable.getItemCount() < 3) {
            gd.heightHint = 4 * this._profilesTable.getItemHeight();
        }
        if (this._profilesTable.getItemCount() > 6) {
            gd.heightHint = 7 * this._profilesTable.getItemHeight();
        }
        this._profilesTable.setLayoutData((Object)gd);
        nameColumn.pack();
        typeColumn.pack();
        descColumn.pack();
        int totalWidth = nameColumn.getWidth() + typeColumn.getWidth() + descColumn.getWidth() + 3 * this._profilesTable.getGridLineWidth();
        int moreWidth = 380 - totalWidth - this._profilesTable.getGridLineWidth();
        if (moreWidth > 0) {
            int aveMoreWidth = moreWidth / 3;
            nameColumn.setWidth(nameColumn.getWidth() + aveMoreWidth);
            typeColumn.setWidth(typeColumn.getWidth() + aveMoreWidth);
            descColumn.setWidth(descColumn.getWidth() + aveMoreWidth);
        } else {
            descColumn.setWidth(380 - nameColumn.getWidth() - typeColumn.getWidth());
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ResultsFilterDialog_dialogtitle);
    }

    protected void okPressed() {
        ArrayList<String> filteredOutProfiles = new ArrayList<String>();
        int i = 0;
        while (i < this._profilesTable.getItemCount()) {
            TableItem item = this._profilesTable.getItem(i);
            if (!item.getChecked()) {
                filteredOutProfiles.add(item.getText(0));
            }
            ++i;
        }
        ResultsFilterHelper.saveFilters(filteredOutProfiles.toArray(new String[filteredOutProfiles.size()]));
        this._store.setValue("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.success", this._success.getSelection());
        this._store.setValue("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.failed", this._failed.getSelection());
        this._store.setValue("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.terminated", this._terminated.getSelection());
        this._store.setValue("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.warning", this._warning.getSelection());
        this._store.setValue("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.critical", this._criticalError.getSelection());
        this._store.setValue("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.profileFilter.change", !this._store.getBoolean("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.profileFilter.change"));
        this._store.setValue("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.limitcheck", this._numCheck.getSelection());
        int limit = this._store.getDefaultInt("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.limitnum");
        try {
            int parsedLimit = Integer.parseInt(this._resultsNum.getText().trim());
            if (parsedLimit >= 0) {
                limit = parsedLimit;
            }
        }
        catch (Exception exception) {}
        this._store.setValue("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.limitnum", limit);
        this._store.setValue("org.eclipse.datatools.sqltools.result.ResultsFilterDialog.unknownProfile", this._unknownProfiles.getSelection());
        super.okPressed();
    }
}

