/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.apache.internal.derby.catalog;

import com.ibm.icu.util.StringTokenizer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Iterator;
import org.eclipse.datatools.connectivity.apache.internal.derby.catalog.DerbyCatalogSchema;
import org.eclipse.datatools.connectivity.apache.internal.derby.catalog.DerbyCatalogTrigger;
import org.eclipse.datatools.connectivity.apache.internal.derby.catalog.DerbyTableColumnLoader;
import org.eclipse.datatools.connectivity.apache.internal.derby.catalog.DerbyTableConstraintLoader;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCTable;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableColumnLoader;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableConstraintLoader;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatement;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatementDefault;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatementsPackage;
import org.eclipse.datatools.modelbase.sql.tables.ActionGranularityType;
import org.eclipse.datatools.modelbase.sql.tables.ActionTimeType;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesPackage;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DerbyCatalogTable
extends JDBCTable {
    private static final long serialVersionUID = 1426200108473580544L;
    private boolean triggerLoaded = false;

    public synchronized void refresh() {
        if (this.triggerLoaded) {
            this.triggerLoaded = false;
        }
        super.refresh();
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 12) {
            this.getTriggers();
        }
        return super.eIsSet(eFeature);
    }

    protected JDBCTableConstraintLoader createConstraintLoader() {
        return new DerbyTableConstraintLoader((ICatalogObject)this);
    }

    public Table getSupertable() {
        return null;
    }

    protected JDBCTableColumnLoader createColumnLoader() {
        return new DerbyTableColumnLoader((ICatalogObject)this);
    }

    private Schema getSchema(String schemaName) {
        Schema s = this.getSchema();
        if (s.getName().equals(schemaName)) {
            return s;
        }
        Database d = s.getCatalog().getDatabase();
        Iterator it = d.getSchemas().iterator();
        while (it.hasNext()) {
            s = (Schema)it.next();
            if (!s.getName().equals(schemaName)) continue;
            return s;
        }
        DerbyCatalogSchema schema = new DerbyCatalogSchema();
        schema.setName(schemaName);
        schema.setCatalog(s.getCatalog());
        schema.setDatabase(d);
        return schema;
    }

    private synchronized void loadTriggers() {
        if (this.triggerLoaded) {
            return;
        }
        EList triggerList = super.getTriggers();
        Object[] list = triggerList.toArray();
        this.clearTriggers(triggerList);
        Connection connection = this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            DataModelElementFactory factory = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase()).getDataModelElementFactory();
            Statement s = connection.createStatement();
            String query = "SELECT TRIGGERNAME, SCHEMANAME,EVENT,FIRINGTIME,TYPE,TRIGGERDEFINITION,REFERENCINGOLD,REFERENCINGNEW,OLDREFERENCINGNAME,NEWREFERENCINGNAME,REFERENCEDCOLUMNS FROM SYS.SYSTRIGGERS A, SYS.SYSTABLES B, SYS.SYSSCHEMAS C WHERE A.TABLEID=B.TABLEID AND B.TABLENAME='" + this.getName() + "'" + " AND A.SCHEMAID=C.SCHEMAID";
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String columns;
                boolean referencingNew;
                String granularity;
                DerbyCatalogTrigger trigger;
                String trigName = r.getString("TRIGGERNAME");
                Object element = this.findTrigger(list, trigName);
                if (element != null) {
                    trigger = (DerbyCatalogTrigger)((Object)element);
                    ((ICatalogObject)element).refresh();
                } else {
                    trigger = new DerbyCatalogTrigger();
                    trigger.setName(trigName);
                }
                trigger.setName(trigName);
                String trigSchema = r.getString("SCHEMANAME");
                trigger.setSchema(this.getSchema(trigSchema));
                String trigTime = r.getString("FIRINGTIME");
                if (trigTime.equals("A")) {
                    trigger.setActionTime(ActionTimeType.AFTER_LITERAL);
                } else if (trigTime.equals("B")) {
                    trigger.setActionTime(ActionTimeType.BEFORE_LITERAL);
                } else {
                    if (!trigTime.equals("I")) continue;
                    trigger.setActionTime(ActionTimeType.INSTEADOF_LITERAL);
                }
                String trigEvent = r.getString("EVENT");
                if (trigEvent.equals("I")) {
                    trigger.setInsertType(true);
                }
                if (trigEvent.equals("D")) {
                    trigger.setDeleteType(true);
                }
                if (trigEvent.equals("U")) {
                    trigger.setUpdateType(true);
                }
                if ((granularity = r.getString("TYPE")).equals("S")) {
                    trigger.setActionGranularity(ActionGranularityType.STATEMENT_LITERAL);
                } else {
                    if (!granularity.equals("R")) continue;
                    trigger.setActionGranularity(ActionGranularityType.ROW_LITERAL);
                }
                boolean referencingOld = r.getBoolean("REFERENCINGOLD");
                if (referencingOld) {
                    trigger.setOldRow(r.getString("OLDREFERENCINGNAME"));
                }
                if (referencingNew = r.getBoolean("REFERENCINGNEW")) {
                    trigger.setNewRow(r.getString("NEWREFERENCINGNAME"));
                }
                if ((columns = r.getString("REFERENCEDCOLUMNS")) != null) {
                    EList updateColumns = trigger.getTriggerColumn();
                    EList columnList = this.getColumns();
                    columns = columns.substring(columns.indexOf("(") + 1, columns.indexOf(")"));
                    StringTokenizer tokenizer = new StringTokenizer(columns, ",");
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken().trim();
                        Column column = (Column)columnList.get(Integer.parseInt(token) - 1);
                        updateColumns.add((Object)column);
                    }
                }
                String text = r.getString("TRIGGERDEFINITION");
                SQLStatement body = (SQLStatement)factory.create(SQLStatementsPackage.eINSTANCE.getSQLStatementDefault());
                ((SQLStatementDefault)body).setSQL(text);
                trigger.getActionStatement().add((Object)body);
                triggerList.add((Object)trigger);
            }
            this.triggerLoaded = true;
            r.close();
            s.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        this.eSetDeliver(deliver);
    }

    private void clearTriggers(EList triggerList) {
        Iterator it = triggerList.iterator();
        while (it.hasNext()) {
            DerbyCatalogTrigger trigger = (DerbyCatalogTrigger)((Object)it.next());
            trigger.getActionStatement().clear();
            trigger.setSchema(null);
        }
        triggerList.clear();
    }

    public EList getTriggers() {
        if (!this.triggerLoaded) {
            this.loadTriggers();
        }
        return this.triggers;
    }

    protected Object findTrigger(Object[] list, String name) {
        Object object = null;
        int i = 0;
        while (i < list.length) {
            SQLObject sqlObject = (SQLObject)list[i];
            if (sqlObject.getName().equals(name) && sqlObject.eClass() == SQLTablesPackage.eINSTANCE.getTrigger()) {
                object = list[i];
                break;
            }
            ++i;
        }
        return object;
    }
}

