/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.catalog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.ase.JDBCASEPlugin;
import org.eclipse.datatools.enablement.ase.catalog.ASEUtil;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalog;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogUtils;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SegmentThreshold;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseasesqlmodelPackage;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.impl.SybaseASESegmentImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASECatalogSegment
extends SybaseASESegmentImpl
implements ICatalogObject,
IAdaptable {
    private static final long serialVersionUID = 6484703933132732304L;
    private Boolean isThresholdLoaded = Boolean.FALSE;

    public Database getCatalogDatabase() {
        return this.getCatalog().getDatabase();
    }

    public Connection getConnection() {
        SybaseASECatalog catalog = (SybaseASECatalog)this.getCatalog();
        return catalog.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.isThresholdLoaded;
        synchronized (bl) {
            this.isThresholdLoaded = Boolean.FALSE;
            super.getThresholds().clear();
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return ASEUtil.SYSTEM_DEFINED_SEGMENTS.contains(this.getName());
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 9) {
            this.getThresholds();
        }
        return super.eIsSet(eFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getThresholds() {
        Boolean bl = this.isThresholdLoaded;
        synchronized (bl) {
            if (!this.isThresholdLoaded.booleanValue()) {
                this.loadThreshold();
            }
        }
        return super.getThresholds();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadThreshold() {
        if (this.isThresholdLoaded.booleanValue()) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        EList thresholdList = this.getThresholds();
        thresholdList.clear();
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String oldCatalog = null;
        try {
            try {
                oldCatalog = conn.getCatalog();
                conn.setCatalog(this.getCatalog().getName());
                stmt = conn.prepareStatement("SELECT s.name, t.free_space, t.proc_name, convert(bit,t.status&1) FROM syssegments s, systhresholds t WHERE s.segment = t.segment AND s.name LIKE ?");
                stmt.setString(1, this.getName());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    int freeSpace = rs.getInt(2);
                    String procName = rs.getString(3);
                    Database database = this.getCatalogDatabase();
                    DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
                    DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
                    SegmentThreshold threshold = (SegmentThreshold)factory.create(SybaseasesqlmodelPackage.eINSTANCE.getSegmentThreshold());
                    threshold.setFreeSpace(freeSpace);
                    threshold.setProcedureName(procName);
                    thresholdList.add((Object)threshold);
                }
            }
            catch (SQLException e) {
                JDBCASEPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
            throw throwable;
        }
        {
            Object var13_16 = null;
        }
        SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        this.isThresholdLoaded = Boolean.TRUE;
        this.eSetDeliver(deliver);
    }

    public Object getAdapter(Class adapter) {
        Object adapterObject = Platform.getAdapterManager().getAdapter((Object)this, adapter);
        if (adapterObject == null) {
            adapterObject = Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        }
        return adapterObject;
    }
}

