/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result;

import java.io.Serializable;
import org.eclipse.datatools.sqltools.result.internal.utils.Images;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.swt.graphics.Image;

public class OperationCommand
implements Serializable {
    private static final long serialVersionUID = 9026813441175593165L;
    private int _actionType;
    private String _displayStr;
    private String _consumerName;
    private String _profileName;
    private String _databaseName;
    private Serializable _data;
    public static final int STATUS_CRITICAL_ERROR = 7;
    public static final int STATUS_WARNING = 6;
    public static final int STATUS_TERMINATED = 5;
    public static final int STATUS_FAILED = 4;
    public static final int STATUS_SUCCEEDED = 3;
    public static final int STATUS_RUNNING = 2;
    public static final int STATUS_STARTED = 1;
    public static final int ACTION_EXECUTE = 1;
    public static final int ACTION_CREATE = 2;
    public static final int ACTION_DEBUG = 3;
    public static final int ACTION_DEPLOY = 4;
    public static final int ACTION_DROP = 5;
    public static final int ACTION_EDIT = 6;
    public static final int ACTION_EXPORT = 7;
    public static final int ACTION_EXTRACT = 8;
    public static final int ACTION_IMPORT = 9;
    public static final int ACTION_LOAD = 10;
    public static final int ACTION_BEFORE_RUN = 11;
    public static final int ACTION_AFTER_RUN = 12;
    public static final int ACTION_RUN = 13;
    public static final int ACTION_VALIDATE = 14;
    public static final int ACTION_VIEW = 15;

    public OperationCommand(int type, String displayStr, String consumerName, String profileName, String databaseName) {
        this._actionType = type;
        this._displayStr = displayStr == null ? "" : displayStr;
        this._consumerName = consumerName == null ? "" : consumerName;
        this._profileName = profileName == null ? "" : profileName;
        this._databaseName = databaseName == null ? "" : databaseName;
    }

    public OperationCommand(int type, String displayStr, String consumerName, String profileName, String databaseName, Serializable data) {
        this(type, displayStr, consumerName, profileName, databaseName);
        this._data = data;
    }

    public String getDisplayString() {
        return this._displayStr;
    }

    public int getActionType() {
        return this._actionType;
    }

    public String getConsumerName() {
        return this._consumerName;
    }

    public String getProfileName() {
        return this._profileName;
    }

    public String getDatabaseName() {
        return this._databaseName;
    }

    public static String getActionString(int actionId) {
        switch (actionId) {
            case 1: {
                return Messages.OperationCommand_action_execute;
            }
            case 2: {
                return Messages.OperationCommand_action_create;
            }
            case 3: {
                return Messages.OperationCommand_action_debug;
            }
            case 4: {
                return Messages.OperationCommand_action_deploy;
            }
            case 5: {
                return Messages.OperationCommand_action_drop;
            }
            case 6: {
                return Messages.OperationCommand_action_edit;
            }
            case 7: {
                return Messages.OperationCommand_action_export;
            }
            case 8: {
                return Messages.OperationCommand_action_extract;
            }
            case 9: {
                return Messages.OperationCommand_action_import;
            }
            case 10: {
                return Messages.OperationCommand_action_load;
            }
            case 11: {
                return Messages.OperationCommand_action_before_run;
            }
            case 12: {
                return Messages.OperationCommand_action_after_run;
            }
            case 13: {
                return Messages.OperationCommand_action_run;
            }
            case 14: {
                return Messages.OperationCommand_action_validate;
            }
            case 15: {
                return Messages.OperationCommand_action_browse;
            }
        }
        return Messages.OperationCommand_unknown_action;
    }

    public static Image getStatusImage(int statusId) {
        switch (statusId) {
            case 1: {
                return Images.get("org.eclipse.datatools.sqltools.resultstarted.gif");
            }
            case 2: {
                return Images.get("org.eclipse.datatools.sqltools.resultrunning.gif");
            }
            case 3: {
                return Images.get("org.eclipse.datatools.sqltools.resultsuccess.gif");
            }
            case 4: {
                return Images.get("org.eclipse.datatools.sqltools.resultfail.gif");
            }
            case 5: {
                return Images.get("org.eclipse.datatools.sqltools.resultterminate.gif");
            }
            case 6: {
                return Images.get("org.eclipse.datatools.sqltools.resultwarning.gif");
            }
            case 7: {
                return Images.get("org.eclipse.datatools.sqltools.resultcritical.gif");
            }
        }
        return Images.get("org.eclipse.datatools.sqltools.resultfail.gif");
    }

    public static String getStatusString(int statusId) {
        switch (statusId) {
            case 1: {
                return Messages.OperationCommand_status_started;
            }
            case 2: {
                return Messages.OperationCommand_status_running;
            }
            case 3: {
                return Messages.OperationCommand_status_succeeded;
            }
            case 4: {
                return Messages.OperationCommand_status_failed;
            }
            case 5: {
                return Messages.OperationCommand_status_terminated;
            }
            case 6: {
                return Messages.OperationCommand_status_warning;
            }
            case 7: {
                return Messages.OperationCommand_status_critical;
            }
        }
        return Messages.OperationCommand_status_unknown;
    }

    public Serializable getData() {
        return this._data;
    }

    public void setData(Serializable _data) {
        this._data = _data;
    }
}

