/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.ResultSetObject;
import org.eclipse.datatools.sqltools.result.internal.Constants;
import org.eclipse.datatools.sqltools.result.internal.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.core.IResultManager;
import org.eclipse.datatools.sqltools.result.internal.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.internal.model.ResultItem;
import org.eclipse.datatools.sqltools.result.internal.utils.ILogger;

public class ResultInstance
implements IResultInstance {
    private static final long serialVersionUID = 1L;
    private static ILogger _log = ResultsViewPlugin.getLogger(null);
    private OperationCommand _operationCommand;
    private IResultManager _resultManager;
    private List _resultList;
    private int _status = 1;
    private transient Runnable _terminateHandler;
    private List _parameters;
    private String _date;
    private int _execFrequency;

    public ResultInstance(IResultManager resultmanager, OperationCommand command, Runnable terminateHandler) {
        this._resultManager = resultmanager;
        this._operationCommand = command;
        this._resultList = new ArrayList(5);
        this._terminateHandler = terminateHandler;
        this._date = Constants.FORMATTER.format(new Date());
        this._execFrequency = 1;
    }

    public void morePlainMessage(String msg) {
        if (msg == null) {
            msg = "";
        }
        this.moreResultItem(new ResultItem(msg, true));
    }

    public void moreStatusMessage(String msg) {
        if (msg == null) {
            msg = "";
        }
        this.moreResultItem(new ResultItem(msg, false));
    }

    public void moreUpdateCount(int updateCount) {
        if (updateCount < 0) {
            updateCount = 0;
        }
        this.moreResultItem(new ResultItem(updateCount));
    }

    public void moreResultSet(ResultSet resultset) throws SQLException {
        ResultSetObject r = null;
        try {
            int maxRowCount = ResultsViewPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.datatools.sqltools.result.preferences.display.maxrowcount");
            int maxDisplayRowCount = ResultsViewPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.datatools.sqltools.result.preferences.display.maxdisplayrowcount");
            r = new ResultSetObject(resultset, maxRowCount, maxDisplayRowCount);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            _log.error("ResultInstance_error_moreResultSet", (Throwable)e);
            return;
        }
        this.moreResultItem(new ResultItem(r));
    }

    public void moreResultItem(ResultItem item) {
        this._resultList.add(item);
        if (this._resultManager != null) {
            this._resultManager.fireAppended(this, item, this._resultList.size() - 1);
        }
    }

    public OperationCommand getOperationCommand() {
        return this._operationCommand;
    }

    public int getStatus() {
        return this._status;
    }

    public boolean isFinished() {
        return this._status == 4 || this._status == 3 || this._status == 7 || this._status == 6 || this._status == 5;
    }

    public ResultItem getItem(int index) {
        return (ResultItem)this._resultList.get(index);
    }

    public int getItemCount() {
        return this._resultList.size();
    }

    public void terminate() {
        if (this._terminateHandler != null) {
            this._terminateHandler.run();
        }
        this._status = 5;
        if (this._resultManager != null) {
            this._resultManager.fireStatusUpdated(this);
        }
    }

    public void dispose() {
        for (int i = 0; i < this._resultList.size(); ++i) {
            Object o;
            ResultItem ri = this.getItem(i);
            if (ri == null || (o = ri.getResultObject()) == null || !(o instanceof IResultSetObject)) continue;
            ((IResultSetObject)o).dispose();
        }
    }

    public String getExecuteTime() {
        return this._date;
    }

    public void updateStatus(int status) {
        this._status = status;
        if (this._resultManager != null) {
            this._resultManager.fireStatusUpdated(this);
        }
    }

    public void resetInstance() {
        this._resultList = new ArrayList(5);
        this._parameters = null;
        this._status = 1;
        if (this._resultManager != null) {
            this._resultManager.fireInstanceReset(this);
        }
    }

    public void moreResultSet(IResultSetObject resultset) {
        this.moreResultItem(new ResultItem(resultset));
    }

    public void showParameters(List params) {
        this._parameters = params;
        if (this._resultManager != null) {
            this._resultManager.fireParametersShow(this, this._parameters);
        }
    }

    public boolean hasTerminateHandler() {
        return this._terminateHandler != null;
    }

    public List getParameters() {
        return this._parameters;
    }

    public int getFrequency() {
        return this._execFrequency;
    }

    public void increaseFrequency() {
        ++this._execFrequency;
        if (this._resultManager != null) {
            this._resultManager.fireStatusUpdated(this);
        }
    }
}

