/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.viewer;

import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.IResultSetRow;
import org.eclipse.datatools.sqltools.result.internal.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.internal.ui.LongDataDialog;
import org.eclipse.datatools.sqltools.result.internal.ui.export.actions.ExportAllResultSetsAction;
import org.eclipse.datatools.sqltools.result.internal.ui.export.actions.ExportResultSetAction;
import org.eclipse.datatools.sqltools.result.internal.ui.export.actions.PrintResultSetAction;
import org.eclipse.datatools.sqltools.result.internal.ui.export.actions.SaveAllResultSetsAction;
import org.eclipse.datatools.sqltools.result.internal.ui.export.actions.SaveResultSetAction;
import org.eclipse.datatools.sqltools.result.internal.ui.viewer.ResultSetContentProvider;
import org.eclipse.datatools.sqltools.result.internal.ui.viewer.ResultSetLabelProvider;
import org.eclipse.datatools.sqltools.result.internal.ui.viewer.ViewerSorterByColumn;
import org.eclipse.datatools.sqltools.result.internal.utils.HexHelper;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.datatools.sqltools.result.internal.utils.SQLUtil;
import org.eclipse.datatools.sqltools.result.internal.utils.UIUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ResultSetViewer
extends TableViewer {
    private IResultInstance _instance;
    private IResultSetObject _result;
    private boolean _showRowCount;
    private String[] _columnProperties;
    private Composite _parent;
    private ITableLabelProvider _labelProvider;
    private ViewerSorter _currentSorter;
    private static final double FONT_AVER_WIDTH_FACTOR = 1.6;
    private static final int MIN_WIDTH = 30;
    public static final int LONG_BOUNDARY = 100;

    public ResultSetViewer(Composite parent, int style, IResultInstance instance, IResultSetObject result, boolean showRowCount) {
        super(parent, style);
        this._showRowCount = showRowCount;
        this._instance = instance;
        this._result = result;
        this._parent = parent;
        this.configTableViewer();
        this.setInput(this._result);
        this.getTable().setSelection(0);
    }

    private void configTableViewer() {
        int i;
        this.getTable().setHeaderVisible(true);
        this.getTable().setLinesVisible(true);
        this.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                Object data;
                Table table = ResultSetViewer.this.getTable();
                Point pt = new Point(event.x, event.y);
                Rectangle clientRect = table.getClientArea();
                int columnCount = table.getColumnCount();
                int maxColumnIndex = columnCount == 0 ? 0 : columnCount - 1;
                int start = table.getTopIndex();
                int end = table.getItemCount();
                int i = 0;
                int j = 0;
                block0: for (i = start; i < end; ++i) {
                    TableItem item = table.getItem(i);
                    for (j = 0; j <= maxColumnIndex; ++j) {
                        Rectangle rect = item.getBounds(j);
                        if (rect.y > clientRect.y + clientRect.height) {
                            return;
                        }
                        if (rect.contains(pt)) break block0;
                    }
                }
                ResultSetViewer.this.setSorter(ResultSetViewer.this._currentSorter);
                Integer[] rows = (Integer[])ResultSetViewer.this.getSortedChildren(ResultSetViewer.this._result);
                IResultSetRow row = ResultSetViewer.this._result.getRowData(rows[i]);
                if (row == null) {
                    return;
                }
                if (ResultSetViewer.this._showRowCount) {
                    --j;
                }
                if ((data = row.getData(j)) == null) {
                    return;
                }
                String strValue = "";
                if (data instanceof byte[]) {
                    byte[] os = (byte[])data;
                    strValue = HexHelper.toHexString(os);
                } else {
                    strValue = data.toString();
                }
                if (strValue.length() > 100) {
                    LongDataDialog dlg = new LongDataDialog(ResultSetViewer.this.getTable().getShell(), ResultSetViewer.this._result.getColumnName(j), SQLUtil.convertToString(ResultSetViewer.this._result.getColumnSQLType(j)), strValue);
                    dlg.open();
                }
            }
        });
        int totalRowCount = this._result.getTotalRowCount();
        int rowCount = this._result.getRowCount();
        if (totalRowCount == rowCount) {
            this.getTable().setToolTipText(NLS.bind((String)Messages.ResultSection_resultset_tooltip1, (Object[])new Object[]{String.valueOf(rowCount)}));
        } else {
            this.getTable().setToolTipText(NLS.bind((String)Messages.ResultSection_resultset_tooltip, (Object[])new Object[]{String.valueOf(totalRowCount), String.valueOf(rowCount)}));
        }
        GridData tableGridData = new GridData();
        tableGridData.grabExcessHorizontalSpace = true;
        tableGridData.grabExcessVerticalSpace = true;
        tableGridData.horizontalAlignment = 4;
        tableGridData.verticalAlignment = 4;
        this.getTable().setLayoutData((Object)tableGridData);
        int columnNum = 0;
        if (this._showRowCount) {
            ++columnNum;
            TableColumn rowCountColumn = new TableColumn(this.getTable(), 0);
            rowCountColumn.setResizable(true);
        }
        this._columnProperties = new String[columnNum += this._result.getColumnCount()];
        if (this._showRowCount) {
            this._columnProperties[0] = "RowCount";
        }
        for (int i2 = 0; i2 < this._result.getColumnCount(); ++i2) {
            TableColumn column = new TableColumn(this.getTable(), 0);
            column.setText(this._result.getColumnName(i2 + 1));
            column.setResizable(true);
            final int finalIndex = i2 + 1;
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){
                private int _index;
                private int _order;
                {
                    this._index = finalIndex;
                    this._order = 1;
                }

                public void widgetSelected(SelectionEvent e) {
                    ViewerSorterByColumn sorter = new ViewerSorterByColumn(this._index, ResultSetViewer.this._result, this._order, ResultSetViewer.this._labelProvider, ResultSetViewer.this._showRowCount);
                    ResultSetViewer.this._currentSorter = sorter;
                    ResultSetViewer.this.setSorter(sorter);
                    this._order *= -1;
                    if (ResultSetViewer.this._showRowCount) {
                        Table table = ResultSetViewer.this.getTable();
                        int itemCount = table.getItemCount();
                        for (int j = 0; j < itemCount; ++j) {
                            TableItem item = table.getItem(j);
                            item.setText(0, Integer.toString(j + 1));
                        }
                    }
                }
            });
            int index = i2;
            if (this._showRowCount) {
                index = i2 + 1;
            }
            this._columnProperties[index] = this._result.getColumnName(i2 + 1);
        }
        this.setColumnProperties(this._columnProperties);
        this.setContentProvider((IContentProvider)new ResultSetContentProvider());
        this._labelProvider = new ResultSetLabelProvider(this._result, this._showRowCount);
        this.setLabelProvider((IBaseLabelProvider)this._labelProvider);
        int columnCount = this._columnProperties.length;
        int defaultWidth = 0;
        int n = i = this._showRowCount ? 1 : 0;
        if (this._showRowCount) {
            int chars = Integer.toString(rowCount).length();
            chars = chars < 2 ? 2 : chars;
            int computedWidth = Math.round(Math.round((double)UIUtil.convertWidthInCharsToPixels(chars, (Control)this._parent) * 1.6));
            if (computedWidth < 30) {
                computedWidth = 30;
            }
            this.getTable().getColumn(0).setWidth(computedWidth);
        }
        while (i < columnCount) {
            TableColumn column = this.getTable().getColumn(i);
            column.pack();
            defaultWidth = defaultWidth + column.getWidth() + this.getTable().getGridLineWidth();
            ++i;
        }
        int moreWidth = this._parent.getParent().getBounds().width - 2 - defaultWidth;
        if (moreWidth > 0) {
            for (i = this._showRowCount ? 1 : 0; i < columnCount; ++i) {
                TableColumn col = this.getTable().getColumn(i);
                int adjustColumnCount = this._showRowCount ? columnCount - 1 : columnCount;
                col.setWidth(col.getWidth() + moreWidth / adjustColumnCount);
            }
        }
        MenuManager mgr = new MenuManager();
        MenuManager saveMgr = new MenuManager(Messages.Save_name);
        saveMgr.add((IAction)new SaveResultSetAction(this.getTable().getShell(), this._result));
        saveMgr.add((IAction)new SaveAllResultSetsAction(this.getTable().getShell(), this._instance));
        MenuManager exportMgr = new MenuManager(Messages.Export_name);
        exportMgr.add((IAction)new ExportResultSetAction(this.getTable().getShell(), this._result));
        exportMgr.add((IAction)new ExportAllResultSetsAction(this.getTable().getShell(), this._instance));
        MenuManager printMgr = new MenuManager(Messages.Print_name);
        printMgr.add((IAction)new PrintResultSetAction(this._result, this._parent));
        printMgr.add((IAction)new PrintResultSetAction(this._instance, this._parent));
        mgr.add((IContributionItem)saveMgr);
        mgr.add((IContributionItem)exportMgr);
        mgr.add((IContributionItem)printMgr);
        Menu menu = mgr.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
    }

    protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
        super.doUpdateItem(widget, element, fullMap);
        if (element instanceof Integer && this._showRowCount) {
            TableItem item = this.getTable().getItem(((Integer)element).intValue());
            item.setBackground(0, ResultsViewPlugin.getDefault().getDisabledBakColor());
        }
    }
}

