/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.data.internal.core.common.data;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import org.eclipse.datatools.sqltools.data.internal.core.common.data.BigIntegerFormat;

public class ResultSetReader {
    /*
     * Unable to fully structure code
     */
    public static String toNormalString(BigDecimal decimalValue) {
        block2: {
            block3: {
                sciValue = decimalValue.toString();
                if (sciValue == null || sciValue.indexOf(69) == -1) break block2;
                sciValue = sciValue.substring(sciValue.indexOf("E", 0) + 1);
                convertedString = decimalValue.unscaledValue().toString();
                precision = Integer.parseInt(sciValue = sciValue.startsWith("+") != false ? sciValue.substring(1) : sciValue);
                if (precision >= 0) ** GOTO lbl14
                i = 0;
                while (i < Math.abs(precision)) {
                    convertedString = i == Math.abs(precision) - 1 ? "0." + convertedString : "0" + convertedString;
                    ++i;
                }
                break block3;
lbl-1000:
                // 1 sources

                {
                    convertedString = String.valueOf(convertedString) + "0";
lbl14:
                    // 2 sources

                    ** while (precision - convertedString.length() + 1 > 0)
                }
lbl15:
                // 1 sources

                convertedString = String.valueOf(convertedString) + ".0";
            }
            return convertedString;
        }
        return sciValue;
    }

    public static Object read(ResultSet rs, int column) throws SQLException, IOException {
        return ResultSetReader.read(rs, column, -1);
    }

    public static Object read(ResultSet rs, int column, int lobLimit) throws SQLException, IOException {
        int type = rs.getMetaData().getColumnType(column + 1);
        if (type == 1111) {
            return rs.getString(column + 1);
        }
        if (type == -5) {
            return new BigIntegerFormat().parse(rs.getString(column + 1));
        }
        if (type == -1) {
            return rs.getString(column + 1);
        }
        Object o = rs.getObject(column + 1);
        if (o == null) {
            return null;
        }
        if (type == 93 && !(o instanceof Timestamp)) {
            Timestamp ts = rs.getTimestamp(column + 1);
            return ResultSetReader.formatTimestamp(ts);
        }
        if (o instanceof Blob) {
            return ResultSetReader.readBinaryStream(((Blob)o).getBinaryStream(), lobLimit);
        }
        if (o instanceof Clob) {
            return ResultSetReader.readCharacterString(((Clob)o).getCharacterStream(), lobLimit);
        }
        if (o instanceof BigDecimal) {
            return ResultSetReader.toNormalString((BigDecimal)o);
        }
        if (o instanceof String) {
            return ((String)o).replaceAll("\u0000", "\ufffd");
        }
        return o;
    }

    protected static String readCharacterString(Reader r, int limit) throws SQLException, IOException {
        StringWriter w = new StringWriter();
        char[] buf = new char[256];
        int remaining = limit;
        int n = r.read(buf);
        while (n != -1) {
            w.write(buf, 0, n);
            if (limit != -1 && (remaining -= n) <= 0) break;
            n = r.read(buf);
        }
        r.close();
        w.close();
        String s = w.toString();
        if (limit != -1 && s.length() > limit) {
            s = s.substring(0, limit);
        }
        return s;
    }

    protected static Object readBinaryStream(InputStream is, int limit) throws SQLException, IOException {
        BufferedInputStream bis = new BufferedInputStream(is);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int n = ((InputStream)bis).read();
        while (n != -1) {
            os.write(n);
            if (limit != -1 && --limit <= 0) break;
            n = ((InputStream)bis).read();
        }
        ((InputStream)bis).close();
        byte[] bytes = os.toByteArray();
        os.close();
        return bytes;
    }

    protected static String formatTimestamp(Timestamp ts) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(ts);
        StringBuffer sb = new StringBuffer(30);
        sb.append(cal.get(5)).append('-');
        int mon = cal.get(2);
        switch (mon) {
            case 0: {
                sb.append("JAN-");
                break;
            }
            case 1: {
                sb.append("FEB-");
                break;
            }
            case 2: {
                sb.append("MAR-");
                break;
            }
            case 3: {
                sb.append("APR-");
                break;
            }
            case 4: {
                sb.append("MAY-");
                break;
            }
            case 5: {
                sb.append("JUN-");
                break;
            }
            case 6: {
                sb.append("JUL-");
                break;
            }
            case 7: {
                sb.append("AUG-");
                break;
            }
            case 8: {
                sb.append("SEP-");
                break;
            }
            case 9: {
                sb.append("OCT-");
                break;
            }
            case 10: {
                sb.append("NOV-");
                break;
            }
            case 11: {
                sb.append("DEC-");
            }
        }
        sb.append(cal.get(1)).append(' ');
        if (cal.get(10) == 0) {
            sb.append("12");
        } else {
            sb.append(cal.get(10));
        }
        sb.append('.').append(cal.get(12)).append('.').append(cal.get(13)).append('.').append(cal.get(14)).append(' ');
        if (cal.get(9) == 0) {
            sb.append("AM");
        } else {
            sb.append("PM");
        }
        return sb.toString();
    }
}

