/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.criteria;

import java.lang.ref.WeakReference;
import java.util.Vector;
import org.eclipse.datatools.modelbase.sql.query.Predicate;
import org.eclipse.datatools.modelbase.sql.query.QueryDeleteStatement;
import org.eclipse.datatools.modelbase.sql.query.QuerySearchCondition;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryUpdateStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionCombined;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.modelbase.sql.xml.query.XMLPredicateExists;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderDialog;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLBuilderConstants;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLStringHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SearchConditionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.swt.widgets.Display;

public class CriteriaElement {
    protected SQLQueryObject statement;
    protected QuerySearchCondition searchCon;
    protected Predicate searchPred;
    protected boolean isHaving = false;
    protected QueryValueExpression column;
    protected String operator = "";
    protected Object value;
    protected String andOr = "";
    protected SQLDomainModel domainModel;
    private boolean firstClause;
    private SearchConditionHelper searchConHelper;
    private WeakReference criteriaElementVectorRef;

    public CriteriaElement(SQLDomainModel domainModel, Object target, Object clause, Predicate predicate, boolean isHaving, boolean firstClause) {
        this.domainModel = domainModel;
        this.statement = (SQLQueryObject)target;
        this.searchCon = (QuerySearchCondition)clause;
        this.isHaving = isHaving;
        this.searchPred = predicate;
        this.firstClause = firstClause;
        this.searchConHelper = new SearchConditionHelper(domainModel);
        this.searchConHelper.setHavingClause(isHaving);
    }

    public boolean getFirstClause() {
        return this.firstClause;
    }

    public Predicate getCurrentPredicate() {
        return this.searchPred;
    }

    public SearchConditionHelper getSearchConditionHelper() {
        return this.searchConHelper;
    }

    public SQLQueryObject getSQLStatement() {
        return this.statement;
    }

    public QuerySearchCondition getSearchCondition() {
        return this.searchCon;
    }

    public void setElementProperty(Object key, Object propValue) {
        if (propValue == null) {
            return;
        }
        boolean changed = false;
        if (key == "org.eclipse.datatools.sqltools.sqlbuilder.CriteriaGridViewer.P_STATEMENT_COLUMN") {
            if (propValue instanceof String && (((String)propValue).equals(SQLBuilderConstants.P_BUILD_EXPRESSION) || ((String)propValue).equals(SQLBuilderConstants.P_EDIT_EXPRESSION) || ((String)propValue).equals(SQLBuilderConstants.P_REPLACE_EXPRESSION))) {
                QueryValueExpression expr = this.showExpressionBuilder(key, false, (String)propValue);
                if (expr != null) {
                    this.column = expr;
                }
            } else if (propValue instanceof String && ((String)propValue).trim().equals("")) {
                this.column = null;
            } else if (propValue instanceof QueryValueExpression) {
                this.column = propValue instanceof ValueExpressionColumn ? ExpressionHelper.createValueExpressionColumn((ValueExpressionColumn)propValue) : (QueryValueExpression)propValue;
            }
            if (this.column != null) {
                changed = this.updateColumn();
            }
        } else if (key == "org.eclipse.datatools.sqltools.sqlbuilder.CriteriaGridViewer.P_STATEMENT_OPERATOR") {
            if (this.searchCon != null) {
                if (propValue instanceof String) {
                    this.operator = (String)propValue;
                    changed = this.updateOperator((String)propValue);
                }
            } else if (propValue instanceof String && ("EXISTS".equals(propValue) || "XMLEXISTS".equals(propValue))) {
                this.createSearchCondition();
                changed = this.searchConHelper.setOperatorInPredicate(this.statement, StatementHelper.getSearchCondition((SQLQueryObject)this.statement), this.searchPred, (String)propValue);
            }
        } else if (key == "org.eclipse.datatools.sqltools.sqlbuilder.CriteriaGridViewer.P_STATEMENT_VALUE") {
            if (this.searchCon != null) {
                if (propValue instanceof String && (((String)propValue).equals(SQLBuilderConstants.P_BUILD_EXPRESSION) || ((String)propValue).equals(SQLBuilderConstants.P_EDIT_EXPRESSION) || ((String)propValue).equals(SQLBuilderConstants.P_REPLACE_EXPRESSION))) {
                    QueryValueExpression expr = this.showExpressionBuilder(key, false, (String)propValue);
                    if (expr != null) {
                        this.value = expr.getSQL();
                    }
                } else if (propValue instanceof String && ((String)propValue).trim().equals("")) {
                    this.value = null;
                } else if (propValue instanceof QueryValueExpression) {
                    this.value = ((QueryValueExpression)propValue).getSQL();
                }
                if (this.searchPred instanceof XMLPredicateExists) {
                    this.value = " (" + this.value + " )";
                }
                changed = this.updateValue();
            }
        } else if (key == "org.eclipse.datatools.sqltools.sqlbuilder.CriteriaGridViewer.P_STATEMENT_ANDOR" && propValue instanceof String && this.searchCon != null) {
            if (!((String)propValue).equals("")) {
                this.andOr = (String)propValue;
                changed = this.setAndOr((String)propValue);
            } else {
                Vector criteriaElements = (Vector)this.getCriteriaElementVectorRef().get();
                int currIdx = criteriaElements.indexOf(this);
                CriteriaElement tempCriteriaElement = null;
                if (criteriaElements.size() > currIdx + 1) {
                    tempCriteriaElement = (CriteriaElement)criteriaElements.get(currIdx + 1);
                }
                if (tempCriteriaElement != null && (tempCriteriaElement.getColumn() == null || tempCriteriaElement.getColumn().getSQL().equalsIgnoreCase("NULL")) && (tempCriteriaElement.getValue().equals("") || tempCriteriaElement.getValue().equalsIgnoreCase("NULL")) && (tempCriteriaElement.getOperator().equals("") || tempCriteriaElement.getOperator().equals("="))) {
                    Predicate nextPred = tempCriteriaElement.getCurrentPredicate();
                    this.searchConHelper.removePredicateFromCondition(nextPred, this.searchCon, this.statement);
                    changed = true;
                }
            }
        }
        if (changed) {
            if (this.statement instanceof QueryUpdateStatement) {
                ((QueryUpdateStatement)this.statement).setWhereClause(((QueryUpdateStatement)this.statement).getWhereClause());
            }
            if (this.statement instanceof QueryDeleteStatement) {
                ((QueryDeleteStatement)this.statement).setWhereClause(((QueryDeleteStatement)this.statement).getWhereClause());
            }
            if (this.statement instanceof QuerySelectStatement) {
                ((QuerySelectStatement)this.statement).setQueryExpr(((QuerySelectStatement)this.statement).getQueryExpr());
            } else if (this.statement instanceof QuerySelect) {
                SelectHelper.refresh(this.statement);
            }
        }
    }

    public String getColumnText(int columnIndex) {
        if (columnIndex == 0) {
            if (this.searchPred != null) {
                this.column = this.getColumn();
            }
            if (this.column != null) {
                String result = SQLStringHelper.trimBlanks(this.column.getSQL());
                return result;
            }
        } else {
            if (columnIndex == 1) {
                if (this.searchPred != null) {
                    this.operator = this.getOperator();
                }
                return this.operator;
            }
            if (columnIndex == 2) {
                if (this.searchPred != null) {
                    this.value = this.getValue();
                }
                if (this.value != null) {
                    String result = SQLStringHelper.trimBlanks(this.value.toString());
                    return result;
                }
            } else if (columnIndex == 3) {
                if (this.searchPred != null) {
                    this.andOr = this.getAndOr();
                }
                return this.andOr;
            }
        }
        return "";
    }

    protected boolean createSearchCondition() {
        boolean created = false;
        if (this.searchPred == null) {
            if (this.searchCon == null) {
                QuerySearchCondition newSearchCon = this.searchConHelper.buildSearchCondition(this.statement, null, this.column, (String)this.value, this.operator);
                if (newSearchCon != null) {
                    if (!this.isHaving) {
                        StatementHelper.setWhereClauseForStatement((QuerySearchCondition)newSearchCon, (SQLQueryObject)this.statement);
                    } else {
                        StatementHelper.setHavingClauseForStatement((QuerySearchCondition)newSearchCon, (SQLQueryObject)this.statement);
                    }
                    this.searchPred = (Predicate)newSearchCon;
                    created = true;
                }
            } else {
                QuerySearchCondition newSearchCon = this.searchConHelper.buildSearchCondition(this.statement, this.searchCon, this.column, (String)this.value, this.operator);
                if (newSearchCon != null) {
                    this.searchPred = (Predicate)newSearchCon.getCombinedRight();
                    created = true;
                }
            }
        }
        return created;
    }

    private boolean isValueNeeded() {
        return !this.operator.equals("IS NULL") && !this.operator.equals("IS NOT NULL");
    }

    private boolean isColumnNeeded() {
        if (this.operator.equals("EXISTS")) {
            return false;
        }
        return !this.operator.equals("XMLEXISTS");
    }

    protected QueryValueExpression getColumn() {
        return this.searchConHelper.getLeftFromPredicate(this.searchPred);
    }

    protected String getValue() {
        return this.searchConHelper.getRightFromPredicate(this.searchPred);
    }

    protected String getOperator() {
        if (this.searchPred != null) {
            return this.searchConHelper.getPredicateOperator(this.searchPred);
        }
        return null;
    }

    protected String getAndOr() {
        String opValue = "";
        if (this.searchPred.getCombinedLeft() != null) {
            SearchConditionCombined scg = this.searchPred.getCombinedLeft();
            if (scg != null) {
                opValue = scg.getCombinedOperator().toString();
            }
        } else {
            SearchConditionCombined target;
            SearchConditionCombined scg = this.searchPred.getCombinedRight();
            if (scg != null && (target = scg.getCombinedLeft()) != null) {
                opValue = target.getCombinedOperator().toString();
            }
        }
        return opValue;
    }

    protected boolean updateColumn() {
        boolean updated = false;
        if (this.column != null) {
            if (this.searchCon == null) {
                this.createSearchCondition();
            }
            QueryValueExpression expr = ExpressionHelper.createExpression(this.column);
            updated = this.searchConHelper.setLeftInPredicate(this.searchPred, expr);
        }
        return updated;
    }

    protected boolean updateOperator(String newValue) {
        if (this.searchCon != null) {
            this.searchConHelper.setOperatorInPredicate(this.statement, this.searchCon, this.searchPred, newValue);
            if (!this.isValueNeeded()) {
                this.value = null;
            } else if (!this.isColumnNeeded()) {
                this.column = null;
                this.updateColumn();
            }
        }
        return true;
    }

    protected boolean updateValue() {
        boolean updated = true;
        String newRight = "";
        QueryValueExpression newLeft = null;
        Predicate newPredicate = null;
        if (this.value != null && !this.value.equals("") && (newPredicate = this.searchConHelper.buildNewPredicate(this.statement, this.column, this.value.toString(), this.operator)) == null) {
            newLeft = this.searchConHelper.getDefaultLeft(this.operator);
            newPredicate = this.searchConHelper.buildNewPredicate(this.statement, newLeft, this.value.toString(), this.operator);
        }
        if (newPredicate == null) {
            newRight = this.searchConHelper.getDefaultRight(this.operator);
            newPredicate = this.searchConHelper.buildNewPredicate(this.statement, this.column, newRight, this.operator);
        }
        if (newPredicate == null) {
            newPredicate = this.searchConHelper.buildNewPredicate(this.statement, newLeft, newRight, this.operator);
        }
        if (newPredicate != null) {
            this.searchConHelper.replacePredicate(this.statement, this.searchCon, this.searchPred, newPredicate);
            this.searchPred = newPredicate;
            updated = true;
        } else {
            updated = false;
        }
        return updated;
    }

    public boolean setAndOr(String andOrString) {
        QuerySearchCondition tmpSearchCon = this.searchConHelper.setAndOrInSearchCondition(this.statement, this.searchCon, this.searchPred, andOrString);
        if (tmpSearchCon != this.searchCon) {
            if (!this.isHaving) {
                StatementHelper.setWhereClauseForStatement((QuerySearchCondition)tmpSearchCon, (SQLQueryObject)this.statement);
            } else {
                StatementHelper.setHavingClauseForStatement((QuerySearchCondition)tmpSearchCon, (SQLQueryObject)this.statement);
            }
        }
        return true;
    }

    public QueryValueExpression showExpressionBuilder(boolean isColumn, String sProperty) {
        ExpressionBuilderWizard wizard = new ExpressionBuilderWizard(this.domainModel, this.statement);
        if (sProperty.equals(SQLBuilderConstants.P_BUILD_EXPRESSION) || sProperty.equals(SQLBuilderConstants.P_REPLACE_EXPRESSION)) {
            wizard.setInputExpression(null);
        } else if (sProperty.equals(SQLBuilderConstants.P_EDIT_EXPRESSION)) {
            if (this.searchPred != null) {
                QueryValueExpression expr = ExpressionHelper.createExpression(this.searchConHelper.getRightFromPredicate(this.searchPred));
                wizard.setInputExpression(expr);
            } else {
                return null;
            }
        }
        wizard.setIsColumn(isColumn);
        ExpressionBuilderDialog dialog = new ExpressionBuilderDialog(Display.getDefault().getActiveShell(), wizard);
        dialog.create();
        dialog.setBlockOnOpen(true);
        int result = dialog.open();
        if (result == 0) {
            return wizard.getSQLExpression();
        }
        return null;
    }

    public QueryValueExpression showExpressionBuilder(Object key, boolean isColumn, String sProperty) {
        ExpressionBuilderWizard wizard = new ExpressionBuilderWizard(this.domainModel, this.statement);
        if (key == "org.eclipse.datatools.sqltools.sqlbuilder.CriteriaGridViewer.P_STATEMENT_COLUMN" || this.value instanceof QueryValueExpression && key == "org.eclipse.datatools.sqltools.sqlbuilder.CriteriaGridViewer.P_STATEMENT_VALUE") {
            if (sProperty.equals(SQLBuilderConstants.P_BUILD_EXPRESSION) || sProperty.equals(SQLBuilderConstants.P_REPLACE_EXPRESSION)) {
                wizard.setInputExpression(null);
            } else if (sProperty.equals(SQLBuilderConstants.P_EDIT_EXPRESSION)) {
                if (key == "org.eclipse.datatools.sqltools.sqlbuilder.CriteriaGridViewer.P_STATEMENT_COLUMN") {
                    if (this.column != null) {
                        wizard.setInputExpression(this.column);
                    }
                } else if (key == "org.eclipse.datatools.sqltools.sqlbuilder.CriteriaGridViewer.P_STATEMENT_VALUE") {
                    if (this.value != null) {
                        wizard.setInputExpression((QueryValueExpression)this.value);
                    }
                } else {
                    wizard.setInputExpression(null);
                }
            }
        }
        wizard.setIsColumn(isColumn);
        ExpressionBuilderDialog dialog = new ExpressionBuilderDialog(Display.getDefault().getActiveShell(), wizard);
        dialog.create();
        dialog.setBlockOnOpen(true);
        int result = dialog.open();
        if (result == 0) {
            return wizard.getSQLExpression();
        }
        return null;
    }

    public WeakReference getCriteriaElementVectorRef() {
        return this.criteriaElementVectorRef;
    }

    public void setCriteriaElementVectorRef(WeakReference criteriaElementVectorRef) {
        this.criteriaElementVectorRef = criteriaElementVectorRef;
    }
}

