/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.query.PredicateBasic;
import org.eclipse.datatools.modelbase.sql.query.QueryDeleteStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryInsertStatement;
import org.eclipse.datatools.modelbase.sql.query.QuerySearchCondition;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryUpdateStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionCombined;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionNested;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.TableJoined;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.helper.TableHelper;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderPlugin;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.InsertHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.UpdateHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.ColumnEditPolicy;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.ColumnSelectionEditPolicy;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.ConnectionCreationDragTracker;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.ISQLEditPart;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.JoinEditPart;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.SQLRootEditPart;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.TableEditPart;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.figures.EdgeChopBoxConnector;
import org.eclipse.draw2d.ChangeEvent;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.FocusListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Toggle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class ColumnEditPart
extends AbstractGraphicalEditPart
implements NodeEditPart,
ISQLEditPart {
    SQLQueryObject sqlStatement;
    ValueExpressionColumn sqlColumnExpr;
    ValueExpressionColumn currentColumn;
    TableEditPart tableEditPart;
    Hashtable matchingSQLJoins = new Hashtable();
    protected Toggle checkBox;
    protected Label keyIcon;
    protected static final Image unCheckedImage = SQLBuilderPlugin.getSQLImage("icons/checkboxoff.gif");
    protected static final Image checkedImage = SQLBuilderPlugin.getSQLImage("icons/checkboxon.gif");
    protected Label unCheckedLabel = new Label(unCheckedImage);
    protected Label checkedLabel = new Label(checkedImage);
    protected Label label;
    private SQLDomainModel domainModel;

    public ColumnEditPart(Object model, TableEditPart tableEditPart, SQLDomainModel domainModel) {
        if (model instanceof ValueExpressionColumn) {
            this.currentColumn = (ValueExpressionColumn)model;
        }
        this.setModel(model);
        this.tableEditPart = tableEditPart;
        this.domainModel = domainModel;
    }

    public TableEditPart getTableEditPart() {
        return this.tableEditPart;
    }

    public String getToolTip() {
        DataType type = null;
        Object model = this.getModel();
        if (model instanceof ValueExpressionColumn) {
            ValueExpressionColumn colExpr = (ValueExpressionColumn)model;
            type = colExpr.getDataType();
        }
        if (type != null) {
            return type.getName();
        }
        return "";
    }

    protected IFigure createFigure() {
        ColumnFigure colFigure = new ColumnFigure();
        colFigure.setLayoutManager((LayoutManager)new FlowLayout());
        colFigure.setOpaque(true);
        colFigure.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent arg0) {
                if (arg0.gainer != null) {
                    ((ColumnFigure)arg0.gainer).setSelectedColors();
                }
            }

            public void focusLost(FocusEvent arg0) {
                if (arg0.loser != null) {
                    ((ColumnFigure)arg0.loser).setDeselectedColors();
                }
            }
        });
        this.checkBox = new MyCheckBox(this.domainModel.getSQLStatement());
        this.checkBox.setOpaque(true);
        this.checkBox.setBackgroundColor(ColorConstants.white);
        this.checkBox.setForegroundColor(ColorConstants.black);
        this.checkBox.addChangeListener((ChangeListener)new CheckBoxListener());
        this.checkBox.setFocusTraversable(false);
        this.checkBox.setRequestFocusEnabled(false);
        this.keyIcon = new Label("");
        colFigure.add((IFigure)this.checkBox);
        this.label = new Label("");
        colFigure.add((IFigure)this.label);
        if (TableHelper.isPrimaryKey((ValueExpressionColumn)this.currentColumn)) {
            this.keyIcon.setIcon(SQLBuilderPlugin.getSQLImage("icons/PrimaryKey.gif"));
            colFigure.add((IFigure)this.keyIcon);
        } else if (TableHelper.isForeignKey((ValueExpressionColumn)this.currentColumn)) {
            this.keyIcon.setIcon(SQLBuilderPlugin.getSQLImage("icons/ForeignKey.gif"));
            colFigure.add((IFigure)this.keyIcon);
        }
        return colFigure;
    }

    public void setModel(Object model) {
        super.setModel(model);
    }

    protected void createEditPolicies() {
        SQLQueryObject statement = (SQLQueryObject)this.getMyRoot().getModel();
        if (statement instanceof QuerySelectStatement || statement instanceof QuerySelect) {
            if (statement instanceof QuerySelectStatement) {
                statement = SelectHelper.getQuerySelect((QuerySelectStatement)statement);
            }
            if (statement != null) {
                ColumnEditPolicy connIp = new ColumnEditPolicy((QuerySelect)statement);
                this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)connIp);
                ColumnSelectionEditPolicy colEditPol = new ColumnSelectionEditPolicy();
                this.installEditPolicy("Selection Feedback", (EditPolicy)colEditPol);
            }
        }
    }

    public void update(Object child) {
        JoinEditPart editPart;
        List childList = this.getSourceConnections();
        int i = 0;
        while (i < childList.size()) {
            editPart = (JoinEditPart)childList.get(i);
            editPart.refreshVisuals();
            ++i;
        }
        childList = this.getTargetConnections();
        i = 0;
        while (i < childList.size()) {
            editPart = (JoinEditPart)childList.get(i);
            editPart.refreshVisuals();
            ++i;
        }
        if (child instanceof ValueExpressionColumn) {
            ValueExpressionColumn valueExpr = (ValueExpressionColumn)child;
            if (this.getModel() == valueExpr) {
                this.refreshVisuals();
                return;
            }
        } else if (child == null) {
            this.refreshVisuals();
        }
        this.refresh();
    }

    protected void selectColumn() {
        for (ColumnEditPart colEditPart : this.getTableEditPart().getChildren()) {
            this.getViewer().deselect((EditPart)colEditPart);
        }
        this.getViewer().select((EditPart)this);
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connVO) {
        return new EdgeChopBoxConnector(this.getFigure(), ((AbstractGraphicalEditPart)this.getParent()).getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new EdgeChopBoxConnector(this.getFigure(), ((AbstractGraphicalEditPart)this.getParent()).getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connVO) {
        return new EdgeChopBoxConnector(this.getFigure(), ((AbstractGraphicalEditPart)this.getParent()).getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new EdgeChopBoxConnector(this.getFigure(), ((AbstractGraphicalEditPart)this.getParent()).getFigure());
    }

    protected void refreshVisuals() {
        this.getLabel().setText(this.currentColumn.getName());
        this.getCheckBox().setSelected(this.isColumnSelected());
        SQLQueryObject sqlStatement = this.getStatement();
        QuerySelect querySelect = null;
        if (sqlStatement instanceof QuerySelect) {
            querySelect = (QuerySelect)sqlStatement;
        } else if (sqlStatement instanceof QuerySelectStatement) {
            QuerySelectStatement selectStmt = (QuerySelectStatement)sqlStatement;
            querySelect = SelectHelper.getQuerySelect(selectStmt);
        }
        if (querySelect != null) {
            if (SelectHelper.isSelectStarQuery(querySelect)) {
                this.getCheckBox().setBackgroundColor(ColorConstants.black);
            } else {
                this.getCheckBox().setBackgroundColor(ColorConstants.white);
            }
        }
    }

    protected Toggle getCheckBox() {
        return this.checkBox;
    }

    public DragTracker getDragTracker(Request request) {
        SQLQueryObject statement = (SQLQueryObject)this.getMyRoot().getModel();
        if (statement instanceof QuerySelectStatement || statement instanceof QuerySelect) {
            ConnectionCreationDragTracker tracker = new ConnectionCreationDragTracker(this);
            return tracker;
        }
        return super.getDragTracker(request);
    }

    public Label getLabel() {
        return this.label;
    }

    public SQLQueryObject getStatement() {
        return (SQLQueryObject)this.getMyRoot().getModel();
    }

    public EditPart getMyRoot() {
        List childList = this.getRoot().getChildren();
        for (Object child : childList) {
            if (!(child instanceof SQLRootEditPart)) continue;
            return (EditPart)child;
        }
        return null;
    }

    private boolean isColumnSelected() {
        boolean status = false;
        this.sqlStatement = (SQLQueryObject)this.getMyRoot().getModel();
        if (this.sqlStatement instanceof QuerySelectStatement || this.sqlStatement instanceof QuerySelect) {
            if (this.currentColumn != null) {
                if (this.sqlStatement instanceof QuerySelectStatement) {
                    status = SelectHelper.isResultColumn(this.sqlStatement, this.currentColumn);
                } else if (this.sqlStatement instanceof QuerySelect) {
                    status = SelectHelper.isResultColumn((QuerySelect)this.sqlStatement, this.currentColumn);
                }
            } else {
                status = false;
            }
        } else if (this.sqlStatement instanceof QueryInsertStatement) {
            QueryInsertStatement insertStmt = (QueryInsertStatement)this.sqlStatement;
            EList columnList = insertStmt.getTargetColumnList();
            if (this.currentColumn != null) {
                status = this.isColumnInColumnList(this.currentColumn, (List)columnList);
            }
        } else if (this.sqlStatement instanceof QueryUpdateStatement) {
            QueryUpdateStatement updateStmt = (QueryUpdateStatement)this.sqlStatement;
            List columnList = UpdateHelper.getTargetColumns(updateStmt);
            if (this.currentColumn != null) {
                status = this.isColumnInColumnList(this.currentColumn, columnList);
            }
        }
        return status;
    }

    boolean isColumnInColumnList(ValueExpressionColumn column, List colList) {
        boolean contains = false;
        if (colList != null) {
            Iterator columnItr = colList.iterator();
            String colName = column.getName();
            while (!contains && columnItr.hasNext()) {
                String currentName = ((ValueExpressionColumn)columnItr.next()).getName();
                if (!colName.equals(currentName)) continue;
                contains = true;
            }
        }
        return contains;
    }

    protected ConnectionEditPart createConnection(Object model) {
        Object part = (ConnectionEditPart)this.getRoot().getViewer().getEditPartRegistry().get(model);
        if (part == null) {
            part = new JoinEditPart((PredicateBasic)model, (SQLQueryObject)this.matchingSQLJoins.get(model));
        }
        return part;
    }

    protected List getModelSourceConnections() {
        ArrayList<PredicateBasic> sources = new ArrayList<PredicateBasic>();
        List allJoin = this.tableEditPart.getLeftJoinTables();
        allJoin.addAll(this.tableEditPart.getRightJoinTables());
        for (TableJoined join : allJoin) {
            QuerySearchCondition searchCond = join.getJoinCondition();
            List predicateList = this.findLeftColumnPredicates(searchCond);
            for (PredicateBasic predicate : predicateList) {
                sources.add(predicate);
                this.matchingSQLJoins.put(predicate, join);
            }
        }
        QuerySearchCondition whereCondition = null;
        if (this.sqlStatement instanceof QuerySelectStatement) {
            QuerySelect qSelect = SelectHelper.getQuerySelect((QuerySelectStatement)this.sqlStatement);
            if (qSelect != null) {
                whereCondition = qSelect.getWhereClause();
            }
        } else if (this.sqlStatement instanceof QuerySelect) {
            whereCondition = ((QuerySelect)this.sqlStatement).getWhereClause();
        }
        if (whereCondition != null) {
            List whereClausePredicates = this.findLeftColumnPredicates(whereCondition);
            for (PredicateBasic predicate : whereClausePredicates) {
                sources.add(predicate);
                this.matchingSQLJoins.put(predicate, whereCondition);
            }
        }
        return sources;
    }

    private List findLeftColumnPredicates(QuerySearchCondition cond) {
        QuerySearchCondition nestedCondition;
        List nestedResults;
        ArrayList<PredicateBasic> result = new ArrayList<PredicateBasic>();
        if (cond instanceof PredicateBasic) {
            ValueExpressionColumn colExpr;
            PredicateBasic sqlPredicate = (PredicateBasic)cond;
            if (sqlPredicate.getRightValueExpr() instanceof ValueExpressionColumn && sqlPredicate.getLeftValueExpr() instanceof ValueExpressionColumn && (colExpr = (ValueExpressionColumn)sqlPredicate.getLeftValueExpr()).getName().trim().equalsIgnoreCase(this.currentColumn.getName().trim())) {
                TableExpression currentTable = this.currentColumn.getParentTableExpr();
                TableExpression predTable = colExpr.getTableExpr();
                if (currentTable != null && predTable != null && currentTable.getName().trim().equalsIgnoreCase(predTable.getName().trim())) {
                    result.add(sqlPredicate);
                }
            }
        } else if (cond instanceof SearchConditionCombined) {
            SearchConditionCombined grp = (SearchConditionCombined)cond;
            List nestedResult = this.findLeftColumnPredicates(grp.getLeftCondition());
            if (nestedResult != null) {
                result.addAll(nestedResult);
            }
            if ((nestedResult = this.findLeftColumnPredicates(grp.getRightCondition())) != null) {
                result.addAll(nestedResult);
            }
        } else if (cond instanceof SearchConditionNested && (nestedResults = this.findLeftColumnPredicates(nestedCondition = ((SearchConditionNested)cond).getNestedCondition())) != null) {
            result.addAll(nestedResults);
        }
        return result;
    }

    protected List getModelTargetConnections() {
        ArrayList<PredicateBasic> targets = new ArrayList<PredicateBasic>();
        List allJoin = this.tableEditPart.getRightJoinTables();
        allJoin.addAll(this.tableEditPart.getLeftJoinTables());
        for (TableJoined join : allJoin) {
            QuerySearchCondition searchCond = join.getJoinCondition();
            List predicates = this.findRightColumnPredicates(searchCond);
            for (PredicateBasic predicate : predicates) {
                if (predicate == null) continue;
                targets.add(predicate);
                this.matchingSQLJoins.put(predicate, join);
            }
        }
        QuerySearchCondition whereCondition = null;
        if (this.sqlStatement instanceof QuerySelectStatement) {
            QuerySelect qSelect = SelectHelper.getQuerySelect((QuerySelectStatement)this.sqlStatement);
            if (qSelect != null) {
                whereCondition = qSelect.getWhereClause();
            }
        } else if (this.sqlStatement instanceof QuerySelect) {
            whereCondition = ((QuerySelect)this.sqlStatement).getWhereClause();
        }
        if (whereCondition != null) {
            List whereClausePredicates = this.findRightColumnPredicates(whereCondition);
            for (PredicateBasic predicate : whereClausePredicates) {
                targets.add(predicate);
                this.matchingSQLJoins.put(predicate, whereCondition);
            }
        }
        return targets;
    }

    private List findRightColumnPredicates(QuerySearchCondition cond) {
        QuerySearchCondition nestedCondition;
        List nestedResults;
        ArrayList<PredicateBasic> result = new ArrayList<PredicateBasic>();
        if (cond instanceof PredicateBasic) {
            ValueExpressionColumn colExpr;
            PredicateBasic sqlPredicate = (PredicateBasic)cond;
            if (sqlPredicate.getRightValueExpr() instanceof ValueExpressionColumn && sqlPredicate.getLeftValueExpr() instanceof ValueExpressionColumn && (colExpr = (ValueExpressionColumn)sqlPredicate.getRightValueExpr()).getName().trim().equalsIgnoreCase(this.currentColumn.getName().trim())) {
                TableExpression currentTable = this.currentColumn.getParentTableExpr();
                TableExpression predTable = colExpr.getTableExpr();
                if (currentTable != null && predTable != null && currentTable.getName().trim().equalsIgnoreCase(predTable.getName().trim())) {
                    result.add(sqlPredicate);
                }
            }
        } else if (cond instanceof SearchConditionCombined) {
            SearchConditionCombined grp = (SearchConditionCombined)cond;
            List nestedResult = this.findRightColumnPredicates(grp.getLeftCondition());
            if (nestedResult != null) {
                result.addAll(nestedResult);
            }
            if ((nestedResult = this.findRightColumnPredicates(grp.getRightCondition())) != null) {
                result.addAll(nestedResult);
            }
        } else if (cond instanceof SearchConditionNested && (nestedResults = this.findRightColumnPredicates(nestedCondition = ((SearchConditionNested)cond).getNestedCondition())) != null) {
            result.addAll(nestedResults);
        }
        return result;
    }

    public void checkBoxAction(boolean status) {
        if (status) {
            if (this.sqlStatement instanceof QuerySelectStatement || this.sqlStatement instanceof QuerySelect) {
                this.sqlColumnExpr = ExpressionHelper.createValueExpressionColumn(this.currentColumn);
                SelectHelper.appendResultColumn(this.sqlStatement, (QueryValueExpression)this.sqlColumnExpr, "");
                SelectHelper.refresh(this.sqlStatement);
            } else if (this.sqlStatement instanceof QueryInsertStatement) {
                AdapterFactoryEditingDomain editDomain = this.domainModel.getEditingDomain();
                QueryInsertStatement insStatement = (QueryInsertStatement)this.sqlStatement;
                Column col = TableHelper.getColumnForColumnExpression((TableExpression)insStatement.getTargetTable(), (ValueExpressionColumn)this.currentColumn);
                InsertHelper.addDefaultInsertValue((EditingDomain)editDomain, insStatement, col);
            } else if (this.sqlStatement instanceof QueryUpdateStatement) {
                QueryUpdateStatement updateStmt = (QueryUpdateStatement)this.sqlStatement;
                Column col = TableHelper.getColumnForColumnExpression((TableExpression)updateStmt.getTargetTable(), (ValueExpressionColumn)this.currentColumn);
                UpdateHelper.addColumn(updateStmt, col);
            }
        } else if (this.sqlStatement instanceof QuerySelectStatement || this.sqlStatement instanceof QuerySelect) {
            this.sqlColumnExpr = ExpressionHelper.createValueExpressionColumn(this.currentColumn);
            if (this.sqlStatement instanceof QuerySelectStatement) {
                SelectHelper.removeAllColumnFromOrderBy((QuerySelectStatement)this.sqlStatement, (QueryValueExpression)this.sqlColumnExpr);
            }
            SelectHelper.removeAllColumnFromResultColumns(this.sqlStatement, (QueryValueExpression)this.sqlColumnExpr);
            SelectHelper.refresh(this.sqlStatement);
        } else if (this.sqlStatement instanceof QueryInsertStatement) {
            InsertHelper.removeColumn((QueryInsertStatement)this.sqlStatement, this.currentColumn);
        } else if (this.sqlStatement instanceof QueryUpdateStatement) {
            UpdateHelper.removeColumn((QueryUpdateStatement)this.sqlStatement, this.currentColumn);
        }
    }

    protected class CheckBoxListener
    implements ChangeListener {
        protected CheckBoxListener() {
        }

        public void handleStateChanged(ChangeEvent event) {
            MyCheckBox checkbox = (MyCheckBox)((Object)event.getSource());
            if (event.getPropertyName().equals("pressed") && !checkbox.getModel().isPressed()) {
                ColumnEditPart.this.checkBoxAction(checkbox.isSelected());
            }
        }
    }

    public class ColumnFigure
    extends Figure {
        Color bColor = this.getBackgroundColor();
        Color fColor = this.getForegroundColor();

        public void setSelectedColors() {
            this.setBackgroundColor(ColorConstants.menuBackgroundSelected);
            this.setForegroundColor(ColorConstants.menuForegroundSelected);
        }

        public void setDeselectedColors() {
            this.setBackgroundColor(this.bColor);
            this.setForegroundColor(this.fColor);
        }
    }

    public class MyCheckBox
    extends Toggle {
        public MyCheckBox(QueryStatement stmt) {
            super((IFigure)ColumnEditPart.this.unCheckedLabel);
            if (stmt instanceof QueryDeleteStatement) {
                this.setEnabled(false);
            }
            this.addChangeListener(new ChangeListener(){

                public void handleStateChanged(ChangeEvent e) {
                    if (e.getPropertyName() == "selected") {
                        MyCheckBox.this.forwardSetContents((IFigure)(MyCheckBox.this.isSelected() ? ((MyCheckBox)MyCheckBox.this).ColumnEditPart.this.checkedLabel : ((MyCheckBox)MyCheckBox.this).ColumnEditPart.this.unCheckedLabel));
                    }
                }
            });
        }

        public void forwardSetContents(IFigure contents) {
            this.setContents(contents);
        }
    }
}

