/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.internal.core.definition;

import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DefaultDataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.DDLGenerator;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.DDLParser;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.DeltaDDLGenerator;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.ICatalogProvider;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.fe.GenericDdlGenerator;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.fe.GenericDeltaDdlGenerator;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.jdbc.JDBCProvider;
import org.eclipse.datatools.modelbase.dbdefinition.ColumnDefinition;
import org.eclipse.datatools.modelbase.dbdefinition.ConstraintDefinition;
import org.eclipse.datatools.modelbase.dbdefinition.DatabaseVendorDefinition;
import org.eclipse.datatools.modelbase.dbdefinition.DebuggerDefinition;
import org.eclipse.datatools.modelbase.dbdefinition.FieldQualifierDefinition;
import org.eclipse.datatools.modelbase.dbdefinition.IndexDefinition;
import org.eclipse.datatools.modelbase.dbdefinition.NicknameDefinition;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.dbdefinition.QueryDefinition;
import org.eclipse.datatools.modelbase.dbdefinition.SQLSyntaxDefinition;
import org.eclipse.datatools.modelbase.dbdefinition.SchemaDefinition;
import org.eclipse.datatools.modelbase.dbdefinition.SequenceDefinition;
import org.eclipse.datatools.modelbase.dbdefinition.StoredProcedureDefinition;
import org.eclipse.datatools.modelbase.dbdefinition.TableDefinition;
import org.eclipse.datatools.modelbase.dbdefinition.TableSpaceDefinition;
import org.eclipse.datatools.modelbase.dbdefinition.TriggerDefinition;
import org.eclipse.datatools.modelbase.dbdefinition.UserDefinedTypeDefinition;
import org.eclipse.datatools.modelbase.dbdefinition.ViewDefinition;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.datatypes.ApproximateNumericDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.BinaryStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.CharacterStringDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DataLinkDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.FixedPrecisionDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.IntegerDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.IntervalDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.IntervalQualifierType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PrimitiveType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataTypesFactory;
import org.eclipse.datatools.modelbase.sql.datatypes.TimeDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;

public class DatabaseDefinitionImpl
implements DatabaseDefinition {
    private String product;
    private String version;
    private String description;
    private String productDisplayString;
    private String versionDisplayString;
    private URL modelURL;
    private DatabaseVendorDefinition databaseVendorDefinition = null;
    private HashMap nameToPrimitiveDataTypeDefinitionMap = null;
    private HashMap nameAndJDBCEnumToPrimitiveDataTypeDefinitionMap = null;
    private DataModelElementFactory factory = null;
    private DDLParser parser = null;
    private DDLGenerator ddlGenerator = null;
    private DeltaDDLGenerator deltaDdlGenerator = null;
    private ICatalogProvider catalogProvider = null;

    DatabaseDefinitionImpl(String product, String version, String desc, String productDisplayString, String versionDisplayString, URL modelURL) {
        this.product = product;
        this.version = version;
        this.description = desc;
        this.productDisplayString = productDisplayString;
        this.versionDisplayString = versionDisplayString;
        this.modelURL = modelURL;
    }

    public String getProduct() {
        return this.product;
    }

    public String getProductDisplayString() {
        return this.productDisplayString;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVersionDisplayString() {
        return this.versionDisplayString;
    }

    public String getDescription() {
        return this.description;
    }

    public DataModelElementFactory getDataModelElementFactory() {
        if (this.factory == null) {
            this.factory = DefaultDataModelElementFactory.INSTANCE;
            IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.datatools.connectivity.sqm.core", "dataModelElementFactory");
            IExtension[] extensions = extensionPoint.getExtensions();
            block2: for (int i = 0; i < extensions.length; ++i) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                for (int j = 0; j < configElements.length; ++j) {
                    String version;
                    String product;
                    if (!configElements[j].getName().equals("factory") || !(product = configElements[j].getAttribute("product")).equals(this.product) || !(version = configElements[j].getAttribute("version")).equals(this.version)) continue;
                    try {
                        this.factory = (DataModelElementFactory)configElements[j].createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, "The error was detected when creating the element factory for " + product + " " + version, (Throwable)e);
                        RDBCorePlugin.getDefault().getLog().log((IStatus)status);
                    }
                    continue block2;
                }
            }
        }
        return this.factory;
    }

    public ICatalogProvider getDatabaseCatalogProvider() {
        if (this.catalogProvider == null) {
            IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.datatools.connectivity.sqm.core", "catalog");
            IExtension[] extensions = extensionPoint.getExtensions();
            block2: for (int i = 0; i < extensions.length; ++i) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                for (int j = 0; j < configElements.length; ++j) {
                    String version;
                    String product;
                    if (!configElements[j].getName().equals("catalog") || !(product = configElements[j].getAttribute("product")).equals(this.product) || !(version = configElements[j].getAttribute("version")).equals(this.version)) continue;
                    try {
                        this.catalogProvider = (ICatalogProvider)configElements[j].createExecutableExtension("provider");
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, "The error was detected when creating the catalog provider for " + product + " " + version, (Throwable)e);
                        RDBCorePlugin.getDefault().getLog().log((IStatus)status);
                    }
                    continue block2;
                }
            }
        }
        if (this.catalogProvider == null) {
            this.catalogProvider = new JDBCProvider(this);
        }
        return this.catalogProvider;
    }

    public DDLParser getDdlParser() {
        if (this.parser == null) {
            IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.datatools.connectivity.sqm.core", "ddlParser");
            IExtension[] extensions = extensionPoint.getExtensions();
            block2: for (int i = 0; i < extensions.length; ++i) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                for (int j = 0; j < configElements.length; ++j) {
                    String version;
                    String product;
                    if (!configElements[j].getName().equals("parser") || !(product = configElements[j].getAttribute("product")).equals(this.product) || !(version = configElements[j].getAttribute("version")).equals(this.version)) continue;
                    try {
                        this.parser = (DDLParser)configElements[j].createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        System.out.println((Object)e);
                    }
                    continue block2;
                }
            }
        }
        return this.parser;
    }

    public DDLGenerator getDDLGenerator() {
        if (this.ddlGenerator == null) {
            IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.datatools.connectivity.sqm.core", "ddlGeneration");
            IExtension[] extensions = extensionPoint.getExtensions();
            block2: for (int i = 0; i < extensions.length; ++i) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                for (int j = 0; j < configElements.length; ++j) {
                    String version;
                    String product;
                    if (!configElements[j].getName().equals("generator") || !(product = configElements[j].getAttribute("product")).equals(this.product) || !(version = configElements[j].getAttribute("version")).equals(this.version)) continue;
                    try {
                        this.ddlGenerator = (DDLGenerator)configElements[j].createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, "The error was detected when creating the DDL generator for " + product + " " + version, (Throwable)e);
                        RDBCorePlugin.getDefault().getLog().log((IStatus)status);
                    }
                    continue block2;
                }
            }
        }
        if (this.ddlGenerator == null) {
            this.ddlGenerator = new GenericDdlGenerator();
        }
        return this.ddlGenerator;
    }

    public DeltaDDLGenerator getDeltaDDLGenerator() {
        if (this.ddlGenerator == null) {
            IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.datatools.connectivity.sqm.core", "ddlGeneration");
            IExtension[] extensions = extensionPoint.getExtensions();
            block2: for (int i = 0; i < extensions.length; ++i) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                for (int j = 0; j < configElements.length; ++j) {
                    String version;
                    String product;
                    if (!configElements[j].getName().equals("delta") || !(product = configElements[j].getAttribute("product")).equals(this.product) || !(version = configElements[j].getAttribute("version")).equals(this.version)) continue;
                    try {
                        this.deltaDdlGenerator = (DeltaDDLGenerator)configElements[j].createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, "The error was detected when creating the DDL generator for " + product + " " + version, (Throwable)e);
                        RDBCorePlugin.getDefault().getLog().log((IStatus)status);
                    }
                    continue block2;
                }
            }
        }
        if (this.deltaDdlGenerator == null) {
            this.deltaDdlGenerator = new GenericDeltaDdlGenerator();
        }
        return this.deltaDdlGenerator;
    }

    public Iterator getPredefinedDataTypes() {
        this.loadDatabaseDefinition();
        return this.databaseVendorDefinition.getPredefinedDataTypeDefinitions().iterator();
    }

    public List getPredefinedDataTypeDefinitionsByJDBCEnumType(int jdbcEnumType) {
        Vector predefinedDataTypeDefinitionList = new Vector();
        Iterator predefinedDataTypeDefinitionIterator = this.getPredefinedDataTypes();
        while (predefinedDataTypeDefinitionIterator.hasNext()) {
            Object o = predefinedDataTypeDefinitionIterator.next();
            if (!(o instanceof PredefinedDataTypeDefinition) || ((PredefinedDataTypeDefinition)o).getJdbcEnumType() != jdbcEnumType) continue;
            predefinedDataTypeDefinitionList.add(o);
        }
        return predefinedDataTypeDefinitionList;
    }

    public List getPredefinedDataTypesByJDBCEnumType(int jdbcEnumType) {
        Vector<PredefinedDataType> predefinedDataTypeList = new Vector<PredefinedDataType>();
        Iterator predefinedDataTypeDefinitionIterator = this.getPredefinedDataTypes();
        while (predefinedDataTypeDefinitionIterator.hasNext()) {
            PredefinedDataType predefinedDataType;
            Object o = predefinedDataTypeDefinitionIterator.next();
            if (!(o instanceof PredefinedDataTypeDefinition) || ((PredefinedDataTypeDefinition)o).getJdbcEnumType() != jdbcEnumType || (predefinedDataType = this.getPredefinedDataType((PredefinedDataTypeDefinition)o)) == null) continue;
            predefinedDataTypeList.add(predefinedDataType);
        }
        return predefinedDataTypeList;
    }

    public PredefinedDataTypeDefinition getPredefinedDataTypeDefinitionByNameAndJDBCEnumType(String dataTypeName, int jdbcEnumType) {
        this.loadDatabaseDefinition();
        return (PredefinedDataTypeDefinition)this.nameAndJDBCEnumToPrimitiveDataTypeDefinitionMap.get(dataTypeName.toUpperCase() + "_" + jdbcEnumType);
    }

    public PredefinedDataType getPredefinedDataTypeByNameAndJDBCEnumType(String dataTypeName, int jdbcEnumType) {
        PredefinedDataTypeDefinition predefinedDataTypeDefinition = this.getPredefinedDataTypeDefinitionByNameAndJDBCEnumType(dataTypeName, jdbcEnumType);
        return this.getPredefinedDataType(predefinedDataTypeDefinition);
    }

    public PredefinedDataTypeDefinition getPredefinedDataTypeDefinition(String dataTypeName) {
        this.loadDatabaseDefinition();
        return (PredefinedDataTypeDefinition)this.nameToPrimitiveDataTypeDefinitionMap.get(dataTypeName.toUpperCase());
    }

    public PredefinedDataType getPredefinedDataType(String dataTypeName) {
        this.loadDatabaseDefinition();
        PredefinedDataTypeDefinition predefinedDataTypeDefinition = (PredefinedDataTypeDefinition)this.nameToPrimitiveDataTypeDefinitionMap.get(dataTypeName.toUpperCase());
        return this.getPredefinedDataType(predefinedDataTypeDefinition);
    }

    public PredefinedDataType getPredefinedDataType(PredefinedDataTypeDefinition predefinedDataTypeDefinition) {
        if (predefinedDataTypeDefinition == null) {
            return null;
        }
        PrimitiveType primitiveType = predefinedDataTypeDefinition.getPrimitiveType();
        IntegerDataType predefinedDataType = null;
        switch (primitiveType.getValue()) {
            case 13: {
                predefinedDataType = SQLDataTypesFactory.eINSTANCE.createIntegerDataType();
                predefinedDataType.setName((String)predefinedDataTypeDefinition.getName().get(0));
                predefinedDataType.setPrimitiveType(primitiveType);
                break;
            }
            case 8: {
                predefinedDataType = SQLDataTypesFactory.eINSTANCE.createBinaryStringDataType();
                predefinedDataType.setName((String)predefinedDataTypeDefinition.getName().get(0));
                predefinedDataType.setPrimitiveType(primitiveType);
                if (!predefinedDataTypeDefinition.isLengthSupported()) break;
                ((BinaryStringDataType)predefinedDataType).setLength(predefinedDataTypeDefinition.getDefaultLength());
                break;
            }
            case 17: {
                predefinedDataType = SQLDataTypesFactory.eINSTANCE.createBooleanDataType();
                predefinedDataType.setName((String)predefinedDataTypeDefinition.getName().get(0));
                predefinedDataType.setPrimitiveType(primitiveType);
                break;
            }
            case 0: {
                predefinedDataType = SQLDataTypesFactory.eINSTANCE.createCharacterStringDataType();
                predefinedDataType.setName((String)predefinedDataTypeDefinition.getName().get(0));
                predefinedDataType.setPrimitiveType(primitiveType);
                if (!predefinedDataTypeDefinition.isLengthSupported()) break;
                ((CharacterStringDataType)predefinedDataType).setLength(predefinedDataTypeDefinition.getDefaultLength());
                break;
            }
            case 2: {
                predefinedDataType = SQLDataTypesFactory.eINSTANCE.createCharacterStringDataType();
                predefinedDataType.setName((String)predefinedDataTypeDefinition.getName().get(0));
                predefinedDataType.setPrimitiveType(primitiveType);
                if (!predefinedDataTypeDefinition.isLengthSupported()) break;
                ((CharacterStringDataType)predefinedDataType).setLength(predefinedDataTypeDefinition.getDefaultLength());
                break;
            }
            case 1: {
                predefinedDataType = SQLDataTypesFactory.eINSTANCE.createCharacterStringDataType();
                predefinedDataType.setName((String)predefinedDataTypeDefinition.getName().get(0));
                predefinedDataType.setPrimitiveType(primitiveType);
                if (!predefinedDataTypeDefinition.isLengthSupported()) break;
                ((CharacterStringDataType)predefinedDataType).setLength(predefinedDataTypeDefinition.getDefaultLength());
                break;
            }
            case 18: {
                predefinedDataType = SQLDataTypesFactory.eINSTANCE.createDateDataType();
                predefinedDataType.setName((String)predefinedDataTypeDefinition.getName().get(0));
                predefinedDataType.setPrimitiveType(primitiveType);
                break;
            }
            case 10: {
                predefinedDataType = SQLDataTypesFactory.eINSTANCE.createFixedPrecisionDataType();
                predefinedDataType.setName((String)predefinedDataTypeDefinition.getName().get(0));
                predefinedDataType.setPrimitiveType(primitiveType);
                if (predefinedDataTypeDefinition.isPrecisionSupported()) {
                    ((FixedPrecisionDataType)predefinedDataType).setPrecision(predefinedDataTypeDefinition.getDefaultPrecision());
                }
                if (!predefinedDataTypeDefinition.isScaleSupported()) break;
                ((FixedPrecisionDataType)predefinedDataType).setScale(predefinedDataTypeDefinition.getDefaultScale());
                break;
            }
            case 16: {
                predefinedDataType = SQLDataTypesFactory.eINSTANCE.createApproximateNumericDataType();
                predefinedDataType.setName((String)predefinedDataTypeDefinition.getName().get(0));
                predefinedDataType.setPrimitiveType(primitiveType);
                break;
            }
            case 14: {
                predefinedDataType = SQLDataTypesFactory.eINSTANCE.createApproximateNumericDataType();
                predefinedDataType.setName((String)predefinedDataTypeDefinition.getName().get(0));
                predefinedDataType.setPrimitiveType(primitiveType);
                if (!predefinedDataTypeDefinition.isPrecisionSupported()) break;
                ((ApproximateNumericDataType)predefinedDataType).setPrecision(predefinedDataTypeDefinition.getDefaultPrecision());
                break;
            }
            case 12: {
                predefinedDataType = SQLDataTypesFactory.eINSTANCE.createIntegerDataType();
                predefinedDataType.setName((String)predefinedDataTypeDefinition.getName().get(0));
                predefinedDataType.setPrimitiveType(primitiveType);
                break;
            }
            case 21: {
                FieldQualifierDefinition trailingFieldQualifierDefinition;
                FieldQualifierDefinition leadingFieldQualifierDefinition;
                predefinedDataType = SQLDataTypesFactory.eINSTANCE.createIntervalDataType();
                predefinedDataType.setName((String)predefinedDataTypeDefinition.getName().get(0));
                predefinedDataType.setPrimitiveType(primitiveType);
                if (predefinedDataTypeDefinition.isLeadingFieldQualifierSupported() && (leadingFieldQualifierDefinition = predefinedDataTypeDefinition.getDefaultLeadingFieldQualifierDefinition()) != null) {
                    ((IntervalDataType)predefinedDataType).setLeadingQualifier(leadingFieldQualifierDefinition.getName());
                    ((IntervalDataType)predefinedDataType).setLeadingFieldPrecision(leadingFieldQualifierDefinition.getDefaultPrecision());
                }
                if (!predefinedDataTypeDefinition.isTrailingFieldQualifierSupported() || (trailingFieldQualifierDefinition = predefinedDataTypeDefinition.getDefaultTrailingFieldQualifierDefinition()) == null) break;
                ((IntervalDataType)predefinedDataType).setTrailingQualifier(trailingFieldQualifierDefinition.getName());
                ((IntervalDataType)predefinedDataType).setTrailingFieldPrecision(trailingFieldQualifierDefinition.getDefaultPrecision());
                break;
            }
            case 3: {
                predefinedDataType = SQLDataTypesFactory.eINSTANCE.createCharacterStringDataType();
                predefinedDataType.setName((String)predefinedDataTypeDefinition.getName().get(0));
                predefinedDataType.setPrimitiveType(primitiveType);
                if (!predefinedDataTypeDefinition.isLengthSupported()) break;
                ((CharacterStringDataType)predefinedDataType).setLength(predefinedDataTypeDefinition.getDefaultLength());
                break;
            }
            case 4: {
                predefinedDataType = SQLDataTypesFactory.eINSTANCE.createCharacterStringDataType();
                predefinedDataType.setName((String)predefinedDataTypeDefinition.getName().get(0));
                predefinedDataType.setPrimitiveType(primitiveType);
                if (!predefinedDataTypeDefinition.isLengthSupported()) break;
                ((CharacterStringDataType)predefinedDataType).setLength(predefinedDataTypeDefinition.getDefaultLength());
                break;
            }
            case 5: {
                predefinedDataType = SQLDataTypesFactory.eINSTANCE.createCharacterStringDataType();
                predefinedDataType.setName((String)predefinedDataTypeDefinition.getName().get(0));
                predefinedDataType.setPrimitiveType(primitiveType);
                if (!predefinedDataTypeDefinition.isLengthSupported()) break;
                ((CharacterStringDataType)predefinedDataType).setLength(predefinedDataTypeDefinition.getDefaultLength());
                break;
            }
            case 9: {
                predefinedDataType = SQLDataTypesFactory.eINSTANCE.createFixedPrecisionDataType();
                predefinedDataType.setName((String)predefinedDataTypeDefinition.getName().get(0));
                predefinedDataType.setPrimitiveType(primitiveType);
                if (predefinedDataTypeDefinition.isPrecisionSupported()) {
                    ((FixedPrecisionDataType)predefinedDataType).setPrecision(predefinedDataTypeDefinition.getDefaultPrecision());
                }
                if (!predefinedDataTypeDefinition.isScaleSupported()) break;
                ((FixedPrecisionDataType)predefinedDataType).setScale(predefinedDataTypeDefinition.getDefaultScale());
                break;
            }
            case 15: {
                predefinedDataType = SQLDataTypesFactory.eINSTANCE.createApproximateNumericDataType();
                predefinedDataType.setName((String)predefinedDataTypeDefinition.getName().get(0));
                predefinedDataType.setPrimitiveType(primitiveType);
                break;
            }
            case 11: {
                predefinedDataType = SQLDataTypesFactory.eINSTANCE.createIntegerDataType();
                predefinedDataType.setName((String)predefinedDataTypeDefinition.getName().get(0));
                predefinedDataType.setPrimitiveType(primitiveType);
                break;
            }
            case 19: {
                predefinedDataType = SQLDataTypesFactory.eINSTANCE.createTimeDataType();
                predefinedDataType.setName((String)predefinedDataTypeDefinition.getName().get(0));
                predefinedDataType.setPrimitiveType(primitiveType);
                if (!predefinedDataTypeDefinition.isPrecisionSupported()) break;
                ((TimeDataType)predefinedDataType).setFractionalSecondsPrecision(predefinedDataTypeDefinition.getDefaultPrecision());
                break;
            }
            case 20: {
                predefinedDataType = SQLDataTypesFactory.eINSTANCE.createTimeDataType();
                predefinedDataType.setName((String)predefinedDataTypeDefinition.getName().get(0));
                predefinedDataType.setPrimitiveType(primitiveType);
                if (!predefinedDataTypeDefinition.isPrecisionSupported()) break;
                ((TimeDataType)predefinedDataType).setFractionalSecondsPrecision(predefinedDataTypeDefinition.getDefaultPrecision());
                break;
            }
            case 22: {
                predefinedDataType = SQLDataTypesFactory.eINSTANCE.createDataLinkDataType();
                predefinedDataType.setName((String)predefinedDataTypeDefinition.getName().get(0));
                predefinedDataType.setPrimitiveType(primitiveType);
                if (!predefinedDataTypeDefinition.isLengthSupported()) break;
                ((DataLinkDataType)predefinedDataType).setLength(predefinedDataTypeDefinition.getDefaultLength());
                break;
            }
            case 6: {
                predefinedDataType = SQLDataTypesFactory.eINSTANCE.createBinaryStringDataType();
                predefinedDataType.setName((String)predefinedDataTypeDefinition.getName().get(0));
                predefinedDataType.setPrimitiveType(primitiveType);
                if (!predefinedDataTypeDefinition.isLengthSupported()) break;
                ((BinaryStringDataType)predefinedDataType).setLength(predefinedDataTypeDefinition.getDefaultLength());
                break;
            }
            case 7: {
                predefinedDataType = SQLDataTypesFactory.eINSTANCE.createBinaryStringDataType();
                predefinedDataType.setName((String)predefinedDataTypeDefinition.getName().get(0));
                predefinedDataType.setPrimitiveType(primitiveType);
                if (!predefinedDataTypeDefinition.isLengthSupported()) break;
                ((BinaryStringDataType)predefinedDataType).setLength(predefinedDataTypeDefinition.getDefaultLength());
                break;
            }
            case 23: {
                predefinedDataType = SQLDataTypesFactory.eINSTANCE.createXMLDataType();
                predefinedDataType.setName((String)predefinedDataTypeDefinition.getName().get(0));
                predefinedDataType.setPrimitiveType(primitiveType);
            }
        }
        return predefinedDataType;
    }

    public String getPredefinedDataTypeFormattedName(PredefinedDataType predefinedDataType) {
        if (predefinedDataType == null) {
            return null;
        }
        PrimitiveType primitiveType = predefinedDataType.getPrimitiveType();
        String predefinedDataTypeFormattedName = null;
        switch (primitiveType.getValue()) {
            case 13: {
                predefinedDataTypeFormattedName = predefinedDataType.getName();
                break;
            }
            case 6: {
                predefinedDataTypeFormattedName = predefinedDataType.getName();
                PredefinedDataTypeDefinition predefinedDataTypeDefinition = this.getPredefinedDataTypeDefinition(predefinedDataType.getName());
                if (predefinedDataTypeDefinition == null) break;
                if (predefinedDataTypeDefinition.isDisplayNameSupported()) {
                    String temp = predefinedDataTypeDefinition.getDisplayName();
                    if (temp == null || temp.length() <= 0 || !predefinedDataTypeDefinition.isLengthSupported()) break;
                    predefinedDataTypeFormattedName = MessageFormat.format(temp, Integer.toString(((BinaryStringDataType)predefinedDataType).getLength()));
                    break;
                }
                if (!predefinedDataTypeDefinition.isLengthSupported() || ((BinaryStringDataType)predefinedDataType).getLength() <= 0) break;
                predefinedDataTypeFormattedName = predefinedDataTypeFormattedName + "(" + ((BinaryStringDataType)predefinedDataType).getLength() + ")";
                break;
            }
            case 8: {
                predefinedDataTypeFormattedName = predefinedDataType.getName();
                PredefinedDataTypeDefinition predefinedDataTypeDefinition = this.getPredefinedDataTypeDefinition(predefinedDataTypeFormattedName);
                if (!predefinedDataTypeDefinition.isLengthSupported() || ((BinaryStringDataType)predefinedDataType).getLength() <= 0) break;
                predefinedDataTypeFormattedName = predefinedDataTypeFormattedName + "(" + ((BinaryStringDataType)predefinedDataType).getLength() + ")";
                break;
            }
            case 7: {
                predefinedDataTypeFormattedName = predefinedDataType.getName();
                PredefinedDataTypeDefinition predefinedDataTypeDefinition = this.getPredefinedDataTypeDefinition(predefinedDataType.getName());
                if (predefinedDataTypeDefinition == null) break;
                if (predefinedDataTypeDefinition.isDisplayNameSupported()) {
                    String temp = predefinedDataTypeDefinition.getDisplayName();
                    if (temp == null || temp.length() <= 0 || !predefinedDataTypeDefinition.isLengthSupported()) break;
                    predefinedDataTypeFormattedName = MessageFormat.format(temp, Integer.toString(((BinaryStringDataType)predefinedDataType).getLength()));
                    break;
                }
                if (!predefinedDataTypeDefinition.isLengthSupported() || ((BinaryStringDataType)predefinedDataType).getLength() <= 0) break;
                predefinedDataTypeFormattedName = predefinedDataTypeFormattedName + "(" + ((BinaryStringDataType)predefinedDataType).getLength() + ")";
                break;
            }
            case 17: {
                predefinedDataTypeFormattedName = predefinedDataType.getName();
                break;
            }
            case 0: {
                predefinedDataTypeFormattedName = predefinedDataType.getName();
                PredefinedDataTypeDefinition predefinedDataTypeDefinition = this.getPredefinedDataTypeDefinition(predefinedDataTypeFormattedName);
                if (!predefinedDataTypeDefinition.isLengthSupported() || ((CharacterStringDataType)predefinedDataType).getLength() <= 0) break;
                predefinedDataTypeFormattedName = predefinedDataTypeFormattedName + "(" + ((CharacterStringDataType)predefinedDataType).getLength() + ")";
                break;
            }
            case 2: {
                predefinedDataTypeFormattedName = predefinedDataType.getName();
                PredefinedDataTypeDefinition predefinedDataTypeDefinition = this.getPredefinedDataTypeDefinition(predefinedDataTypeFormattedName);
                if (!predefinedDataTypeDefinition.isLengthSupported() || ((CharacterStringDataType)predefinedDataType).getLength() <= 0) break;
                predefinedDataTypeFormattedName = predefinedDataTypeFormattedName + "(" + ((CharacterStringDataType)predefinedDataType).getLength() + ")";
                break;
            }
            case 1: {
                predefinedDataTypeFormattedName = predefinedDataType.getName();
                PredefinedDataTypeDefinition predefinedDataTypeDefinition = this.getPredefinedDataTypeDefinition(predefinedDataTypeFormattedName);
                if (!predefinedDataTypeDefinition.isLengthSupported() || ((CharacterStringDataType)predefinedDataType).getLength() <= 0) break;
                predefinedDataTypeFormattedName = predefinedDataTypeFormattedName + "(" + ((CharacterStringDataType)predefinedDataType).getLength() + ")";
                break;
            }
            case 18: {
                predefinedDataTypeFormattedName = predefinedDataType.getName();
                break;
            }
            case 10: {
                predefinedDataTypeFormattedName = predefinedDataType.getName();
                PredefinedDataTypeDefinition predefinedDataTypeDefinition = this.getPredefinedDataTypeDefinition(predefinedDataTypeFormattedName);
                if (!predefinedDataTypeDefinition.isPrecisionSupported() || !predefinedDataTypeDefinition.isScaleSupported()) break;
                predefinedDataTypeFormattedName = predefinedDataTypeFormattedName + "(" + ((FixedPrecisionDataType)predefinedDataType).getPrecision() + " , " + ((FixedPrecisionDataType)predefinedDataType).getScale() + ")";
                break;
            }
            case 16: {
                predefinedDataTypeFormattedName = predefinedDataType.getName();
                break;
            }
            case 14: {
                predefinedDataTypeFormattedName = predefinedDataType.getName();
                PredefinedDataTypeDefinition predefinedDataTypeDefinition = this.getPredefinedDataTypeDefinition(predefinedDataTypeFormattedName);
                if (!predefinedDataTypeDefinition.isPrecisionSupported() || ((ApproximateNumericDataType)predefinedDataType).getPrecision() <= 0) break;
                predefinedDataTypeFormattedName = predefinedDataTypeFormattedName + "(" + ((ApproximateNumericDataType)predefinedDataType).getPrecision() + ")";
                break;
            }
            case 12: {
                predefinedDataTypeFormattedName = predefinedDataType.getName();
                break;
            }
            case 21: {
                FieldQualifierDefinition fieldQualifierDefinition;
                predefinedDataTypeFormattedName = predefinedDataType.getName();
                PredefinedDataTypeDefinition predefinedDataTypeDefinition = this.getPredefinedDataTypeDefinition(predefinedDataType.getName());
                if (!predefinedDataTypeDefinition.isDisplayNameSupported()) break;
                String temp = predefinedDataTypeDefinition.getDisplayName();
                Vector<String> parameterList = new Vector<String>();
                IntervalQualifierType leadingQualifier = ((IntervalDataType)predefinedDataType).getLeadingQualifier();
                IntervalQualifierType trailingQualifier = ((IntervalDataType)predefinedDataType).getTrailingQualifier();
                if (leadingQualifier == null && trailingQualifier == null) {
                    predefinedDataTypeFormattedName = predefinedDataType.getName();
                    break;
                }
                if (leadingQualifier != null && leadingQualifier.toString().length() > 0) {
                    String leadingQualifierString = leadingQualifier.toString();
                    int leadingPrecision = ((IntervalDataType)predefinedDataType).getLeadingFieldPrecision();
                    fieldQualifierDefinition = this.getLeadingFieldQualifierDefinition(predefinedDataTypeDefinition, leadingQualifierString);
                    int defaultLeadingPrecision = 0;
                    if (fieldQualifierDefinition != null) {
                        defaultLeadingPrecision = fieldQualifierDefinition.getDefaultPrecision();
                    }
                    if (leadingPrecision > 0 && leadingPrecision != defaultLeadingPrecision) {
                        leadingQualifierString = leadingQualifierString + "(" + Integer.toString(leadingPrecision) + ")";
                    }
                    parameterList.add(leadingQualifierString);
                }
                if (trailingQualifier != null && trailingQualifier.toString().length() > 0) {
                    String trailingQualifierString = trailingQualifier.toString();
                    int trailingPrecision = ((IntervalDataType)predefinedDataType).getTrailingFieldPrecision();
                    fieldQualifierDefinition = this.getTrailingFieldQualifierDefinition(predefinedDataTypeDefinition, trailingQualifierString);
                    int defaultTrailingPrecision = 0;
                    if (fieldQualifierDefinition != null) {
                        defaultTrailingPrecision = fieldQualifierDefinition.getDefaultPrecision();
                    }
                    if (trailingPrecision > 0 && trailingPrecision != defaultTrailingPrecision) {
                        trailingQualifierString = trailingQualifierString + "(" + Integer.toString(trailingPrecision) + ")";
                    }
                    parameterList.add(trailingQualifierString);
                }
                Object[] parameters = new Object[parameterList.size()];
                for (int i = 0; i < parameters.length; ++i) {
                    parameters[i] = parameterList.get(i);
                }
                predefinedDataTypeFormattedName = MessageFormat.format(temp, parameters);
                break;
            }
            case 3: {
                predefinedDataTypeFormattedName = predefinedDataType.getName();
                PredefinedDataTypeDefinition predefinedDataTypeDefinition = this.getPredefinedDataTypeDefinition(predefinedDataTypeFormattedName);
                if (!predefinedDataTypeDefinition.isLengthSupported()) break;
                predefinedDataTypeFormattedName = predefinedDataTypeFormattedName + "(" + ((CharacterStringDataType)predefinedDataType).getLength() + ")";
                break;
            }
            case 4: {
                predefinedDataTypeFormattedName = predefinedDataType.getName();
                PredefinedDataTypeDefinition predefinedDataTypeDefinition = this.getPredefinedDataTypeDefinition(predefinedDataTypeFormattedName);
                if (!predefinedDataTypeDefinition.isLengthSupported()) break;
                predefinedDataTypeFormattedName = predefinedDataTypeFormattedName + "(" + ((CharacterStringDataType)predefinedDataType).getLength() + ")";
                break;
            }
            case 5: {
                predefinedDataTypeFormattedName = predefinedDataType.getName();
                PredefinedDataTypeDefinition predefinedDataTypeDefinition = this.getPredefinedDataTypeDefinition(predefinedDataTypeFormattedName);
                if (!predefinedDataTypeDefinition.isLengthSupported()) break;
                predefinedDataTypeFormattedName = predefinedDataTypeFormattedName + "(" + ((CharacterStringDataType)predefinedDataType).getLength() + ")";
                break;
            }
            case 9: {
                predefinedDataTypeFormattedName = predefinedDataType.getName();
                PredefinedDataTypeDefinition predefinedDataTypeDefinition = this.getPredefinedDataTypeDefinition(predefinedDataTypeFormattedName);
                if (!predefinedDataTypeDefinition.isPrecisionSupported() || !predefinedDataTypeDefinition.isScaleSupported()) break;
                predefinedDataTypeFormattedName = predefinedDataTypeFormattedName + "(" + ((FixedPrecisionDataType)predefinedDataType).getPrecision() + " , " + ((FixedPrecisionDataType)predefinedDataType).getScale() + ")";
                break;
            }
            case 15: {
                predefinedDataTypeFormattedName = predefinedDataType.getName();
                break;
            }
            case 11: {
                predefinedDataTypeFormattedName = predefinedDataType.getName();
                break;
            }
            case 19: {
                predefinedDataTypeFormattedName = predefinedDataType.getName();
                break;
            }
            case 20: {
                predefinedDataTypeFormattedName = predefinedDataType.getName();
                PredefinedDataTypeDefinition predefinedDataTypeDefinition = this.getPredefinedDataTypeDefinition(predefinedDataTypeFormattedName);
                if (!predefinedDataTypeDefinition.isPrecisionSupported()) break;
                predefinedDataTypeFormattedName = predefinedDataTypeFormattedName + "(" + ((TimeDataType)predefinedDataType).getFractionalSecondsPrecision() + ")";
                break;
            }
            case 22: {
                predefinedDataTypeFormattedName = predefinedDataType.getName();
                PredefinedDataTypeDefinition predefinedDataTypeDefinition = this.getPredefinedDataTypeDefinition(predefinedDataTypeFormattedName);
                if (!predefinedDataTypeDefinition.isLengthSupported()) break;
                predefinedDataTypeFormattedName = predefinedDataTypeFormattedName + "(" + ((DataLinkDataType)predefinedDataType).getLength() + ")";
                break;
            }
            case 23: {
                predefinedDataTypeFormattedName = predefinedDataType.getName();
            }
        }
        return predefinedDataTypeFormattedName;
    }

    public FieldQualifierDefinition getLeadingFieldQualifierDefinition(PredefinedDataTypeDefinition predefinedDataTypeDefinition, String fieldQualifierName) {
        Iterator leadingFieldQualifierDefinitionIter = predefinedDataTypeDefinition.getLeadingFieldQualifierDefinition().iterator();
        while (leadingFieldQualifierDefinitionIter.hasNext()) {
            FieldQualifierDefinition fieldQualifierDefinition = (FieldQualifierDefinition)leadingFieldQualifierDefinitionIter.next();
            if (!fieldQualifierDefinition.getName().toString().equals(fieldQualifierName)) continue;
            return fieldQualifierDefinition;
        }
        return null;
    }

    public FieldQualifierDefinition getTrailingFieldQualifierDefinition(PredefinedDataTypeDefinition predefinedDataTypeDefinition, String fieldQualifierName) {
        Iterator trailingFieldQualifierDefinitionIter = predefinedDataTypeDefinition.getTrailingFieldQualifierDefinition().iterator();
        while (trailingFieldQualifierDefinitionIter.hasNext()) {
            FieldQualifierDefinition fieldQualifierDefinition = (FieldQualifierDefinition)trailingFieldQualifierDefinitionIter.next();
            if (!fieldQualifierDefinition.getName().toString().equals(fieldQualifierName)) continue;
            return fieldQualifierDefinition;
        }
        return null;
    }

    public Iterator getSequenceSupportedPredefinedDataTypes() {
        this.loadDatabaseDefinition();
        SequenceDefinition sequenceDefinition = this.databaseVendorDefinition.getSequenceDefinition();
        if (sequenceDefinition != null) {
            return sequenceDefinition.getPredefinedDataTypeDefinitions().iterator();
        }
        return new Vector().iterator();
    }

    public Iterator getIdentityColumnSupportedPredefinedDataTypes() {
        this.loadDatabaseDefinition();
        ColumnDefinition columnDefinition = this.databaseVendorDefinition.getColumnDefinition();
        if (columnDefinition != null) {
            return columnDefinition.getIdentityColumnDataTypeDefinitions().iterator();
        }
        return new Vector().iterator();
    }

    public boolean isKeyConstraintSupported(DataType dataType) {
        PredefinedDataTypeDefinition predefinedDataTypeDefinition;
        if (dataType instanceof PredefinedDataType && (predefinedDataTypeDefinition = this.getPredefinedDataTypeDefinition(dataType.getName())) != null) {
            return predefinedDataTypeDefinition.isKeyConstraintSupported();
        }
        return false;
    }

    public boolean supportsSchema() {
        this.loadDatabaseDefinition();
        return this.databaseVendorDefinition.isSchemaSupported();
    }

    public boolean supportsAlias() {
        this.loadDatabaseDefinition();
        return this.databaseVendorDefinition.isAliasSupported();
    }

    public boolean supportsSynonym() {
        this.loadDatabaseDefinition();
        return this.databaseVendorDefinition.isSynonymSupported();
    }

    public boolean supportsUserDefinedType() {
        this.loadDatabaseDefinition();
        return this.databaseVendorDefinition.isUserDefinedTypeSupported();
    }

    public boolean supportsIdentityColumns() {
        this.loadDatabaseDefinition();
        ColumnDefinition columnDefinition = this.databaseVendorDefinition.getColumnDefinition();
        if (columnDefinition != null) {
            return columnDefinition.isIdentitySupported();
        }
        return false;
    }

    public boolean supportsComputedColumns() {
        this.loadDatabaseDefinition();
        ColumnDefinition columnDefinition = this.databaseVendorDefinition.getColumnDefinition();
        if (columnDefinition != null) {
            return columnDefinition.isComputedSupported();
        }
        return true;
    }

    public boolean supportsDeferrableConstraints() {
        this.loadDatabaseDefinition();
        ConstraintDefinition constraintDefinition = this.databaseVendorDefinition.getConstraintDefinition();
        if (constraintDefinition != null) {
            return constraintDefinition.isDeferrableConstraintSupported();
        }
        return false;
    }

    public boolean supportsInformationalConstraints() {
        this.loadDatabaseDefinition();
        ConstraintDefinition constraintDefinition = this.databaseVendorDefinition.getConstraintDefinition();
        if (constraintDefinition != null) {
            return constraintDefinition.isInformationalConstraintSupported();
        }
        return false;
    }

    public boolean supportsSequence() {
        this.loadDatabaseDefinition();
        return this.databaseVendorDefinition.isSequenceSupported();
    }

    public boolean supportsMQT() {
        this.loadDatabaseDefinition();
        return this.databaseVendorDefinition.isMQTSupported();
    }

    public boolean supportsMQTIndex() {
        this.loadDatabaseDefinition();
        return this.databaseVendorDefinition.isMQTIndexSupported();
    }

    public boolean supportsClusteredIndexes() {
        this.loadDatabaseDefinition();
        IndexDefinition indexDefinition = this.databaseVendorDefinition.getIndexDefinition();
        if (indexDefinition != null) {
            return indexDefinition.isClusteringSupported();
        }
        return false;
    }

    public boolean isUniqueKeyNullable() {
        this.loadDatabaseDefinition();
        ConstraintDefinition constraintDefinition = this.databaseVendorDefinition.getConstraintDefinition();
        if (constraintDefinition != null) {
            return constraintDefinition.isUniqueKeyNullable();
        }
        return false;
    }

    public List getParentDeleteDRIRules() {
        this.loadDatabaseDefinition();
        ConstraintDefinition constraintDefinition = this.databaseVendorDefinition.getConstraintDefinition();
        if (constraintDefinition != null) {
            return constraintDefinition.getParentDeleteDRIRuleType();
        }
        return new Vector();
    }

    public List getParentUpdateDRIRules() {
        this.loadDatabaseDefinition();
        ConstraintDefinition constraintDefinition = this.databaseVendorDefinition.getConstraintDefinition();
        if (constraintDefinition != null) {
            return constraintDefinition.getParentUpdateDRIRuleType();
        }
        return new Vector();
    }

    public boolean supportsConstraints() {
        this.loadDatabaseDefinition();
        return this.databaseVendorDefinition.isConstraintsSupported();
    }

    public int queryMaxCommentLength() {
        this.loadDatabaseDefinition();
        return this.databaseVendorDefinition.getMaximumCommentLength();
    }

    public int queryMaxIdentifierLength() {
        this.loadDatabaseDefinition();
        int len = this.databaseVendorDefinition.getMaximumIdentifierLength();
        if (len == 0) {
            len = 128;
        }
        return len;
    }

    public int getDatabaseMaximumIdentifierLength() {
        this.loadDatabaseDefinition();
        int len = this.databaseVendorDefinition.getMaximumIdentifierLength();
        if (len == 0) {
            len = 128;
        }
        return len;
    }

    public int getSchemaMaximumIdentifierLength() {
        this.loadDatabaseDefinition();
        SchemaDefinition schemaDefinition = this.databaseVendorDefinition.getSchemaDefinition();
        if (schemaDefinition != null) {
            return schemaDefinition.getMaximumIdentifierLength();
        }
        return 0;
    }

    public int getTableMaximumIdentifierLength() {
        this.loadDatabaseDefinition();
        TableDefinition tableDefinition = this.databaseVendorDefinition.getTableDefinition();
        if (tableDefinition != null) {
            return tableDefinition.getMaximumIdentifierLength();
        }
        return 0;
    }

    public int getViewMaximumIdentifierLength() {
        this.loadDatabaseDefinition();
        ViewDefinition viewDefinition = this.databaseVendorDefinition.getViewDefinition();
        if (viewDefinition != null) {
            return viewDefinition.getMaximumIdentifierLength();
        }
        return 0;
    }

    public int getColumnMaximumIdentifierLength() {
        this.loadDatabaseDefinition();
        ColumnDefinition columnDefinition = this.databaseVendorDefinition.getColumnDefinition();
        if (columnDefinition != null) {
            return columnDefinition.getMaximumIdentifierLength();
        }
        return 0;
    }

    public int getTriggerMaximumIdentifierLength() {
        this.loadDatabaseDefinition();
        TriggerDefinition triggerDefinition = this.databaseVendorDefinition.getTriggerDefinition();
        if (triggerDefinition != null) {
            return triggerDefinition.getMaximumIdentifierLength();
        }
        return 0;
    }

    public int getPrimarykeyIdentifierLength() {
        this.loadDatabaseDefinition();
        ConstraintDefinition constraintDefinition = this.databaseVendorDefinition.getConstraintDefinition();
        if (constraintDefinition != null) {
            return constraintDefinition.getMaximumPrimaryKeyIdentifierLength();
        }
        return 0;
    }

    public int getForeignKeyMaximumIdentifierLength() {
        this.loadDatabaseDefinition();
        ConstraintDefinition constraintDefinition = this.databaseVendorDefinition.getConstraintDefinition();
        if (constraintDefinition != null) {
            return constraintDefinition.getMaximumForeignKeyIdentifierLength();
        }
        return 0;
    }

    public int getCheckConstraintMaximumIdentifierLength() {
        this.loadDatabaseDefinition();
        ConstraintDefinition constraintDefinition = this.databaseVendorDefinition.getConstraintDefinition();
        if (constraintDefinition != null) {
            return constraintDefinition.getMaximumCheckConstraintIdentifierLength();
        }
        return 0;
    }

    public int getNicknameMaximumIdentifierLength() {
        this.loadDatabaseDefinition();
        NicknameDefinition nicknameDefinition = this.databaseVendorDefinition.getNicknameDefinition();
        if (nicknameDefinition != null) {
            return nicknameDefinition.getMaximumIdentifierLength();
        }
        return 0;
    }

    public int getUserDefinedTypeMaximumIdentifierLength() {
        this.loadDatabaseDefinition();
        UserDefinedTypeDefinition udtDefinition = this.databaseVendorDefinition.getUdtDefinition();
        if (udtDefinition != null) {
            return udtDefinition.getMaximumIdentifierLength();
        }
        return 0;
    }

    public int getTablespaceMaximumIdentifierLength() {
        this.loadDatabaseDefinition();
        TableSpaceDefinition tablespaceDefinition = this.databaseVendorDefinition.getTableSpaceDefinition();
        if (tablespaceDefinition != null) {
            return tablespaceDefinition.getMaximumIdentifierLength();
        }
        return 0;
    }

    public int queryMaxCheckExpression() {
        this.loadDatabaseDefinition();
        ConstraintDefinition constraintDefinition = this.databaseVendorDefinition.getConstraintDefinition();
        if (constraintDefinition != null) {
            return constraintDefinition.getMaximumCheckExpressionLength();
        }
        return 0;
    }

    public int queryTriggerMaxReferencePartLength() {
        this.loadDatabaseDefinition();
        TriggerDefinition triggerDefinition = this.databaseVendorDefinition.getTriggerDefinition();
        if (triggerDefinition != null) {
            return triggerDefinition.getMaximumReferencePartLength();
        }
        return 0;
    }

    public int queryTriggerMaxActionBodyLength() {
        this.loadDatabaseDefinition();
        TriggerDefinition triggerDefinition = this.databaseVendorDefinition.getTriggerDefinition();
        if (triggerDefinition != null) {
            return triggerDefinition.getMaximumActionBodyLength();
        }
        return 0;
    }

    public int queryStoredProcedureMaxActionBodyLength() {
        this.loadDatabaseDefinition();
        StoredProcedureDefinition storedProcedureDefinition = this.databaseVendorDefinition.getStoredProcedureDefinition();
        if (storedProcedureDefinition != null) {
            return storedProcedureDefinition.getMaximumActionBodyLength();
        }
        return 0;
    }

    public boolean supportsStoredProcedureNullInputAction() {
        this.loadDatabaseDefinition();
        StoredProcedureDefinition storedProcedureDefinition = this.databaseVendorDefinition.getStoredProcedureDefinition();
        if (storedProcedureDefinition != null) {
            return storedProcedureDefinition.isNullInputActionSupported();
        }
        return false;
    }

    public boolean supportsTriggers() {
        this.loadDatabaseDefinition();
        return this.databaseVendorDefinition.isTriggerSupported();
    }

    public boolean supportsTriggerTypes() {
        this.loadDatabaseDefinition();
        TriggerDefinition triggerDefinition = this.databaseVendorDefinition.getTriggerDefinition();
        if (triggerDefinition != null) {
            return triggerDefinition.isTypeSupported();
        }
        return false;
    }

    public boolean supportsInsteadOfTrigger() {
        this.loadDatabaseDefinition();
        TriggerDefinition triggerDefinition = this.databaseVendorDefinition.getTriggerDefinition();
        if (triggerDefinition != null) {
            return triggerDefinition.isInsteadOfTriggerSupported();
        }
        return false;
    }

    public boolean supportsPerColumnUpdateTrigger() {
        this.loadDatabaseDefinition();
        TriggerDefinition triggerDefinition = this.databaseVendorDefinition.getTriggerDefinition();
        if (triggerDefinition != null) {
            return triggerDefinition.isPerColumnUpdateTriggerSupported();
        }
        return false;
    }

    public boolean supportsTriggerReferencesClause() {
        this.loadDatabaseDefinition();
        TriggerDefinition triggerDefinition = this.databaseVendorDefinition.getTriggerDefinition();
        if (triggerDefinition != null) {
            return triggerDefinition.isReferencesClauseSupported();
        }
        return false;
    }

    public boolean supportsRowTriggerReference() {
        this.loadDatabaseDefinition();
        TriggerDefinition triggerDefinition = this.databaseVendorDefinition.getTriggerDefinition();
        if (triggerDefinition != null) {
            return triggerDefinition.isRowTriggerReferenceSupported();
        }
        return false;
    }

    public boolean supportsTableTriggerReference() {
        this.loadDatabaseDefinition();
        TriggerDefinition triggerDefinition = this.databaseVendorDefinition.getTriggerDefinition();
        if (triggerDefinition != null) {
            return triggerDefinition.isTableTriggerReferenceSupported();
        }
        return false;
    }

    public boolean supportTriggerWhenClause() {
        this.loadDatabaseDefinition();
        TriggerDefinition triggerDefinition = this.databaseVendorDefinition.getTriggerDefinition();
        if (triggerDefinition != null) {
            return triggerDefinition.isWhenClauseSupported();
        }
        return true;
    }

    public boolean supportsTriggerGranularity() {
        this.loadDatabaseDefinition();
        TriggerDefinition triggerDefinition = this.databaseVendorDefinition.getTriggerDefinition();
        if (triggerDefinition != null) {
            return triggerDefinition.isGranularitySupported();
        }
        return false;
    }

    public boolean supportsSnapshotViews() {
        this.loadDatabaseDefinition();
        return this.databaseVendorDefinition.isSnapshotViewSupported();
    }

    public boolean supportsViewTriggers() {
        this.loadDatabaseDefinition();
        return this.databaseVendorDefinition.isViewTriggerSupported();
    }

    public boolean supportsQuotedDML() {
        this.loadDatabaseDefinition();
        return this.databaseVendorDefinition.isQuotedDMLSupported();
    }

    public boolean supportsQuotedDDL() {
        this.loadDatabaseDefinition();
        return this.databaseVendorDefinition.isQuotedDDLSupported();
    }

    public String getIdentifierQuoteString() {
        this.loadDatabaseDefinition();
        QueryDefinition queryDefinition = this.databaseVendorDefinition.getQueryDefinition();
        if (queryDefinition != null) {
            return queryDefinition.getIdentifierQuoteString();
        }
        return "";
    }

    public String getHostVariableMarker() {
        this.loadDatabaseDefinition();
        QueryDefinition queryDefinition = this.databaseVendorDefinition.getQueryDefinition();
        if (queryDefinition != null) {
            return queryDefinition.getHostVariableMarker();
        }
        return "";
    }

    public boolean supportsHostVariableMarker() {
        this.loadDatabaseDefinition();
        QueryDefinition queryDefinition = this.databaseVendorDefinition.getQueryDefinition();
        if (queryDefinition != null) {
            return queryDefinition.isHostVariableMarkerSupported();
        }
        return false;
    }

    public boolean supportsCastExpression() {
        this.loadDatabaseDefinition();
        QueryDefinition queryDefinition = this.databaseVendorDefinition.getQueryDefinition();
        if (queryDefinition != null) {
            return queryDefinition.isCastExpressionSupported();
        }
        return false;
    }

    public boolean supportsDefaultKeywordForInsertValue() {
        this.loadDatabaseDefinition();
        QueryDefinition queryDefinition = this.databaseVendorDefinition.getQueryDefinition();
        if (queryDefinition != null) {
            return queryDefinition.isDefaultKeywordForInsertValueSupported();
        }
        return false;
    }

    public boolean supportsExtendedGrouping() {
        this.loadDatabaseDefinition();
        QueryDefinition queryDefinition = this.databaseVendorDefinition.getQueryDefinition();
        if (queryDefinition != null) {
            return queryDefinition.isExtendedGroupingSupported();
        }
        return false;
    }

    public boolean supportsTableAliasInDelete() {
        this.loadDatabaseDefinition();
        QueryDefinition queryDefinition = this.databaseVendorDefinition.getQueryDefinition();
        if (queryDefinition != null) {
            return queryDefinition.isTableAliasInDeleteSupported();
        }
        return false;
    }

    public List getProcedureLanguageType() {
        this.loadDatabaseDefinition();
        StoredProcedureDefinition storedProcedureDefinition = this.databaseVendorDefinition.getStoredProcedureDefinition();
        if (storedProcedureDefinition != null) {
            return storedProcedureDefinition.getLanguageType();
        }
        return new Vector();
    }

    public List getFunctionLanguageType() {
        this.loadDatabaseDefinition();
        StoredProcedureDefinition storedProcedureDefinition = this.databaseVendorDefinition.getStoredProcedureDefinition();
        if (storedProcedureDefinition != null) {
            return storedProcedureDefinition.getFunctionLanguageType();
        }
        return new Vector();
    }

    public boolean supportsSQLStatement() {
        this.loadDatabaseDefinition();
        return this.databaseVendorDefinition.isSQLStatementSupported();
    }

    public List getSQLKeywords() {
        this.loadDatabaseDefinition();
        SQLSyntaxDefinition sqlSyntaxDefinition = this.databaseVendorDefinition.getSQLSyntaxDefinition();
        if (sqlSyntaxDefinition != null) {
            return sqlSyntaxDefinition.getKeywords();
        }
        return new Vector();
    }

    public List getSQLOperators() {
        this.loadDatabaseDefinition();
        SQLSyntaxDefinition sqlSyntaxDefinition = this.databaseVendorDefinition.getSQLSyntaxDefinition();
        if (sqlSyntaxDefinition != null) {
            return sqlSyntaxDefinition.getOperators();
        }
        return new Vector();
    }

    public String getSQLTerminationCharacter() {
        this.loadDatabaseDefinition();
        SQLSyntaxDefinition sqlSyntaxDefinition = this.databaseVendorDefinition.getSQLSyntaxDefinition();
        if (sqlSyntaxDefinition != null) {
            return sqlSyntaxDefinition.getTerminationCharacter();
        }
        return ";";
    }

    public int getMaximumIdentifierLength() {
        this.loadDatabaseDefinition();
        return this.databaseVendorDefinition.getMaximumIdentifierLength();
    }

    public int getMaximumIdentifierLength(SQLObject sqlObject) {
        StoredProcedureDefinition storedProcedureDefinition;
        int maximumLength = 0;
        this.loadDatabaseDefinition();
        if (sqlObject instanceof Database) {
            maximumLength = this.databaseVendorDefinition.getMaximumIdentifierLength();
        } else if (sqlObject instanceof Schema) {
            SchemaDefinition schemaDefinition = this.databaseVendorDefinition.getSchemaDefinition();
            if (schemaDefinition != null) {
                maximumLength = schemaDefinition.getMaximumIdentifierLength();
            }
        } else if (sqlObject instanceof BaseTable) {
            TableDefinition tableDefinition = this.databaseVendorDefinition.getTableDefinition();
            if (tableDefinition != null) {
                maximumLength = tableDefinition.getMaximumIdentifierLength();
            }
        } else if (sqlObject instanceof ViewTable) {
            ViewDefinition viewDefinition = this.databaseVendorDefinition.getViewDefinition();
            if (viewDefinition != null) {
                maximumLength = viewDefinition.getMaximumIdentifierLength();
            }
        } else if (sqlObject instanceof Column) {
            ColumnDefinition columnDefinition = this.databaseVendorDefinition.getColumnDefinition();
            if (columnDefinition != null) {
                maximumLength = columnDefinition.getMaximumIdentifierLength();
            }
        } else if (sqlObject instanceof PrimaryKey) {
            ConstraintDefinition constraintDefinition = this.databaseVendorDefinition.getConstraintDefinition();
            if (constraintDefinition != null) {
                maximumLength = constraintDefinition.getMaximumPrimaryKeyIdentifierLength();
            }
        } else if (sqlObject instanceof ForeignKey) {
            ConstraintDefinition constraintDefinition = this.databaseVendorDefinition.getConstraintDefinition();
            if (constraintDefinition != null) {
                maximumLength = constraintDefinition.getMaximumForeignKeyIdentifierLength();
            }
        } else if (sqlObject instanceof CheckConstraint) {
            ConstraintDefinition constraintDefinition = this.databaseVendorDefinition.getConstraintDefinition();
            if (constraintDefinition != null) {
                maximumLength = constraintDefinition.getMaximumCheckConstraintIdentifierLength();
            }
        } else if (sqlObject instanceof Trigger) {
            TriggerDefinition triggerDefinition = this.databaseVendorDefinition.getTriggerDefinition();
            if (triggerDefinition != null) {
                maximumLength = triggerDefinition.getMaximumIdentifierLength();
            }
        } else if (sqlObject instanceof UserDefinedType) {
            UserDefinedTypeDefinition udtDefinition = this.databaseVendorDefinition.getUdtDefinition();
            if (udtDefinition != null) {
                maximumLength = udtDefinition.getMaximumIdentifierLength();
            }
        } else if (sqlObject instanceof Procedure && (storedProcedureDefinition = this.databaseVendorDefinition.getStoredProcedureDefinition()) != null) {
            maximumLength = storedProcedureDefinition.getMaximumIdentifierLength();
        }
        return maximumLength;
    }

    public boolean isSQLKeyword(String word) {
        this.loadDatabaseDefinition();
        SQLSyntaxDefinition sqlSyntaxDefinition = this.databaseVendorDefinition.getSQLSyntaxDefinition();
        if (sqlSyntaxDefinition != null) {
            return sqlSyntaxDefinition.getKeywords().contains((Object)word);
        }
        return false;
    }

    public boolean isSQLOperator(String word) {
        this.loadDatabaseDefinition();
        SQLSyntaxDefinition sqlSyntaxDefinition = this.databaseVendorDefinition.getSQLSyntaxDefinition();
        if (sqlSyntaxDefinition != null) {
            return sqlSyntaxDefinition.getOperators().contains((Object)word);
        }
        return false;
    }

    public boolean supportsNicknames() {
        this.loadDatabaseDefinition();
        return this.databaseVendorDefinition.isNicknameSupported();
    }

    public boolean supportsNicknameConstraints() {
        this.loadDatabaseDefinition();
        NicknameDefinition nicknameDefinition = this.databaseVendorDefinition.getNicknameDefinition();
        if (nicknameDefinition != null) {
            return nicknameDefinition.isConstraintSupported();
        }
        return false;
    }

    public boolean supportsNicknameIndex() {
        this.loadDatabaseDefinition();
        NicknameDefinition nicknameDefinition = this.databaseVendorDefinition.getNicknameDefinition();
        if (nicknameDefinition != null) {
            return nicknameDefinition.isIndexSupported();
        }
        return false;
    }

    public boolean supportsXML() {
        this.loadDatabaseDefinition();
        return this.databaseVendorDefinition.isXmlSupported();
    }

    public boolean supportsEvents() {
        this.loadDatabaseDefinition();
        return this.databaseVendorDefinition.isEventSupported();
    }

    public boolean supportsSQLUDFs() {
        this.loadDatabaseDefinition();
        return this.databaseVendorDefinition.isSqlUDFSupported();
    }

    public boolean supportsStoredProcedures() {
        this.loadDatabaseDefinition();
        return this.databaseVendorDefinition.isStoredProcedureSupported();
    }

    public DebuggerDefinition getDebuggerDefinition() {
        this.loadDatabaseDefinition();
        return this.databaseVendorDefinition.getDebuggerDefinition();
    }

    private DatabaseVendorDefinition loadDatabaseDefinition() {
        if (this.databaseVendorDefinition == null) {
            try {
                URI uri = URI.createURI((String)this.modelURL.toString());
                XMIResourceImpl doc = new XMIResourceImpl(uri);
                doc.load(null);
                EList resourceContents = doc.getContents();
                Iterator i = resourceContents.iterator();
                while (i.hasNext()) {
                    Object o = i.next();
                    if (!(o instanceof DatabaseVendorDefinition)) continue;
                    this.databaseVendorDefinition = (DatabaseVendorDefinition)o;
                    if (this.nameToPrimitiveDataTypeDefinitionMap == null) {
                        this.nameToPrimitiveDataTypeDefinitionMap = new HashMap();
                    }
                    if (this.nameAndJDBCEnumToPrimitiveDataTypeDefinitionMap == null) {
                        this.nameAndJDBCEnumToPrimitiveDataTypeDefinitionMap = new HashMap();
                    }
                    Iterator j = this.databaseVendorDefinition.getPredefinedDataTypeDefinitions().iterator();
                    while (j.hasNext()) {
                        Object p = j.next();
                        if (!(p instanceof PredefinedDataTypeDefinition)) continue;
                        PredefinedDataTypeDefinition pd = (PredefinedDataTypeDefinition)p;
                        Iterator k = pd.getName().iterator();
                        while (k.hasNext()) {
                            Object q = k.next();
                            if (!(q instanceof String)) continue;
                            String name = (String)q;
                            if (this.nameToPrimitiveDataTypeDefinitionMap.get(name) == null) {
                                this.nameToPrimitiveDataTypeDefinitionMap.put(name, pd);
                            }
                            if (this.nameAndJDBCEnumToPrimitiveDataTypeDefinitionMap.get(name + "_" + pd.getJdbcEnumType()) != null) continue;
                            this.nameAndJDBCEnumToPrimitiveDataTypeDefinitionMap.put(name + "_" + pd.getJdbcEnumType(), pd);
                        }
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Exception caught while loading database vendor definition document: " + e);
            }
        }
        return this.databaseVendorDefinition;
    }
}

