/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.internal.core.definition;

import java.net.URL;
import java.sql.Connection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinitionImpl;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinitionRegistry;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.IDatabaseRecognizer;
import org.eclipse.datatools.modelbase.sql.schema.Database;

public final class DatabaseDefinitionRegistryImpl
implements DatabaseDefinitionRegistry {
    public static final DatabaseDefinitionRegistry INSTANCE = new DatabaseDefinitionRegistryImpl();
    private Collection recognizers = null;
    private Map products = new TreeMap();
    private Map connectibleProductVersions = new TreeMap();

    public Iterator getProducts() {
        return this.products.keySet().iterator();
    }

    public Iterator getConnectibleProducts() {
        return this.connectibleProductVersions.keySet().iterator();
    }

    public Iterator getVersions(String product) {
        Map versions = (Map)this.products.get(product);
        if (versions == null) {
            return new TreeMap().keySet().iterator();
        }
        return versions.keySet().iterator();
    }

    public Iterator getConnectibleVersions(String product) {
        Map versions = (Map)this.connectibleProductVersions.get(product);
        if (versions == null) {
            return new TreeMap().keySet().iterator();
        }
        return versions.keySet().iterator();
    }

    public DatabaseDefinition getDefinition(Database database) {
        return this.getDefinition(database.getVendor(), database.getVersion());
    }

    public DatabaseDefinition getDefinition(String product, String version) {
        Map versions = (Map)this.products.get(product);
        if (versions == null) {
            return null;
        }
        return (DatabaseDefinition)versions.get(version);
    }

    public DatabaseDefinition recognize(Connection connection) {
        if (this.recognizers == null) {
            this.loadRecognizers();
        }
        Iterator it = this.recognizers.iterator();
        while (it.hasNext()) {
            IDatabaseRecognizer recognizer = (IDatabaseRecognizer)it.next();
            try {
                DatabaseDefinition def = recognizer.recognize(connection);
                if (def == null) continue;
                return def;
            }
            catch (Exception e) {
                Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, "An exception was thrown from database recognizer " + recognizer.getClass().getName(), (Throwable)e);
                RDBCorePlugin.getDefault().getLog().log((IStatus)status);
                it.remove();
            }
        }
        return null;
    }

    private DatabaseDefinitionRegistryImpl() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.datatools.connectivity.sqm.core", "databaseDefinition");
        IExtension[] extensions = extensionPoint.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            for (int j = 0; j < configElements.length; ++j) {
                TreeMap<String, DatabaseDefinitionImpl> versions;
                if (!configElements[j].getName().equals("definition")) continue;
                String product = configElements[j].getAttribute("product");
                String version = configElements[j].getAttribute("version");
                String desc = configElements[j].getAttribute("description");
                String allowsConnections = configElements[j].getAttribute("allowsConnections");
                String productDisplayString = configElements[j].getAttribute("productDisplayString");
                String versionDisplayString = configElements[j].getAttribute("versionDisplayString");
                String modelLocation = configElements[j].getAttribute("file");
                URL modelURL = modelLocation == null ? null : Platform.getBundle((String)configElements[j].getContributor().getName()).getEntry(modelLocation);
                DatabaseDefinitionImpl definition = new DatabaseDefinitionImpl(product, version, desc, productDisplayString, versionDisplayString, modelURL);
                if (this.products.containsKey(product)) {
                    ((Map)this.products.get(product)).put(version, definition);
                } else {
                    versions = new TreeMap<String, DatabaseDefinitionImpl>();
                    versions.put(version, definition);
                    this.products.put(product, versions);
                }
                if (allowsConnections != null && allowsConnections.equals("false")) continue;
                if (this.connectibleProductVersions.containsKey(product)) {
                    ((Map)this.connectibleProductVersions.get(product)).put(version, definition);
                    continue;
                }
                versions = new TreeMap();
                versions.put(version, definition);
                this.connectibleProductVersions.put(product, versions);
            }
        }
    }

    private void loadRecognizers() {
        this.recognizers = new LinkedList();
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.datatools.connectivity.sqm.core", "databaseRecognition");
        IExtension[] extensions = extensionPoint.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            for (int j = 0; j < configElements.length; ++j) {
                if (!configElements[j].getName().equals("recognizer")) continue;
                String className = configElements[j].getAttribute("class");
                try {
                    IDatabaseRecognizer recognizer = (IDatabaseRecognizer)configElements[j].createExecutableExtension("class");
                    this.recognizers.add(recognizer);
                    continue;
                }
                catch (CoreException e) {
                    Status status = new Status(4, RDBCorePlugin.getDefault().getBundle().getSymbolicName(), 4, "The error was detected when creating the database recognizer " + className, (Throwable)e);
                    RDBCorePlugin.getDefault().getLog().log((IStatus)status);
                }
            }
        }
    }
}

