/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.internal.core.rte.fe;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.sqm.internal.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.DDLGenerator;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.EngineeringOption;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.EngineeringOptionCategory;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.fe.GenericDdlBuilder;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.fe.GenericDdlGenerationOptions;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.fe.GenericDdlScript;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.PersistentTable;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.emf.ecore.EObject;

public final class GenericDdlGenerator
implements DDLGenerator {
    private EngineeringOption[] options = null;
    private EngineeringOptionCategory[] categories = null;
    private GenericDdlBuilder builder = null;

    public String[] generateDDL(SQLObject[] elements, IProgressMonitor progressMonitor) {
        String[] statements = new String[]{};
        if (this.generateCreateStatement()) {
            statements = this.createSQLObjects(elements, this.generateQuotedIdentifiers(), this.generateFullyQualifiedNames(), progressMonitor);
        }
        if (this.generateDropStatement()) {
            int i;
            String[] drop = this.dropSQLObjects(elements, this.generateQuotedIdentifiers(), this.generateFullyQualifiedNames(), progressMonitor);
            String[] temp = statements;
            statements = new String[temp.length + drop.length];
            for (i = 0; i < drop.length; ++i) {
                statements[i] = drop[i];
            }
            for (i = 0; i < temp.length; ++i) {
                statements[i + drop.length] = temp[i];
            }
        }
        return statements;
    }

    public String[] createSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor) {
        String[] statements = this.createStatements(elements, quoteIdentifiers, qualifyNames, progressMonitor, 100);
        return statements;
    }

    public String[] dropSQLObjects(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor) {
        String[] statements = this.dropStatements(elements, quoteIdentifiers, qualifyNames, progressMonitor, 100);
        return statements;
    }

    private String[] createStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        GenericDdlScript script = new GenericDdlScript();
        if (this.builder == null) {
            this.builder = new GenericDdlBuilder();
        }
        Iterator it = this.getAllContainedDisplayableElementSet(elements).iterator();
        while (it.hasNext()) {
            String statement;
            Object o = it.next();
            if (o instanceof PersistentTable) {
                if (!this.generateTables() || (statement = this.builder.createTable((BaseTable)((PersistentTable)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateTableStatement(statement);
                continue;
            }
            if (o instanceof ViewTable) {
                if (!this.generateViews() || (statement = this.builder.createView((ViewTable)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateViewStatement(statement);
                continue;
            }
            if (o instanceof Trigger) {
                if (!this.generateTriggers() || (statement = this.builder.createTrigger((Trigger)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateTriggerStatement(statement);
                continue;
            }
            if (o instanceof CheckConstraint) {
                statement = this.builder.addCheckConstraint((CheckConstraint)o, quoteIdentifiers, qualifyNames);
                if (statement == null) continue;
                script.addAlterTableAddConstraintStatement(statement);
                continue;
            }
            if (o instanceof UniqueConstraint) {
                statement = this.builder.addUniqueConstraint((UniqueConstraint)o, quoteIdentifiers, qualifyNames);
                if (statement == null) continue;
                script.addAlterTableAddConstraintStatement(statement);
                continue;
            }
            if (o instanceof ForeignKey) {
                statement = this.builder.addForeignKey((ForeignKey)o, quoteIdentifiers, qualifyNames);
                if (statement == null) continue;
                script.addAlterTableAddForeignKeyStatement(statement);
                continue;
            }
            if (!(o instanceof Index) || !this.generateIndexes() || (statement = this.builder.createIndex((Index)o, quoteIdentifiers, qualifyNames)) == null) continue;
            script.addCreateIndexStatement(statement);
        }
        return script.getStatements();
    }

    private String[] dropStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        GenericDdlScript script = new GenericDdlScript();
        if (this.builder == null) {
            this.builder = new GenericDdlBuilder();
        }
        Iterator it = this.getAllContainedDisplayableElementSet(elements).iterator();
        while (it.hasNext()) {
            String statement;
            Object o = it.next();
            if (o instanceof PersistentTable) {
                if (!this.generateTables() || (statement = this.builder.dropTable((BaseTable)((PersistentTable)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropTableStatement(statement);
                continue;
            }
            if (o instanceof ViewTable) {
                if (!this.generateViews() || (statement = this.builder.dropView((ViewTable)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropViewStatement(statement);
                continue;
            }
            if (o instanceof Trigger) {
                if (!this.generateTriggers() || (statement = this.builder.dropTrigger((Trigger)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropTriggerStatement(statement);
                continue;
            }
            if (o instanceof CheckConstraint) {
                statement = this.builder.dropTableConstraint((TableConstraint)((CheckConstraint)o), quoteIdentifiers, qualifyNames);
                if (statement == null) continue;
                script.addAlterTableDropConstraintStatement(statement);
                continue;
            }
            if (o instanceof UniqueConstraint) {
                statement = this.builder.dropTableConstraint((TableConstraint)((UniqueConstraint)o), quoteIdentifiers, qualifyNames);
                if (statement == null) continue;
                script.addAlterTableDropConstraintStatement(statement);
                continue;
            }
            if (o instanceof ForeignKey) {
                statement = this.builder.dropTableConstraint((TableConstraint)((ForeignKey)o), quoteIdentifiers, qualifyNames);
                if (statement == null) continue;
                script.addAlterTableDropForeignKeyStatement(statement);
                continue;
            }
            if (!(o instanceof Index) || !this.generateIndexes() || (statement = this.builder.dropIndex((Index)o, quoteIdentifiers, qualifyNames)) == null) continue;
            script.addDropIndexStatement(statement);
        }
        return script.getStatements();
    }

    public EngineeringOption[] getOptions() {
        if (this.options == null) {
            this.options = GenericDdlGenerationOptions.createDDLGenerationOptions(this.getOptionCategories());
        }
        return this.options;
    }

    public EngineeringOptionCategory[] getOptionCategories() {
        if (this.categories == null) {
            this.categories = GenericDdlGenerationOptions.createDDLGenerationOptionCategories();
        }
        return this.categories;
    }

    private boolean generateDropStatement() {
        return this.getOptions()[2].getBoolean();
    }

    private boolean generateCreateStatement() {
        return this.getOptions()[3].getBoolean();
    }

    private final boolean generateQuotedIdentifiers() {
        return this.getOptions()[1].getBoolean();
    }

    private final boolean generateFullyQualifiedNames() {
        return this.getOptions()[0].getBoolean();
    }

    public final boolean generateTables() {
        return this.getOptions()[4].getBoolean();
    }

    public boolean generateIndexes() {
        return this.getOptions()[5].getBoolean();
    }

    public boolean generateViews() {
        return this.getOptions()[6].getBoolean();
    }

    public boolean generateTriggers() {
        return this.getOptions()[7].getBoolean();
    }

    private Set getAllContainedDisplayableElementSet(SQLObject[] elements) {
        HashSet<SQLObject> s = new HashSet<SQLObject>();
        for (int i = 0; i < elements.length; ++i) {
            s.add(elements[i]);
            s.addAll(ContainmentServiceImpl.INSTANCE.getAllContainedDisplayableElements((EObject)elements[i]));
        }
        return s;
    }
}

