/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.internal.core.rte.jdbc;

import com.ibm.icu.util.StringTokenizer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Vector;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilterListener;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.jdbc.JDBCSchema;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.impl.DatabaseImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class JDBCDatabase
extends DatabaseImpl
implements ICatalogObject {
    private static final long serialVersionUID = 7464150486346999662L;
    private Connection connection;
    private boolean schemasLoaded = false;
    private transient ConnectionFilterListener filterListener;

    public JDBCDatabase(Connection connection) {
        if (connection == null) {
            System.err.println("null connection");
            throw new RuntimeException();
        }
        this.connection = connection;
    }

    public synchronized void refresh() {
        if (this.schemasLoaded) {
            this.schemasLoaded = false;
            this.schemas.clear();
        }
        RefreshManager.getInstance().referesh(this);
    }

    public EList getSchemas() {
        if (!this.schemasLoaded) {
            this.loadSchemas();
        }
        return this.schemas;
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Database getCatalogDatabase() {
        return this;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 7) {
            this.getSchemas();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadSchemas() {
        if (this.schemasLoaded) {
            return;
        }
        EList schemaList = super.getSchemas();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            ConnectionInfo connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase((Database)this);
            ConnectionFilter filter = connectionInfo.getFilter(this.getFilterKey());
            if (filter == null) {
                filter = connectionInfo.getFilter("DatatoolsSchemaFilterPredicate");
            }
            String[] schemaAry = null;
            String pattern = null;
            if (filter != null) {
                String schemaFilter = filter.getPredicate();
                if ((schemaFilter = schemaFilter.replaceAll(" ", "")).startsWith("IN(")) {
                    schemaFilter = schemaFilter.substring(3, schemaFilter.length() - 1);
                    schemaFilter = schemaFilter.replaceAll(",", "");
                    schemaAry = this.parseINClause(schemaFilter);
                }
                if (schemaFilter.startsWith("LIKE")) {
                    pattern = this.parseLikeClause(schemaFilter);
                }
            }
            DatabaseMetaData metaData = this.connection.getMetaData();
            ResultSet r = metaData.getSchemas();
            while (r.next()) {
                String schemaName = r.getString(1);
                if (schemaAry != null) {
                    boolean found = false;
                    for (int i = 0; i < schemaAry.length; ++i) {
                        if (!schemaName.equals(schemaAry[i])) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                }
                if (pattern != null && !(pattern.indexOf("%") == 0 && pattern.endsWith("%") ? schemaName.indexOf(pattern.substring(1, pattern.length() - 1)) != -1 : (pattern.indexOf("%") == 0 ? schemaName.endsWith(pattern.substring(1)) : schemaName.startsWith(pattern.substring(0, pattern.length() - 1))))) continue;
                JDBCSchema schema = new JDBCSchema();
                schema.setName(schemaName);
                schemaList.add((Object)schema);
            }
            this.schemasLoaded = true;
            r.close();
            if (this.filterListener == null) {
                this.filterListener = new FilterListener();
                connectionInfo.addFilterListener(this.filterListener);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    protected String[] parseINClause(String toParse) {
        StringTokenizer tokenizer = new StringTokenizer(toParse, "'");
        Vector<String> list = new Vector<String>();
        Object result = null;
        if (tokenizer.countTokens() >= 1) {
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken());
            }
        }
        String[] retStrList = null;
        if (list.size() > 0) {
            retStrList = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                retStrList[i] = (String)list.get(i);
            }
        }
        return retStrList;
    }

    protected String parseLikeClause(String toParse) {
        String retString = toParse.substring(toParse.indexOf("'") + 1, toParse.length() - 1);
        return retString;
    }

    private void handleFilterChanged(String filterKey) {
        ConnectionInfo conInf;
        if (!this.schemasLoaded) {
            return;
        }
        if (filterKey.equals(this.getFilterKey())) {
            this.refresh();
        } else if ("DatatoolsSchemaFilterPredicate".equals(filterKey) && (conInf = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase((Database)this)) != null && conInf.getFilter(this.getFilterKey()) == null) {
            this.refresh();
        }
    }

    private String getFilterKey() {
        return this.getName() + "::" + "DatatoolsSchemaFilterPredicate";
    }

    private class FilterListener
    implements ConnectionFilterListener {
        private FilterListener() {
        }

        public void connectionFilterAdded(String filterKey) {
            JDBCDatabase.this.handleFilterChanged(filterKey);
        }

        public void connectionFilterRemoved(String filterKey) {
            JDBCDatabase.this.handleFilterChanged(filterKey);
        }
    }
}

