/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.actions;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.datatools.sqltools.sqleditor.IPageUpdate;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class ToggleCommentAction
extends TextEditorAction
implements IPageUpdate {
    private ITextOperationTarget _operationTarget;
    private String _documentPartitioning;
    private Map _prefixesMap;
    private boolean _isSourcePage = true;

    public ToggleCommentAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
        this.setActionDefinitionId("org.eclipse.datatools.sqltools.sqleditor.toggleCommentAction");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.datatools.sqltools.sqleditor.toggle_comment_action");
    }

    public void run() {
        if (this._operationTarget == null || this._documentPartitioning == null || this._prefixesMap == null) {
            return;
        }
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return;
        }
        if (!this.validateEditorInputState()) {
            return;
        }
        final int operationCode = this.isSelectionCommented(editor.getSelectionProvider().getSelection()) ? 12 : 11;
        Shell shell = editor.getSite().getShell();
        if (!this._operationTarget.canDoOperation(operationCode)) {
            if (shell != null) {
                MessageDialog.openError((Shell)shell, (String)Messages.ToggleComment_error_title, (String)Messages.ToggleComment_error_message);
            }
            return;
        }
        Display display = null;
        if (shell != null && !shell.isDisposed()) {
            display = shell.getDisplay();
        }
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            public void run() {
                ToggleCommentAction.this._operationTarget.doOperation(operationCode);
            }
        });
    }

    private boolean isSelectionCommented(ISelection selection) {
        if (!(selection instanceof ITextSelection)) {
            return false;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        if (textSelection.getStartLine() < 0 || textSelection.getEndLine() < 0) {
            return false;
        }
        IDocument document = this.getTextEditor().getDocumentProvider().getDocument((Object)this.getTextEditor().getEditorInput());
        try {
            IRegion block = this.getTextBlockFromSelection(textSelection, document);
            ITypedRegion[] regions = TextUtilities.computePartitioning((IDocument)document, (String)this._documentPartitioning, (int)block.getOffset(), (int)block.getLength(), (boolean)false);
            int lineCount = 0;
            int[] lines = new int[regions.length * 2];
            int i = 0;
            int j = 0;
            while (i < regions.length) {
                lines[j] = this.getFirstCompleteLineOfRegion((IRegion)regions[i], document);
                int length = regions[i].getLength();
                int offset = regions[i].getOffset() + length;
                if (length > 0) {
                    --offset;
                }
                lines[j + 1] = lines[j] == -1 ? -1 : document.getLineOfOffset(offset);
                lineCount += lines[j + 1] - lines[j] + 1;
                ++i;
                j += 2;
            }
            i = 0;
            j = 0;
            while (i < regions.length) {
                String[] prefixes = (String[])this._prefixesMap.get(regions[i].getType());
                if (prefixes != null && prefixes.length > 0 && lines[j] >= 0 && lines[j + 1] >= 0 && !this.isBlockCommented(lines[j], lines[j + 1], prefixes, document)) {
                    return false;
                }
                ++i;
                j += 2;
            }
            return true;
        }
        catch (BadLocationException x) {
            return false;
        }
    }

    private IRegion getTextBlockFromSelection(ITextSelection selection, IDocument document) {
        try {
            IRegion line = document.getLineInformationOfOffset(selection.getOffset());
            int length = selection.getLength() == 0 ? line.getLength() : selection.getLength() + (selection.getOffset() - line.getOffset());
            return new Region(line.getOffset(), length);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private int getFirstCompleteLineOfRegion(IRegion region, IDocument document) {
        try {
            int startLine = document.getLineOfOffset(region.getOffset());
            int offset = document.getLineOffset(startLine);
            if (offset >= region.getOffset()) {
                return startLine;
            }
            offset = document.getLineOffset(startLine + 1);
            return offset > region.getOffset() + region.getLength() ? -1 : startLine + 1;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    private boolean isBlockCommented(int startLine, int endLine, String[] prefixes, IDocument document) {
        try {
            for (int i = startLine; i <= endLine; ++i) {
                IRegion line = document.getLineInformation(i);
                String text = document.get(line.getOffset(), line.getLength());
                int[] found = TextUtilities.indexOf((String[])prefixes, (String)text, (int)0);
                if (found[0] == -1) {
                    return false;
                }
                String s = document.get(line.getOffset(), found[0]);
                if ((s = s.trim()).length() == 0) continue;
                return false;
            }
            return true;
        }
        catch (BadLocationException x) {
            return false;
        }
    }

    public void update() {
        super.update();
        if (!this._isSourcePage) {
            this.setEnabled(false);
            return;
        }
        SQLEditor editor = (SQLEditor)this.getTextEditor();
        if (editor.isEditorInputReadOnly()) {
            this.setEnabled(false);
            return;
        }
        if (this._operationTarget == null && editor != null) {
            this._operationTarget = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
        }
        boolean isEnabled = this._operationTarget != null && this._operationTarget.canDoOperation(11) && this._operationTarget.canDoOperation(12);
        this.setEnabled(isEnabled);
    }

    public void setEditor(ITextEditor editor) {
        super.setEditor(editor);
        this._operationTarget = null;
    }

    public void configure(ISourceViewer sourceViewer, SourceViewerConfiguration configuration) {
        this._prefixesMap = null;
        String[] types = configuration.getConfiguredContentTypes(sourceViewer);
        HashMap<String, String[]> prefixesMap = new HashMap<String, String[]>(types.length);
        for (int i = 0; i < types.length; ++i) {
            String type = types[i];
            String[] prefixes = configuration.getDefaultPrefixes(sourceViewer, type);
            if (prefixes == null || prefixes.length <= 0) continue;
            int emptyPrefixes = 0;
            for (int j = 0; j < prefixes.length; ++j) {
                if (prefixes[j].length() != 0) continue;
                ++emptyPrefixes;
            }
            if (emptyPrefixes > 0) {
                String[] nonemptyPrefixes = new String[prefixes.length - emptyPrefixes];
                int k = 0;
                for (int j = 0; j < prefixes.length; ++j) {
                    String prefix = prefixes[j];
                    if (prefix.length() == 0) continue;
                    nonemptyPrefixes[k] = prefix;
                    ++k;
                }
                prefixes = nonemptyPrefixes;
            }
            prefixesMap.put(type, prefixes);
        }
        this._documentPartitioning = configuration.getConfiguredDocumentPartitioning(sourceViewer);
        this._prefixesMap = prefixesMap;
    }

    public void update(boolean isSQLEditorPage) {
        this._isSourcePage = isSQLEditorPage;
        this.update();
    }
}

