/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.service.start.launcher;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.device.common.utilities.exception.SequoyahException;
import org.eclipse.sequoyah.device.framework.model.IDeviceLauncher;
import org.eclipse.sequoyah.device.service.start.exception.StartServiceExceptionHandler;

public class DeviceLauncherManager {
    public static final String LAUNCHER_ID = "org.eclipse.sequoyah.device.service.start.launcher";
    public static final String ATTR_LAUNCH_CONFIGURATION_BUILD_SCOPE = "org.eclipse.ui.externaltools.ATTR_LAUNCH_CONFIGURATION_BUILD_SCOPE";
    public static final String ATTR_LAUNCH_CONFIGURATION_BUILD_SCOPE_VALUE = "${none}";

    public static ILaunch launch(IDeviceLauncher iDeviceLauncher, String string) {
        ILaunch iLaunch = null;
        try {
            BasePlugin.logInfo((String)("launching " + string));
            ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType iLaunchConfigurationType = iLaunchManager.getLaunchConfigurationType(LAUNCHER_ID);
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, string);
            iLaunchConfigurationWorkingCopy.setAttribute(ATTR_LAUNCH_CONFIGURATION_BUILD_SCOPE, ATTR_LAUNCH_CONFIGURATION_BUILD_SCOPE_VALUE);
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.sequoyah.device.service.start.ATTR_LOCATION", iDeviceLauncher.getLocation());
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.sequoyah.device.service.start.ATTR_TOOL_ARGUMENTS", iDeviceLauncher.getToolArguments());
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.sequoyah.device.service.start.ATTR_WORKING_DIRECTORY", iDeviceLauncher.getWorkingDirectory());
            ILaunchConfiguration iLaunchConfiguration = iLaunchConfigurationWorkingCopy.doSave();
            File file = new File(iDeviceLauncher.getFileId());
            if (file.exists()) {
                file.delete();
            }
            iLaunch = iLaunchConfiguration.launch("debug", null);
            iDeviceLauncher.setPID(DeviceLauncherManager.readPID(iDeviceLauncher.getFileId()));
        }
        catch (Throwable throwable) {
            BasePlugin.logError((String)"emulator could not be launched", (Throwable)throwable);
        }
        return iLaunch;
    }

    private static int readPID(String string) throws SequoyahException {
        int n = 0;
        File file = new File(string);
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        DataInputStream dataInputStream = null;
        int n2 = 0;
        while (!file.exists() && n2 < 50) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            ++n2;
        }
        if (n2 >= 50) {
            throw StartServiceExceptionHandler.exception(100);
        }
        try {
            try {
                fileInputStream = new FileInputStream(file);
                bufferedInputStream = new BufferedInputStream(fileInputStream);
                dataInputStream = new DataInputStream(bufferedInputStream);
                while (dataInputStream.available() != 0) {
                    n = Integer.valueOf(dataInputStream.readLine());
                }
                fileInputStream.close();
                bufferedInputStream.close();
                dataInputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                file.delete();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                file.delete();
            }
        }
        finally {
            file.delete();
        }
        return n;
    }
}

