/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CBanner;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.internal.IReorderListener;
import org.eclipse.ui.internal.PerspectiveBarContributionItem;
import org.eclipse.ui.internal.PerspectiveBarManager;
import org.eclipse.ui.internal.PerspectiveBarNewContributionItem;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.layout.CacheWrapper;
import org.eclipse.ui.internal.layout.CellLayout;
import org.eclipse.ui.internal.layout.ITrimManager;
import org.eclipse.ui.internal.layout.IWindowTrim;
import org.eclipse.ui.internal.layout.LayoutUtil;
import org.eclipse.ui.internal.layout.Row;
import org.eclipse.ui.internal.util.PrefUtil;

public class PerspectiveSwitcher
implements IWindowTrim {
    private static final int MIN_WIDTH = 45;
    private static final int ITEM_WIDTH = 80;
    private static final int MIN_DEFAULT_WIDTH = 160;
    private IWorkbenchWindow window;
    private CBanner topBar;
    private int style;
    private Composite parent;
    private Composite trimControl;
    private Label trimSeparator;
    private GridData trimLayoutData;
    private boolean trimVisible = false;
    private int trimOldLength = 0;
    private PerspectiveBarManager perspectiveBar;
    private CoolBar perspectiveCoolBar;
    private CacheWrapper perspectiveCoolBarWrapper;
    private CoolItem coolItem;
    private CacheWrapper toolbarWrapper;
    private static final int INITIAL = -1;
    private static final int TOP_RIGHT = 1;
    private static final int TOP_LEFT = 2;
    private static final int LEFT = 3;
    private int currentLocation = -1;
    private IPreferenceStore apiPreferenceStore = PrefUtil.getAPIPreferenceStore();
    private IPropertyChangeListener propertyChangeListener;
    private ChangeListener changeListener = new ChangeListener();
    private Listener dragListener;
    private DisposeListener toolBarListener;

    public PerspectiveSwitcher(IWorkbenchWindow window, CBanner topBar, int style) {
        this.window = window;
        this.topBar = topBar;
        this.style = style;
        this.setPropertyChangeListener();
        this.toolBarListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PerspectiveSwitcher.this.dispose();
            }
        };
        window.addPerspectiveListener(this.changeListener);
        window.addPageListener(this.changeListener);
    }

    private static int convertLocation(String preference) {
        if ("topRight".equals(preference)) {
            return 1;
        }
        if ("topLeft".equals(preference)) {
            return 2;
        }
        if ("left".equals(preference)) {
            return 3;
        }
        return 1;
    }

    public void createControl(Composite parent) {
        Assert.isTrue((this.parent == null ? 1 : 0) != 0);
        this.parent = parent;
        this.setPerspectiveBarLocation(PrefUtil.getAPIPreferenceStore().getString("DOCK_PERSPECTIVE_BAR"));
    }

    private void addPerspectiveShortcut(IPerspectiveDescriptor perspective, IWorkbenchPage workbenchPage) {
        if (this.perspectiveBar == null) {
            return;
        }
        PerspectiveBarContributionItem item = new PerspectiveBarContributionItem(perspective, workbenchPage);
        this.perspectiveBar.addItem(item);
        this.setCoolItemSize(this.coolItem);
        if (this.perspectiveBar != null) {
            this.perspectiveBar.update(true);
        }
        if (this.currentLocation == 3) {
            this.updatePerspectiveBar();
        }
    }

    public IContributionItem findPerspectiveShortcut(IPerspectiveDescriptor perspective, IWorkbenchPage page) {
        if (this.perspectiveBar == null) {
            return null;
        }
        IContributionItem[] items = this.perspectiveBar.getItems();
        int length = items.length;
        int i = 0;
        while (i < length) {
            IContributionItem item = items[i];
            if (item instanceof PerspectiveBarContributionItem && ((PerspectiveBarContributionItem)item).handles(perspective, page)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    private void removePerspectiveShortcut(IPerspectiveDescriptor perspective, IWorkbenchPage page) {
        if (this.perspectiveBar == null) {
            return;
        }
        IContributionItem item = this.findPerspectiveShortcut(perspective, page);
        if (item != null) {
            if (item instanceof PerspectiveBarContributionItem) {
                this.perspectiveBar.removeItem((PerspectiveBarContributionItem)item);
            }
            item.dispose();
            this.perspectiveBar.update(false);
            this.setCoolItemSize(this.coolItem);
            if (this.currentLocation == 3) {
                this.updatePerspectiveBar();
                LayoutUtil.resize((Control)this.perspectiveBar.getControl());
            }
        }
    }

    public void setPerspectiveBarLocation(String preference) {
        if (this.parent == null) {
            return;
        }
        int newLocation = PerspectiveSwitcher.convertLocation(preference);
        if (newLocation == this.currentLocation) {
            return;
        }
        this.createControlForLocation(newLocation);
        this.currentLocation = newLocation;
        this.showPerspectiveBar();
        if (newLocation == 2 || newLocation == 1) {
            this.updatePerspectiveBar();
            this.updateBarParent();
        }
    }

    private void showPerspectiveBar() {
        switch (this.currentLocation) {
            case 2: {
                this.topBar.setRight(null);
                this.topBar.setBottom((Control)this.perspectiveCoolBarWrapper.getControl());
                break;
            }
            case 1: {
                this.topBar.setBottom(null);
                this.topBar.setRight((Control)this.perspectiveCoolBarWrapper.getControl());
                this.topBar.setRightWidth(this.getDefaultWidth());
                break;
            }
            case 3: {
                this.topBar.setBottom(null);
                this.topBar.setRight(null);
                LayoutUtil.resize((Control)this.topBar);
                this.getTrimManager().addTrim(16384, this);
                break;
            }
            default: {
                return;
            }
        }
        LayoutUtil.resize((Control)this.perspectiveBar.getControl());
    }

    private int getDefaultWidth() {
        String extras = PrefUtil.getAPIPreferenceStore().getString("PERSPECTIVE_BAR_EXTRAS");
        StringTokenizer tok = new StringTokenizer(extras, ", ");
        int numExtras = tok.countTokens();
        int numPersps = Math.max(numExtras, 1);
        return Math.max(160, 45 + numPersps * 80);
    }

    private ITrimManager getTrimManager() {
        if (this.window instanceof WorkbenchWindow) {
            return ((WorkbenchWindow)this.window).getTrimManager();
        }
        return null;
    }

    public void update(boolean force) {
        if (this.perspectiveBar == null) {
            return;
        }
        this.perspectiveBar.update(force);
        if (this.currentLocation == 3) {
            boolean shouldExpand;
            ToolItem[] items = this.perspectiveBar.getControl().getItems();
            boolean bl = shouldExpand = items.length > 0;
            if (shouldExpand != this.trimVisible) {
                this.perspectiveBar.getControl().setVisible(true);
                this.trimVisible = shouldExpand;
            }
            if (items.length != this.trimOldLength) {
                LayoutUtil.resize((Control)this.trimControl);
                this.trimOldLength = items.length;
            }
        }
    }

    private void selectPerspectiveShortcut(IPerspectiveDescriptor perspective, IWorkbenchPage page, boolean selected) {
        IContributionItem item = this.findPerspectiveShortcut(perspective, page);
        if (item != null && item instanceof PerspectiveBarContributionItem) {
            if (selected) {
                PerspectiveBarContributionItem contribItem = (PerspectiveBarContributionItem)item;
                this.perspectiveBar.select(contribItem);
            }
            ((PerspectiveBarContributionItem)item).setSelection(selected);
        }
    }

    private void updatePerspectiveShortcut(IPerspectiveDescriptor oldDesc, IPerspectiveDescriptor newDesc, IWorkbenchPage page) {
        IContributionItem item = this.findPerspectiveShortcut(oldDesc, page);
        if (item != null && item instanceof PerspectiveBarContributionItem) {
            ((PerspectiveBarContributionItem)item).update(newDesc);
        }
    }

    public PerspectiveBarManager getPerspectiveBar() {
        return this.perspectiveBar;
    }

    public void dispose() {
        this.window.removePerspectiveListener(this.changeListener);
        this.window.removePageListener(this.changeListener);
        if (this.propertyChangeListener != null) {
            this.apiPreferenceStore.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        this.unhookDragSupport();
        this.disposeChildControls();
        this.toolBarListener = null;
    }

    private void disposeChildControls() {
        if (this.trimControl != null) {
            this.trimControl.dispose();
            this.trimControl = null;
        }
        if (this.trimSeparator != null) {
            this.trimSeparator.dispose();
            this.trimSeparator = null;
        }
        if (this.perspectiveCoolBar != null) {
            this.perspectiveCoolBar.dispose();
            this.perspectiveCoolBar = null;
        }
        if (this.toolbarWrapper != null) {
            this.toolbarWrapper.dispose();
            this.toolbarWrapper = null;
        }
        if (this.perspectiveBar != null) {
            this.perspectiveBar.dispose();
            this.perspectiveBar = null;
        }
        this.perspectiveCoolBarWrapper = null;
    }

    private void createControlForLocation(int newLocation) {
        if (this.perspectiveBar != null && this.perspectiveBar.getControl() != null && !this.perspectiveBar.getControl().isDisposed()) {
            if (newLocation == 3 && this.currentLocation == 3) {
                return;
            }
            if (!(newLocation != 2 && newLocation != 1 || this.currentLocation != 2 && this.currentLocation != 1)) {
                return;
            }
        }
        if (this.perspectiveBar != null) {
            this.perspectiveBar.getControl().removeDisposeListener(this.toolBarListener);
            this.unhookDragSupport();
        }
        this.getTrimManager().removeTrim(this);
        this.disposeChildControls();
        if (newLocation == 3) {
            this.createControlForLeft();
        } else {
            this.createControlForTop();
        }
        this.hookDragSupport();
    }

    private void unhookDragSupport() {
        ToolBar bar = this.perspectiveBar.getControl();
        if (bar == null || bar.isDisposed() || this.dragListener == null) {
            return;
        }
        this.dragListener = null;
    }

    private void hookDragSupport() {
    }

    private void setPropertyChangeListener() {
        this.propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("SHOW_TEXT_ON_PERSPECTIVE_BAR".equals(propertyChangeEvent.getProperty())) {
                    if (PerspectiveSwitcher.this.perspectiveBar == null) {
                        return;
                    }
                    PerspectiveSwitcher.this.updatePerspectiveBar();
                    PerspectiveSwitcher.this.updateBarParent();
                }
            }
        };
        this.apiPreferenceStore.addPropertyChangeListener(this.propertyChangeListener);
    }

    private void createControlForLeft() {
        this.trimControl = new Composite(this.parent, 0);
        this.trimControl.setLayout((Layout)new CellLayout(1).setMargins(0, 0).setSpacing(3, 3).setDefaultRow(Row.fixed()).setDefaultColumn(Row.growing()));
        this.perspectiveBar = this.createBarManager(512);
        this.perspectiveBar.createControl(this.trimControl);
        this.trimLayoutData = new GridData(1808);
        this.trimVisible = false;
        this.perspectiveBar.getControl().setLayoutData((Object)this.trimLayoutData);
    }

    private void createControlForTop() {
        this.perspectiveBar = this.createBarManager(256);
        this.perspectiveCoolBarWrapper = new CacheWrapper((Composite)this.topBar);
        this.perspectiveCoolBar = new CoolBar(this.perspectiveCoolBarWrapper.getControl(), 0x800000);
        this.coolItem = new CoolItem(this.perspectiveCoolBar, 4);
        this.toolbarWrapper = new CacheWrapper((Composite)this.perspectiveCoolBar);
        this.perspectiveBar.createControl(this.toolbarWrapper.getControl());
        this.coolItem.setControl((Control)this.toolbarWrapper.getControl());
        this.perspectiveCoolBar.setLocked(true);
        this.perspectiveBar.setParent(this.perspectiveCoolBar);
        this.perspectiveBar.update(true);
        this.perspectiveCoolBar.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                PerspectiveSwitcher.this.setCoolItemSize(PerspectiveSwitcher.this.coolItem);
            }
        });
        this.coolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 4 && PerspectiveSwitcher.this.perspectiveBar != null) {
                    PerspectiveSwitcher.this.perspectiveBar.handleChevron(e);
                }
            }
        });
        this.coolItem.setMinimumSize(0, 0);
    }

    private void setCoolItemSize(CoolItem coolItem) {
        int rows;
        if (this.currentLocation == 3) {
            return;
        }
        ToolBar toolbar = this.perspectiveBar.getControl();
        if (toolbar == null) {
            return;
        }
        int rowHeight = 0;
        ToolItem[] toolItems = toolbar.getItems();
        int i = 0;
        while (i < toolItems.length) {
            rowHeight = Math.max(rowHeight, toolItems[i].getBounds().height);
            ++i;
        }
        Rectangle area = this.perspectiveCoolBar.getClientArea();
        int n = rows = rowHeight <= 0 ? 1 : (int)Math.max(1.0, Math.floor(area.height / rowHeight));
        if (rows == 1 || (toolbar.getStyle() & 0x40) == 0 || this.currentLocation == 2) {
            Point p = toolbar.computeSize(-1, -1);
            coolItem.setSize(coolItem.computeSize(p.x, p.y));
            return;
        }
        Point offset = coolItem.computeSize(0, 0);
        Point wrappedSize = toolbar.computeSize(area.width - offset.x, -1);
        int h = rows * rowHeight;
        int w = wrappedSize.y <= h ? wrappedSize.x : wrappedSize.x + 1;
        coolItem.setSize(coolItem.computeSize(w, h));
    }

    private PerspectiveBarManager createBarManager(int direction) {
        IWorkbenchPage page;
        PerspectiveBarManager barManager = new PerspectiveBarManager(this.style | direction);
        if (this.apiPreferenceStore.getBoolean("SHOW_OPEN_ON_PERSPECTIVE_BAR")) {
            barManager.add((IContributionItem)new PerspectiveBarNewContributionItem(this.window));
        }
        if ((page = this.window.getActivePage()) != null) {
            IPerspectiveDescriptor[] perspectives = page.getOpenPerspectives();
            int i = 0;
            while (i < perspectives.length) {
                barManager.insert(1, (IContributionItem)new PerspectiveBarContributionItem(perspectives[i], page));
                ++i;
            }
        }
        return barManager;
    }

    public void saveState(IMemento persBarMem) {
        IMemento childMem = persBarMem.createChild("itemSize");
        int x = this.currentLocation == 1 && this.topBar != null ? this.topBar.getRightWidth() : this.getDefaultWidth();
        childMem.putString("x", Integer.toString(x));
    }

    public void restoreState(IMemento memento) {
        if (memento == null) {
            return;
        }
        IMemento attributes = memento.getChild("perspectiveBar");
        IMemento size = null;
        if (attributes != null) {
            size = attributes.getChild("itemSize");
        }
        if (size != null && this.currentLocation == 1 && this.topBar != null) {
            final Integer x = size.getInteger("x");
            StartupThreading.runWithoutExceptions(new StartupThreading.StartupRunnable(){

                public void runWithException() {
                    if (x != null) {
                        PerspectiveSwitcher.this.topBar.setRightWidth(x.intValue());
                    } else {
                        PerspectiveSwitcher.this.topBar.setRightWidth(PerspectiveSwitcher.this.getDefaultWidth());
                    }
                }
            });
        }
    }

    void updatePerspectiveBar() {
        IContributionItem[] items = this.perspectiveBar.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].update();
            ++i;
        }
        this.perspectiveBar.arrangeToolbar();
        this.setCoolItemSize(this.coolItem);
        this.perspectiveBar.getControl().redraw();
        if (this.getControl() != null) {
            this.getControl().pack(true);
        }
    }

    public void updateBarParent() {
        if (this.perspectiveBar == null || this.perspectiveBar.getControl() == null) {
            return;
        }
        if (this.currentLocation == 1 && this.topBar != null) {
            int maxRowHeight = 0;
            ToolItem[] toolItems = this.perspectiveBar.getControl().getItems();
            int i = 0;
            while (i < toolItems.length) {
                maxRowHeight = Math.max(maxRowHeight, toolItems[i].getBounds().height);
                ++i;
            }
            this.topBar.setRightMinimumSize(new Point(45, maxRowHeight));
        }
        LayoutUtil.resize((Control)this.perspectiveBar.getControl());
    }

    public void addReorderListener(IReorderListener listener) {
    }

    public void dock(int dropSide) {
    }

    public Control getControl() {
        return this.trimControl;
    }

    public String getId() {
        return "org.eclipse.ui.internal.PerspectiveSwitcher";
    }

    public String getDisplayName() {
        return WorkbenchMessages.get().TrimCommon_PerspectiveSwitcher_TrimName;
    }

    public int getValidSides() {
        return 0;
    }

    public boolean isCloseable() {
        return false;
    }

    public void handleClose() {
    }

    public int getWidthHint() {
        return -1;
    }

    public int getHeightHint() {
        return -1;
    }

    public boolean isResizeable() {
        return false;
    }

    class ChangeListener
    extends PerspectiveAdapter
    implements IPageListener {
        ChangeListener() {
        }

        public void perspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            if (PerspectiveSwitcher.this.findPerspectiveShortcut(perspective, page) == null) {
                PerspectiveSwitcher.this.addPerspectiveShortcut(perspective, page);
            }
        }

        public void perspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            if (page != null && !page.getWorkbenchWindow().getWorkbench().isClosing()) {
                PerspectiveSwitcher.this.removePerspectiveShortcut(perspective, page);
            }
        }

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            PerspectiveSwitcher.this.selectPerspectiveShortcut(perspective, page, true);
        }

        public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            PerspectiveSwitcher.this.selectPerspectiveShortcut(perspective, page, false);
        }

        public void perspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
            PerspectiveSwitcher.this.updatePerspectiveShortcut(oldPerspective, newPerspective, page);
        }

        public void pageActivated(IWorkbenchPage page) {
        }

        public void pageClosed(IWorkbenchPage page) {
        }

        public void pageOpened(IWorkbenchPage page) {
        }
    }
}

