/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.menus.MenuAdditionCacheEntry;
import org.eclipse.ui.internal.menus.MenuLocationURI;
import org.eclipse.ui.internal.menus.TrimAdditionCacheEntry;
import org.eclipse.ui.internal.menus.WorkbenchMenuService;
import org.eclipse.ui.internal.services.RegistryPersistence;

final class MenuPersistence
extends RegistryPersistence {
    private final WorkbenchMenuService menuService;

    MenuPersistence(WorkbenchMenuService workbenchMenuService) {
        if (workbenchMenuService == null) {
            throw new NullPointerException("The menu service cannot be null");
        }
        this.menuService = workbenchMenuService;
    }

    public final void dispose() {
        super.dispose();
    }

    protected final boolean isChangeImportant(IRegistryChangeEvent event) {
        return false;
    }

    public boolean menusNeedUpdating(IRegistryChangeEvent event) {
        IExtensionDelta[] menuDeltas = event.getExtensionDeltas("org.eclipse.ui", "menus");
        return menuDeltas.length != 0;
    }

    protected final void read() {
        super.read();
        this.readTrimAdditions();
        this.readAdditions();
    }

    public void readTrimAdditions() {
        if (this.menuService == null) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] configElements = registry.getConfigurationElementsFor("org.eclipse.ui.menus");
        int i = 0;
        while (i < configElements.length) {
            if ("group".equals(configElements[i].getName())) {
                String id = configElements[i].getAttribute("id");
                String uriSpec = "toolbar:" + id;
                if (configElements[i].getChildren("location").length > 0) {
                    IConfigurationElement location = configElements[i].getChildren("location")[0];
                    if (location.getChildren("order").length > 0) {
                        IConfigurationElement order = location.getChildren("order")[0];
                        String pos = order.getAttribute("position");
                        String relTo = order.getAttribute("relativeTo");
                        uriSpec = String.valueOf(uriSpec) + "?" + pos + "=" + relTo;
                        MenuLocationURI uri = new MenuLocationURI("toolbar:" + relTo);
                        List trimAdditions = this.menuService.getAdditionsForURI(uri);
                        uri = new MenuLocationURI(uriSpec);
                        trimAdditions.add(new TrimAdditionCacheEntry(configElements[i], uri, this.menuService));
                    } else {
                        MenuLocationURI uri = new MenuLocationURI(uriSpec);
                        this.menuService.getAdditionsForURI(uri);
                    }
                }
            }
            ++i;
        }
    }

    public void readAdditions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] menusExtensionPoint = registry.getConfigurationElementsFor("org.eclipse.ui.menus");
        int i = 0;
        while (i < menusExtensionPoint.length) {
            if ("menuContribution".equals(menusExtensionPoint[i].getName())) {
                String location = menusExtensionPoint[i].getAttribute("locationURI");
                this.menuService.addContributionFactory(new MenuAdditionCacheEntry(this.menuService, menusExtensionPoint[i], location, menusExtensionPoint[i].getNamespaceIdentifier()));
            }
            ++i;
        }
    }
}

