/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.actions;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringBufferInputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.photran.internal.core.lexer.CPreprocessingInputStream;
import org.eclipse.photran.internal.ui.actions.FortranEditorActionDelegate;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.Workbench;

public class DisplayPreprocessedSource
extends FortranEditorActionDelegate {
    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            boolean isFixedForm = this.getFortranEditor().isFixedForm();
            IDocument doc = this.getFortranEditor().getIDocument();
            StringBufferInputStream in = new StringBufferInputStream(doc.get());
            CPreprocessingInputStream cppIn = new CPreprocessingInputStream(this.getFortranEditor().getIFile(), null, (InputStream)in);
            File tempFile = File.createTempFile("tmp", isFixedForm ? ".f" : ".f90");
            tempFile.deleteOnExit();
            PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(tempFile)));
            int c = cppIn.read();
            while (c != -1) {
                out.print((char)c);
                c = cppIn.read();
            }
            out.close();
            IDE.openEditor((IWorkbenchPage)Workbench.getInstance().getActiveWorkbenchWindow().getActivePage(), (URI)tempFile.toURI(), (String)(isFixedForm ? "org.eclipse.photran.ui.FixedFormFortranEditor" : "org.eclipse.photran.ui.FreeFormFortranEditor"), (boolean)true);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = e.getClass().getName();
            }
            MessageDialog.openError((Shell)this.getFortranEditor().getShell(), (String)"Error", (String)message);
        }
    }
}

