/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.core.pdi.request;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.request.AbstractEventRequest;
import org.eclipse.ptp.debug.core.pdi.request.IPDIInternalEventRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEventResultRequest
extends AbstractEventRequest
implements IPDIInternalEventRequest {
    private final Object lock = new Object();
    protected Map<BitList, Object> results = new HashMap<BitList, Object>();
    protected long DEFAULT_TIMEOUT = 5000L;

    public AbstractEventResultRequest(BitList tasks) {
        super(tasks);
    }

    @Override
    public boolean completed(BitList cTasks, Object result) {
        if (this.tasks.intersects(cTasks)) {
            this.storeResult(cTasks.copy(), result);
            this.notifyWaiting();
            return super.completed(cTasks, result);
        }
        return false;
    }

    @Override
    public int getResponseAction() {
        return 2;
    }

    @Override
    public Object getResult(BitList qTasks) throws PDIException {
        if (this.findResult(qTasks)) {
            return this.results.get(qTasks);
        }
        for (BitList sTasks : this.results.keySet()) {
            if (!sTasks.intersects(qTasks)) continue;
            return this.results.get(sTasks);
        }
        throw new PDIException(qTasks, String.valueOf(this.getName()) + ": No request task found");
    }

    @Override
    public Map<BitList, Object> getResultMap(BitList qTasks) throws PDIException {
        this.waitUntilCompleted(qTasks);
        return this.results;
    }

    @Override
    public void waitUntilCompleted(BitList qTasks) throws PDIException {
        this.waiting();
        if (this.status == 1) {
            throw new PDIException(qTasks, this.getErrorMessage());
        }
    }

    @Override
    public void waitUntilCompleted(BitList qTasks, IProgressMonitor monitor) throws PDIException {
        while (!(this.tasks.isEmpty() || this.status != 5 && this.status != 2)) {
            if (monitor.isCanceled()) {
                this.error("This request is interrupted.");
                break;
            }
            this.lockRequest(500L);
            monitor.worked(1);
        }
        if (this.status == 1) {
            throw new PDIException(qTasks, this.getErrorMessage());
        }
        if (this.status == 3) {
            monitor.done();
        }
    }

    private void notifyWaiting() {
        this.releaseRequest();
    }

    @Override
    protected void doFinish() throws PDIException {
        this.notifyWaiting();
    }

    protected boolean findResult(BitList qTasks) {
        return this.results.containsKey(qTasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockRequest(long timeout) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait(timeout);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseRequest() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    protected abstract void storeResult(BitList var1, Object var2);

    protected void storeUnknownResult(BitList rTasks, Object result) {
        this.results.put(rTasks, result);
    }

    protected void waiting() {
        while (!(this.tasks.isEmpty() || this.status != 5 && this.status != 2)) {
            this.lockRequest(this.DEFAULT_TIMEOUT);
        }
    }
}

