/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.ptp.core.util.BitList;
import org.eclipse.ptp.debug.core.IPMemoryManager;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.model.IPDebugTarget;
import org.eclipse.ptp.debug.core.model.IPValue;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.IPDISessionObject;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.event.IPDIChangedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEventListener;
import org.eclipse.ptp.debug.core.pdi.event.IPDIMemoryBlockInfo;
import org.eclipse.ptp.debug.core.pdi.event.IPDIRestartedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIResumedEvent;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFException;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeArray;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypePointer;
import org.eclipse.ptp.debug.core.pdi.model.aif.ITypeIntegral;
import org.eclipse.ptp.debug.internal.core.InternalDebugCoreMessages;
import org.eclipse.ptp.debug.internal.core.model.PDebugTarget;
import org.eclipse.ptp.debug.internal.core.model.PExpression;
import org.eclipse.ptp.debug.internal.core.model.PMemoryBlockExtension;
import org.eclipse.ptp.debug.internal.core.model.PStackFrame;
import org.eclipse.ptp.debug.internal.core.model.PThread;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PMemoryManager
implements IAdaptable,
IPDIEventListener,
IPMemoryManager {
    private static final String MEMORY_BLOCK_EXPRESSION_LIST = "memoryBlockExpressionList";
    private static final String MEMORY_BLOCK_EXPRESSION_ITEM = "memoryBlockExpressionItem";
    private static final String MEMORY_BLOCK_EXPRESSION = "expression";
    private static final String MEMORY_BLOCK_MEMSPACEID = "memorySpaceID";
    private static final String ATTR_MEMORY_BLOCK_MEMSPACEID_TEXT = "text";
    private static final String ATTR_MEMORY_BLOCK_EXPRESSION_TEXT = "text";
    private final IPSession session;
    protected final Map<BitList, PMemoryBlockRetrievalExtension> fMemoryRetrievalMap = new HashMap<BitList, PMemoryBlockRetrievalExtension>();

    public static String addressToString(BigInteger address, String memorySpaceID) {
        return String.valueOf(memorySpaceID) + ":0x" + address.toString(16);
    }

    public static BigInteger stringToAddress(String str, StringBuffer memorySpaceID_out) throws CoreException {
        int index = str.lastIndexOf(58);
        if (index == -1 || str.length() <= index + 3 || str.charAt(index + 1) != '0' || str.charAt(index + 2) != 'x') {
            Status s = new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 1000, InternalDebugCoreMessages.getString("PMemoryBlockRetrievalExtension.5"), null);
            throw new CoreException((IStatus)s);
        }
        memorySpaceID_out.setLength(0);
        memorySpaceID_out.append(str.substring(0, index));
        return new BigInteger(str.substring(index + 3), 16);
    }

    public PMemoryManager(IPSession session) {
        this.session = session;
        session.getPDISession().getEventManager().addEventListener(this);
    }

    public void dispose(BitList qTasks) {
        this.getMemoryRetrieval(qTasks).dispose();
    }

    public void dispose(IProgressMonitor monitor) {
        this.fMemoryRetrievalMap.clear();
        this.session.getPDISession().getEventManager().removeEventListener(this);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IPDISession.class)) {
            return this.getSession();
        }
        if (adapter.equals(PMemoryManager.class)) {
            return this;
        }
        return null;
    }

    public IMemoryBlockExtension getExtendedMemoryBlock(BitList qTasks, String expression, Object selected) throws DebugException {
        return this.getMemoryRetrieval(qTasks).getExtendedMemoryBlock(expression, selected);
    }

    public IMemoryBlock getMemoryBlock(BitList qTasks, long startAddress, long length) throws DebugException {
        return this.getMemoryRetrieval(qTasks).getMemoryBlock(startAddress, length);
    }

    public IMemoryBlockExtension getMemoryBlockWithMemorySpaceID(BitList qTasks, String address, String memorySpaceID, Object selected) throws DebugException {
        return this.getMemoryRetrieval(qTasks).getMemoryBlockWithMemorySpaceID(address, memorySpaceID, selected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PMemoryBlockRetrievalExtension getMemoryRetrieval(BitList qTasks) {
        Map<BitList, PMemoryBlockRetrievalExtension> map = this.fMemoryRetrievalMap;
        synchronized (map) {
            PMemoryBlockRetrievalExtension set = this.fMemoryRetrievalMap.get(qTasks);
            if (set == null) {
                set = new PMemoryBlockRetrievalExtension(qTasks, null);
                this.fMemoryRetrievalMap.put(qTasks, set);
            }
            return set;
        }
    }

    public IPSession getSession() {
        return this.session;
    }

    public void handleDebugEvents(IPDIEvent[] events) {
        int i = 0;
        while (i < events.length) {
            IPDIEvent event = events[i];
            if (this.fMemoryRetrievalMap.containsKey(event.getTasks())) {
                if (event instanceof IPDIResumedEvent || event instanceof IPDIRestartedEvent) {
                    this.doResetChange(event);
                } else if (event instanceof IPDIChangedEvent) {
                    this.handleChangedEvent((IPDIChangedEvent)event);
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(BitList qTasks, PDebugTarget debugTarget) {
        Map<BitList, PMemoryBlockRetrievalExtension> map = this.fMemoryRetrievalMap;
        synchronized (map) {
            PMemoryBlockRetrievalExtension set = new PMemoryBlockRetrievalExtension(qTasks, debugTarget);
            this.fMemoryRetrievalMap.put(qTasks, set);
            set.initialize();
        }
    }

    public void initializeFromMemento(BitList qTasks, String memento) throws CoreException {
        this.getMemoryRetrieval(qTasks).initializeFromMemento(memento);
    }

    public void save(BitList qTasks) {
        try {
            String memto = this.getMemoryRetrieval(qTasks).getMemento();
            ILaunchConfiguration config = this.session.getLaunch().getLaunchConfiguration();
            if (config != null) {
                ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                wc.setAttribute("org.eclipse.ptp.launch.MEMORY_BLOCKS", memto);
                wc.doSave();
            }
        }
        catch (CoreException e) {
            PTPDebugCorePlugin.log(e.getStatus());
        }
    }

    public boolean supportsStorageRetrieval(BitList qTasks) {
        return true;
    }

    private void doResetChange(final IPDIEvent event) {
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            public void run() {
                IMemoryBlock[] blocks;
                IPDebugTarget debugTarget = PMemoryManager.this.getMemoryRetrieval(event.getTasks()).getDebugTarget();
                IMemoryBlock[] iMemoryBlockArray = blocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks((IDebugTarget)debugTarget);
                int n = blocks.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemoryBlock block = iMemoryBlockArray[n2];
                    if (block instanceof IMemoryBlockExtension) {
                        ((PMemoryBlockExtension)block).resetChanges();
                    }
                    ++n2;
                }
            }
        });
    }

    private void handleChangedEvent(final IPDIChangedEvent event) {
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            public void run() {
                IPDISessionObject reason = event.getReason();
                if (reason instanceof IPDIMemoryBlockInfo) {
                    IMemoryBlock[] blocks;
                    IPDebugTarget debugTarget = PMemoryManager.this.getMemoryRetrieval(event.getTasks()).getDebugTarget();
                    IMemoryBlock[] iMemoryBlockArray = blocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks((IDebugTarget)debugTarget);
                    int n = blocks.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMemoryBlock block = iMemoryBlockArray[n2];
                        if (block instanceof IMemoryBlockExtension) {
                            ((PMemoryBlockExtension)block).changes(((IPDIMemoryBlockInfo)reason).getMemoryBlock(), ((IPDIMemoryBlockInfo)reason).getAddresses());
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PMemoryBlockRetrievalExtension
    extends PlatformObject
    implements IMemoryBlockRetrievalExtension {
        private IPDebugTarget debugTarget = null;
        private final BitList mTasks;

        public PMemoryBlockRetrievalExtension(BitList mTasks, PDebugTarget debugTarget) {
            this.mTasks = mTasks;
            this.debugTarget = debugTarget;
        }

        public void abort(String message, Throwable e) throws CoreException {
            Status s = new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 1000, message, e);
            throw new CoreException((IStatus)s);
        }

        public void createMemoryBlocks(String[] expressions, String[] memorySpaceIDs) {
            ArrayList<PMemoryBlockExtension> list = new ArrayList<PMemoryBlockExtension>(expressions.length);
            int i = 0;
            while (i < expressions.length) {
                try {
                    BigInteger address = new BigInteger(expressions[i]);
                    if (address != null) {
                        if (memorySpaceIDs[i] == null) {
                            list.add(new PMemoryBlockExtension(PMemoryManager.this.session, this.mTasks, address.toString(16), address));
                        } else {
                            list.add(new PMemoryBlockExtension(PMemoryManager.this.session, this.mTasks, address, memorySpaceIDs[i]));
                        }
                    }
                }
                catch (NumberFormatException exc) {
                    PTPDebugCorePlugin.log(exc);
                }
                ++i;
            }
            DebugPlugin.getDefault().getMemoryBlockManager().addMemoryBlocks(list.toArray(new IMemoryBlock[0]));
        }

        public void dispose() {
        }

        public IPDebugTarget getDebugTarget() {
            if (this.debugTarget == null) {
                this.debugTarget = PMemoryManager.this.session.findDebugTarget(this.mTasks);
            }
            return this.debugTarget;
        }

        /*
         * Unable to fully structure code
         */
        public IMemoryBlockExtension getExtendedMemoryBlock(String expression, Object selected) throws DebugException {
            block16: {
                address = null;
                exp = null;
                msg = null;
                try {
                    if (!(selected instanceof IDebugElement)) break block16;
                    debugElement = (IDebugElement)selected;
                    target = debugElement.getDebugTarget();
                    if (!(target instanceof PDebugTarget)) {
                        throw new DebugException((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 5012, msg, null));
                    }
                    try {
                        var14_10 = new PMemoryBlockExtension(PMemoryManager.access$1(PMemoryManager.this), this.mTasks, expression, new BigInteger(expression, 16));
                        return var14_10;
                    }
                    catch (NumberFormatException v0) {
                        block17: {
                            block18: {
                                frame = this.getStackFrame(debugElement);
                                if (frame == null) break block16;
                                pdiExpression = PMemoryManager.access$1(PMemoryManager.this).getPDISession().getExpressionManager().createExpression(frame.getTasks(), expression);
                                exp = new PExpression(frame, pdiExpression, null);
                                value = exp.getValue();
                                if (!(value instanceof IPValue)) ** GOTO lbl36
                                aif = value.getAIF();
                                if (aif == null || !(aif.getType() instanceof IAIFTypePointer) && !(aif.getType() instanceof ITypeIntegral) && !(aif.getType() instanceof IAIFTypeArray)) break block17;
                                address = aif.getValue().getValueString();
                                if (address == null) break block16;
                                a = address.startsWith("0x") != false ? new BigInteger(address.substring(2), 16) : new BigInteger(address);
                                var14_11 = new PMemoryBlockExtension(PMemoryManager.access$1(PMemoryManager.this), this.mTasks, expression, a);
                                if (exp == null) break block18;
                                exp.dispose();
                            }
                            return var14_11;
                        }
                        try {
                            msg = MessageFormat.format(InternalDebugCoreMessages.getString("PTPMemoryBlockRetrievalExtension.1"), new Object[]{expression});
                            break block16;
lbl36:
                            // 1 sources

                            msg = MessageFormat.format(InternalDebugCoreMessages.getString("PTPMemoryBlockRetrievalExtension.2"), new Object[]{expression});
                        }
                        catch (PDIException pe) {
                            msg = pe.getMessage();
                            if (exp != null) {
                                exp.dispose();
                            }
                        }
                        catch (AIFException e) {
                            msg = e.getMessage();
                        }
                        catch (NumberFormatException v1) {
                            msg = MessageFormat.format(InternalDebugCoreMessages.getString("PTPMemoryBlockRetrievalExtension.0"), new Object[]{expression, address});
                            break block16;
                            {
                                catch (Throwable var13_17) {
                                    throw var13_17;
                                }
                            }
                        }
                    }
                }
                finally {
                    if (exp != null) {
                        exp.dispose();
                    }
                }
            }
            throw new DebugException((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 5012, msg, null));
        }

        public String getMemento() throws CoreException {
            IMemoryBlock[] blocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks((IDebugTarget)this.getDebugTarget());
            Document document = DebugPlugin.newDocument();
            Element exprList = document.createElement(PMemoryManager.MEMORY_BLOCK_EXPRESSION_LIST);
            int i = 0;
            while (i < blocks.length) {
                if (blocks[i] instanceof IMemoryBlockExtension) {
                    IMemoryBlockExtension memBlockExt = (IMemoryBlockExtension)blocks[i];
                    Element exprItem = document.createElement(PMemoryManager.MEMORY_BLOCK_EXPRESSION_ITEM);
                    exprList.appendChild(exprItem);
                    BigInteger addrBigInt = null;
                    String memorySpaceID = null;
                    if (this.hasMemorySpaces()) {
                        try {
                            StringBuffer sbuf = new StringBuffer();
                            addrBigInt = PMemoryManager.stringToAddress(memBlockExt.getExpression(), sbuf);
                            memorySpaceID = sbuf.toString();
                        }
                        catch (CoreException coreException) {}
                    }
                    Element child = document.createElement(PMemoryManager.MEMORY_BLOCK_EXPRESSION);
                    try {
                        if (addrBigInt != null && memorySpaceID != null) {
                            child.setAttribute("text", addrBigInt.toString());
                        } else {
                            child.setAttribute("text", memBlockExt.getBigBaseAddress().toString());
                        }
                        exprItem.appendChild(child);
                    }
                    catch (DebugException e) {
                        PTPDebugCorePlugin.log(e.getStatus());
                    }
                    if (memorySpaceID != null) {
                        child = document.createElement(PMemoryManager.MEMORY_BLOCK_MEMSPACEID);
                        child.setAttribute("text", memorySpaceID);
                        exprItem.appendChild(child);
                    }
                }
                ++i;
            }
            document.appendChild(exprList);
            return DebugPlugin.serializeDocument((Document)document);
        }

        public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
            String expression = Long.toHexString(startAddress);
            BigInteger address = new BigInteger(expression, 16);
            expression = String.valueOf(expression) + "0x";
            return new PMemoryBlockExtension(PMemoryManager.this.session, this.mTasks, expression, address);
        }

        public IMemoryBlockExtension getMemoryBlockWithMemorySpaceID(String address, String memorySpaceID, Object selected) throws DebugException {
            String msg = null;
            try {
                IDebugElement debugElement;
                IDebugTarget target;
                if (selected instanceof IDebugElement && (target = (debugElement = (IDebugElement)selected).getDebugTarget()) instanceof PDebugTarget && address != null) {
                    BigInteger addr = address.startsWith("0x") ? new BigInteger(address.substring(2), 16) : new BigInteger(address);
                    return new PMemoryBlockExtension(PMemoryManager.this.session, this.mTasks, addr, memorySpaceID);
                }
            }
            catch (NumberFormatException numberFormatException) {
                msg = MessageFormat.format(InternalDebugCoreMessages.getString("PMemoryBlockRetrievalExtension.4"), address);
            }
            throw new DebugException((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), 5012, msg, null));
        }

        public String[] getMemorySpaces() {
            return new String[0];
        }

        public PStackFrame getStackFrame(IDebugElement selected) throws DebugException {
            IStackFrame frame;
            if (selected instanceof PStackFrame) {
                return (PStackFrame)selected;
            }
            if (selected instanceof PThread && (frame = ((PThread)selected).getTopStackFrame()) instanceof PStackFrame) {
                return (PStackFrame)frame;
            }
            return null;
        }

        public boolean hasMemorySpaces() {
            return this.getMemorySpaces().length > 0;
        }

        public void initialize() {
            ILaunchConfiguration config = PMemoryManager.this.session.getLaunch().getLaunchConfiguration();
            try {
                String memento = config.getAttribute("org.eclipse.ptp.launch.MEMORY_BLOCKS", "");
                if (memento != null && memento.trim().length() != 0) {
                    this.initializeFromMemento(memento);
                }
            }
            catch (CoreException e) {
                PTPDebugCorePlugin.log(e);
            }
        }

        public void initializeFromMemento(String memento) throws CoreException {
            Element root = DebugPlugin.parseDocument((String)memento);
            if (root.getNodeName().equalsIgnoreCase(PMemoryManager.MEMORY_BLOCK_EXPRESSION_LIST)) {
                ArrayList<String> expressions = new ArrayList<String>();
                ArrayList<String> memorySpaceIDs = new ArrayList<String>();
                NodeList list = root.getChildNodes();
                int length = list.getLength();
                int i = 0;
                while (i < length) {
                    Element entry;
                    Node node = list.item(i);
                    if (node.getNodeType() == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase(PMemoryManager.MEMORY_BLOCK_EXPRESSION)) {
                        this.parseMementoExprItem(entry, expressions, memorySpaceIDs);
                    }
                    ++i;
                }
                this.createMemoryBlocks(expressions.toArray(new String[0]), memorySpaceIDs.toArray(new String[0]));
                return;
            }
            this.abort(InternalDebugCoreMessages.getString("PTPMemoryBlockRetrievalExtension.3"), null);
        }

        public void parseMementoExprItem(Element element, List<String> expressions, List<String> memorySpaceIDs) {
            NodeList list = element.getChildNodes();
            int length = list.getLength();
            String exp = null;
            String memorySpaceID = null;
            int i = 0;
            while (i < length) {
                Node node = list.item(i);
                if (node.getNodeType() == 1) {
                    Element entry = (Element)node;
                    if (entry.getNodeName().equalsIgnoreCase(PMemoryManager.MEMORY_BLOCK_EXPRESSION)) {
                        exp = entry.getAttribute("text");
                    } else if (entry.getNodeName().equalsIgnoreCase(PMemoryManager.MEMORY_BLOCK_MEMSPACEID)) {
                        memorySpaceID = entry.getAttribute("text");
                    }
                }
                ++i;
            }
            if (exp != null) {
                expressions.add(exp);
                memorySpaceIDs.add(memorySpaceID);
            }
        }

        public boolean supportsStorageRetrieval() {
            return true;
        }
    }
}

