/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.ptp.debug.core.IPDebugConstants;
import org.eclipse.ptp.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.debug.core.model.IPStackFrame;
import org.eclipse.ptp.debug.core.model.IPValue;
import org.eclipse.ptp.debug.core.model.PVariableFormat;
import org.eclipse.ptp.debug.core.pdi.IPDISessionObject;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.event.IPDIChangedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIResumedEvent;
import org.eclipse.ptp.debug.core.pdi.event.IPDIVariableInfo;
import org.eclipse.ptp.debug.core.pdi.model.IPDITargetExpression;
import org.eclipse.ptp.debug.core.pdi.model.IPDIVariable;
import org.eclipse.ptp.debug.core.pdi.model.IPDIVariableDescriptor;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIF;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeArray;
import org.eclipse.ptp.debug.internal.core.model.AbstractPValue;
import org.eclipse.ptp.debug.internal.core.model.PLocalVariable;
import org.eclipse.ptp.debug.internal.core.model.PStackFrame;
import org.eclipse.ptp.debug.internal.core.model.PValueFactory;

public class PExpression
extends PLocalVariable
implements IExpression {
    private String fText;
    private IPDITargetExpression fPDIExpression;
    private PStackFrame fStackFrame;
    private IPValue fValue = PValueFactory.NULL_VALUE;

    public PExpression(PStackFrame frame, IPDITargetExpression pdiExpression, IPDIVariableDescriptor varObject) {
        super(frame, varObject);
        this.setFormat(PVariableFormat.getFormat(PTPDebugCorePlugin.getDefault().getPluginPreferences().getInt(IPDebugConstants.PREF_DEFAULT_EXPRESSION_FORMAT)));
        this.fText = pdiExpression.getExpressionText();
        this.fPDIExpression = pdiExpression;
        this.fStackFrame = frame;
    }

    public String getExpressionText() {
        return this.fText;
    }

    public void handleDebugEvents(IPDIEvent[] events) {
        int i = 0;
        while (i < events.length) {
            IPDIEvent event = events[i];
            if (event.contains(this.getTasks())) {
                IPDISessionObject reason;
                if (event instanceof IPDIResumedEvent) {
                    this.setChanged(false);
                    this.resetValue();
                } else if (event instanceof IPDIChangedEvent && (reason = ((IPDIChangedEvent)event).getReason()) instanceof IPDIVariableInfo) {
                    this.setChanged(false);
                    this.resetValue();
                }
            }
            ++i;
        }
        super.handleDebugEvents(events);
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean canEnableDisable() {
        return true;
    }

    protected boolean isBookkeepingEnabled() {
        return false;
    }

    public IPValue getValue() {
        PStackFrame frame = (PStackFrame)this.getStackFrame();
        try {
            return this.getValue(frame);
        }
        catch (DebugException debugException) {
            return null;
        }
    }

    protected synchronized IPValue getValue(PStackFrame frame) throws DebugException {
        if (this.fValue.equals(PValueFactory.NULL_VALUE) && frame.isSuspended()) {
            try {
                IPDIVariable variable = this.fPDIExpression.getVariable(frame.getPDIStackFrame());
                if (variable != null) {
                    IAIF aif = variable.getAIF();
                    if (aif != null && aif.getType() instanceof IAIFTypeArray) {
                        int[] dims = ((IAIFTypeArray)aif.getType()).getDimensionDetails();
                        if (dims.length > 0 && dims[0] > 0) {
                            this.fValue = PValueFactory.createIndexedValue(this, variable, 0, dims[0]);
                        }
                    } else {
                        this.fValue = PValueFactory.createValue(this, variable);
                    }
                }
            }
            catch (PDIException e) {
                PExpression.targetRequestFailed(e.getMessage(), null);
            }
        }
        return this.fValue;
    }

    protected IPStackFrame getStackFrame() {
        return this.fStackFrame;
    }

    protected void resetValue() {
        if (this.fValue instanceof AbstractPValue) {
            ((AbstractPValue)this.fValue).reset();
        }
        this.fValue = PValueFactory.NULL_VALUE;
    }

    public String getExpressionString() throws DebugException {
        return this.getExpressionText();
    }

    public void dispose() {
        if (this.fPDIExpression != null) {
            try {
                this.fPDIExpression.dispose();
                this.fPDIExpression = null;
            }
            catch (PDIException pDIException) {}
        }
        if (this.fValue instanceof AbstractPValue) {
            ((AbstractPValue)this.fValue).dispose();
            this.fValue = PValueFactory.NULL_VALUE;
        }
        this.internalDispose(true);
        this.setDisposed(true);
    }
}

