/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi.aif;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFType;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeEnum;
import org.eclipse.ptp.debug.internal.core.pdi.aif.TypeIntegral;

public class AIFTypeEnum
extends TypeIntegral
implements IAIFTypeEnum {
    private List<String> fields = new ArrayList<String>();
    private List<String> values = new ArrayList<String>();
    private IAIFType basetype;
    private String name;

    public AIFTypeEnum(String format, IAIFType basetype) {
        this(format, true, basetype);
    }

    public AIFTypeEnum(String format, boolean signed, IAIFType basetype) {
        super(signed);
        this.basetype = basetype;
        this.parse(format);
    }

    public IAIFType getBaseType() {
        return this.basetype;
    }

    public int sizeof() {
        return this.getNumberOfChildren() * this.basetype.sizeof();
    }

    protected void parse(String fmt) {
        if ((fmt = this.parseName(fmt)).length() > 0) {
            String[] pairs = fmt.split(",");
            int i = 0;
            while (i < pairs.length) {
                String[] results = pairs[i].split("=");
                this.fields.add(results[0]);
                this.values.add(results[1]);
                ++i;
            }
        }
    }

    protected String parseName(String fmt) {
        int pos = fmt.indexOf("|");
        this.name = fmt.substring(0, pos);
        int last_pos = fmt.lastIndexOf(">");
        if (last_pos == -1) {
            return "";
        }
        return fmt.substring(pos + 1, last_pos);
    }

    public String getName() {
        return this.name;
    }

    public String[] getFields() {
        return this.fields.toArray(new String[0]);
    }

    public String[] getTypes() {
        return this.values.toArray(new String[0]);
    }

    public String getField(int index) {
        return this.fields.get(index);
    }

    public String getValue(int index) {
        return this.values.get(index);
    }

    public int getNumberOfChildren() {
        return this.fields.size();
    }

    public String toString() {
        String content = "<" + this.getName() + "|";
        int i = 0;
        while (i < this.fields.size()) {
            content = String.valueOf(content) + this.fields.get(i) + "=" + this.values.get(i);
            if (i < this.fields.size() - 1) {
                content = String.valueOf(content) + ",";
            }
            ++i;
        }
        return String.valueOf(content) + ">" + super.toString();
    }
}

