/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi.aif;

import org.eclipse.ptp.debug.core.pdi.model.aif.AIFException;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFFactory;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFType;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeArray;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValue;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValueArray;
import org.eclipse.ptp.debug.core.pdi.model.aif.IValueParent;
import org.eclipse.ptp.debug.internal.core.pdi.aif.ValueDerived;

public class AIFValueArray
extends ValueDerived
implements IAIFValueArray {
    IAIFValue[] values = new IAIFValue[0];
    AIFFactory.SimpleByteBuffer buffer = null;

    public AIFValueArray(IAIFTypeArray type, AIFFactory.SimpleByteBuffer buffer) {
        super(type);
        this.buffer = buffer;
    }

    protected void parse(AIFFactory.SimpleByteBuffer buffer) {
        IAIFTypeArray arrType = (IAIFTypeArray)this.type;
        IAIFType baseType = arrType.getBaseType();
        this.values = new IAIFValue[arrType.getRange()];
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = AIFFactory.getAIFValue((IValueParent)this, baseType, buffer);
            this.size += this.values[i].sizeof();
            ++i;
        }
    }

    public IAIFValue[] getValues() {
        if (this.values.length == 0 && this.buffer != null) {
            this.parse(this.buffer);
            this.buffer = null;
        }
        return this.values;
    }

    public String getValueString() throws AIFException {
        if (this.result == null) {
            this.result = this.getString();
        }
        return this.result;
    }

    private String getString() throws AIFException {
        String content = "[";
        IAIFValue[] aifValues = this.getValues();
        int i = 0;
        while (i < aifValues.length) {
            content = String.valueOf(content) + aifValues[i].getValueString();
            if (i < aifValues.length - 1) {
                content = String.valueOf(content) + ",";
            }
            ++i;
        }
        content = String.valueOf(content) + "]";
        return content;
    }
}

