/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.debug.internal.core.pdi.aif;

import org.eclipse.ptp.debug.core.pdi.model.aif.AIFException;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFFactory;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeString;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFValueString;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFTypeString;
import org.eclipse.ptp.debug.internal.core.pdi.aif.AIFValue;

public class AIFValueString
extends AIFValue
implements IAIFValueString {
    public AIFValueString(IAIFTypeString type, AIFFactory.SimpleByteBuffer buffer) {
        super(type);
        this.parse(buffer);
        ((AIFTypeString)type).size = this.size;
    }

    protected void parse(AIFFactory.SimpleByteBuffer buffer) {
        this.size = this.getSize(buffer);
        byte[] bytes = new byte[this.size];
        int i = 0;
        while (i < this.size) {
            bytes[i] = buffer.get();
            ++i;
        }
        this.result = new String(bytes);
    }

    public int getSize(AIFFactory.SimpleByteBuffer buffer) {
        String hex = "";
        int i = 0;
        while (i < 2) {
            hex = String.valueOf(hex) + Integer.toHexString(256 + (buffer.get() & 0xFF)).substring(1);
            ++i;
        }
        try {
            return Integer.parseInt(hex, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return 1;
        }
    }

    public String getValueString() throws AIFException {
        if (this.result == null) {
            this.result = "";
        }
        return this.result;
    }

    public static void main(String[] args) {
        int length = 30;
        byte[] bytes = new byte[]{(byte)(length >> 8 & 0xFF), (byte)(length & 0xFF)};
        System.err.println("---- bytes: " + bytes);
        String hex = "";
        int i = 0;
        while (i < 2) {
            hex = String.valueOf(hex) + Integer.toHexString(256 + (bytes[i] & 0xFF));
            System.err.println("hex: " + hex);
            ++i;
        }
        int test = 0;
        try {
            test = Integer.parseInt(hex, 16);
        }
        catch (NumberFormatException numberFormatException) {
            test = -1;
        }
        System.out.println("---- test: " + test);
    }
}

