/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.index;

import org.eclipse.cdt.core.dom.IPDOMIndexerTask;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.pdom.indexer.AbstractPDOMIndexer;
import org.eclipse.cdt.internal.core.pdom.indexer.PDOMRebuildTask;
import org.eclipse.ptp.internal.rdt.core.index.RemoteIndexerTask;
import org.eclipse.ptp.rdt.core.serviceproviders.IIndexServiceProvider;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.ServiceModelManager;

public class RemoteFastIndexer
extends AbstractPDOMIndexer {
    public static final String ID = "org.eclipse.ptp.rdt.core.RemoteFastIndexer";

    public IPDOMIndexerTask createTask(ITranslationUnit[] added, ITranslationUnit[] changed, ITranslationUnit[] removed) {
        IService indexingService;
        ServiceModelManager smm = ServiceModelManager.getInstance();
        IServiceConfiguration serviceConfig = smm.getActiveConfiguration(this.getProject().getProject());
        IServiceProvider serviceProvider = serviceConfig.getServiceProvider(indexingService = smm.getService("org.eclipse.ptp.rdt.core.CIndexingService"));
        if (serviceProvider instanceof IIndexServiceProvider) {
            boolean update = !this.isReindex();
            return new RemoteIndexerTask(this, (IIndexServiceProvider)serviceProvider, added, changed, removed, update);
        }
        return null;
    }

    private boolean isReindex() {
        StackTraceElement[] stackTrace;
        String pdomRebuildTask = PDOMRebuildTask.class.getName();
        StackTraceElement[] stackTraceElementArray = stackTrace = Thread.currentThread().getStackTrace();
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement frame = stackTraceElementArray[n2];
            if (frame.getClassName().equals(pdomRebuildTask)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getID() {
        return ID;
    }
}

