/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.model;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IField;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.IStructureDeclaration;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.ptp.internal.rdt.core.model.Parent;
import org.eclipse.ptp.internal.rdt.core.model.StructureDeclaration;

public class Structure
extends StructureDeclaration
implements IStructure {
    private static final long serialVersionUID = 1L;
    protected List<SuperClassInfo> fSuperClasses = new LinkedList<SuperClassInfo>();

    public Structure(Parent parent, int kind, String className) {
        super(parent, className, kind);
    }

    public Structure(Parent parent, IStructure element) throws CModelException {
        super(parent, (IStructureDeclaration)element);
        String[] stringArray = element.getSuperClassesNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String superClass = stringArray[n2];
            this.addSuperClass(superClass, element.getSuperClassAccess(superClass));
            ++n2;
        }
    }

    public Structure(Parent parent, ICompositeType binding) throws DOMException {
        super(parent, Structure.adaptASTClassType(binding), binding);
    }

    protected Structure(Parent parent, int type, ICompositeType binding) {
        super(parent, type, binding);
    }

    static int adaptASTClassType(ICompositeType type) throws DOMException {
        switch (type.getKey()) {
            case 1: {
                return 67;
            }
            case 2: {
                return 69;
            }
        }
        return 65;
    }

    public IField getField(String name) {
        return null;
    }

    public IField[] getFields() throws CModelException {
        return null;
    }

    public IMethodDeclaration getMethod(String name) {
        return null;
    }

    public IMethodDeclaration[] getMethods() throws CModelException {
        return null;
    }

    public boolean isAbstract() throws CModelException {
        return false;
    }

    public ASTAccessVisibility getSuperClassAccess(String name) {
        for (SuperClassInfo info : this.fSuperClasses) {
            if (!info.name.equals(name)) continue;
            return info.visibility;
        }
        return null;
    }

    public String[] getSuperClassesNames() {
        String[] names = new String[this.fSuperClasses.size()];
        int i = 0;
        while (i < this.fSuperClasses.size()) {
            names[i] = this.fSuperClasses.get((int)i).name;
            ++i;
        }
        return names;
    }

    public void addSuperClass(String simpleName, ASTAccessVisibility visibility) {
        this.fSuperClasses.add(new SuperClassInfo(simpleName, visibility));
    }

    private static class SuperClassInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String name;
        public ASTAccessVisibility visibility;

        public SuperClassInfo(String name, ASTAccessVisibility visibility) {
            this.name = name;
            this.visibility = visibility;
        }
    }
}

