/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;

public class JAXBException
extends EclipseLinkException {
    public static final int NO_OBJECT_FACTORY_OR_JAXB_INDEX_IN_PATH = 50000;
    public static final int FACTORY_METHOD_OR_ZERO_ARG_CONST_REQ = 50001;
    public static final int FACTORY_CLASS_WITHOUT_FACTORY_METHOD = 50002;
    public static final int FACTORY_METHOD_NOT_DECLARED = 50003;
    public static final int ANY_ATTRIBUTE_ON_NON_MAP_PROPERTY = 50004;
    public static final int MULTIPLE_ANY_ATTRIBUTE_MAPPING = 50005;
    public static final int INVALID_XML_ELEMENT_REF = 50006;
    public static final int NAME_COLLISION = 50007;
    public static final int UNSUPPORTED_NODE_CLASS = 50008;
    public static final int TRANSIENT_IN_PROP_ORDER = 50009;
    public static final int XMLVALUE_ATTRIBUTE_CONFLICT = 50010;
    public static final int SUBCLASS_CANNOT_HAVE_XMLVALUE = 50011;
    public static final int NON_EXISTENT_PROPERTY_IN_PROP_ORDER = 50012;
    public static final int MISSING_PROPERTY_IN_PROP_ORDER = 50013;
    public static final int INVALID_TYPE_FOR_XMLVALUE_PROPERTY = 50014;
    public static final int INVALID_XML_ELEMENT_WRAPPER = 50015;
    public static final int INVALID_ID = 50016;
    public static final int INVALID_IDREF = 50017;
    public static final int INVALID_LIST = 50018;
    public static final int VALUE_PARAMETER_TYPE_INCORRECT_FOR_OXM_XML = 50019;
    public static final int KEY_PARAMETER_TYPE_INCORRECT = 50021;
    public static final int VALUE_PARAMETER_TYPE_INCORRECT = 50022;
    public static final int NULL_METADATA_SOURCE = 50023;
    public static final int NULL_MAP_KEY = 50024;
    public static final int COULD_NOT_LOAD_CLASS_FROM_METADATA = 50025;
    public static final int COULD_NOT_CREATE_CONTEXT_FOR_XML_MODEL = 50026;
    public static final int COULD_NOT_UNMARSHAL_METADATA = 50027;
    public static final int COULD_NOT_CREATE_CUSTOMIZER_INSTANCE = 50028;
    public static final int INVALID_CUSTOMIZER_CLASS = 50029;
    public static final int ID_ALREADY_SET = 50030;
    public static final int XMLVALUE_ALREADY_SET = 50031;
    public static final int XMLANYELEMENT_ALREADY_SET = 50032;
    public static final int COULD_NOT_INITIALIZE_DOM_HANDLER_CONVERTER = 50033;
    public static final int INVALID_TYPE_FOR_XMLATTRIBUTEREF_PROPERTY = 50034;
    public static final int INVALID_XMLELEMENT_IN_XMLELEMENTS = 50035;
    public static final int NULL_TYPE_ON_TYPEMAPPINGINFO = 50036;
    public static final int JAVATYPE_NOT_ALLOWED_IN_BINDINGS_FILE = 50037;
    public static final int CANNOT_CREATE_DYNAMIC_CONTEXT_FROM_CLASSES = 50038;

    protected JAXBException(String message) {
        super(message);
    }

    protected JAXBException(String message, Exception internalException) {
        super(message, internalException);
    }

    public static JAXBException noObjectFactoryOrJaxbIndexInPath(String path) {
        Object[] args = new Object[]{path};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50000, args));
        exception.setErrorCode(50000);
        return exception;
    }

    public static JAXBException factoryMethodOrConstructorRequired(String className) {
        Object[] args = new Object[]{className};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50001, args));
        exception.setErrorCode(50001);
        return exception;
    }

    public static JAXBException factoryClassWithoutFactoryMethod(String className) {
        Object[] args = new Object[]{className};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50002, args));
        exception.setErrorCode(50002);
        return exception;
    }

    public static JAXBException factoryMethodNotDeclared(String methodName, String className) {
        Object[] args = new Object[]{methodName, className};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50003, args));
        exception.setErrorCode(50003);
        return exception;
    }

    public static JAXBException multipleAnyAttributeMapping(String className) {
        Object[] args = new Object[]{className};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50005, args));
        exception.setErrorCode(50005);
        return exception;
    }

    public static JAXBException anyAttributeOnNonMap(String propertyName) {
        Object[] args = new Object[]{propertyName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50004, args));
        exception.setErrorCode(50004);
        return exception;
    }

    public static JAXBException invalidElementRef(String propertyName, String className) {
        Object[] args = new Object[]{propertyName, className};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50006, args));
        exception.setErrorCode(50006);
        return exception;
    }

    public static JAXBException invalidElementWrapper(String propertyName) {
        Object[] args = new Object[]{propertyName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50015, args));
        exception.setErrorCode(50015);
        return exception;
    }

    public static JAXBException invalidId(String propertyName) {
        Object[] args = new Object[]{propertyName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50016, args));
        exception.setErrorCode(50016);
        return exception;
    }

    public static JAXBException invalidIdRef(String propertyName, String className) {
        Object[] args = new Object[]{propertyName, className};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50017, args));
        exception.setErrorCode(50017);
        return exception;
    }

    public static JAXBException invalidList(String propertyName) {
        Object[] args = new Object[]{propertyName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50018, args));
        exception.setErrorCode(50018);
        return exception;
    }

    public static JAXBException nameCollision(String uri, String name) {
        Object[] args = new Object[]{uri, name};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50007, args));
        exception.setErrorCode(50007);
        return exception;
    }

    public static JAXBException unsupportedNodeClass(String className) {
        Object[] args = new Object[]{className};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50008, args));
        exception.setErrorCode(50008);
        return exception;
    }

    public static JAXBException transientInProporder(String fieldName) {
        Object[] args = new Object[]{fieldName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50009, args));
        exception.setErrorCode(50009);
        return exception;
    }

    public static JAXBException nonExistentPropertyInPropOrder(String fieldName) {
        Object[] args = new Object[]{fieldName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50012, args));
        exception.setErrorCode(50012);
        return exception;
    }

    public static JAXBException missingPropertyInPropOrder(String fieldName) {
        Object[] args = new Object[]{fieldName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50013, args));
        exception.setErrorCode(50013);
        return exception;
    }

    public static JAXBException propertyOrFieldShouldBeAnAttribute(String fieldName) {
        Object[] args = new Object[]{fieldName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50010, args));
        exception.setErrorCode(50010);
        return exception;
    }

    public static JAXBException propertyOrFieldCannotBeXmlValue(String fieldName) {
        Object[] args = new Object[]{fieldName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50011, args));
        exception.setErrorCode(50011);
        return exception;
    }

    public static JAXBException invalidTypeForXmlValueField(String fieldName) {
        Object[] args = new Object[]{fieldName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50014, args));
        exception.setErrorCode(50014);
        return exception;
    }

    public static JAXBException incorrectKeyParameterType() {
        Object[] args = new Object[]{};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50021, args));
        exception.setErrorCode(50021);
        return exception;
    }

    public static JAXBException incorrectValueParameterType() {
        Object[] args = new Object[]{};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50022, args));
        exception.setErrorCode(50022);
        return exception;
    }

    public static JAXBException incorrectValueParameterTypeForOxmXmlKey() {
        Object[] args = new Object[]{};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50019, args));
        exception.setErrorCode(50019);
        return exception;
    }

    public static JAXBException nullMetadataSource(String key) {
        Object[] args = new Object[]{key};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50023, args));
        exception.setErrorCode(50023);
        return exception;
    }

    public static JAXBException nullMapKey() {
        Object[] args = new Object[]{};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50024, args));
        exception.setErrorCode(50024);
        return exception;
    }

    public static JAXBException couldNotLoadClassFromMetadata(String classname) {
        Object[] args = new Object[]{classname};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50025, args));
        exception.setErrorCode(50025);
        return exception;
    }

    public static JAXBException couldNotCreateContextForXmlModel() {
        Object[] args = new Object[]{};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50026, args));
        exception.setErrorCode(50026);
        return exception;
    }

    public static JAXBException couldNotCreateContextForXmlModel(Exception ex) {
        Object[] args = new Object[]{ex};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50026, args), ex);
        exception.setErrorCode(50026);
        return exception;
    }

    public static JAXBException couldNotUnmarshalMetadata(Exception e) {
        Object[] args = new Object[]{};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50027, args), e);
        exception.setErrorCode(50027);
        return exception;
    }

    public static JAXBException couldNotCreateCustomizerInstance(Exception e, String customizerClassName) {
        Object[] args = new Object[]{customizerClassName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50028, args), e);
        exception.setErrorCode(50028);
        return exception;
    }

    public static JAXBException invalidCustomizerClass(Exception e, String customizerClassName) {
        Object[] args = new Object[]{customizerClassName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50029, args), e);
        exception.setErrorCode(50029);
        return exception;
    }

    public static JAXBException idAlreadySet(String propertyName, String idPropertyName, String className) {
        Object[] args = new Object[]{propertyName, className, idPropertyName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50030, args));
        exception.setErrorCode(50030);
        return exception;
    }

    public static JAXBException xmlValueAlreadySet(String propertyName, String xmlValuePropertyName, String className) {
        Object[] args = new Object[]{className, propertyName, xmlValuePropertyName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50031, args));
        exception.setErrorCode(50031);
        return exception;
    }

    public static JAXBException xmlAnyElementAlreadySet(String propertyName, String xmlAnyElementPropertyName, String className) {
        Object[] args = new Object[]{className, propertyName, xmlAnyElementPropertyName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50032, args));
        exception.setErrorCode(50032);
        return exception;
    }

    public static JAXBException couldNotInitializeDomHandlerConverter(Exception nestedException, String domHandlerClassName, String propertyName) {
        Object[] args = new Object[]{domHandlerClassName, propertyName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50033, args), nestedException);
        exception.setErrorCode(50033);
        return exception;
    }

    public static JAXBException invalidAttributeRef(String propertyName, String className) {
        Object[] args = new Object[]{propertyName, className};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50034, args));
        exception.setErrorCode(50034);
        return exception;
    }

    public static JAXBException invalidXmlElementInXmlElementsList(String propertyName, String elementName) {
        Object[] args = new Object[]{propertyName, elementName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50035, args));
        exception.setErrorCode(50035);
        return exception;
    }

    public static JAXBException nullTypeOnTypeMappingInfo(QName tagName) {
        Object[] args = new Object[]{tagName};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50036, args));
        exception.setErrorCode(50036);
        return exception;
    }

    public static JAXBException javaTypeNotAllowedInBindingsFile(String javaTypePackage, String bindingsPackage) {
        Object[] args = new Object[]{javaTypePackage, bindingsPackage};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50037, args));
        exception.setErrorCode(50037);
        return exception;
    }

    public static JAXBException cannotCreateDynamicContextFromClasses() {
        Object[] args = new Object[]{};
        JAXBException exception = new JAXBException(ExceptionMessageGenerator.buildMessage(JAXBException.class, 50038, args));
        exception.setErrorCode(50038);
        return exception;
    }
}

