/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.indirection;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeTracker;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.changetracking.AttributeChangeListener;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.indirection.UnitOfWorkQueryValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.mappings.CollectionMapping;

public class IndirectList
extends Vector
implements CollectionChangeTracker,
IndirectCollection {
    protected volatile Vector delegate;
    protected ValueHolderInterface valueHolder;
    private transient PropertyChangeListener changeListener;
    private transient String attributeName;
    private transient List addedElements;
    private transient List removedElements;
    protected int initialCapacity;
    protected boolean isRegistered;
    private boolean isListOrderBrokenInDb;

    public IndirectList() {
        this(10);
    }

    public IndirectList(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public IndirectList(int initialCapacity, int capacityIncrement) {
        super(0);
        this.initialCapacity = initialCapacity;
        this.capacityIncrement = capacityIncrement;
    }

    public IndirectList(Collection collection) {
        super(0);
        this.valueHolder = new ValueHolder(new Vector(collection));
    }

    public void add(int index, Object element) {
        this.getDelegate().add(index, element);
        this.raiseAddChangeEvent(element, index);
    }

    protected void raiseAddChangeEvent(Object element, Integer index) {
        this.raiseAddChangeEvent(element, index, false);
    }

    protected void raiseAddChangeEvent(Object element, Integer index, boolean isSet) {
        if (this.hasTrackedPropertyChangeListener()) {
            this._persistence_getPropertyChangeListener().propertyChange(new CollectionChangeEvent(this, this.getTrackedAttributeName(), this, element, CollectionChangeEvent.ADD, index, isSet));
        }
        if (this.hasBeenRegistered()) {
            ((UnitOfWorkQueryValueHolder)this.getValueHolder()).updateForeignReferenceSet(element, null);
        }
    }

    protected void raiseRemoveChangeEvent(Object element, Integer index) {
        this.raiseRemoveChangeEvent(element, index, false);
    }

    protected void raiseRemoveChangeEvent(Object element, Integer index, boolean isSet) {
        if (this.hasTrackedPropertyChangeListener()) {
            this._persistence_getPropertyChangeListener().propertyChange(new CollectionChangeEvent(this, this.getTrackedAttributeName(), this, element, CollectionChangeEvent.REMOVE, index, isSet));
        }
        if (this.hasBeenRegistered()) {
            ((UnitOfWorkQueryValueHolder)this.getValueHolder()).updateForeignReferenceRemove(element);
        }
    }

    public boolean add(Object element) {
        if (!this.isRegistered) {
            return this.getDelegate().add(element);
        }
        boolean added = true;
        if (this.shouldAvoidInstantiation()) {
            if (this.hasRemovedElements() && this.getRemovedElements().contains(element)) {
                this.getRemovedElements().remove(element);
            } else {
                if (this.getAddedElements().contains(element)) {
                    return false;
                }
                this.getAddedElements().add(element);
            }
        } else {
            added = this.getDelegate().add(element);
        }
        this.raiseAddChangeEvent(element, null);
        return added;
    }

    public boolean addAll(int index, Collection c) {
        Iterator objects = c.iterator();
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            while (objects.hasNext()) {
                this.add(index, objects.next());
                ++index;
            }
            return true;
        }
        return this.getDelegate().addAll(index, c);
    }

    public boolean addAll(Collection c) {
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            Iterator objects = c.iterator();
            while (objects.hasNext()) {
                this.add(objects.next());
            }
            return true;
        }
        return this.getDelegate().addAll(c);
    }

    public void addElement(Object obj) {
        this.add(obj);
    }

    protected Vector buildDelegate() {
        int index;
        int size;
        Vector delegate = (Vector)this.getValueHolder().getValue();
        if (delegate == null) {
            delegate = new Vector(this.initialCapacity, this.capacityIncrement);
        }
        while (delegate instanceof IndirectList) {
            if (((IndirectList)delegate).isListOrderBrokenInDb()) {
                this.isListOrderBrokenInDb = true;
            }
            delegate = ((IndirectList)delegate).getDelegate();
        }
        if (this.hasAddedElements()) {
            size = this.getAddedElements().size();
            for (index = 0; index < size; ++index) {
                Object element = ((List)this.getAddedElements()).get(index);
                if (delegate.contains(element)) continue;
                delegate.add(element);
            }
            this.addedElements = null;
        }
        if (this.hasRemovedElements()) {
            size = this.getRemovedElements().size();
            for (index = 0; index < size; ++index) {
                delegate.remove(((List)this.getRemovedElements()).get(index));
            }
            this.removedElements = null;
        }
        return delegate;
    }

    public int capacity() {
        return this.getDelegate().capacity();
    }

    public void clear() {
        this.removeAllElements();
    }

    public synchronized Object clone() {
        IndirectList result = (IndirectList)super.clone();
        result.delegate = (Vector)this.getDelegate().clone();
        result.attributeName = null;
        result.changeListener = null;
        return result;
    }

    public boolean contains(Object element) {
        if (this.hasAddedElements() && this.getAddedElements().contains(element)) {
            return true;
        }
        if (this.hasRemovedElements() && this.getRemovedElements().contains(element)) {
            return false;
        }
        return this.getDelegate().contains(element);
    }

    public boolean containsAll(Collection c) {
        return this.getDelegate().containsAll(c);
    }

    public synchronized void copyInto(Object[] anArray) {
        this.getDelegate().copyInto(anArray);
    }

    public Object elementAt(int index) {
        return this.getDelegate().elementAt(index);
    }

    public Enumeration elements() {
        return this.getDelegate().elements();
    }

    public void ensureCapacity(int minCapacity) {
        this.getDelegate().ensureCapacity(minCapacity);
    }

    public boolean equals(Object o) {
        return this.getDelegate().equals(o);
    }

    public Object firstElement() {
        return this.getDelegate().firstElement();
    }

    public Object get(int index) {
        return this.getDelegate().get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector getDelegate() {
        if (this.delegate == null) {
            IndirectList indirectList = this;
            synchronized (indirectList) {
                if (this.delegate == null) {
                    this.delegate = this.buildDelegate();
                }
            }
        }
        return this.delegate;
    }

    public Object getDelegateObject() {
        return this.getDelegate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueHolderInterface getValueHolder() {
        if (this.valueHolder == null) {
            IndirectList indirectList = this;
            synchronized (indirectList) {
                if (this.valueHolder == null) {
                    this.valueHolder = new ValueHolder(new Vector(this.initialCapacity, this.capacityIncrement));
                }
            }
        }
        return this.valueHolder;
    }

    public boolean hasBeenRegistered() {
        return this.getValueHolder() instanceof UnitOfWorkQueryValueHolder;
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    public int indexOf(Object elem) {
        return this.getDelegate().indexOf(elem);
    }

    public int indexOf(Object elem, int index) {
        return this.getDelegate().indexOf(elem, index);
    }

    public void insertElementAt(Object obj, int index) {
        this.getDelegate().insertElementAt(obj, index);
        this.raiseAddChangeEvent(obj, new Integer(index));
    }

    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    public boolean isInstantiated() {
        return this.getValueHolder().isInstantiated();
    }

    public Iterator iterator() {
        return this.listIterator(0);
    }

    public Object lastElement() {
        return this.getDelegate().lastElement();
    }

    public int lastIndexOf(Object elem) {
        return this.getDelegate().lastIndexOf(elem);
    }

    public int lastIndexOf(Object elem, int index) {
        return this.getDelegate().lastIndexOf(elem, index);
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(final int index) {
        return new ListIterator(){
            ListIterator delegateIterator;
            Object currentObject;
            {
                this.delegateIterator = IndirectList.this.getDelegate().listIterator(index);
            }

            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            public boolean hasPrevious() {
                return this.delegateIterator.hasPrevious();
            }

            public int previousIndex() {
                return this.delegateIterator.previousIndex();
            }

            public int nextIndex() {
                return this.delegateIterator.nextIndex();
            }

            public Object next() {
                this.currentObject = this.delegateIterator.next();
                return this.currentObject;
            }

            public Object previous() {
                this.currentObject = this.delegateIterator.previous();
                return this.currentObject;
            }

            public void remove() {
                this.delegateIterator.remove();
                IndirectList.this.raiseRemoveChangeEvent(this.currentObject, new Integer(this.delegateIterator.nextIndex()));
            }

            public void set(Object object) {
                this.delegateIterator.set(object);
                Integer index2 = new Integer(this.delegateIterator.previousIndex());
                IndirectList.this.raiseRemoveChangeEvent(this.currentObject, index2, true);
                IndirectList.this.raiseAddChangeEvent(object, index2, true);
            }

            public void add(Object object) {
                this.delegateIterator.add(object);
                IndirectList.this.raiseAddChangeEvent(object, new Integer(this.delegateIterator.previousIndex()));
            }
        };
    }

    public Object remove(int index) {
        Object value = this.getDelegate().remove(index);
        this.raiseRemoveChangeEvent(value, new Integer(index));
        return value;
    }

    public boolean remove(Object element) {
        if (!this.isRegistered) {
            return this.getDelegate().remove(element);
        }
        if (this.shouldAvoidInstantiation()) {
            if (this.hasAddedElements() && this.getAddedElements().contains(element)) {
                this.getAddedElements().remove(element);
            } else {
                if (this.getRemovedElements().contains(element)) {
                    return false;
                }
                this.getRemovedElements().add(element);
            }
            this.raiseRemoveChangeEvent(element, null);
            return true;
        }
        int index = this.getDelegate().indexOf(element);
        if (index > -1) {
            this.getDelegate().remove(index);
            this.raiseRemoveChangeEvent(element, index);
            return true;
        }
        return false;
    }

    public boolean removeAll(Collection c) {
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            boolean hasChanged = false;
            Iterator objects = c.iterator();
            while (objects.hasNext()) {
                hasChanged |= this.remove(objects.next());
            }
            return hasChanged;
        }
        return this.getDelegate().removeAll(c);
    }

    public void removeAllElements() {
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            Iterator objects = this.iterator();
            while (objects.hasNext()) {
                objects.next();
                objects.remove();
            }
            return;
        }
        this.getDelegate().removeAllElements();
    }

    public boolean removeElement(Object obj) {
        return this.remove(obj);
    }

    public void removeElementAt(int index) {
        this.remove(index);
    }

    public boolean retainAll(Collection c) {
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            Iterator objects = this.getDelegate().iterator();
            while (objects.hasNext()) {
                Object object = objects.next();
                if (c.contains(object)) continue;
                objects.remove();
                this.raiseRemoveChangeEvent(object, null);
            }
            return true;
        }
        return this.getDelegate().retainAll(c);
    }

    public Object set(int index, Object element) {
        Object oldValue = this.getDelegate().set(index, element);
        Integer bigIntIndex = new Integer(index);
        this.raiseRemoveChangeEvent(oldValue, bigIntIndex, true);
        this.raiseAddChangeEvent(element, bigIntIndex, true);
        return oldValue;
    }

    public void setElementAt(Object obj, int index) {
        this.set(index, obj);
    }

    public void setSize(int newSize) {
        if ((this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) && newSize > this.size()) {
            for (int index = this.size(); index > newSize; --index) {
                this.remove(index - 1);
            }
        }
        this.getDelegate().setSize(newSize);
    }

    public void setValueHolder(ValueHolderInterface valueHolder) {
        this.delegate = null;
        this.valueHolder = valueHolder;
        if (valueHolder instanceof UnitOfWorkQueryValueHolder) {
            this.isRegistered = true;
        }
    }

    public int size() {
        return this.getDelegate().size();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.getDelegate().subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        return this.getDelegate().toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.getDelegate().toArray(a);
    }

    public String toString() {
        if (this.isInstantiated()) {
            return "{" + this.getDelegate().toString() + "}";
        }
        return "{" + Helper.getShortClassName(this.getClass()) + ": not instantiated}";
    }

    public void trimToSize() {
        this.getDelegate().trimToSize();
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this.changeListener;
    }

    public boolean hasTrackedPropertyChangeListener() {
        return this.changeListener != null;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener changeListener) {
        this.changeListener = changeListener;
        if (changeListener != null) {
            this.isRegistered = true;
        }
    }

    public String getTrackedAttributeName() {
        return this.attributeName;
    }

    public void setTrackedAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public Collection getRemovedElements() {
        if (this.removedElements == null) {
            this.removedElements = new ArrayList();
        }
        return this.removedElements;
    }

    public Collection getAddedElements() {
        if (this.addedElements == null) {
            this.addedElements = new ArrayList();
        }
        return this.addedElements;
    }

    public boolean hasAddedElements() {
        return this.addedElements != null && !this.addedElements.isEmpty();
    }

    public boolean hasRemovedElements() {
        return this.removedElements != null && !this.removedElements.isEmpty();
    }

    public boolean hasDeferredChanges() {
        return this.hasRemovedElements() || this.hasAddedElements();
    }

    protected boolean shouldAvoidInstantiation() {
        return !this.isInstantiated() && this._persistence_getPropertyChangeListener() instanceof AttributeChangeListener && !this.usesListOrderField() && ((WeavedAttributeValueHolderInterface)this.getValueHolder()).shouldAllowInstantiationDeferral();
    }

    protected boolean usesListOrderField() {
        if (this.valueHolder instanceof UnitOfWorkValueHolder) {
            return ((CollectionMapping)((UnitOfWorkValueHolder)this.valueHolder).getMapping()).getListOrderField() != null;
        }
        return false;
    }

    public boolean isListOrderBrokenInDb() {
        return this.isListOrderBrokenInDb;
    }

    public void setIsListOrderBrokenInDb(boolean isBroken) {
        this.isListOrderBrokenInDb = isBroken;
    }
}

