/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ExpressionIterator;
import org.eclipse.persistence.internal.expressions.FieldExpression;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.SQLDeleteAllStatement;
import org.eclipse.persistence.internal.expressions.SQLDeleteAllStatementForTempTable;
import org.eclipse.persistence.internal.expressions.SQLDeleteStatement;
import org.eclipse.persistence.internal.expressions.SQLInsertStatement;
import org.eclipse.persistence.internal.expressions.SQLModifyStatement;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.expressions.SQLStatement;
import org.eclipse.persistence.internal.expressions.SQLUpdateAllStatement;
import org.eclipse.persistence.internal.expressions.SQLUpdateAllStatementForOracleAnonymousBlock;
import org.eclipse.persistence.internal.expressions.SQLUpdateAllStatementForTempTable;
import org.eclipse.persistence.internal.expressions.SQLUpdateStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.queries.DatabaseQueryMechanism;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.queries.StatementQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.queries.ConstructorReportItem;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.ModifyAllQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.UpdateAllQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionQueryMechanism
extends StatementQueryMechanism {
    protected Expression selectionCriteria;

    public ExpressionQueryMechanism(DatabaseQuery query) {
        super(query);
    }

    public ExpressionQueryMechanism(DatabaseQuery query, Expression expression) {
        super(query);
        this.selectionCriteria = expression;
    }

    protected Vector aliasFields(ObjectExpression node, Vector fields) {
        Vector<DatabaseField> result = new Vector<DatabaseField>(fields.size());
        Enumeration e = fields.elements();
        while (e.hasMoreElements()) {
            DatabaseField eachField = (DatabaseField)((DatabaseField)e.nextElement()).clone();
            eachField.setTable(node.aliasForTable(eachField.getTable()));
            result.addElement(eachField);
        }
        return result;
    }

    public Vector aliasPresetFields(SQLSelectStatement statement) {
        Vector fields = statement.getFields();
        Expression exp = statement.getWhereClause();
        if (exp == null) {
            return fields;
        }
        ExpressionBuilder base = exp.getBuilder();
        return this.aliasFields(base, fields);
    }

    public Expression buildBaseSelectionCriteria(boolean isSubSelect, Map clonedExpressions) {
        DescriptorQueryManager queryManager;
        Expression expression = this.getSelectionCriteria();
        if (expression == null && this.getQuery().isObjectLevelReadQuery()) {
            expression = ((ObjectLevelReadQuery)this.getQuery()).getExpressionBuilder();
        }
        if (!isSubSelect && expression != null) {
            expression = expression.copiedVersionFrom(clonedExpressions);
        }
        if (expression != null && this.getQuery().isObjectLevelReadQuery()) {
            ExpressionBuilder builder = ((ObjectLevelReadQuery)this.getQuery()).getExpressionBuilder();
            if (!isSubSelect && builder != null) {
                builder = (ExpressionBuilder)builder.copiedVersionFrom(clonedExpressions);
            }
            expression.resetPlaceHolderBuilder(builder);
        }
        if (!((queryManager = this.getDescriptor().getQueryManager()).getAdditionalJoinExpression() == null || this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().hasView())) {
            Expression additionalJoin = queryManager.getAdditionalJoinExpression();
            if (expression == null) {
                expression = (Expression)additionalJoin.clone();
            } else {
                if (this.query.isObjectLevelReadQuery()) {
                    ExpressionBuilder builder = ((ObjectLevelReadQuery)this.query).getExpressionBuilder();
                    if (additionalJoin.getBuilder() != builder && additionalJoin.getBuilder().getQueryClass() == null) {
                        if (!isSubSelect && builder != null) {
                            builder = (ExpressionBuilder)builder.copiedVersionFrom(clonedExpressions);
                        }
                        additionalJoin = additionalJoin.rebuildOn(builder);
                    }
                }
                expression = expression.and(additionalJoin);
            }
            additionalJoin.getBuilder().setWasAdditionJoinCriteriaUsed(true);
        }
        return expression;
    }

    public SQLSelectStatement buildBaseSelectStatement(boolean isSubSelect, Map clonedExpressions) {
        SQLSelectStatement selectStatement = new SQLSelectStatement();
        ObjectLevelReadQuery query = (ObjectLevelReadQuery)this.getQuery();
        selectStatement.setQuery(query);
        selectStatement.setLockingClause(query.getLockingClause());
        selectStatement.setDistinctState(query.getDistinctState());
        selectStatement.setTables((Vector)this.getDescriptor().getTables().clone());
        selectStatement.setWhereClause(this.buildBaseSelectionCriteria(isSubSelect, clonedExpressions));
        if (query.hasDefaultBuilder() && !query.getExpressionBuilder().wasQueryClassSetInternally()) {
            selectStatement.setBuilder((ExpressionBuilder)query.getExpressionBuilder().copiedVersionFrom(clonedExpressions));
        }
        if (query.hasOrderByExpressions()) {
            selectStatement.setOrderByExpressions(this.cloneExpressions(query.getOrderByExpressions(), clonedExpressions));
        }
        if (this.getQuery().isReadAllQuery() && ((ReadAllQuery)this.getQuery()).hasHierarchicalExpressions()) {
            ReadAllQuery readAllquery = (ReadAllQuery)query;
            Expression startsWith = readAllquery.getStartWithExpression();
            if (startsWith != null) {
                startsWith.copiedVersionFrom(clonedExpressions);
            }
            selectStatement.setHierarchicalQueryExpressions(startsWith, readAllquery.getConnectByExpression().copiedVersionFrom(clonedExpressions), this.cloneExpressions(readAllquery.getOrderSiblingsByExpressions(), clonedExpressions));
        }
        selectStatement.setHintString(query.getHintString());
        selectStatement.setTranslationRow(this.getTranslationRow());
        return selectStatement;
    }

    protected SQLSelectStatement buildConcreteSelectStatement() {
        IdentityHashMap clonedExpressions = new IdentityHashMap();
        SQLSelectStatement selectStatement = this.buildBaseSelectStatement(false, clonedExpressions);
        if (this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().shouldReadSubclasses()) {
            Expression concrete = this.getDescriptor().getInheritancePolicy().getOnlyInstancesExpression();
            if (concrete != null && selectStatement.getWhereClause() != null) {
                selectStatement.setWhereClause(selectStatement.getWhereClause().and(concrete));
            } else if (concrete != null) {
                selectStatement.setWhereClause((Expression)concrete.clone());
            }
        }
        selectStatement.setFields(this.getSelectionFields(selectStatement, false));
        selectStatement.normalize(this.getSession(), this.getDescriptor(), clonedExpressions);
        if (((ObjectLevelReadQuery)this.getQuery()).hasJoining()) {
            ((ObjectLevelReadQuery)this.getQuery()).getJoinedAttributeManager().computeJoiningMappingIndexes(false, this.getSession(), 0);
        }
        return selectStatement;
    }

    protected SQLDeleteStatement buildDeleteAllStatement(DatabaseTable table, Expression inheritanceExpression, SQLCall selectCallForExist, SQLSelectStatement selectStatementForExist, SQLCall selectCallForNotExist, SQLSelectStatement selectStatementForNotExist, Collection primaryKeyFields) {
        if (selectCallForExist == null && selectCallForNotExist == null) {
            return this.buildDeleteStatementForDeleteAllQuery(table, inheritanceExpression);
        }
        SQLDeleteAllStatement deleteAllStatement = new SQLDeleteAllStatement();
        deleteAllStatement.setTable(table);
        deleteAllStatement.setTranslationRow(this.getTranslationRow());
        if (selectCallForExist != null) {
            deleteAllStatement.setSelectCallForExist(selectCallForExist);
            deleteAllStatement.setShouldExtractWhereClauseFromSelectCallForExist(!selectStatementForExist.requiresAliases() && table.equals(selectStatementForExist.getTables().firstElement()));
            deleteAllStatement.setTableAliasInSelectCallForExist(ExpressionQueryMechanism.getAliasTableName(selectStatementForExist, table, this.getSession().getPlatform()));
        } else if (inheritanceExpression != null) {
            deleteAllStatement.setInheritanceExpression((Expression)inheritanceExpression.clone());
        }
        if (selectCallForNotExist != null) {
            deleteAllStatement.setSelectCallForNotExist(selectCallForNotExist);
            deleteAllStatement.setTableAliasInSelectCallForNotExist(ExpressionQueryMechanism.getAliasTableName(selectStatementForNotExist, table, this.getSession().getPlatform()));
        }
        deleteAllStatement.setPrimaryKeyFieldsForAutoJoin(primaryKeyFields);
        return deleteAllStatement;
    }

    protected SQLDeleteStatement buildDeleteAllStatementForMapping(SQLCall selectCallForExist, SQLSelectStatement selectStatementForExist, Vector sourceFields, Vector targetFields) {
        DatabaseTable targetTable = ((DatabaseField)targetFields.firstElement()).getTable();
        if (selectCallForExist == null) {
            return this.buildDeleteStatementForDeleteAllQuery(targetTable);
        }
        SQLDeleteAllStatement deleteAllStatement = new SQLDeleteAllStatement();
        deleteAllStatement.setTable(targetTable);
        deleteAllStatement.setTranslationRow(this.getTranslationRow());
        deleteAllStatement.setSelectCallForExist(selectCallForExist);
        DatabaseTable sourceTable = ((DatabaseField)sourceFields.firstElement()).getTable();
        if (selectStatementForExist != null) {
            deleteAllStatement.setTableAliasInSelectCallForExist(ExpressionQueryMechanism.getAliasTableName(selectStatementForExist, sourceTable, this.getSession().getPlatform()));
        }
        deleteAllStatement.setAliasedFieldsForJoin(sourceFields);
        deleteAllStatement.setOriginalFieldsForJoin(targetFields);
        return deleteAllStatement;
    }

    protected Vector buildDeleteAllStatementsForMappingsWithTempTable(ClassDescriptor descriptor, DatabaseTable rootTable, Collection rootTablePrimaryKeyFields, boolean dontCheckDescriptor) {
        Vector<SQLDeleteAllStatementForTempTable> deleteStatements = new Vector<SQLDeleteAllStatementForTempTable>();
        for (DatabaseMapping mapping : descriptor.getMappings()) {
            if (!mapping.isManyToManyMapping() && !mapping.isDirectCollectionMapping() || !dontCheckDescriptor && !mapping.getDescriptor().equals(descriptor)) continue;
            Vector<DatabaseField> targetFields = null;
            if (mapping.isManyToManyMapping()) {
                targetFields = ((ManyToManyMapping)mapping).getSourceRelationKeyFields();
            } else if (mapping.isDirectCollectionMapping()) {
                targetFields = ((DirectCollectionMapping)mapping).getReferenceKeyFields();
            }
            DatabaseTable targetTable = targetFields.firstElement().getTable();
            SQLDeleteAllStatementForTempTable deleteStatement = this.buildDeleteAllStatementForTempTable(rootTable, rootTablePrimaryKeyFields, targetTable, targetFields);
            deleteStatements.addElement(deleteStatement);
        }
        return deleteStatements;
    }

    protected static String getAliasTableName(SQLSelectStatement selectStatement, DatabaseTable table, DatasourcePlatform platform) {
        if (!selectStatement.requiresAliases()) {
            return null;
        }
        HashSet<DatabaseTable> aliasTables = new HashSet<DatabaseTable>();
        Iterator itEntries = selectStatement.getTableAliases().entrySet().iterator();
        DatabaseTable aliasTable = null;
        while (itEntries.hasNext()) {
            Map.Entry entry = itEntries.next();
            if (!table.equals(entry.getValue())) continue;
            aliasTable = (DatabaseTable)entry.getKey();
            aliasTables.add(aliasTable);
        }
        if (aliasTables.isEmpty()) {
            return null;
        }
        if (aliasTables.size() == 1) {
            return aliasTable.getQualifiedNameDelimited(platform);
        }
        ExpressionIterator expIterator = new ExpressionIterator(){

            public void iterate(Expression each) {
                DataExpression dataExpression;
                DatabaseField field;
                if (each instanceof DataExpression && (field = (dataExpression = (DataExpression)each).getField()) != null && dataExpression.getBaseExpression() != this.getStatement().getBuilder()) {
                    ((Collection)this.getResult()).remove(dataExpression.getAliasedField().getTable());
                }
            }

            public boolean shouldIterateOverSubSelects() {
                return true;
            }
        };
        expIterator.setStatement(selectStatement);
        expIterator.setResult(aliasTables);
        expIterator.iterateOn(selectStatement.getWhereClause());
        if (aliasTables.size() == 1) {
            aliasTable = (DatabaseTable)aliasTables.iterator().next();
            return aliasTable.getQualifiedName();
        }
        if (aliasTables.isEmpty()) {
            return aliasTable.getQualifiedName();
        }
        aliasTable = (DatabaseTable)aliasTables.iterator().next();
        return aliasTable.getQualifiedName();
    }

    protected SQLDeleteStatement buildDeleteStatementForDeleteAllQuery(DatabaseTable table) {
        return this.buildDeleteStatementForDeleteAllQuery(table, null);
    }

    protected SQLDeleteStatement buildDeleteStatementForDeleteAllQuery(DatabaseTable table, Expression inheritanceExpression) {
        SQLDeleteStatement deleteStatement = new SQLDeleteStatement();
        if (inheritanceExpression != null) {
            deleteStatement.setWhereClause((Expression)inheritanceExpression.clone());
        }
        deleteStatement.setTable(table);
        deleteStatement.setTranslationRow(this.getTranslationRow());
        deleteStatement.setHintString(this.getQuery().getHintString());
        return deleteStatement;
    }

    protected SQLDeleteStatement buildDeleteStatement(DatabaseTable table) {
        SQLDeleteStatement deleteStatement = new SQLDeleteStatement();
        Expression whereClause = this.getDescriptor().getObjectBuilder().buildDeleteExpression(table, this.getTranslationRow());
        deleteStatement.setWhereClause(whereClause);
        deleteStatement.setTable(table);
        deleteStatement.setTranslationRow(this.getTranslationRow());
        deleteStatement.setHintString(this.getQuery().getHintString());
        return deleteStatement;
    }

    protected SQLInsertStatement buildInsertStatement(DatabaseTable table) {
        SQLInsertStatement insertStatement = new SQLInsertStatement();
        insertStatement.setTable(table);
        insertStatement.setModifyRow(this.getModifyRow());
        if (this.getDescriptor().hasReturningPolicy()) {
            insertStatement.setReturnFields(this.getDescriptor().getReturningPolicy().getFieldsToGenerateInsert(table));
        }
        insertStatement.setHintString(this.getQuery().getHintString());
        return insertStatement;
    }

    protected SQLSelectStatement buildNormalSelectStatement() {
        IdentityHashMap<Expression, Expression> clonedExpressions = new IdentityHashMap<Expression, Expression>();
        SQLSelectStatement selectStatement = this.buildBaseSelectStatement(false, clonedExpressions);
        ObjectLevelReadQuery query = (ObjectLevelReadQuery)this.getQuery();
        if (this.getDescriptor().hasInheritance()) {
            this.getDescriptor().getInheritancePolicy().appendWithAllSubclassesExpression(selectStatement);
            if (!query.isReportQuery() && query.shouldOuterJoinSubclasses()) {
                selectStatement.getExpressionBuilder().setShouldUseOuterJoinForMultitableInheritance(true);
            }
        }
        selectStatement.setFields(this.getSelectionFields(selectStatement, true));
        if (query.hasNonFetchJoinedAttributeExpressions()) {
            selectStatement.setNonSelectFields(this.cloneExpressions(query.getNonFetchJoinAttributeExpressions(), clonedExpressions));
        }
        selectStatement.normalize(this.getSession(), this.getDescriptor(), clonedExpressions);
        if (((ObjectLevelReadQuery)this.getQuery()).hasJoining()) {
            ((ObjectLevelReadQuery)this.getQuery()).getJoinedAttributeManager().computeJoiningMappingIndexes(true, this.getSession(), 0);
        }
        return selectStatement;
    }

    protected SQLSelectStatement buildReportQuerySelectStatement(boolean isSubSelect) {
        return this.buildReportQuerySelectStatement(isSubSelect, false, null);
    }

    protected SQLSelectStatement buildReportQuerySelectStatement(boolean isSubSelect, boolean useCustomaryInheritanceExpression, Expression inheritanceExpression) {
        int i;
        int size;
        List reportItems;
        ConstructorReportItem citem;
        ReportQuery reportQuery = (ReportQuery)this.getQuery();
        IdentityHashMap<Expression, Expression> clonedExpressions = isSubSelect ? null : new IdentityHashMap<Expression, Expression>();
        SQLSelectStatement selectStatement = this.buildBaseSelectStatement(isSubSelect, clonedExpressions);
        if (reportQuery.hasGroupByExpressions()) {
            selectStatement.setGroupByExpressions(this.cloneExpressions(reportQuery.getGroupByExpressions(), clonedExpressions));
        }
        if (reportQuery.getHavingExpression() != null) {
            selectStatement.setHavingExpression(reportQuery.getHavingExpression().copiedVersionFrom(clonedExpressions));
        }
        if (this.getDescriptor().hasInheritance()) {
            if (useCustomaryInheritanceExpression) {
                if (inheritanceExpression != null) {
                    if (selectStatement.getWhereClause() == null) {
                        selectStatement.setWhereClause((Expression)inheritanceExpression.clone());
                    } else {
                        selectStatement.setWhereClause(selectStatement.getWhereClause().and(inheritanceExpression));
                    }
                }
            } else {
                this.getDescriptor().getInheritancePolicy().appendWithAllSubclassesExpression(selectStatement);
            }
        }
        Vector fieldExpressions = reportQuery.getQueryExpressions();
        int itemOffset = fieldExpressions.size();
        for (ReportItem item : reportQuery.getItems()) {
            if (item.isConstructorItem()) {
                citem = (ConstructorReportItem)item;
                reportItems = citem.getReportItems();
                size = reportItems.size();
                for (i = 0; i < size; ++i) {
                    item = (ReportItem)reportItems.get(i);
                    this.extractStatementFromItem(item, clonedExpressions, selectStatement, fieldExpressions);
                }
                continue;
            }
            this.extractStatementFromItem(item, clonedExpressions, selectStatement, fieldExpressions);
        }
        selectStatement.setFields(fieldExpressions);
        if (reportQuery.hasNonFetchJoinedAttributeExpressions()) {
            selectStatement.setNonSelectFields(this.cloneExpressions(reportQuery.getNonFetchJoinAttributeExpressions(), clonedExpressions));
        }
        if (!isSubSelect) {
            selectStatement.normalize(this.getSession(), this.getDescriptor(), clonedExpressions);
        }
        for (ReportItem item : reportQuery.getItems()) {
            if (item.isConstructorItem()) {
                citem = (ConstructorReportItem)item;
                reportItems = citem.getReportItems();
                size = reportItems.size();
                for (i = 0; i < size; ++i) {
                    item = (ReportItem)reportItems.get(i);
                    itemOffset = this.computeAndSetItemOffset(item, itemOffset);
                }
                continue;
            }
            itemOffset = this.computeAndSetItemOffset(item, itemOffset);
        }
        return selectStatement;
    }

    protected int computeAndSetItemOffset(ReportItem item, int itemOffset) {
        item.setResultIndex(itemOffset);
        if (item.getAttributeExpression() != null) {
            itemOffset = item.hasJoining() ? item.getJoinedAttributeManager().computeJoiningMappingIndexes(true, this.getSession(), itemOffset) : (item.getDescriptor() != null ? (itemOffset += item.getDescriptor().getAllFields().size()) : ++itemOffset);
        }
        return itemOffset;
    }

    public void extractStatementFromItem(ReportItem item, Map clonedExpressions, SQLSelectStatement selectStatement, Vector fieldExpressions) {
        if (item.getAttributeExpression() != null) {
            Expression attributeExpression = item.getAttributeExpression();
            ExpressionBuilder clonedBuilder = attributeExpression.getBuilder();
            if (clonedBuilder.wasQueryClassSetInternally() && ((ReportQuery)this.getQuery()).getExpressionBuilder() != clonedBuilder) {
                clonedBuilder = selectStatement.getBuilder();
                attributeExpression = attributeExpression.rebuildOn(clonedBuilder);
            } else if (clonedExpressions != null && clonedExpressions.get(clonedBuilder) != null) {
                Expression cloneExpression = (Expression)clonedExpressions.get(attributeExpression);
                if (cloneExpression != null && !cloneExpression.isExpressionBuilder()) {
                    attributeExpression = cloneExpression;
                } else {
                    clonedBuilder = (ExpressionBuilder)clonedBuilder.copiedVersionFrom(clonedExpressions);
                    attributeExpression = attributeExpression.rebuildOn(clonedBuilder);
                }
            }
            if (attributeExpression.isExpressionBuilder() && item.getDescriptor().getQueryManager().getAdditionalJoinExpression() != null && !clonedBuilder.wasAdditionJoinCriteriaUsed()) {
                if (selectStatement.getWhereClause() == null) {
                    selectStatement.setWhereClause(item.getDescriptor().getQueryManager().getAdditionalJoinExpression().rebuildOn(clonedBuilder));
                } else {
                    selectStatement.setWhereClause(selectStatement.getWhereClause().and(item.getDescriptor().getQueryManager().getAdditionalJoinExpression().rebuildOn(clonedBuilder)));
                }
            }
            fieldExpressions.add(attributeExpression);
            if (item.hasJoining()) {
                fieldExpressions.addAll(item.getJoinedAttributeManager().getJoinedAttributeExpressions());
                fieldExpressions.addAll(item.getJoinedAttributeManager().getJoinedMappingExpressions());
            }
        }
    }

    protected SQLSelectStatement buildSelectStatementForDoesExist(DatabaseField field) {
        SQLSelectStatement selectStatement = new SQLSelectStatement();
        selectStatement.addField(field);
        selectStatement.setWhereClause(((Expression)this.getDescriptor().getObjectBuilder().getPrimaryKeyExpression().clone()).and(this.getDescriptor().getQueryManager().getAdditionalJoinExpression()));
        selectStatement.setTranslationRow(this.getTranslationRow());
        selectStatement.normalize(this.getSession(), this.getQuery().getDescriptor());
        selectStatement.setHintString(this.getQuery().getHintString());
        return selectStatement;
    }

    protected SQLUpdateAllStatement buildUpdateAllStatement(DatabaseTable table, HashMap databaseFieldsToValues, SQLCall selectCallForExist, SQLSelectStatement selectStatementForExist, Collection primaryKeyFields) {
        SQLUpdateAllStatement updateAllStatement = new SQLUpdateAllStatement();
        updateAllStatement.setTable(table);
        updateAllStatement.setTranslationRow(this.getTranslationRow());
        HashMap<DatabaseField, SQLCall> databaseFieldsToValuesCopy = new HashMap<DatabaseField, SQLCall>(databaseFieldsToValues.size());
        HashMap<DatabaseField, String> databaseFieldsToTableAliases = null;
        for (Map.Entry entry : databaseFieldsToValues.entrySet()) {
            DatabaseField field = (DatabaseField)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof SQLSelectStatement) {
                SQLSelectStatement selStatement = (SQLSelectStatement)value;
                SQLCall selCall = (SQLCall)selStatement.buildCall(this.getSession());
                databaseFieldsToValuesCopy.put(field, selCall);
                if (databaseFieldsToTableAliases == null) {
                    databaseFieldsToTableAliases = new HashMap<DatabaseField, String>();
                    updateAllStatement.setPrimaryKeyFieldsForAutoJoin(primaryKeyFields);
                }
                databaseFieldsToTableAliases.put(field, ExpressionQueryMechanism.getAliasTableName(selStatement, table, this.getSession().getPlatform()));
                continue;
            }
            databaseFieldsToValuesCopy.put(field, (SQLCall)value);
        }
        updateAllStatement.setUpdateClauses(databaseFieldsToValuesCopy);
        updateAllStatement.setDatabaseFieldsToTableAliases(databaseFieldsToTableAliases);
        updateAllStatement.setSelectCallForExist(selectCallForExist);
        updateAllStatement.setShouldExtractWhereClauseFromSelectCallForExist(!selectStatementForExist.requiresAliases() && table.equals(selectStatementForExist.getTables().firstElement()));
        updateAllStatement.setTableAliasInSelectCallForExist(ExpressionQueryMechanism.getAliasTableName(selectStatementForExist, table, this.getSession().getPlatform()));
        updateAllStatement.setPrimaryKeyFieldsForAutoJoin(primaryKeyFields);
        return updateAllStatement;
    }

    protected SQLUpdateStatement buildUpdateStatement(DatabaseTable table) {
        SQLUpdateStatement updateStatement = new SQLUpdateStatement();
        updateStatement.setModifyRow(this.getModifyRow());
        updateStatement.setTranslationRow(this.getTranslationRow());
        if (this.getDescriptor().hasReturningPolicy()) {
            updateStatement.setReturnFields(this.getDescriptor().getReturningPolicy().getFieldsToGenerateUpdate(table));
        }
        updateStatement.setTable(table);
        updateStatement.setWhereClause(this.getDescriptor().getObjectBuilder().buildUpdateExpression(table, this.getTranslationRow(), this.getModifyRow()));
        updateStatement.setHintString(this.getQuery().getHintString());
        return updateStatement;
    }

    @Override
    public Object checkCacheForObject(AbstractRecord translationRow, AbstractSession session) {
        Object selectionKey;
        Expression selectionCriteria;
        Object cachedObject;
        int policyToUse;
        UnitOfWorkImpl uow;
        boolean conforming;
        ClassDescriptor descriptor;
        ReadObjectQuery query;
        block35: {
            query = this.getReadObjectQuery();
            descriptor = this.getDescriptor();
            conforming = false;
            uow = null;
            if (session.isUnitOfWork()) {
                conforming = query.shouldConformResultsInUnitOfWork() || descriptor.shouldAlwaysConformResultsInUnitOfWork();
                uow = (UnitOfWorkImpl)session;
            }
            policyToUse = query.getInMemoryQueryIndirectionPolicyState();
            if (conforming && policyToUse != 1) {
                policyToUse = 2;
            }
            cachedObject = null;
            selectionCriteria = this.getSelectionCriteria();
            selectionKey = query.getSelectionId();
            Object selectionObject = query.getSelectionObject();
            if (selectionKey != null || selectionObject != null) {
                if (selectionKey == null) {
                    selectionKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(selectionObject, session, true);
                    if (selectionKey == null) {
                        return InvalidObject.instance;
                    }
                    query.setSelectionId(selectionKey);
                }
                cachedObject = descriptor.shouldAcquireCascadedLocks() ? session.getIdentityMapAccessorInstance().getFromIdentityMapWithDeferredLock(selectionKey, query.getReferenceClass(), false, descriptor) : session.getIdentityMapAccessorInstance().getFromIdentityMap(selectionKey, query.getReferenceClass(), false, descriptor);
            } else if (selectionCriteria == null) {
                if (query.shouldConformResultsInUnitOfWork() || descriptor.shouldAlwaysConformResultsInUnitOfWork() || query.shouldCheckCacheOnly() || query.shouldCheckCacheThenDatabase()) {
                    cachedObject = session.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(null, query.getReferenceClass(), translationRow, policyToUse, conforming, false, descriptor);
                }
            } else {
                selectionKey = descriptor.getObjectBuilder().extractPrimaryKeyFromExpression(true, selectionCriteria, translationRow, session);
                if (selectionKey != null || query.shouldCheckCacheByExactPrimaryKey()) {
                    if (selectionKey != null) {
                        if (selectionKey == InvalidObject.instance) {
                            return selectionKey;
                        }
                        cachedObject = descriptor.shouldAcquireCascadedLocks() ? session.getIdentityMapAccessorInstance().getFromIdentityMapWithDeferredLock(selectionKey, query.getReferenceClass(), false, descriptor) : session.getIdentityMapAccessorInstance().getFromIdentityMap(selectionKey, query.getReferenceClass(), false, descriptor);
                    }
                } else {
                    boolean conformingButOutsideUnitOfWork;
                    Object inexactSelectionKey = descriptor.getObjectBuilder().extractPrimaryKeyFromExpression(false, selectionCriteria, translationRow, session);
                    if (inexactSelectionKey != null) {
                        if (selectionKey == InvalidObject.instance) {
                            return selectionKey;
                        }
                        cachedObject = descriptor.shouldAcquireCascadedLocks() ? session.getIdentityMapAccessorInstance().getFromIdentityMapWithDeferredLock(inexactSelectionKey, query.getReferenceClass(), false, descriptor) : session.getIdentityMapAccessorInstance().getFromIdentityMap(inexactSelectionKey, query.getReferenceClass(), false, descriptor);
                        if (cachedObject != null) {
                            try {
                                ExpressionBuilder builder = selectionCriteria.getBuilder();
                                builder.setSession(session.getRootSession(null));
                                builder.setQueryClass(descriptor.getJavaClass());
                                if (!selectionCriteria.doesConform(cachedObject, session, translationRow, policyToUse)) {
                                    cachedObject = null;
                                }
                            }
                            catch (QueryException exception) {
                                if (query.shouldCheckCacheOnly()) {
                                    throw exception;
                                }
                                cachedObject = null;
                            }
                        }
                    }
                    boolean bl = conformingButOutsideUnitOfWork = (query.shouldConformResultsInUnitOfWork() || descriptor.shouldAlwaysConformResultsInUnitOfWork()) && !session.isUnitOfWork();
                    if (cachedObject == null && (conforming || !query.shouldCheckCacheByPrimaryKey() && !conformingButOutsideUnitOfWork)) {
                        if (selectionCriteria != null) {
                            ExpressionBuilder builder = selectionCriteria.getBuilder();
                            builder.setSession(session.getRootSession(null));
                            builder.setQueryClass(descriptor.getJavaClass());
                        }
                        try {
                            cachedObject = session.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(selectionCriteria, query.getReferenceClass(), translationRow, policyToUse, conforming, false, descriptor);
                        }
                        catch (QueryException exception) {
                            if (!query.shouldCheckCacheOnly()) break block35;
                            throw exception;
                        }
                    }
                }
            }
        }
        if (conforming) {
            if (cachedObject == null) {
                if (selectionKey != null) {
                    cachedObject = uow.getObjectFromNewObjects(query.getReferenceClass(), selectionKey);
                } else {
                    if (selectionCriteria != null) {
                        ExpressionBuilder builder = selectionCriteria.getBuilder();
                        builder.setSession(session.getRootSession(null));
                        builder.setQueryClass(descriptor.getJavaClass());
                    }
                    try {
                        cachedObject = uow.getObjectFromNewObjects(selectionCriteria, query.getReferenceClass(), translationRow, policyToUse);
                    }
                    catch (QueryException exception) {
                        // empty catch block
                    }
                }
            }
            if (cachedObject != null && uow.isObjectDeleted(cachedObject)) {
                if (selectionKey != null) {
                    return InvalidObject.instance;
                }
                cachedObject = null;
            }
        }
        if (cachedObject != null && descriptor.hasFetchGroupManager() && descriptor.getFetchGroupManager().isPartialObject(cachedObject) && !descriptor.getFetchGroupManager().isObjectValidForFetchGroup(cachedObject, query.getFetchGroup())) {
            cachedObject = null;
        }
        if (cachedObject == null && query.shouldCheckCacheOnly() && (uow == null || !uow.isNestedUnitOfWork() && descriptor.shouldIsolateObjectsInUnitOfWork())) {
            return InvalidObject.instance;
        }
        return cachedObject;
    }

    @Override
    public void clearStatement() {
        this.setSQLStatement(null);
        this.setSQLStatements(null);
    }

    @Override
    public DatabaseQueryMechanism clone(DatabaseQuery queryClone) {
        DatabaseQueryMechanism clone = (DatabaseQueryMechanism)this.clone();
        clone.setQuery(queryClone);
        return clone;
    }

    public ExpressionBuilder getExpressionBuilder() {
        if (this.getSelectionCriteria() != null) {
            return this.getSelectionCriteria().getBuilder();
        }
        return null;
    }

    @Override
    public Expression getSelectionCriteria() {
        return this.selectionCriteria;
    }

    public Vector getSelectionFields(SQLSelectStatement statement, boolean includeAllSubclassFields) {
        Vector fields;
        ObjectLevelReadQuery owner = (ObjectLevelReadQuery)this.getQuery();
        if (owner.hasPartialAttributeExpressions()) {
            return owner.getPartialAttributeSelectionFields(false);
        }
        if (owner.hasFetchGroup()) {
            return owner.getFetchGroupSelectionFields(false);
        }
        ExpressionBuilder base = statement.getExpressionBuilder();
        if (includeAllSubclassFields) {
            fields = (Vector)this.getDescriptor().getAllFields().clone();
        } else {
            fields = NonSynchronizedVector.newInstance();
            ((Vector)fields).addElement(base);
        }
        if (owner.hasJoining()) {
            Helper.addAllToVector(fields, owner.getJoinedAttributeManager().getJoinedAttributeExpressions());
            Helper.addAllToVector(fields, owner.getJoinedAttributeManager().getJoinedMappingExpressions());
        }
        if (owner.hasAdditionalFields()) {
            Helper.addAllToVector(fields, owner.getAdditionalFields());
        }
        return fields;
    }

    @Override
    public boolean isExpressionQueryMechanism() {
        return true;
    }

    @Override
    public boolean isStatementQueryMechanism() {
        return false;
    }

    @Override
    public void prepare() throws QueryException {
    }

    @Override
    public void prepareCursorSelectAllRows() {
        if (this.getQuery().isReportQuery()) {
            SQLSelectStatement statement = this.buildReportQuerySelectStatement(false);
            this.setSQLStatement(statement);
        } else if (this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().requiresMultipleTableSubclassRead() && this.getDescriptor().getInheritancePolicy().hasView()) {
            InheritancePolicy inheritancePolicy = this.getDescriptor().getInheritancePolicy();
            SQLSelectStatement statement = inheritancePolicy.buildViewSelectStatement((ObjectLevelReadQuery)this.getQuery());
            this.setSQLStatement(statement);
        } else {
            this.setSQLStatement(this.buildNormalSelectStatement());
        }
        super.prepareCursorSelectAllRows();
    }

    @Override
    public void prepareDeleteAll() {
        this.prepareDeleteAll(null);
    }

    protected void prepareDeleteAll(Vector tablesToIgnore) {
        boolean shouldHandleChildren;
        Vector<DatabaseTable> tablesInInsertOrder;
        if (tablesToIgnore == null) {
            tablesInInsertOrder = this.getDescriptor().getMultipleTableInsertOrder();
        } else {
            tablesInInsertOrder = new Vector(this.getDescriptor().getMultipleTableInsertOrder().size());
            for (DatabaseTable table : this.getDescriptor().getMultipleTableInsertOrder()) {
                if (tablesToIgnore.contains(table)) continue;
                tablesInInsertOrder.addElement(table);
            }
        }
        boolean hasInheritance = this.getDescriptor().hasInheritance();
        if (!tablesInInsertOrder.isEmpty()) {
            Vector deleteStatementsForMappings;
            SQLSelectStatement selectStatementForExist;
            boolean isMainCase;
            Expression whereClause = this.getSelectionCriteria();
            SQLCall selectCallForExist = null;
            boolean isSelectCallForNotExistRequired = tablesToIgnore == null && tablesInInsertOrder.size() > 1;
            SQLSelectStatement selectStatementForNotExist = null;
            SQLCall selectCallForNotExist = null;
            Expression inheritanceExpression = null;
            if (tablesToIgnore == null && hasInheritance) {
                inheritanceExpression = this.getDescriptor().getInheritancePolicy().shouldReadSubclasses() ? this.getDescriptor().getInheritancePolicy().getWithAllSubclassesExpression() : this.getDescriptor().getInheritancePolicy().getOnlyInstancesExpression();
            }
            if (isMainCase = (selectStatementForExist = this.createSQLSelectStatementForModifyAll(whereClause)).requiresAliases()) {
                if (whereClause != null) {
                    if (this.getSession().getPlatform().shouldAlwaysUseTempStorageForModifyAll() && tablesToIgnore == null && !this.getSession().getPlatform().isOracle()) {
                        this.prepareDeleteAllUsingTempStorage();
                        return;
                    }
                    if (isSelectCallForNotExistRequired) {
                        selectStatementForNotExist = this.createSQLSelectStatementForModifyAll(null, null);
                        selectCallForNotExist = (SQLCall)selectStatementForNotExist.buildCall(this.getSession());
                    }
                } else if (this.getSession().getPlatform().shouldAlwaysUseTempStorageForModifyAll() && tablesToIgnore == null && !this.getSession().getPlatform().isOracle() && hasInheritance && (inheritanceExpression != null || !this.getDescriptor().getInheritancePolicy().isRootParentDescriptor())) {
                    this.prepareDeleteAllUsingTempStorage();
                    return;
                }
            } else if (whereClause != null && this.getSession().getPlatform().shouldAlwaysUseTempStorageForModifyAll() && tablesToIgnore == null && !this.getSession().getPlatform().isOracle() && hasInheritance && this.getDescriptor().getInheritancePolicy().hasMultipleTableChild()) {
                this.prepareDeleteAllUsingTempStorage();
                return;
            }
            if (whereClause != null) {
                selectCallForExist = (SQLCall)selectStatementForExist.buildCall(this.getSession());
            }
            if (isMainCase) {
                Enumeration<DatabaseTable> tablesEnum = tablesInInsertOrder.elements();
                while (tablesEnum.hasMoreElements()) {
                    SQLDeleteStatement deleteStatement;
                    DatabaseTable table = tablesEnum.nextElement();
                    Collection primaryKeyFields = this.getPrimaryKeyFieldsForTable(table);
                    if (!isSelectCallForNotExistRequired) {
                        deleteStatement = this.buildDeleteAllStatement(table, inheritanceExpression, selectCallForExist, selectStatementForExist, null, null, primaryKeyFields);
                    } else {
                        boolean isLastTable = table.equals(tablesInInsertOrder.lastElement());
                        if (inheritanceExpression == null) {
                            deleteStatement = isLastTable ? this.buildDeleteAllStatement(table, null, selectCallForExist, selectStatementForExist, null, null, primaryKeyFields) : this.buildDeleteAllStatement(table, null, null, null, selectCallForNotExist, selectStatementForNotExist, primaryKeyFields);
                        } else if (table.equals(this.getDescriptor().getMultipleTableInsertOrder().firstElement())) {
                            deleteStatement = this.buildDeleteAllStatement(table, inheritanceExpression, null, null, selectCallForNotExist, selectStatementForNotExist, primaryKeyFields);
                        } else {
                            ClassDescriptor desc = this.getHighestDescriptorMappingTable(table);
                            if (desc == this.getDescriptor()) {
                                deleteStatement = isLastTable ? this.buildDeleteAllStatement(table, null, selectCallForExist, selectStatementForExist, null, null, primaryKeyFields) : this.buildDeleteAllStatement(table, null, null, null, selectCallForNotExist, selectStatementForNotExist, primaryKeyFields);
                            } else {
                                SQLSelectStatement inheritanceSelectStatementForExist = this.createSQLSelectStatementForModifyAll(null, inheritanceExpression, desc);
                                SQLCall inheritanceSelectCallForExist = (SQLCall)inheritanceSelectStatementForExist.buildCall(this.getSession());
                                deleteStatement = isLastTable ? this.buildDeleteAllStatement(table, null, inheritanceSelectCallForExist, inheritanceSelectStatementForExist, null, null, primaryKeyFields) : this.buildDeleteAllStatement(table, null, inheritanceSelectCallForExist, inheritanceSelectStatementForExist, selectCallForNotExist, selectStatementForNotExist, primaryKeyFields);
                            }
                        }
                    }
                    if (this.getDescriptor().getTables().size() > 1) {
                        this.getSQLStatements().addElement(deleteStatement);
                        continue;
                    }
                    this.setSQLStatement(deleteStatement);
                }
            } else {
                this.setSQLStatement(this.buildDeleteAllStatement(this.getDescriptor().getDefaultTable(), inheritanceExpression, selectCallForExist, selectStatementForExist, null, null, null));
            }
            if (selectCallForExist == null && hasInheritance && (tablesToIgnore != null || inheritanceExpression != null)) {
                selectCallForExist = (SQLCall)selectStatementForExist.buildCall(this.getSession());
            }
            if (!(deleteStatementsForMappings = this.buildDeleteAllStatementsForMappings(selectCallForExist, selectStatementForExist, tablesToIgnore == null)).isEmpty()) {
                if (this.getSQLStatement() != null) {
                    this.getSQLStatements().add(this.getSQLStatement());
                    this.setSQLStatement(null);
                }
                this.getSQLStatements().addAll(deleteStatementsForMappings);
            }
        }
        boolean hasChildrenWithExtraTables = hasInheritance && this.getDescriptor().getInheritancePolicy().hasChildren() && this.getDescriptor().getInheritancePolicy().hasMultipleTableChild();
        boolean bl = shouldHandleChildren = hasChildrenWithExtraTables && this.getDescriptor().getInheritancePolicy().shouldReadSubclasses();
        if (shouldHandleChildren) {
            Vector<DatabaseTable> tablesToIgnoreForChildren = new Vector<DatabaseTable>();
            if (tablesToIgnore != null) {
                tablesToIgnoreForChildren.addAll(tablesToIgnore);
            }
            if (this.getDescriptor().getInheritancePolicy().shouldReadSubclasses()) {
                tablesToIgnoreForChildren.addAll(tablesInInsertOrder);
            }
            for (ClassDescriptor childDescriptor : this.getDescriptor().getInheritancePolicy().getChildDescriptors()) {
                if (childDescriptor.getTables().size() <= this.getDescriptor().getTables().size() && !childDescriptor.getInheritancePolicy().hasMultipleTableChild()) continue;
                DeleteAllQuery childQuery = new DeleteAllQuery();
                childQuery.setReferenceClass(childDescriptor.getJavaClass());
                childQuery.setSelectionCriteria(this.getSelectionCriteria());
                childQuery.setDescriptor(childDescriptor);
                childQuery.setSession(this.getSession());
                ExpressionQueryMechanism childMechanism = (ExpressionQueryMechanism)childQuery.getQueryMechanism();
                childMechanism.prepareDeleteAll(tablesToIgnoreForChildren);
                Vector<SQLStatement> childStatements = new Vector<SQLStatement>();
                if (childMechanism.getCall() != null) {
                    childStatements.add(childMechanism.getSQLStatement());
                } else if (childMechanism.getSQLStatements() != null) {
                    childStatements.addAll(childMechanism.getSQLStatements());
                }
                if (childStatements.isEmpty()) continue;
                if (this.getSQLStatement() != null) {
                    this.getSQLStatements().add(this.getSQLStatement());
                    this.setSQLStatement(null);
                }
                this.getSQLStatements().addAll(childStatements);
            }
        }
        if (tablesToIgnore == null) {
            ((DeleteAllQuery)this.getQuery()).setIsPreparedUsingTempStorage(false);
            super.prepareDeleteAll();
        }
    }

    protected void prepareDeleteAllUsingTempStorage() {
        if (!this.getSession().getPlatform().supportsTempTables()) {
            throw QueryException.tempTablesNotSupported(this.getQuery(), Helper.getShortClassName(this.getSession().getPlatform()));
        }
        this.prepareDeleteAllUsingTempTables();
    }

    protected void prepareDeleteAllUsingTempTables() {
        this.getSQLStatements().addAll(this.buildStatementsForDeleteAllForTempTables());
        ((DeleteAllQuery)this.getQuery()).setIsPreparedUsingTempStorage(true);
        super.prepareDeleteAll();
    }

    protected Vector buildDeleteAllStatementsForMappings(SQLCall selectCallForExist, SQLSelectStatement selectStatementForExist, boolean dontCheckDescriptor) {
        Vector<SQLDeleteStatement> deleteStatements = new Vector<SQLDeleteStatement>();
        for (DatabaseMapping mapping : this.getDescriptor().getMappings()) {
            if (!mapping.isManyToManyMapping() && !mapping.isDirectCollectionMapping() || !dontCheckDescriptor && !mapping.getDescriptor().equals(this.getDescriptor())) continue;
            Vector<DatabaseField> sourceFields = null;
            Vector<DatabaseField> targetFields = null;
            if (mapping.isManyToManyMapping()) {
                sourceFields = ((ManyToManyMapping)mapping).getSourceKeyFields();
                targetFields = ((ManyToManyMapping)mapping).getSourceRelationKeyFields();
            } else if (mapping.isDirectCollectionMapping()) {
                sourceFields = ((DirectCollectionMapping)mapping).getSourceKeyFields();
                targetFields = ((DirectCollectionMapping)mapping).getReferenceKeyFields();
            }
            deleteStatements.addElement(this.buildDeleteAllStatementForMapping(selectCallForExist, selectStatementForExist, sourceFields, targetFields));
        }
        return deleteStatements;
    }

    protected SQLSelectStatement createSQLSelectStatementForModifyAll(Expression whereClause) {
        return this.createSQLSelectStatementForModifyAll(whereClause, null, this.getDescriptor(), false);
    }

    protected SQLSelectStatement createSQLSelectStatementForModifyAll(Expression whereClause, Expression inheritanceExpression) {
        return this.createSQLSelectStatementForModifyAll(whereClause, inheritanceExpression, this.getDescriptor(), true);
    }

    protected SQLSelectStatement createSQLSelectStatementForModifyAll(Expression whereClause, Expression inheritanceExpression, ClassDescriptor desc) {
        return this.createSQLSelectStatementForModifyAll(whereClause, inheritanceExpression, desc, true);
    }

    protected SQLSelectStatement createSQLSelectStatementForModifyAll(Expression whereClause, Expression inheritanceExpression, ClassDescriptor desc, boolean useCustomaryInheritanceExpression) {
        ExpressionBuilder builder;
        if (whereClause != null) {
            whereClause = (Expression)whereClause.clone();
            builder = whereClause.getBuilder();
        } else {
            builder = new ExpressionBuilder();
        }
        ReportQuery reportQuery = new ReportQuery(desc.getJavaClass(), builder);
        reportQuery.setDescriptor(desc);
        reportQuery.setShouldRetrieveFirstPrimaryKey(true);
        reportQuery.setSelectionCriteria(whereClause);
        reportQuery.setSession(this.getSession());
        SQLSelectStatement selectStatement = ((ExpressionQueryMechanism)reportQuery.getQueryMechanism()).buildReportQuerySelectStatement(false, useCustomaryInheritanceExpression, inheritanceExpression);
        reportQuery.setSession(null);
        return selectStatement;
    }

    protected SQLSelectStatement createSQLSelectStatementForAssignedExpressionForUpdateAll(Expression value) {
        ReportQuery reportQuery = new ReportQuery(this.getQuery().getReferenceClass(), value.getBuilder());
        reportQuery.setDescriptor(this.getQuery().getDescriptor());
        reportQuery.setSession(this.getSession());
        reportQuery.addAttribute("", value);
        SQLSelectStatement selectStatement = ((ExpressionQueryMechanism)reportQuery.getQueryMechanism()).buildReportQuerySelectStatement(false);
        reportQuery.setSession(null);
        return selectStatement;
    }

    private List<Expression> cloneExpressions(List<Expression> originalExpressions, Map<Expression, Expression> clonedExpressions) {
        if (originalExpressions == null || originalExpressions.size() == 0 || clonedExpressions == null) {
            return originalExpressions;
        }
        ArrayList<Expression> newExpressions = new ArrayList<Expression>(originalExpressions.size());
        for (Expression expression : originalExpressions) {
            newExpressions.add(expression.copiedVersionFrom(clonedExpressions));
        }
        return newExpressions;
    }

    @Override
    public void prepareDeleteObject() {
        if (this.getDescriptor().usesFieldLocking() && this.getTranslationRow() == null) {
            return;
        }
        Enumeration<DatabaseTable> tablesEnum = this.getDescriptor().getMultipleTableInsertOrder().elements();
        while (tablesEnum.hasMoreElements()) {
            DatabaseTable table = tablesEnum.nextElement();
            SQLDeleteStatement deleteStatement = this.buildDeleteStatement(table);
            if (this.getDescriptor().getTables().size() > 1) {
                this.getSQLStatements().addElement(deleteStatement);
                continue;
            }
            this.setSQLStatement(deleteStatement);
        }
        super.prepareDeleteObject();
    }

    @Override
    public void prepareDoesExist(DatabaseField field) {
        this.setSQLStatement(this.buildSelectStatementForDoesExist(field));
        super.prepareDoesExist(field);
    }

    @Override
    public void prepareInsertObject() {
        if (this.getModifyRow() == null) {
            return;
        }
        Enumeration<DatabaseTable> tablesEnum = this.getDescriptor().getMultipleTableInsertOrder().elements();
        while (tablesEnum.hasMoreElements()) {
            DatabaseTable table = tablesEnum.nextElement();
            SQLInsertStatement insertStatement = this.buildInsertStatement(table);
            if (this.getDescriptor().getTables().size() > 1) {
                this.getSQLStatements().addElement(insertStatement);
                continue;
            }
            this.setSQLStatement(insertStatement);
        }
        super.prepareInsertObject();
    }

    @Override
    public void prepareReportQuerySelectAllRows() {
        SQLSelectStatement statement = this.buildReportQuerySelectStatement(false);
        this.setSQLStatement(statement);
        this.setCallFromStatement();
        this.setSQLStatement(null);
        this.getCall().returnManyRows();
        this.prepareCall();
    }

    @Override
    public void prepareReportQuerySubSelect() {
        this.setSQLStatement(this.buildReportQuerySelectStatement(true));
        this.setSelectionCriteria(null);
    }

    @Override
    public void prepareSelectAllRows() {
        if (!this.getDescriptor().hasInheritance() || !this.getDescriptor().getInheritancePolicy().requiresMultipleTableSubclassRead()) {
            this.setSQLStatement(this.buildNormalSelectStatement());
            super.prepareSelectAllRows();
        } else {
            InheritancePolicy policy = this.getDescriptor().getInheritancePolicy();
            if (policy.hasView()) {
                this.setSQLStatement(this.getDescriptor().getInheritancePolicy().buildViewSelectStatement((ObjectLevelReadQuery)this.getQuery()));
                super.prepareSelectAllRows();
            } else if (((ObjectLevelReadQuery)this.getQuery()).shouldOuterJoinSubclasses()) {
                this.setSQLStatement(this.buildNormalSelectStatement());
                super.prepareSelectAllRows();
            } else if (!this.getDescriptor().getInheritancePolicy().hasClassExtractor()) {
                this.setSQLStatement(this.getDescriptor().getInheritancePolicy().buildClassIndicatorSelectStatement((ObjectLevelReadQuery)this.getQuery()));
                super.prepareSelectAllRows();
            }
        }
    }

    @Override
    public void prepareSelectOneRow() {
        if (!this.getDescriptor().hasInheritance() || !this.getDescriptor().getInheritancePolicy().requiresMultipleTableSubclassRead()) {
            this.setSQLStatement(this.buildNormalSelectStatement());
            super.prepareSelectOneRow();
        } else {
            InheritancePolicy policy = this.getDescriptor().getInheritancePolicy();
            if (policy.hasView()) {
                this.setSQLStatement(this.getDescriptor().getInheritancePolicy().buildViewSelectStatement((ObjectLevelReadQuery)this.getQuery()));
                super.prepareSelectOneRow();
            } else if (((ObjectLevelReadQuery)this.getQuery()).shouldOuterJoinSubclasses()) {
                this.setSQLStatement(this.buildNormalSelectStatement());
                super.prepareSelectOneRow();
            } else if (!this.getDescriptor().getInheritancePolicy().hasClassExtractor()) {
                this.setSQLStatement(this.getDescriptor().getInheritancePolicy().buildClassIndicatorSelectStatement((ObjectLevelReadQuery)this.getQuery()));
                super.prepareSelectOneRow();
            }
        }
    }

    @Override
    public void prepareUpdateObject() {
        if (this.getModifyRow() == null) {
            return;
        }
        Vector updateCalls = this.getDescriptor().getQueryManager().getCachedUpdateCalls(this.getModifyRow().getFields());
        if (updateCalls != null) {
            int updateCallsSize = updateCalls.size();
            if (updateCallsSize == 1) {
                DatasourceCall existingCall = (DatasourceCall)updateCalls.get(0);
                DatasourceCall clonedCall = (DatasourceCall)existingCall.clone();
                this.setCall(clonedCall);
            } else {
                Vector<Object> clonedCalls = new Vector<Object>(updateCallsSize);
                for (int i = 0; i < updateCallsSize; ++i) {
                    DatasourceCall existingCall = (DatasourceCall)updateCalls.get(i);
                    clonedCalls.add(existingCall.clone());
                }
                this.setCalls(clonedCalls);
            }
            return;
        }
        int tablesSize = this.getDescriptor().getTables().size();
        for (int index = 0; index < tablesSize; ++index) {
            DatabaseTable table = this.getDescriptor().getTables().get(index);
            SQLUpdateStatement updateStatement = this.buildUpdateStatement(table);
            if (tablesSize > 1) {
                this.getSQLStatements().addElement(updateStatement);
                continue;
            }
            this.setSQLStatement(updateStatement);
        }
        super.prepareUpdateObject();
        if (this.hasMultipleCalls()) {
            updateCalls = this.getCalls();
        } else {
            updateCalls = NonSynchronizedVector.newInstance(1);
            if (this.getCall() != null) {
                updateCalls.add(this.getCall());
            }
        }
        this.getDescriptor().getQueryManager().putCachedUpdateCalls(this.getModifyRow().getFields(), updateCalls);
    }

    @Override
    public void prepareUpdateAll() {
        ExpressionBuilder builder = ((UpdateAllQuery)this.getQuery()).getExpressionBuilder();
        HashMap updateClauses = ((UpdateAllQuery)this.getQuery()).getUpdateClauses();
        OptimisticLockingPolicy policy = this.getDescriptor().getOptimisticLockingPolicy();
        if (policy != null && policy.getWriteLockField() != null) {
            Expression writeLock = builder.getField(policy.getWriteLockField());
            Expression writeLockUpdateExpression = policy.getWriteLockUpdateExpression(builder, this.getQuery().getSession());
            if (writeLockUpdateExpression != null) {
                updateClauses = (HashMap)updateClauses.clone();
                updateClauses.put(writeLock, writeLockUpdateExpression);
            }
        }
        HashMap tables_databaseFieldsToValues = new HashMap();
        HashMap<DatabaseTable, Collection> tablesToPrimaryKeyFields = new HashMap<DatabaseTable, Collection>();
        for (Map.Entry entry : updateClauses.entrySet()) {
            int i;
            NonSynchronizedVector baseExpressions;
            NonSynchronizedVector values;
            int fieldsSize;
            Vector fields;
            Object fieldObject = entry.getKey();
            DataExpression fieldExpression = null;
            Expression baseExpression = null;
            String attributeName = null;
            if (fieldObject instanceof String) {
                attributeName = (String)fieldObject;
            } else {
                fieldExpression = (DataExpression)fieldObject;
            }
            DatabaseField field = null;
            DatabaseMapping mapping = null;
            if (attributeName != null) {
                mapping = this.getDescriptor().getObjectBuilder().getMappingForAttributeName(attributeName);
                if (mapping != null && !mapping.getFields().isEmpty()) {
                    field = mapping.getFields().get(0);
                }
                if (field == null) {
                    throw QueryException.updateAllQueryAddUpdateDoesNotDefineField(this.getDescriptor(), this.getQuery(), attributeName);
                }
                baseExpression = ((UpdateAllQuery)this.getQuery()).getExpressionBuilder().get(attributeName);
            } else if (fieldExpression != null) {
                if (fieldExpression.getBaseExpression() instanceof ExpressionBuilder) {
                    field = this.getDescriptor().getObjectBuilder().getFieldForQueryKeyName(fieldExpression.getName());
                }
                if (field == null) {
                    DataExpression fieldExpressionClone = (DataExpression)fieldExpression.clone();
                    fieldExpressionClone.getBuilder().setQueryClass(this.getQuery().getReferenceClass());
                    fieldExpressionClone.getBuilder().setSession(this.getSession().getRootSession(null));
                    field = fieldExpressionClone.getField();
                    if (field == null) {
                        throw QueryException.updateAllQueryAddUpdateDoesNotDefineField(this.getDescriptor(), this.getQuery(), fieldExpression.toString());
                    }
                }
                mapping = this.getDescriptor().getObjectBuilder().getMappingForField(field);
                baseExpression = fieldExpression;
            }
            Object valueObject = entry.getValue();
            if (mapping != null && mapping.isOneToOneMapping()) {
                fields = mapping.getFields();
                fieldsSize = fields.size();
                values = NonSynchronizedVector.newInstance(fieldsSize);
                baseExpressions = NonSynchronizedVector.newInstance(fieldsSize);
                for (i = 0; i < fieldsSize; ++i) {
                    if (valueObject instanceof ConstantExpression) {
                        valueObject = ((ConstantExpression)valueObject).getValue();
                    }
                    if (valueObject == null) {
                        ((Vector)values).add(null);
                    } else {
                        DatabaseField targetField = ((OneToOneMapping)mapping).getSourceToTargetKeyFields().get(fields.get(i));
                        if (valueObject instanceof Expression) {
                            Expression exp = ((Expression)((Expression)valueObject).clone()).getField(targetField);
                            if (exp.isParameterExpression()) {
                                ((ParameterExpression)exp).setType(targetField.getType());
                            }
                            ((Vector)values).add(exp);
                        } else {
                            ((Vector)values).add(((OneToOneMapping)mapping).getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(valueObject, targetField, this.getSession()));
                        }
                    }
                    ((Vector)baseExpressions).add(new FieldExpression((DatabaseField)fields.elementAt(i), ((QueryKeyExpression)baseExpression).getBaseExpression()));
                }
            } else {
                fields = NonSynchronizedVector.newInstance(1);
                fields.add(field);
                values = NonSynchronizedVector.newInstance(1);
                ((Vector)values).add(valueObject);
                baseExpressions = NonSynchronizedVector.newInstance(1);
                ((Vector)baseExpressions).add(baseExpression);
            }
            fieldsSize = fields.size();
            for (i = 0; i < fieldsSize; ++i) {
                field = (DatabaseField)fields.elementAt(i);
                DatabaseTable table = field.getTable();
                if (!this.getDescriptor().getTables().contains(table)) {
                    if (attributeName != null) {
                        throw QueryException.updateAllQueryAddUpdateDefinesWrongField(this.getDescriptor(), this.getQuery(), attributeName, field.getQualifiedName());
                    }
                    throw QueryException.updateAllQueryAddUpdateDefinesWrongField(this.getDescriptor(), this.getQuery(), fieldExpression.toString(), field.getQualifiedName());
                }
                HashMap<DatabaseField, Expression> databaseFieldsToValues = (HashMap<DatabaseField, Expression>)tables_databaseFieldsToValues.get(table);
                if (databaseFieldsToValues == null) {
                    databaseFieldsToValues = new HashMap<DatabaseField, Expression>();
                    tables_databaseFieldsToValues.put(table, databaseFieldsToValues);
                    tablesToPrimaryKeyFields.put(table, this.getPrimaryKeyFieldsForTable(table));
                }
                Object value = ((Vector)values).elementAt(i);
                Expression valueExpression = valueObject instanceof Expression ? (Expression)value : builder.value(value);
                if (valueExpression.isValueExpression()) {
                    valueExpression.setLocalBase((Expression)((Vector)baseExpressions).elementAt(i));
                }
                databaseFieldsToValues.put(field, valueExpression);
            }
        }
        SQLCall selectCallForExist = null;
        SQLSelectStatement selectStatementForExist = this.createSQLSelectStatementForModifyAll(this.getSelectionCriteria());
        boolean isMainCase = selectStatementForExist.requiresAliases();
        if (isMainCase && this.getSession().getPlatform().shouldAlwaysUseTempStorageForModifyAll()) {
            this.prepareUpdateAllUsingTempStorage(tables_databaseFieldsToValues, tablesToPrimaryKeyFields);
            return;
        }
        selectCallForExist = (SQLCall)selectStatementForExist.buildCall(this.getSession());
        ExpressionIterator expRequiresSelectIterator = new ExpressionIterator(){

            public void iterate(Expression each) {
                if (this.getResult() == null) {
                    return;
                }
                if (each instanceof DataExpression) {
                    DatabaseField field;
                    DataExpression dataExpression = (DataExpression)each;
                    Expression baseExpression = dataExpression.getBaseExpression();
                    if (baseExpression != null && !(baseExpression instanceof ExpressionBuilder)) {
                        DataExpression baseDataExpression;
                        boolean stop = true;
                        if (baseExpression instanceof DataExpression && (baseDataExpression = (DataExpression)baseExpression).getMapping() != null && baseDataExpression.getMapping().isAggregateObjectMapping()) {
                            stop = false;
                        }
                        if (stop) {
                            this.setResult(null);
                            return;
                        }
                    }
                    if ((field = dataExpression.getField()) != null && !field.getTable().equals((DatabaseTable)this.getResult())) {
                        this.setResult(null);
                        return;
                    }
                }
            }

            public boolean shouldIterateOverSubSelects() {
                return true;
            }
        };
        HashMap tables_databaseFieldsToValuesCopy = new HashMap();
        for (Map.Entry entry : tables_databaseFieldsToValues.entrySet()) {
            DatabaseTable table = (DatabaseTable)entry.getKey();
            HashMap databaseFieldsToValues = (HashMap)entry.getValue();
            HashMap<DatabaseField, Cloneable> databaseFieldsToValuesCopy = new HashMap<DatabaseField, Cloneable>();
            tables_databaseFieldsToValuesCopy.put(table, databaseFieldsToValuesCopy);
            for (Map.Entry entry2 : databaseFieldsToValues.entrySet()) {
                DatabaseField field = (DatabaseField)entry2.getKey();
                Expression value = (Expression)entry2.getValue();
                expRequiresSelectIterator.setResult(table);
                Expression valueClone = (Expression)value.clone();
                valueClone.getBuilder().setSession(this.getSession());
                valueClone.getBuilder().setQueryClass(this.getQuery().getReferenceClass());
                expRequiresSelectIterator.iterateOn(valueClone);
                if (expRequiresSelectIterator.getResult() == null) {
                    if (this.getSession().getPlatform().shouldAlwaysUseTempStorageForModifyAll()) {
                        this.prepareUpdateAllUsingTempStorage(tables_databaseFieldsToValues, tablesToPrimaryKeyFields);
                        return;
                    }
                    SQLSelectStatement selStatement = this.createSQLSelectStatementForAssignedExpressionForUpdateAll(value);
                    databaseFieldsToValuesCopy.put(field, selStatement);
                    continue;
                }
                databaseFieldsToValuesCopy.put(field, valueClone);
            }
        }
        HashMap tables_databaseFieldsToValuesOriginal = tables_databaseFieldsToValues;
        tables_databaseFieldsToValues = tables_databaseFieldsToValuesCopy;
        if (tables_databaseFieldsToValues.size() == 1) {
            Map.Entry entry = tables_databaseFieldsToValues.entrySet().iterator().next();
            DatabaseTable table = (DatabaseTable)entry.getKey();
            HashMap databaseFieldsToValues = (HashMap)entry.getValue();
            Collection primaryKeyFields = (Collection)tablesToPrimaryKeyFields.values().iterator().next();
            this.setSQLStatement(this.buildUpdateAllStatement(table, databaseFieldsToValues, selectCallForExist, selectStatementForExist, primaryKeyFields));
        } else {
            ExpressionIterator expIterator = new ExpressionIterator(){

                public void iterate(Expression each) {
                    DataExpression dataExpression;
                    DatabaseField field;
                    if (each instanceof DataExpression && (field = (dataExpression = (DataExpression)each).getField()) != null) {
                        ((Collection)this.getResult()).add(field);
                    }
                }

                public boolean shouldIterateOverSubSelects() {
                    return true;
                }
            };
            HashSet selectCallForExistFields = new HashSet();
            if (selectCallForExist != null) {
                expIterator.setResult(selectCallForExistFields);
                expIterator.iterateOn(selectStatementForExist.getWhereClause());
            }
            HashMap tablesToLeftFields = new HashMap();
            HashMap<DatabaseTable, HashSet> tablesToRightFields = new HashMap<DatabaseTable, HashSet>();
            NonSynchronizedVector beforeTables = NonSynchronizedVector.newInstance();
            NonSynchronizedVector afterTables = NonSynchronizedVector.newInstance();
            HashMap<DatabaseTable, DatabaseTable> simpleConflicts = new HashMap<DatabaseTable, DatabaseTable>();
            for (Map.Entry entry : tables_databaseFieldsToValues.entrySet()) {
                DatabaseTable table = (DatabaseTable)entry.getKey();
                HashMap databaseFieldsToValues = (HashMap)entry.getValue();
                HashSet<DatabaseField> leftFields = new HashSet<DatabaseField>(databaseFieldsToValues.size());
                HashSet rightFields = (HashSet)selectCallForExistFields.clone();
                expIterator.setResult(rightFields);
                for (Map.Entry databaseFieldValueEntry : databaseFieldsToValues.entrySet()) {
                    DatabaseField field = (DatabaseField)databaseFieldValueEntry.getKey();
                    leftFields.add(field);
                    Object value = databaseFieldValueEntry.getValue();
                    if (value instanceof Expression) {
                        Expression valueExpression = (Expression)value;
                        expIterator.iterateOn(valueExpression);
                        continue;
                    }
                    SQLSelectStatement selStatement = (SQLSelectStatement)value;
                    expIterator.iterateOn((Expression)selStatement.getFields().elementAt(0));
                    expIterator.iterateOn(selStatement.getWhereClause());
                }
                for (DatabaseTable processedTable : tablesToLeftFields.keySet()) {
                    HashSet processedTableLeftFields = (HashSet)tablesToLeftFields.get(processedTable);
                    HashSet processedTableRightFields = (HashSet)tablesToRightFields.get(processedTable);
                    boolean tableBeforeProcessedTable = false;
                    Iterator itProcessedTableLeftField = processedTableLeftFields.iterator();
                    while (itProcessedTableLeftField.hasNext()) {
                        if (!rightFields.contains(itProcessedTableLeftField.next())) continue;
                        tableBeforeProcessedTable = true;
                        break;
                    }
                    boolean processedTableBeforeTable = false;
                    Iterator itLeftField = leftFields.iterator();
                    while (itLeftField.hasNext()) {
                        if (!processedTableRightFields.contains(itLeftField.next())) continue;
                        processedTableBeforeTable = true;
                        break;
                    }
                    if (tableBeforeProcessedTable && !processedTableBeforeTable) {
                        ((Vector)beforeTables).add(table);
                        ((Vector)afterTables).add(processedTable);
                        continue;
                    }
                    if (!tableBeforeProcessedTable && processedTableBeforeTable) {
                        ((Vector)beforeTables).add(processedTable);
                        ((Vector)afterTables).add(table);
                        continue;
                    }
                    if (!tableBeforeProcessedTable || !processedTableBeforeTable) continue;
                    simpleConflicts.put(processedTable, table);
                }
                tablesToLeftFields.put(table, leftFields);
                tablesToRightFields.put(table, rightFields);
            }
            if (!simpleConflicts.isEmpty()) {
                this.prepareUpdateAllUsingTempStorage(tables_databaseFieldsToValuesOriginal, tablesToPrimaryKeyFields);
                return;
            }
            NonSynchronizedVector orderedTables = NonSynchronizedVector.newInstance(tables_databaseFieldsToValues.size());
            while (!((Vector)beforeTables).isEmpty()) {
                int i;
                DatabaseTable firstTable = null;
                for (i = 0; i < ((Vector)beforeTables).size(); ++i) {
                    DatabaseTable beforeTable = (DatabaseTable)((Vector)beforeTables).elementAt(i);
                    if (afterTables.contains(beforeTable)) continue;
                    firstTable = beforeTable;
                    break;
                }
                if (firstTable == null) {
                    this.prepareUpdateAllUsingTempStorage(tables_databaseFieldsToValuesOriginal, tablesToPrimaryKeyFields);
                    return;
                }
                for (i = ((Vector)beforeTables).size() - 1; i >= 0; --i) {
                    if (!((Vector)beforeTables).elementAt(i).equals(firstTable)) continue;
                    ((Vector)beforeTables).remove(i);
                    ((Vector)afterTables).remove(i);
                }
                ((Vector)orderedTables).addElement(firstTable);
            }
            for (DatabaseTable table : tables_databaseFieldsToValues.keySet()) {
                if (orderedTables.contains(table)) continue;
                ((Vector)orderedTables).add(table);
            }
            for (int i = 0; i < ((Vector)orderedTables).size(); ++i) {
                DatabaseTable table = (DatabaseTable)((Vector)orderedTables).elementAt(i);
                HashMap databaseFieldsToValues = (HashMap)tables_databaseFieldsToValues.get(table);
                Collection primaryKeyFields = (Collection)tablesToPrimaryKeyFields.get(table);
                this.getSQLStatements().addElement(this.buildUpdateAllStatement(table, databaseFieldsToValues, selectCallForExist, selectStatementForExist, primaryKeyFields));
            }
        }
        ((UpdateAllQuery)this.getQuery()).setIsPreparedUsingTempStorage(false);
        super.prepareUpdateAll();
    }

    protected SQLSelectStatement createSQLSelectStatementForUpdateAllForOracleAnonymousBlock(HashMap tables_databaseFieldsToValues) {
        ExpressionBuilder builder = ((UpdateAllQuery)this.getQuery()).getExpressionBuilder();
        Expression whereClause = this.getSelectionCriteria();
        ReportQuery reportQuery = new ReportQuery(this.getDescriptor().getJavaClass(), builder);
        reportQuery.setDescriptor(this.getDescriptor());
        reportQuery.setSelectionCriteria(whereClause);
        reportQuery.setSession(this.getSession());
        reportQuery.setShouldRetrievePrimaryKeys(true);
        for (HashMap databaseFieldsToValues : tables_databaseFieldsToValues.values()) {
            Iterator itValues = databaseFieldsToValues.values().iterator();
            while (itValues.hasNext()) {
                reportQuery.addAttribute("", (Expression)itValues.next());
            }
        }
        SQLSelectStatement selectStatement = ((ExpressionQueryMechanism)reportQuery.getQueryMechanism()).buildReportQuerySelectStatement(false);
        reportQuery.setSession(null);
        return selectStatement;
    }

    protected SQLSelectStatement createSQLSelectStatementForModifyAllForTempTable(HashMap databaseFieldsToValues) {
        ExpressionBuilder builder = ((ModifyAllQuery)this.getQuery()).getExpressionBuilder();
        Expression whereClause = this.getSelectionCriteria();
        ReportQuery reportQuery = new ReportQuery(this.getDescriptor().getJavaClass(), builder);
        reportQuery.setDescriptor(this.getDescriptor());
        reportQuery.setSelectionCriteria(whereClause);
        reportQuery.setSession(this.getSession());
        reportQuery.setShouldRetrievePrimaryKeys(true);
        if (databaseFieldsToValues != null) {
            Iterator itValues = databaseFieldsToValues.values().iterator();
            while (itValues.hasNext()) {
                reportQuery.addAttribute("", (Expression)itValues.next());
            }
        }
        SQLSelectStatement selectStatement = ((ExpressionQueryMechanism)reportQuery.getQueryMechanism()).buildReportQuerySelectStatement(false);
        reportQuery.setSession(null);
        return selectStatement;
    }

    protected SQLModifyStatement buildUpdateAllStatementForOracleAnonymousBlock(HashMap tables_databaseFieldsToValues, HashMap tablesToPrimaryKeyFields) {
        SQLSelectStatement selectStatement = this.createSQLSelectStatementForUpdateAllForOracleAnonymousBlock(tables_databaseFieldsToValues);
        SQLCall selectCall = (SQLCall)selectStatement.buildCall(this.getSession());
        SQLUpdateAllStatementForOracleAnonymousBlock updateAllStatement = new SQLUpdateAllStatementForOracleAnonymousBlock();
        updateAllStatement.setTranslationRow(this.getTranslationRow());
        updateAllStatement.setSelectCall(selectCall);
        updateAllStatement.setTables_databaseFieldsToValues(tables_databaseFieldsToValues);
        updateAllStatement.setTablesToPrimaryKeyFields(tablesToPrimaryKeyFields);
        updateAllStatement.setTable(this.getDescriptor().getTables().firstElement());
        return updateAllStatement;
    }

    protected void prepareUpdateAllUsingTempStorage(HashMap tables_databaseFieldsToValues, HashMap tablesToPrimaryKeyFields) {
        if (this.getSession().getPlatform().supportsTempTables()) {
            this.prepareUpdateAllUsingTempTables(tables_databaseFieldsToValues, tablesToPrimaryKeyFields);
        } else if (this.getSession().getPlatform().isOracle()) {
            this.prepareUpdateAllUsingOracleAnonymousBlock(tables_databaseFieldsToValues, tablesToPrimaryKeyFields);
        } else {
            throw QueryException.tempTablesNotSupported(this.getQuery(), Helper.getShortClassName(this.getSession().getPlatform()));
        }
    }

    protected void prepareUpdateAllUsingOracleAnonymousBlock(HashMap tables_databaseFieldsToValues, HashMap tablesToPrimaryKeyFields) {
        this.setSQLStatement(this.buildUpdateAllStatementForOracleAnonymousBlock(tables_databaseFieldsToValues, tablesToPrimaryKeyFields));
        ((UpdateAllQuery)this.getQuery()).setIsPreparedUsingTempStorage(true);
        super.prepareUpdateAll();
    }

    protected void prepareUpdateAllUsingTempTables(HashMap tables_databaseFieldsToValues, HashMap tablesToPrimaryKeyFields) {
        int nTables = tables_databaseFieldsToValues.size();
        NonSynchronizedVector createTableStatements = NonSynchronizedVector.newInstance(nTables);
        NonSynchronizedVector selectStatements = NonSynchronizedVector.newInstance(nTables);
        NonSynchronizedVector updateStatements = NonSynchronizedVector.newInstance(nTables);
        NonSynchronizedVector cleanupStatements = NonSynchronizedVector.newInstance(nTables);
        for (Map.Entry entry : tables_databaseFieldsToValues.entrySet()) {
            DatabaseTable table = (DatabaseTable)entry.getKey();
            HashMap databaseFieldsToValues = (HashMap)entry.getValue();
            Collection primaryKeyFields = (Collection)tablesToPrimaryKeyFields.get(table);
            Vector statementsForTable = this.buildStatementsForUpdateAllForTempTables(table, databaseFieldsToValues, primaryKeyFields);
            ((Vector)createTableStatements).add(statementsForTable.elementAt(0));
            ((Vector)selectStatements).add(statementsForTable.elementAt(1));
            ((Vector)updateStatements).add(statementsForTable.elementAt(2));
            ((Vector)cleanupStatements).add(statementsForTable.elementAt(3));
        }
        this.getSQLStatements().addAll(createTableStatements);
        this.getSQLStatements().addAll(selectStatements);
        this.getSQLStatements().addAll(updateStatements);
        this.getSQLStatements().addAll(cleanupStatements);
        if (this.getSession().getPlatform().dontBindUpdateAllQueryUsingTempTables() && (this.getQuery().shouldBindAllParameters() || this.getQuery().shouldIgnoreBindAllParameters() && this.getSession().getPlatform().shouldBindAllParameters())) {
            this.getQuery().setShouldBindAllParameters(false);
            this.getSession().warning("update_all_query_cannot_use_binding_on_this_platform", "query");
        }
        ((UpdateAllQuery)this.getQuery()).setIsPreparedUsingTempStorage(true);
        super.prepareUpdateAll();
    }

    protected Vector buildStatementsForDeleteAllForTempTables() {
        NonSynchronizedVector statements = NonSynchronizedVector.newInstance();
        DatabaseTable rootTable = this.getDescriptor().getMultipleTableInsertOrder().firstElement();
        Collection rootTablePrimaryKeyFields = this.getPrimaryKeyFieldsForTable(rootTable);
        ClassDescriptor rootDescriptor = this.getDescriptor();
        if (this.getDescriptor().hasInheritance()) {
            rootDescriptor = rootDescriptor.getInheritancePolicy().getRootParentDescriptor();
        }
        NonSynchronizedVector allFields = NonSynchronizedVector.newInstance();
        for (DatabaseField field : rootDescriptor.getFields()) {
            if (!rootTable.equals(field.getTable())) continue;
            ((Vector)allFields).add(field);
        }
        SQLDeleteAllStatementForTempTable cleanupStatement = new SQLDeleteAllStatementForTempTable();
        cleanupStatement.setMode(3);
        cleanupStatement.setTable(rootTable);
        ((Vector)statements).addElement(cleanupStatement);
        Vector deleteStatements = this.buildDeleteAllStatementsForTempTable(this.getDescriptor(), rootTable, rootTablePrimaryKeyFields, null);
        ((Vector)statements).addAll(deleteStatements);
        SQLSelectStatement selectStatement = this.createSQLSelectStatementForModifyAllForTempTable(null);
        SQLCall selectCall = (SQLCall)selectStatement.buildCall(this.getSession());
        SQLDeleteAllStatementForTempTable insertStatement = new SQLDeleteAllStatementForTempTable();
        insertStatement.setMode(1);
        insertStatement.setTable(rootTable);
        insertStatement.setTranslationRow(this.getTranslationRow());
        insertStatement.setSelectCall(selectCall);
        insertStatement.setPrimaryKeyFields(rootTablePrimaryKeyFields);
        ((Vector)statements).addElement(insertStatement);
        SQLDeleteAllStatementForTempTable createTempTableStatement = new SQLDeleteAllStatementForTempTable();
        createTempTableStatement.setMode(0);
        createTempTableStatement.setTable(rootTable);
        createTempTableStatement.setAllFields(allFields);
        createTempTableStatement.setPrimaryKeyFields(rootTablePrimaryKeyFields);
        ((Vector)statements).addElement(createTempTableStatement);
        return statements;
    }

    private Vector buildDeleteAllStatementsForTempTable(ClassDescriptor descriptor, DatabaseTable rootTable, Collection rootTablePrimaryKeyFields, Vector tablesToIgnore) {
        boolean shouldHandleChildren;
        Vector<DatabaseTable> tablesInInsertOrder;
        NonSynchronizedVector statements = NonSynchronizedVector.newInstance();
        if (tablesToIgnore == null) {
            tablesInInsertOrder = descriptor.getMultipleTableInsertOrder();
        } else {
            tablesInInsertOrder = new Vector(descriptor.getMultipleTableInsertOrder().size());
            for (DatabaseTable table : descriptor.getMultipleTableInsertOrder()) {
                if (tablesToIgnore.contains(table)) continue;
                tablesInInsertOrder.addElement(table);
            }
        }
        if (!tablesInInsertOrder.isEmpty()) {
            for (DatabaseTable table : tablesInInsertOrder) {
                SQLDeleteAllStatementForTempTable deleteStatement = this.buildDeleteAllStatementForTempTable(rootTable, rootTablePrimaryKeyFields, table, this.getPrimaryKeyFieldsForTable(descriptor, table));
                ((Vector)statements).addElement(deleteStatement);
            }
            Vector deleteStatementsForMappings = this.buildDeleteAllStatementsForMappingsWithTempTable(descriptor, rootTable, rootTablePrimaryKeyFields, tablesToIgnore == null);
            ((Vector)statements).addAll(deleteStatementsForMappings);
        }
        boolean hasChildrenWithExtraTables = descriptor.hasInheritance() && descriptor.getInheritancePolicy().hasChildren() && descriptor.getInheritancePolicy().hasMultipleTableChild();
        boolean bl = shouldHandleChildren = hasChildrenWithExtraTables && descriptor.getInheritancePolicy().shouldReadSubclasses();
        if (shouldHandleChildren) {
            Vector<DatabaseTable> tablesToIgnoreForChildren = new Vector<DatabaseTable>();
            if (tablesToIgnore != null) {
                tablesToIgnoreForChildren.addAll(tablesToIgnore);
            }
            if (descriptor.getInheritancePolicy().shouldReadSubclasses()) {
                tablesToIgnoreForChildren.addAll(tablesInInsertOrder);
            }
            for (ClassDescriptor childDescriptor : descriptor.getInheritancePolicy().getChildDescriptors()) {
                if (childDescriptor.getTables().size() <= descriptor.getTables().size() && !childDescriptor.getInheritancePolicy().hasMultipleTableChild()) continue;
                Vector childStatements = this.buildDeleteAllStatementsForTempTable(childDescriptor, rootTable, rootTablePrimaryKeyFields, tablesToIgnoreForChildren);
                ((Vector)statements).addAll(childStatements);
            }
        }
        return statements;
    }

    private SQLDeleteAllStatementForTempTable buildDeleteAllStatementForTempTable(DatabaseTable rootTable, Collection rootTablePrimaryKeyFields, DatabaseTable targetTable, Collection targetTablePrimaryKeyFields) {
        SQLDeleteAllStatementForTempTable deleteStatement = new SQLDeleteAllStatementForTempTable();
        deleteStatement.setMode(2);
        deleteStatement.setTable(rootTable);
        deleteStatement.setPrimaryKeyFields(rootTablePrimaryKeyFields);
        deleteStatement.setTargetTable(targetTable);
        deleteStatement.setTargetPrimaryKeyFields(targetTablePrimaryKeyFields);
        return deleteStatement;
    }

    protected Vector buildStatementsForUpdateAllForTempTables(DatabaseTable table, HashMap databaseFieldsToValues, Collection primaryKeyFields) {
        NonSynchronizedVector statements = NonSynchronizedVector.newInstance(4);
        NonSynchronizedVector allFields = NonSynchronizedVector.newInstance();
        for (DatabaseField field : this.getDescriptor().getFields()) {
            if (!table.equals(field.getTable())) continue;
            ((Vector)allFields).add(field);
        }
        Set assignedFields = databaseFieldsToValues.keySet();
        HashMap databaseFieldsToValuesForInsert = databaseFieldsToValues;
        Set assignedFieldsForInsert = assignedFields;
        if (!this.getSession().getPlatform().isNullAllowedInSelectClause()) {
            databaseFieldsToValuesForInsert = new HashMap(databaseFieldsToValues.size());
            for (Map.Entry entry : databaseFieldsToValues.entrySet()) {
                ConstantExpression constExp;
                if (entry.getValue() instanceof ConstantExpression && (constExp = (ConstantExpression)entry.getValue()).getValue() == null) continue;
                databaseFieldsToValuesForInsert.put(entry.getKey(), entry.getValue());
            }
            assignedFieldsForInsert = databaseFieldsToValuesForInsert.keySet();
        }
        SQLUpdateAllStatementForTempTable createTempTableStatement = new SQLUpdateAllStatementForTempTable();
        createTempTableStatement.setMode(0);
        createTempTableStatement.setTable(table);
        createTempTableStatement.setAllFields(allFields);
        createTempTableStatement.setAssignedFields(assignedFields);
        createTempTableStatement.setPrimaryKeyFields(primaryKeyFields);
        ((Vector)statements).addElement(createTempTableStatement);
        SQLSelectStatement selectStatement = this.createSQLSelectStatementForModifyAllForTempTable(databaseFieldsToValuesForInsert);
        SQLCall selectCall = (SQLCall)selectStatement.buildCall(this.getSession(), this.getQuery());
        SQLUpdateAllStatementForTempTable insertStatement = new SQLUpdateAllStatementForTempTable();
        insertStatement.setMode(1);
        insertStatement.setTable(table);
        insertStatement.setTranslationRow(this.getTranslationRow());
        insertStatement.setSelectCall(selectCall);
        insertStatement.setAssignedFields(assignedFieldsForInsert);
        insertStatement.setPrimaryKeyFields(primaryKeyFields);
        ((Vector)statements).addElement(insertStatement);
        SQLUpdateAllStatementForTempTable updateStatement = new SQLUpdateAllStatementForTempTable();
        updateStatement.setMode(2);
        updateStatement.setTable(table);
        updateStatement.setTranslationRow(this.getTranslationRow());
        updateStatement.setAssignedFields(assignedFields);
        updateStatement.setPrimaryKeyFields(primaryKeyFields);
        ((Vector)statements).addElement(updateStatement);
        SQLUpdateAllStatementForTempTable cleanupStatement = new SQLUpdateAllStatementForTempTable();
        cleanupStatement.setMode(3);
        cleanupStatement.setTable(table);
        ((Vector)statements).addElement(cleanupStatement);
        return statements;
    }

    protected Collection getPrimaryKeyFieldsForTable(DatabaseTable table) {
        return this.getPrimaryKeyFieldsForTable(this.getDescriptor(), table);
    }

    protected Collection getPrimaryKeyFieldsForTable(ClassDescriptor descriptor, DatabaseTable table) {
        Collection<DatabaseField> primaryKeyFields = table.equals(descriptor.getTables().firstElement()) ? descriptor.getPrimaryKeyFields() : descriptor.getAdditionalTablePrimaryKeyFields().get(table).values();
        return primaryKeyFields;
    }

    @Override
    public Vector selectAllReportQueryRows() throws DatabaseException {
        return this.selectAllRowsFromTable();
    }

    @Override
    public Vector selectAllRows() throws DatabaseException {
        ClassDescriptor descriptor;
        if (!((ObjectLevelReadQuery)this.query).shouldOuterJoinSubclasses() && (descriptor = this.getDescriptor()).hasInheritance() && descriptor.getInheritancePolicy().requiresMultipleTableSubclassRead() && !descriptor.getInheritancePolicy().hasView()) {
            return descriptor.getInheritancePolicy().selectAllRowUsingMultipleTableSubclassRead((ReadAllQuery)this.query);
        }
        return this.selectAllRowsFromTable();
    }

    public Vector selectAllRowsFromConcreteTable() throws DatabaseException {
        ObjectLevelReadQuery query = (ObjectLevelReadQuery)this.query;
        boolean shouldPrepare = query.shouldPrepare();
        DatabaseCall call = null;
        if (shouldPrepare) {
            call = query.getConcreteSubclassCalls().get(query.getReferenceClass());
        }
        if (call == null) {
            AbstractRecord translationRow = query.getTranslationRow();
            if (shouldPrepare) {
                query.setTranslationRow(null);
            }
            this.setSQLStatement(this.buildConcreteSelectStatement());
            super.prepareSelectAllRows();
            if (shouldPrepare) {
                query.getConcreteSubclassCalls().put(query.getReferenceClass(), (DatabaseCall)this.call);
                query.setTranslationRow(translationRow);
            }
        } else {
            this.setCall(call);
        }
        return super.selectAllRows();
    }

    public Vector selectAllRowsFromTable() throws DatabaseException {
        return super.selectAllRows();
    }

    @Override
    public AbstractRecord selectOneRow() throws DatabaseException {
        ClassDescriptor descriptor;
        if (!this.getReadObjectQuery().shouldOuterJoinSubclasses() && (descriptor = this.getDescriptor()).hasInheritance() && descriptor.getInheritancePolicy().requiresMultipleTableSubclassRead() && !descriptor.getInheritancePolicy().hasView()) {
            return descriptor.getInheritancePolicy().selectOneRowUsingMultipleTableSubclassRead((ReadObjectQuery)this.query);
        }
        return this.selectOneRowFromTable();
    }

    public AbstractRecord selectOneRowFromConcreteTable() throws DatabaseException {
        ObjectLevelReadQuery query = (ObjectLevelReadQuery)this.query;
        DatabaseCall call = query.getConcreteSubclassCalls().get(query.getReferenceClass());
        if (call == null) {
            this.setSQLStatement(this.buildConcreteSelectStatement());
            super.prepareSelectOneRow();
            query.getConcreteSubclassCalls().put(query.getReferenceClass(), (DatabaseCall)this.call);
        } else {
            this.setCall(call);
        }
        return super.selectOneRow();
    }

    public AbstractRecord selectOneRowFromTable() throws DatabaseException {
        return super.selectOneRow();
    }

    public void setSelectionCriteria(Expression expression) {
        this.selectionCriteria = expression;
    }

    protected ClassDescriptor getHighestDescriptorMappingTable(DatabaseTable table) {
        ClassDescriptor desc = this.getDescriptor();
        ClassDescriptor parentDescriptor = this.getDescriptor().getInheritancePolicy().getParentDescriptor();
        while (parentDescriptor != null && parentDescriptor.getTables().contains(table)) {
            desc = parentDescriptor;
            parentDescriptor = parentDescriptor.getInheritancePolicy().getParentDescriptor();
        }
        return desc;
    }
}

