/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.ObjectReferenceChangeRecord;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.RelationalMapping;
import org.eclipse.persistence.mappings.TypedAssociation;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.mappings.querykeys.DirectQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;

public class VariableOneToOneMapping
extends ObjectReferenceMapping
implements RelationalMapping {
    protected DatabaseField typeField;
    protected Map sourceToTargetQueryKeyNames;
    protected Map typeIndicatorTranslation;
    protected Map typeIndicatorNameTranslation;

    public VariableOneToOneMapping() {
        this.selectionQuery = new ReadObjectQuery();
        this.sourceToTargetQueryKeyNames = new HashMap(2);
        this.typeIndicatorTranslation = new HashMap(5);
        this.typeIndicatorNameTranslation = new HashMap(5);
        this.foreignKeyFields = NonSynchronizedVector.newInstance(1);
        this.isForeignKeyRelationship = false;
    }

    public boolean isRelationalMapping() {
        return true;
    }

    public void addClassIndicator(Class implementer, Object typeIndicator) {
        if (typeIndicator == null) {
            typeIndicator = Helper.getNullWrapper();
        }
        this.getTypeIndicatorTranslation().put(implementer, typeIndicator);
        this.getTypeIndicatorTranslation().put(typeIndicator, implementer);
    }

    public void addClassNameIndicator(String className, Object typeIndicator) {
        if (typeIndicator == null) {
            typeIndicator = Helper.getNullWrapper();
        }
        this.getTypeIndicatorNameTranslation().put(className, typeIndicator);
    }

    public void addForeignQueryKeyName(DatabaseField sourceForeignKeyField, String targetQueryKeyName) {
        this.getSourceToTargetQueryKeyNames().put(sourceForeignKeyField, targetQueryKeyName);
        this.getForeignKeyFields().addElement(sourceForeignKeyField);
        this.setIsForeignKeyRelationship(true);
    }

    public void addForeignQueryKeyName(String sourceForeignKeyFieldName, String targetQueryKeyName) {
        this.addForeignQueryKeyName(new DatabaseField(sourceForeignKeyFieldName), targetQueryKeyName);
    }

    public void addTargetForeignQueryKeyName(String targetForeignQueryKeyName, String sourcePrimaryKeyFieldName) {
        DatabaseField sourceField = new DatabaseField(sourcePrimaryKeyFieldName);
        this.getSourceToTargetQueryKeyNames().put(sourceField, targetForeignQueryKeyName);
    }

    protected Object batchedValueFromRow(AbstractRecord row, ObjectLevelReadQuery query) {
        throw QueryException.batchReadingNotSupported(this, query);
    }

    public Object clone() {
        VariableOneToOneMapping clone = (VariableOneToOneMapping)super.clone();
        HashMap<DatabaseField, DatabaseField> setOfKeys = new HashMap<DatabaseField, DatabaseField>(this.getSourceToTargetQueryKeyNames().size());
        HashMap sourceToTarget = new HashMap(this.getSourceToTargetQueryKeyNames().size());
        NonSynchronizedVector foreignKeys = NonSynchronizedVector.newInstance(this.getForeignKeyFields().size());
        if (this.getTypeField() != null) {
            clone.setTypeField((DatabaseField)this.getTypeField().clone());
        }
        for (DatabaseField field : this.getSourceToTargetQueryKeyNames().keySet()) {
            DatabaseField clonedField = (DatabaseField)field.clone();
            setOfKeys.put(field, clonedField);
            sourceToTarget.put(clonedField, this.getSourceToTargetQueryKeyNames().get(field));
        }
        Enumeration<DatabaseField> enumtr = this.getForeignKeyFields().elements();
        while (enumtr.hasMoreElements()) {
            DatabaseField field;
            field = (DatabaseField)enumtr.nextElement();
            ((Vector)foreignKeys).addElement(setOfKeys.get(field));
        }
        clone.setSourceToTargetQueryKeyFields(sourceToTarget);
        clone.setForeignKeyFields(foreignKeys);
        clone.setTypeIndicatorTranslation(new HashMap(this.getTypeIndicatorTranslation()));
        return clone;
    }

    protected Vector collectFields() {
        DatabaseField type = this.getTypeField();
        if (type != null) {
            Vector sourceFields = (Vector)this.getForeignKeyFields().clone();
            sourceFields.addElement(type);
            return sourceFields;
        }
        return this.getForeignKeyFields();
    }

    protected boolean compareObjectsWithoutPrivateOwned(Object firstObject, Object secondObject, AbstractSession session) {
        Object firstPrivateObject = this.getRealAttributeValueFromObject(firstObject, session);
        Object secondPrivateObject = this.getRealAttributeValueFromObject(secondObject, session);
        if (firstPrivateObject == null && secondPrivateObject == null) {
            return true;
        }
        if (firstPrivateObject == null || secondPrivateObject == null) {
            return false;
        }
        if (firstPrivateObject.getClass() != secondPrivateObject.getClass()) {
            return false;
        }
        Iterator targetKeys = this.getSourceToTargetQueryKeyNames().values().iterator();
        ClassDescriptor descriptor = session.getDescriptor(firstPrivateObject.getClass());
        ClassDescriptor descriptor2 = session.getDescriptor(secondPrivateObject.getClass());
        while (targetKeys.hasNext()) {
            String queryKey = (String)targetKeys.next();
            DatabaseField field = descriptor.getObjectBuilder().getFieldForQueryKeyName(queryKey);
            Object firstObjectField = descriptor.getObjectBuilder().extractValueFromObjectForField(firstPrivateObject, field, session);
            DatabaseField field2 = descriptor2.getObjectBuilder().getFieldForQueryKeyName(queryKey);
            Object secondObjectField = descriptor2.getObjectBuilder().extractValueFromObjectForField(secondPrivateObject, field2, session);
            if (firstObjectField == null && secondObjectField == null) continue;
            if (firstObjectField == null || secondObjectField == null) {
                return false;
            }
            if (firstObjectField.equals(secondObjectField)) continue;
            return false;
        }
        return true;
    }

    public Vector getClassIndicatorAssociations() {
        Vector<TypedAssociation> associations = new Vector<TypedAssociation>();
        Iterator classesEnum = this.getTypeIndicatorNameTranslation().keySet().iterator();
        Iterator valuesEnum = this.getTypeIndicatorNameTranslation().values().iterator();
        while (classesEnum.hasNext()) {
            Object className = classesEnum.next();
            if (className instanceof Class) {
                className = ((Class)className).getName();
            }
            Object value = valuesEnum.next();
            associations.addElement(new TypedAssociation(className, value));
        }
        return associations;
    }

    public ClassDescriptor getDescriptorForTarget(Object targetObject, AbstractSession session) {
        return session.getDescriptor(targetObject);
    }

    public Class getFieldClassification(DatabaseField fieldToClassify) {
        if (this.getTypeField() != null && fieldToClassify.equals(this.getTypeField())) {
            return this.getTypeField().getType();
        }
        String queryKey = (String)this.getSourceToTargetQueryKeyNames().get(fieldToClassify);
        if (queryKey == null) {
            return null;
        }
        Iterator iterator = this.getReferenceDescriptor().getInterfacePolicy().getChildDescriptors().iterator();
        if (iterator.hasNext()) {
            ClassDescriptor firstChild = (ClassDescriptor)iterator.next();
            DatabaseMapping mapping = firstChild.getObjectBuilder().getMappingForAttributeName(queryKey);
            if (mapping != null && mapping.isDirectToFieldMapping()) {
                return ((AbstractDirectMapping)mapping).getAttributeClassification();
            }
            QueryKey targetQueryKey = firstChild.getQueryKeyNamed(queryKey);
            if (targetQueryKey != null && targetQueryKey.isDirectQueryKey()) {
                return firstChild.getObjectBuilder().getFieldClassification(((DirectQueryKey)targetQueryKey).getField());
            }
        }
        return null;
    }

    public Vector getForeignKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getForeignKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getForeignKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    protected Object getImplementorForType(Object type, AbstractSession session) {
        if (type == null) {
            return this.getTypeIndicatorTranslation().get(Helper.getNullWrapper());
        }
        try {
            type = session.getDatasourcePlatform().convertObject(type, this.getTypeField().getType());
        }
        catch (ConversionException e) {
            throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
        }
        return this.getTypeIndicatorTranslation().get(type);
    }

    public Vector getSourceToTargetQueryKeyFieldAssociations() {
        Vector<Association> associations = new Vector<Association>(this.getSourceToTargetQueryKeyNames().size());
        Iterator sourceFieldEnum = this.getSourceToTargetQueryKeyNames().keySet().iterator();
        Iterator targetQueryKeyEnum = this.getSourceToTargetQueryKeyNames().values().iterator();
        while (sourceFieldEnum.hasNext()) {
            String fieldValue = ((DatabaseField)sourceFieldEnum.next()).getQualifiedName();
            Object attributeValue = targetQueryKeyEnum.next();
            associations.addElement(new Association(fieldValue, attributeValue));
        }
        return associations;
    }

    public Map getSourceToTargetQueryKeyNames() {
        return this.sourceToTargetQueryKeyNames;
    }

    public DatabaseField getTypeField() {
        return this.typeField;
    }

    public String getTypeFieldName() {
        if (this.getTypeField() == null) {
            return null;
        }
        return this.getTypeField().getQualifiedName();
    }

    protected Object getTypeForImplementor(Class implementor) {
        Object type = this.getTypeIndicatorTranslation().get(implementor);
        if (type == Helper.getNullWrapper()) {
            type = null;
        }
        return type;
    }

    public Map getTypeIndicatorTranslation() {
        return this.typeIndicatorTranslation;
    }

    public Map getTypeIndicatorNameTranslation() {
        if (this.typeIndicatorNameTranslation.isEmpty() && !this.typeIndicatorTranslation.isEmpty()) {
            Iterator keysEnum = this.typeIndicatorTranslation.keySet().iterator();
            Iterator valuesEnum = this.typeIndicatorTranslation.values().iterator();
            while (keysEnum.hasNext()) {
                Object key = keysEnum.next();
                Object value = valuesEnum.next();
                if (!(key instanceof Class)) continue;
                String className = ((Class)key).getName();
                this.typeIndicatorNameTranslation.put(className, value);
            }
        }
        return this.typeIndicatorNameTranslation;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        Iterator iterator = this.getTypeIndicatorNameTranslation().entrySet().iterator();
        this.typeIndicatorTranslation = new HashMap();
        while (iterator.hasNext()) {
            Class referenceClass;
            Object indicator;
            block6: {
                Map.Entry entry = iterator.next();
                String referenceClassName = (String)entry.getKey();
                indicator = entry.getValue();
                referenceClass = null;
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            referenceClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(referenceClassName, true, classLoader));
                            break block6;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(referenceClassName, exception.getException());
                        }
                    }
                    referenceClass = PrivilegedAccessHelper.getClassForName(referenceClassName, true, classLoader);
                }
                catch (ClassNotFoundException exception) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(referenceClassName, exception);
                }
            }
            this.addClassIndicator(referenceClass, indicator);
        }
    }

    public void initialize(AbstractSession session) {
        super.initialize(session);
        this.initializeForeignKeys(session);
        this.setFields(this.collectFields());
        if (this.getTypeField() != null) {
            this.setTypeField(this.getDescriptor().buildField(this.getTypeField()));
        }
        if (this.shouldInitializeSelectionCriteria()) {
            this.initializeSelectionCriteria(session);
        }
    }

    protected void initializeForeignKeys(AbstractSession session) {
        HashMap newSourceToTargetQueryKeyNames = new HashMap(this.getSourceToTargetQueryKeyNames().size());
        for (Map.Entry entry : this.getSourceToTargetQueryKeyNames().entrySet()) {
            DatabaseField field = this.getDescriptor().buildField((DatabaseField)entry.getKey());
            newSourceToTargetQueryKeyNames.put(field, entry.getValue());
        }
        this.sourceToTargetQueryKeyNames = newSourceToTargetQueryKeyNames;
    }

    public void initializeSelectionCriteria(AbstractSession session) {
        Expression selectionCriteria = null;
        ExpressionBuilder expBuilder = new ExpressionBuilder();
        for (DatabaseField sourceKey : this.getSourceToTargetQueryKeyNames().keySet()) {
            String target = (String)this.getSourceToTargetQueryKeyNames().get(sourceKey);
            Expression expression = expBuilder.getParameter(sourceKey).equal(expBuilder.get(target));
            if (selectionCriteria == null) {
                selectionCriteria = expression;
                continue;
            }
            selectionCriteria = expression.and(selectionCriteria);
        }
        this.setSelectionCriteria(selectionCriteria);
    }

    public boolean isVariableOneToOneMapping() {
        return true;
    }

    protected Object getPrimaryKeyForObject(Object object, AbstractSession session) {
        return session.getId(object);
    }

    public void preInitialize(AbstractSession session) throws DescriptorException {
        super.preInitialize(session);
        if (this.getTypeIndicatorTranslation().isEmpty()) {
            return;
        }
        Class<?> type = null;
        Iterator typeValuesEnum = this.getTypeIndicatorTranslation().values().iterator();
        while (typeValuesEnum.hasNext() && type == null) {
            Object value = typeValuesEnum.next();
            if (value == Helper.getNullWrapper() || value instanceof Class) continue;
            type = value.getClass();
        }
        this.getTypeField().setType(type);
    }

    public void rehashFieldDependancies(AbstractSession session) {
        this.setSourceToTargetQueryKeyFields(Helper.rehashMap(this.getSourceToTargetQueryKeyNames()));
    }

    public void setClassIndicatorAssociations(Vector classIndicatorAssociations) {
        this.setTypeIndicatorNameTranslation(new HashMap(classIndicatorAssociations.size() + 1));
        this.setTypeIndicatorTranslation(new HashMap(classIndicatorAssociations.size() * 2 + 1));
        Enumeration associationsEnum = classIndicatorAssociations.elements();
        while (associationsEnum.hasMoreElements()) {
            Association association = (Association)associationsEnum.nextElement();
            Object classValue = association.getKey();
            if (classValue instanceof Class) {
                this.addClassIndicator((Class)association.getKey(), association.getValue());
                continue;
            }
            this.addClassNameIndicator((String)association.getKey(), association.getValue());
        }
    }

    public void setForeignKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setForeignKeyFields(fields);
        if (!((Vector)fields).isEmpty()) {
            this.setIsForeignKeyRelationship(true);
        }
    }

    public void setForeignQueryKeyName(String sourceForeignKeyFieldName, String targetQueryKeyName) {
        this.addForeignQueryKeyName(sourceForeignKeyFieldName, targetQueryKeyName);
    }

    public void setSourceToTargetQueryKeyFieldAssociations(Vector sourceToTargetQueryKeyFieldAssociations) {
        this.setSourceToTargetQueryKeyFields(new HashMap(sourceToTargetQueryKeyFieldAssociations.size() + 1));
        Enumeration associationsEnum = sourceToTargetQueryKeyFieldAssociations.elements();
        while (associationsEnum.hasMoreElements()) {
            Association association = (Association)associationsEnum.nextElement();
            DatabaseField sourceField = new DatabaseField((String)association.getKey());
            String targetQueryKey = (String)association.getValue();
            this.getSourceToTargetQueryKeyNames().put(sourceField, targetQueryKey);
        }
    }

    protected void setSourceToTargetQueryKeyFields(Map sourceToTargetQueryKeyNames) {
        this.sourceToTargetQueryKeyNames = sourceToTargetQueryKeyNames;
    }

    public void setTypeField(DatabaseField typeField) {
        this.typeField = typeField;
    }

    public void setTypeFieldName(String typeFieldName) {
        this.setTypeField(new DatabaseField(typeFieldName));
    }

    protected void setTypeIndicatorTranslation(Map translations) {
        this.typeIndicatorTranslation = translations;
    }

    protected void setTypeIndicatorNameTranslation(Map translations) {
        this.typeIndicatorNameTranslation = translations;
    }

    public Object valueFromObject(Object object, DatabaseField field, AbstractSession session) {
        AbstractRecord referenceRow = this.getIndirectionPolicy().extractReferenceRow(this.getAttributeValueFromObject(object));
        if (referenceRow != null) {
            Object value = referenceRow.get(field);
            try {
                value = session.getDatasourcePlatform().convertObject(value, this.getFieldClassification(field));
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
            return value;
        }
        Object referenceObject = this.getRealAttributeValueFromObject(object, session);
        String queryKeyName = (String)this.getSourceToTargetQueryKeyNames().get(field);
        ClassDescriptor objectDescriptor = session.getDescriptor(referenceObject.getClass());
        DatabaseField targetField = objectDescriptor.getObjectBuilder().getTargetFieldForQueryKeyName(queryKeyName);
        if (targetField == null) {
            return null;
        }
        return objectDescriptor.getObjectBuilder().extractValueFromObjectForField(referenceObject, targetField, session);
    }

    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        for (DatabaseField field : this.getFields()) {
            if (row.get(field) != null) continue;
            return this.getIndirectionPolicy().nullValueFromRow();
        }
        if (this.getTypeField() != null) {
            if (sourceQuery.isObjectLevelReadQuery() && (((ObjectLevelReadQuery)sourceQuery).isAttributeBatchRead(this.descriptor, this.getAttributeName()) || sourceQuery.isReadAllQuery() && this.shouldUseBatchReading())) {
                return this.batchedValueFromRow(row, (ObjectLevelReadQuery)sourceQuery);
            }
            if (row.get(this.getTypeField()) == null) {
                return this.getIndirectionPolicy().nullValueFromRow();
            }
            Class implementerClass = (Class)this.getImplementorForType(row.get(this.getTypeField()), executionSession);
            ReadObjectQuery query = (ReadObjectQuery)this.getSelectionQuery().clone();
            query.setReferenceClass(implementerClass);
            query.setSelectionCriteria(this.getSelectionCriteria());
            query.setDescriptor(null);
            if (sourceQuery.isObjectLevelReadQuery() && (sourceQuery.shouldCascadeAllParts() || sourceQuery.shouldCascadePrivateParts() && this.isPrivateOwned() || sourceQuery.shouldCascadeByMapping() && this.cascadeRefresh)) {
                query.setShouldRefreshIdentityMapResult(sourceQuery.shouldRefreshIdentityMapResult());
                query.setCascadePolicy(sourceQuery.getCascadePolicy());
                query.setShouldMaintainCache(sourceQuery.shouldMaintainCache());
                if (((ObjectLevelReadQuery)sourceQuery).hasAsOfClause()) {
                    query.setAsOfClause(((ObjectLevelReadQuery)sourceQuery).getAsOfClause());
                }
                query.setQueryId(sourceQuery.getQueryId());
            }
            return this.getIndirectionPolicy().valueFromQuery(query, row, executionSession);
        }
        return super.valueFromRow(row, joinManager, sourceQuery, executionSession);
    }

    protected void writeFromNullObjectIntoRow(AbstractRecord record) {
        if (this.isReadOnly()) {
            return;
        }
        if (this.isForeignKeyRelationship()) {
            Enumeration<DatabaseField> foreignKeys = this.getForeignKeyFields().elements();
            while (foreignKeys.hasMoreElements()) {
                record.put(foreignKeys.nextElement(), (Object)null);
            }
        }
        if (this.getTypeField() != null) {
            record.put(this.getTypeField(), (Object)null);
        }
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord record, AbstractSession session, DatabaseMapping.WriteType writeType) {
        if (this.isReadOnly()) {
            return;
        }
        Object referenceObject = this.getRealAttributeValueFromObject(object, session);
        if (referenceObject == null) {
            this.writeFromNullObjectIntoRow(record);
        } else {
            if (this.isForeignKeyRelationship()) {
                Enumeration<DatabaseField> sourceFields = this.getForeignKeyFields().elements();
                ClassDescriptor descriptor = session.getDescriptor(referenceObject.getClass());
                while (sourceFields.hasMoreElements()) {
                    DatabaseField sourceKey = sourceFields.nextElement();
                    String targetQueryKey = (String)this.getSourceToTargetQueryKeyNames().get(sourceKey);
                    DatabaseField targetKeyField = descriptor.getObjectBuilder().getFieldForQueryKeyName(targetQueryKey);
                    if (targetKeyField == null) {
                        throw DescriptorException.variableOneToOneMappingIsNotDefinedProperly(this, descriptor, targetQueryKey);
                    }
                    Object referenceValue = descriptor.getObjectBuilder().extractValueFromObjectForField(referenceObject, targetKeyField, session);
                    record.put(sourceKey, referenceValue);
                }
            }
            if (this.getTypeField() != null) {
                record.put(this.getTypeField(), this.getTypeForImplementor(referenceObject.getClass()));
            }
        }
    }

    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord record, AbstractSession session, DatabaseMapping.WriteType writeType) {
        if (this.isReadOnly()) {
            return;
        }
        ObjectChangeSet changeSet = (ObjectChangeSet)((ObjectReferenceChangeRecord)changeRecord).getNewValue();
        if (changeSet == null) {
            this.writeFromNullObjectIntoRow(record);
        } else {
            Object referenceObject = changeSet.getUnitOfWorkClone();
            if (this.isForeignKeyRelationship()) {
                Enumeration<DatabaseField> sourceFields = this.getForeignKeyFields().elements();
                ClassDescriptor descriptor = session.getDescriptor(referenceObject.getClass());
                while (sourceFields.hasMoreElements()) {
                    DatabaseField sourceKey = sourceFields.nextElement();
                    String targetQueryKey = (String)this.getSourceToTargetQueryKeyNames().get(sourceKey);
                    DatabaseField targetKeyField = descriptor.getObjectBuilder().getFieldForQueryKeyName(targetQueryKey);
                    if (targetKeyField == null) {
                        throw DescriptorException.variableOneToOneMappingIsNotDefinedProperly(this, descriptor, targetQueryKey);
                    }
                    Object referenceValue = descriptor.getObjectBuilder().extractValueFromObjectForField(referenceObject, targetKeyField, session);
                    record.put(sourceKey, referenceValue);
                }
            }
            if (this.getTypeField() != null) {
                record.put(this.getTypeField(), this.getTypeForImplementor(referenceObject.getClass()));
            }
        }
    }

    public void writeFromObjectIntoRowForShallowInsert(Object object, AbstractRecord record, AbstractSession session) {
        this.writeFromNullObjectIntoRow(record);
    }

    public void writeFromObjectIntoRowForShallowInsertWithChangeRecord(ChangeRecord changeRecord, AbstractRecord record, AbstractSession session) {
        this.writeFromNullObjectIntoRow(record);
    }

    public void writeFromObjectIntoRowForWhereClause(ObjectLevelModifyQuery query, AbstractRecord record) {
        if (this.isReadOnly()) {
            return;
        }
        Object object = query.isDeleteObjectQuery() ? query.getObject() : query.getBackupClone();
        Object referenceObject = this.getRealAttributeValueFromObject(object, query.getSession());
        if (referenceObject == null) {
            this.writeFromNullObjectIntoRow(record);
        } else {
            if (this.isForeignKeyRelationship()) {
                Enumeration<DatabaseField> sourceFields = this.getForeignKeyFields().elements();
                ClassDescriptor descriptor = query.getSession().getDescriptor(referenceObject.getClass());
                while (sourceFields.hasMoreElements()) {
                    DatabaseField sourceKey = sourceFields.nextElement();
                    String targetQueryKey = (String)this.getSourceToTargetQueryKeyNames().get(sourceKey);
                    DatabaseField targetKeyField = descriptor.getObjectBuilder().getFieldForQueryKeyName(targetQueryKey);
                    if (targetKeyField == null) {
                        throw DescriptorException.variableOneToOneMappingIsNotDefinedProperly(this, descriptor, targetQueryKey);
                    }
                    Object referenceValue = descriptor.getObjectBuilder().extractValueFromObjectForField(referenceObject, targetKeyField, query.getSession());
                    record.put(sourceKey, referenceValue);
                }
            }
            if (this.getTypeField() != null) {
                record.put(this.getTypeField(), this.getTypeForImplementor(referenceObject.getClass()));
            }
        }
    }

    public void writeInsertFieldsIntoRow(AbstractRecord record, AbstractSession session) {
        this.writeFromNullObjectIntoRow(record);
    }
}

