/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.ReadQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchFetchPolicy
implements Serializable,
Cloneable {
    protected BatchFetchType type;
    protected int size;
    protected List<Expression> attributeExpressions;
    protected transient Map<DatabaseMapping, ReadQuery> mappingQueries;
    protected List<String> attributes;

    public BatchFetchPolicy() {
        this.type = BatchFetchType.JOIN;
    }

    public BatchFetchPolicy(BatchFetchType type) {
        this.type = type;
    }

    public BatchFetchPolicy clone() {
        try {
            return (BatchFetchPolicy)super.clone();
        }
        catch (CloneNotSupportedException error) {
            throw new InternalError(error.getMessage());
        }
    }

    public BatchFetchType getType() {
        return this.type;
    }

    public void setType(BatchFetchType type) {
        this.type = type;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public Map<DatabaseMapping, ReadQuery> getMappingQueries() {
        return this.mappingQueries;
    }

    public void setMappingQueries(Map<DatabaseMapping, ReadQuery> mappingQueries) {
        this.mappingQueries = mappingQueries;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<String> attributes) {
        this.attributes = attributes;
    }

    public void setAttributeExpressions(List<Expression> attributeExpressions) {
        this.attributeExpressions = attributeExpressions;
    }

    public List<Expression> getAttributeExpressions() {
        if (this.attributeExpressions == null) {
            this.attributeExpressions = new ArrayList<Expression>();
        }
        return this.attributeExpressions;
    }

    public boolean hasAttributes() {
        return this.attributeExpressions != null && !this.attributeExpressions.isEmpty();
    }

    public boolean isAttributeBatchRead(String attributeName) {
        if (this.attributeExpressions == null) {
            return false;
        }
        List<Expression> batchReadAttributeExpressions = this.attributeExpressions;
        int size = batchReadAttributeExpressions.size();
        for (int index = 0; index < size; ++index) {
            QueryKeyExpression expression = (QueryKeyExpression)batchReadAttributeExpressions.get(index);
            while (!expression.getBaseExpression().isExpressionBuilder()) {
                expression = (QueryKeyExpression)expression.getBaseExpression();
            }
            if (!expression.getName().equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    public boolean isAttributeBatchRead(ClassDescriptor mappingDescriptor, String attributeName) {
        if (this.attributeExpressions == null) {
            return false;
        }
        if (this.attributes != null) {
            return this.attributes.contains(attributeName);
        }
        return this.isAttributeBatchRead(attributeName);
    }
}

