/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.services.weblogic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheIdentityMap;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;
import org.eclipse.persistence.internal.identitymaps.HardCacheWeakIdentityMap;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.identitymaps.NoIdentityMap;
import org.eclipse.persistence.internal.identitymaps.SoftCacheWeakIdentityMap;
import org.eclipse.persistence.internal.identitymaps.SoftIdentityMap;
import org.eclipse.persistence.internal.identitymaps.WeakIdentityMap;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.logging.JavaLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.platform.server.wls.WebLogicPlatform;
import org.eclipse.persistence.services.RuntimeServices;
import org.eclipse.persistence.services.weblogic.ClassSummaryDetail;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DefaultConnector;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.tools.profiler.PerformanceProfiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebLogicRuntimeServices
extends RuntimeServices {
    private int deployedSessionProfileWeight;
    private SessionLog deployedSessionLog;
    public String objectName;
    private static final String EclipseLink_Product_Name = "EclipseLink";

    public WebLogicRuntimeServices() {
    }

    public WebLogicRuntimeServices(AbstractSession session) {
        this.session = session;
        this.updateDeploymentTimeData();
    }

    public WebLogicRuntimeServices(Locale locale) {
    }

    protected void setSession(AbstractSession newSession) {
        this.session = newSession;
        this.updateDeploymentTimeData();
    }

    protected void updateDeploymentTimeData() {
        this.deployedSessionLog = (SessionLog)((AbstractSessionLog)this.session.getSessionLog()).clone();
        this.deployedSessionProfileWeight = this.session.getProfiler() == null ? -1 : this.session.getProfiler().getProfileWeight();
    }

    public String getSessionName() {
        return this.getSession().getName();
    }

    public String getSessionType() {
        return Helper.getShortClassName(this.getSession().getClass());
    }

    public Object[][] getClassSummaryDetailsUsingFilter(String filter) {
        try {
            return this.tabularDataTo2DArray(this.buildClassSummaryDetailsUsingFilter(filter), new String[]{"Class Name", "Parent Class Name", "Cache Type", "Configured Size", "Current Size"});
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(7, "weblogic_mbean_runtime_exception", exception);
            return null;
        }
    }

    public ArrayList<ClassSummaryDetail> getClassSummaryDetailsUsingFilterArray(String filter) {
        if (filter == null) {
            return this.getClassSummaryDetailsArray();
        }
        try {
            Vector mappedClassNames = this.getMappedClassNamesUsingFilter(filter);
            ArrayList<ClassSummaryDetail> classSummaryDetails = new ArrayList<ClassSummaryDetail>();
            if (mappedClassNames.size() == 0) {
                return null;
            }
            for (int index = 0; index < mappedClassNames.size(); ++index) {
                String mappedClassName = (String)mappedClassNames.elementAt(index);
                classSummaryDetails.add((ClassSummaryDetail)((Object)this.buildLowlevelDetailsFor(mappedClassName)));
            }
            return classSummaryDetails;
        }
        catch (Exception openTypeException) {
            AbstractSessionLog.getLog().log(7, "weblogic_mbean_runtime_exception", openTypeException);
            openTypeException.printStackTrace();
            return null;
        }
    }

    public ArrayList<ClassSummaryDetail> getClassSummaryDetailsArray() {
        try {
            Vector mappedClassNames = this.getMappedClassNames();
            ArrayList<ClassSummaryDetail> classSummaryDetails = new ArrayList<ClassSummaryDetail>();
            if (mappedClassNames.size() == 0) {
                return null;
            }
            for (int index = 0; index < mappedClassNames.size(); ++index) {
                String mappedClassName = (String)mappedClassNames.elementAt(index);
                classSummaryDetails.add((ClassSummaryDetail)((Object)this.buildLowlevelDetailsFor(mappedClassName)));
            }
            return classSummaryDetails;
        }
        catch (Exception openTypeException) {
            AbstractSessionLog.getLog().log(7, "weblogic_mbean_runtime_exception", openTypeException);
            openTypeException.printStackTrace();
            return null;
        }
    }

    public Object[][] getClassSummaryDetails() {
        try {
            return this.tabularDataTo2DArray(this.buildClassSummaryDetails(), new String[]{"Class Name", "Parent Class Name", "Cache Type", "Configured Size", "Current Size"});
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(7, "weblogic_mbean_runtime_exception", exception);
            return null;
        }
    }

    private TabularData buildClassSummaryDetailsUsingFilter(String filter) {
        if (filter == null) {
            return this.buildClassSummaryDetails();
        }
        try {
            Vector mappedClassNames = this.getMappedClassNamesUsingFilter(filter);
            TabularDataSupport rowData = new TabularDataSupport(this.buildTabularTypeForClassSummaryDetails());
            if (mappedClassNames.size() == 0) {
                return null;
            }
            for (int index = 0; index < mappedClassNames.size(); ++index) {
                String mappedClassName = (String)mappedClassNames.elementAt(index);
                String[] key = new String[]{mappedClassName};
                rowData.put(key, this.buildDetailsFor(mappedClassName, rowData.getTabularType().getRowType()));
            }
            return rowData;
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(7, "weblogic_mbean_runtime_exception", exception);
            return null;
        }
    }

    private TabularData buildClassSummaryDetails() {
        try {
            Vector mappedClassNames = this.getMappedClassNames();
            TabularDataSupport rowData = new TabularDataSupport(this.buildTabularTypeForClassSummaryDetails());
            if (mappedClassNames.size() == 0) {
                return null;
            }
            for (int index = 0; index < mappedClassNames.size(); ++index) {
                String mappedClassName = (String)mappedClassNames.elementAt(index);
                String[] key = new String[]{mappedClassName};
                rowData.put(key, this.buildDetailsFor(mappedClassName, rowData.getTabularType().getRowType()));
            }
            return rowData;
        }
        catch (Exception exception) {
            AbstractSessionLog.getLog().log(7, "weblogic_mbean_runtime_exception", exception);
            return null;
        }
    }

    private Vector getMappedClassNames() {
        Hashtable<String, Boolean> alreadyAdded = new Hashtable<String, Boolean>();
        Vector<String> mappedClassNames = new Vector<String>();
        String mappedClassName = null;
        for (ClassDescriptor nextDescriptor : this.getSession().getProject().getDescriptors().values()) {
            if (nextDescriptor.getCMPPolicy() != null && nextDescriptor.getCMPPolicy().getMappedClass() != null) {
                mappedClassName = nextDescriptor.getCMPPolicy().getMappedClass().getName();
            }
            if (mappedClassName == null) {
                mappedClassName = nextDescriptor.getJavaClassName();
            }
            if (alreadyAdded.get(mappedClassName) == null) {
                alreadyAdded.put(mappedClassName, Boolean.TRUE);
                mappedClassNames.addElement(mappedClassName);
            }
            mappedClassName = null;
        }
        return mappedClassNames;
    }

    public Vector getMappedClassNamesUsingFilter(String filter) {
        Vector<String> outputVector = new Vector<String>();
        Vector mappedClassNames = this.getMappedClassNames();
        ArrayList<String> filters = new ArrayList<String>();
        StringTokenizer lineTokens = new StringTokenizer(filter, ",");
        while (lineTokens.hasMoreTokens()) {
            filters.add(lineTokens.nextToken());
        }
        for (int i = 0; i < mappedClassNames.size(); ++i) {
            String className = (String)mappedClassNames.get(i);
            String classNameLowerCase = ((String)mappedClassNames.get(i)).toLowerCase();
            for (int j = 0; j < filters.size(); ++j) {
                String filterValue = Helper.rightTrimString((String)filters.get(j)).trim().toLowerCase();
                if (filterValue.indexOf(42) == 0) {
                    filterValue = filterValue.substring(1);
                }
                try {
                    if (!classNameLowerCase.matches(new StringBuffer().append("^.*").append(filterValue).append(".*$").toString()) || outputVector.contains(className)) continue;
                    outputVector.add(className);
                    continue;
                }
                catch (PatternSyntaxException exception) {
                    AbstractSessionLog.getLog().log(1, "pattern_syntax_error", exception);
                }
            }
        }
        Collections.sort(outputVector);
        return outputVector;
    }

    private TabularType buildTabularTypeForClassSummaryDetails() throws OpenDataException {
        return new TabularType(this.getSessionName(), "Session description", this.buildCompositeTypeForClassSummaryDetails(), new String[]{"Class Name"});
    }

    private CompositeType buildCompositeTypeForClassSummaryDetails() throws OpenDataException {
        return new CompositeType("Class Details", "Details of class for Class Summary", new String[]{"Class Name", "Parent Class Name", "Cache Type", "Configured Size", "Current Size"}, new String[]{"Class Name", "Parent Class Name", "Cache Type", "Configured Size", "Current Size"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING});
    }

    private CompositeData buildDetailsFor(String mappedClassName, CompositeType detailsType) throws Exception {
        return new CompositeDataSupport(detailsType, this.buildLowlevelDetailsFor(mappedClassName));
    }

    private HashMap buildLowlevelDetailsFor(String mappedClassName) {
        Class mappedClass = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(mappedClassName, ClassConstants.CLASS);
        IdentityMap identityMap = this.getSession().getIdentityMapAccessorInstance().getIdentityMap(mappedClass);
        ClassDescriptor descriptor = this.getSession().getProject().getDescriptor(mappedClass);
        String cacheType = this.getCacheTypeFor(identityMap.getClass());
        String configuredSize = "" + identityMap.getMaxSize();
        String currentSize = "";
        currentSize = "" + identityMap.getSize(mappedClass, true);
        String parentClassName = "";
        boolean isChildDescriptor = descriptor.isChildDescriptor();
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Class Name", mappedClassName);
        details.put("Cache Type", isChildDescriptor ? "" : cacheType);
        details.put("Configured Size", isChildDescriptor ? "" : configuredSize);
        details.put("Current Size", currentSize);
        if (descriptor.hasInheritance() && descriptor.getInheritancePolicy().getParentDescriptor() != null) {
            parentClassName = descriptor.getInheritancePolicy().getParentClassName();
        }
        details.put("Parent Class Name", parentClassName);
        return details;
    }

    private ClassSummaryDetail buildLowlevelDetailsForNew(String mappedClassName) {
        Class mappedClass = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(mappedClassName, ClassConstants.CLASS);
        IdentityMap identityMap = this.getSession().getIdentityMapAccessorInstance().getIdentityMap(mappedClass);
        ClassDescriptor descriptor = this.getSession().getProject().getDescriptor(mappedClass);
        String cacheType = this.getCacheTypeFor(identityMap.getClass());
        String configuredSize = "" + identityMap.getMaxSize();
        String currentSize = "";
        currentSize = "" + identityMap.getSize(mappedClass, true);
        String parentClassName = "";
        boolean isChildDescriptor = descriptor.isChildDescriptor();
        ClassSummaryDetail details = new ClassSummaryDetail(mappedClassName, isChildDescriptor ? "" : cacheType, isChildDescriptor ? "" : configuredSize, currentSize, parentClassName);
        return details;
    }

    private String getCacheTypeFor(Class identityMapClass) {
        if (identityMapClass == CacheIdentityMap.class) {
            return "Cache";
        }
        if (identityMapClass == FullIdentityMap.class) {
            return "Full";
        }
        if (identityMapClass == HardCacheWeakIdentityMap.class) {
            return "HardWeak";
        }
        if (identityMapClass == NoIdentityMap.class) {
            return "None";
        }
        if (identityMapClass == SoftCacheWeakIdentityMap.class) {
            return "SoftWeak";
        }
        if (identityMapClass == WeakIdentityMap.class) {
            return "Weak";
        }
        if (identityMapClass == SoftIdentityMap.class) {
            return "Soft";
        }
        return "N/A";
    }

    public String getModuleName() {
        return ((DatabaseSessionImpl)this.getSession()).getServerPlatform().getModuleName();
    }

    public String getApplicationName() {
        return ((WebLogicPlatform)((DatabaseSessionImpl)this.getSession()).getServerPlatform()).getApplicationName();
    }

    public String getDeployedEclipseLinkLogLevel() {
        return this.getNameForLogLevel(this.deployedSessionLog.getLevel());
    }

    public String getCurrentEclipseLinkLogLevel() {
        return this.getNameForLogLevel(this.getSession().getSessionLog().getLevel());
    }

    public synchronized void setCurrentEclipseLinkLogLevel(String newLevel) {
        this.getSession().setLogLevel(this.getLogLevelForName(newLevel));
    }

    private String getNameForLogLevel(int logLevel) {
        switch (logLevel) {
            case 0: {
                return "ALL";
            }
            case 7: {
                return "SEVERE";
            }
            case 6: {
                return "WARNING";
            }
            case 5: {
                return "INFO";
            }
            case 4: {
                return "CONFIG";
            }
            case 3: {
                return "FINE";
            }
            case 2: {
                return "FINER";
            }
            case 1: {
                return "FINEST";
            }
            case 8: {
                return "OFF";
            }
        }
        return "N/A";
    }

    private int getLogLevelForName(String levelName) {
        if (levelName.equals("ALL")) {
            return 0;
        }
        if (levelName.equals("SEVERE")) {
            return 7;
        }
        if (levelName.equals("WARNING")) {
            return 6;
        }
        if (levelName.equals("INFO")) {
            return 5;
        }
        if (levelName.equals("CONFIG")) {
            return 4;
        }
        if (levelName.equals("FINE")) {
            return 3;
        }
        if (levelName.equals("FINER")) {
            return 2;
        }
        if (levelName.equals("FINEST")) {
            return 1;
        }
        return 8;
    }

    public synchronized String getProfilingType() {
        if (this.getUsesEclipseLinkProfiling().booleanValue()) {
            return EclipseLink_Product_Name;
        }
        return "None";
    }

    public synchronized void setProfilingType(String profileType) {
        if (profileType == null || profileType.compareToIgnoreCase("None") == 0) {
            this.setUseNoProfiling();
        } else if (profileType.compareToIgnoreCase(EclipseLink_Product_Name) == 0) {
            this.setUseEclipseLinkProfiling();
        }
    }

    public void setUseEclipseLinkProfiling() {
        if (this.getUsesEclipseLinkProfiling().booleanValue()) {
            return;
        }
        this.getSession().setProfiler(new PerformanceProfiler());
    }

    public Boolean getUsesEclipseLinkProfiling() {
        return this.getSession().getProfiler() instanceof PerformanceProfiler;
    }

    public void setUseNoProfiling() {
        this.getSession().setProfiler(null);
    }

    public Boolean getShouldBindAllParameters() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return Boolean.FALSE;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).shouldBindAllParameters();
    }

    public Integer getStringBindingSize() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return new Integer(0);
        }
        if (!((DatabaseLogin)this.getSession().getDatasourceLogin()).getPlatform().usesStringBinding()) {
            return new Integer(0);
        }
        return new Integer(((DatabaseLogin)this.getSession().getDatasourceLogin()).getStringBindingSize());
    }

    public Boolean getUsesBatchWriting() {
        return this.getSession().getDatasourceLogin().getPlatform().usesBatchWriting();
    }

    public Long getTimeConnectionEstablished() {
        return new Long(((DatabaseSessionImpl)this.getSession()).getConnectedTime());
    }

    public Boolean getUsesJDBCBatchWriting() {
        return this.getSession().getDatasourceLogin().getPlatform().usesJDBCBatchWriting();
    }

    public Boolean getUsesByteArrayBinding() {
        return this.getSession().getDatasourceLogin().getPlatform().usesByteArrayBinding();
    }

    public Boolean getUsesNativeSQL() {
        return this.getSession().getDatasourceLogin().getPlatform().usesNativeSQL();
    }

    public Boolean getUsesStreamsForBinding() {
        return this.getSession().getDatasourceLogin().getPlatform().usesStreamsForBinding();
    }

    public Boolean getUsesStringBinding() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return Boolean.FALSE;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).getPlatform().usesStringBinding();
    }

    @Override
    public boolean getShouldCacheAllStatements() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return Boolean.FALSE;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).shouldCacheAllStatements();
    }

    @Override
    public int getStatementCacheSize() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return 0;
        }
        return new Integer(((DatabaseLogin)this.getSession().getDatasourceLogin()).getStatementCacheSize());
    }

    public synchronized void clearStatementCache() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseAccessor)this.getSession().getAccessor()).clearStatementCache(this.getSession());
        ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_statement_cache_cleared");
    }

    @Override
    public int getSequencePreallocationSize() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return 0;
        }
        return ((DatasourcePlatform)this.getSession().getDatasourcePlatform()).getSequencePreallocationSize();
    }

    public void printAvailableConnectionPools() {
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass())) {
            Map pools = ((ServerSession)this.getSession()).getConnectionPools();
            Iterator poolNames = pools.keySet().iterator();
            while (poolNames.hasNext()) {
                String poolName = poolNames.next().toString();
                ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_pool_name", poolName);
            }
        } else {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_no_connection_pools_available");
        }
    }

    public Integer getMaxSizeForPool(String poolName) {
        ConnectionPool connectionPool;
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass()) && (connectionPool = ((ServerSession)this.getSession()).getConnectionPool(poolName)) != null) {
            return new Integer(connectionPool.getMaxNumberOfConnections());
        }
        return new Integer(-1);
    }

    public Integer getMinSizeForPool(String poolName) {
        ConnectionPool connectionPool;
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass()) && (connectionPool = ((ServerSession)this.getSession()).getConnectionPool(poolName)) != null) {
            return new Integer(connectionPool.getMinNumberOfConnections());
        }
        return new Integer(-1);
    }

    @Override
    public synchronized void resetAllConnections() {
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass())) {
            for (ConnectionPool pool : ((ServerSession)this.getSession()).getConnectionPools().values()) {
                pool.shutDown();
                pool.startUp();
            }
        } else if (ClassConstants.PublicInterfaceDatabaseSession_Class.isAssignableFrom(this.getSession().getClass())) {
            this.getSession().getAccessor().reestablishConnection(this.getSession());
        }
    }

    public void printClassesInSession() {
        Vector classes = this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().getClassesRegistered();
        if (classes.isEmpty()) {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_no_classes_in_session");
            return;
        }
        for (int index = 0; index < classes.size(); ++index) {
            this.getSession().getSessionLog().log(1, (String)classes.elementAt(index));
        }
    }

    public void printObjectsInIdentityMap(String className) throws ClassNotFoundException {
        Class classWithMap = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(className, ClassConstants.CLASS);
        IdentityMap map = this.getSession().getIdentityMapAccessorInstance().getIdentityMap(classWithMap);
        if (null == map) {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_identity_map_non_existent", className);
            return;
        }
        Enumeration objects = map.keys();
        if (!objects.hasMoreElements()) {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_identity_map_empty", className);
        }
        while (objects.hasMoreElements()) {
            CacheKey cacheKey = (CacheKey)objects.nextElement();
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_print_cache_key_value", cacheKey.getKey().toString(), cacheKey.getObject().toString());
        }
    }

    public void printAllIdentityMapTypes() {
        Vector classesRegistered = this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().getClassesRegistered();
        if (classesRegistered.size() == 0) {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_no_identity_maps_in_session");
            return;
        }
        for (int index = 0; index < classesRegistered.size(); ++index) {
            String registeredClassName = (String)classesRegistered.elementAt(index);
            Class registeredClass = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(registeredClassName, ClassConstants.CLASS);
            IdentityMap map = this.getSession().getIdentityMapAccessorInstance().getIdentityMap(registeredClass);
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_identity_map_class", registeredClassName, map.getClass());
        }
    }

    public void printObjectsInIdentityMaps() {
        Vector classesRegistered = this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().getClassesRegistered();
        if (classesRegistered.size() == 0) {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_no_identity_maps_in_session");
            return;
        }
        for (int index = 0; index < classesRegistered.size(); ++index) {
            String registeredClassName = (String)classesRegistered.elementAt(index);
            try {
                this.printObjectsInIdentityMap(registeredClassName);
                continue;
            }
            catch (ClassNotFoundException classNotFound) {
                classNotFound.printStackTrace();
                AbstractSessionLog.getLog().log(7, "weblogic_mbean_runtime_exception", classNotFound);
            }
        }
    }

    @Override
    public Integer getNumberOfObjectsInIdentityMap(String className) throws ClassNotFoundException {
        Class classWithIdentityMap = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(className, ClassConstants.CLASS);
        Class rootClass = null;
        ClassDescriptor descriptor = this.getSession().getDescriptor(classWithIdentityMap);
        ClassDescriptor rootDescriptor = descriptor.hasInheritance() ? descriptor.getInheritancePolicy().getRootParentDescriptor() : descriptor;
        if (rootDescriptor.getCMPPolicy() != null && rootDescriptor.getCMPPolicy().getMappedClass() != null) {
            rootClass = rootDescriptor.getCMPPolicy().getMappedClass();
        }
        if (rootClass == null) {
            rootClass = rootDescriptor.getJavaClass();
        }
        return new Integer(this.getSession().getIdentityMapAccessorInstance().getIdentityMap(rootClass).getSize(rootClass, true));
    }

    public Integer getNumberOfObjectsInAllIdentityMaps() {
        Vector classesRegistered = this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().getClassesRegistered();
        int sum = 0;
        if (classesRegistered.size() == 0) {
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_no_identity_maps_in_session");
            return new Integer(0);
        }
        for (int index = 0; index < classesRegistered.size(); ++index) {
            String registeredClassName = (String)classesRegistered.elementAt(index);
            try {
                sum += this.getNumberOfObjectsInIdentityMap(registeredClassName).intValue();
                continue;
            }
            catch (ClassNotFoundException classNotFound) {
                classNotFound.printStackTrace();
                AbstractSessionLog.getLog().log(7, "weblogic_mbean_runtime_exception", classNotFound);
            }
        }
        return new Integer(sum);
    }

    public Integer getNumberOfPersistentClasses() {
        Hashtable<String, Boolean> classesTable = new Hashtable<String, Boolean>();
        for (ClassDescriptor currentDescriptor : this.getSession().getProject().getDescriptors().values()) {
            if (currentDescriptor.isAggregateDescriptor()) continue;
            classesTable.put(currentDescriptor.getJavaClassName(), Boolean.TRUE);
        }
        return new Integer(classesTable.size());
    }

    public void printIdentityMapLocks() {
        this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().printLocks();
    }

    public void printIdentityMapLocks(String registeredClassName) {
        Class registeredClass = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(registeredClassName, ClassConstants.CLASS);
        this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().printLocks(registeredClass);
    }

    public void printProfileSummary() {
        if (!this.getUsesEclipseLinkProfiling().booleanValue()) {
            return;
        }
        PerformanceProfiler performanceProfiler = (PerformanceProfiler)this.getSession().getProfiler();
        this.getSession().getSessionLog().info(performanceProfiler.buildProfileSummary().toString());
    }

    private String trimProfileString(String originalProfileString) {
        if (originalProfileString.length() > 1) {
            String trimmedString = originalProfileString.substring(0, originalProfileString.length());
            if (trimmedString.charAt(0) == '{' && trimmedString.charAt(trimmedString.length() - 1) == '}') {
                trimmedString = trimmedString.substring(1, trimmedString.length() - 1);
            }
            return trimmedString;
        }
        return originalProfileString;
    }

    public void printProfileSummaryByClass() {
        if (!this.getUsesEclipseLinkProfiling().booleanValue()) {
            return;
        }
        PerformanceProfiler performanceProfiler = (PerformanceProfiler)this.getSession().getProfiler();
        this.getSession().getSessionLog().info(this.trimProfileString(performanceProfiler.buildProfileSummaryByClass().toString()));
    }

    public void printProfileSummaryByQuery() {
        if (!this.getUsesEclipseLinkProfiling().booleanValue()) {
            return;
        }
        PerformanceProfiler performanceProfiler = (PerformanceProfiler)this.getSession().getProfiler();
        this.getSession().getSessionLog().info(this.trimProfileString(performanceProfiler.buildProfileSummaryByQuery().toString()));
    }

    public String getLogType() {
        if (this.getSession().getSessionLog().getClass() == JavaLog.class) {
            return "Java";
        }
        return EclipseLink_Product_Name;
    }

    public String getDatabasePlatform() {
        return this.getSession().getDatasourcePlatform().getClass().getName();
    }

    public synchronized String getJdbcConnectionDetails() {
        return this.getSession().getLogin().getConnector().getConnectionDetails();
    }

    public synchronized String getConnectionPoolType() {
        if (this.getSession().getLogin().shouldUseExternalConnectionPooling()) {
            return "External";
        }
        return "N/A";
    }

    public synchronized String getDriver() {
        if (this.getSession().getLogin().getConnector() instanceof DefaultConnector) {
            return this.getSession().getLogin().getDriverClassName();
        }
        return "N/A";
    }

    public String getLogFilename() {
        if (this.getLogType().equals(EclipseLink_Product_Name) && this.session.getSessionLog() instanceof DefaultSessionLog) {
            return ((DefaultSessionLog)this.session.getSessionLog()).getWriterFilename();
        }
        return null;
    }

    public synchronized void initializeAllIdentityMaps() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public synchronized void initializeIdentityMaps(String[] classNames) throws ClassNotFoundException {
        for (int index = 0; index < classNames.length; ++index) {
            this.initializeIdentityMap(classNames[index]);
        }
    }

    public synchronized void initializeIdentityMap(String className) throws ClassNotFoundException {
        Class registeredClass = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(className, ClassConstants.CLASS);
        this.getSession().getIdentityMapAccessor().initializeIdentityMap(registeredClass);
        ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_identity_map_initialized", className);
    }

    public synchronized void invalidateAllIdentityMaps() {
        Vector classesRegistered = this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().getClassesRegistered();
        if (classesRegistered.isEmpty()) {
            this.getSession().getSessionLog().info("There are no Identity Maps in this session");
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_no_identity_maps_in_session");
        }
        for (int index = 0; index < classesRegistered.size(); ++index) {
            String registeredClassName = (String)classesRegistered.elementAt(index);
            Class registeredClass = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(registeredClassName, ClassConstants.CLASS);
            this.getSession().getIdentityMapAccessor().invalidateClass(registeredClass);
            ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_identity_map_invalidated", registeredClassName);
        }
    }

    public synchronized void invalidateIdentityMaps(String[] classNamesParam, Boolean recurse) throws ClassNotFoundException {
        String[] classNames = classNamesParam;
        for (int index = 0; index < classNames.length; ++index) {
            this.invalidateIdentityMap(classNames[index], recurse);
        }
    }

    public synchronized void invalidateIdentityMap(String className) throws ClassNotFoundException {
        this.invalidateIdentityMap(className, Boolean.FALSE);
    }

    public synchronized void invalidateIdentityMap(String className, Boolean recurse) throws ClassNotFoundException {
        Class registeredClass = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(className, ClassConstants.CLASS);
        this.getSession().getIdentityMapAccessor().invalidateClass(registeredClass);
        ((AbstractSession)this.session).log(5, "server", "jmx_mbean_runtime_services_identity_map_invalidated", className);
    }

    private Object[][] tabularDataTo2DArray(TabularData tdata, String[] names) throws Exception {
        if (tdata == null) {
            return null;
        }
        Object[] rows = tdata.values().toArray();
        Object[][] data = new Object[rows.length][];
        for (int i = 0; i < rows.length; ++i) {
            data[i] = ((CompositeData)rows[i]).getAll(names);
        }
        return data;
    }

    public boolean isJPASession() {
        return true;
    }
}

