/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.ui.view;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.ui.view.InstanceServicesComposite;
import org.eclipse.sequoyah.device.framework.ui.view.InstanceStatusComposite;
import org.eclipse.sequoyah.device.framework.ui.view.Messages;
import org.eclipse.sequoyah.device.framework.ui.view.model.InstanceSelectionChangeEvent;
import org.eclipse.sequoyah.device.framework.ui.view.model.InstanceSelectionChangeListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class InstanceMgtView
extends ViewPart {
    private static final Set<InstanceSelectionChangeListener> listeners = new LinkedHashSet<InstanceSelectionChangeListener>();
    private static InstanceServicesComposite instanceServicesComposite = null;
    private static IInstance selectedInstance = null;
    private static InstanceStatusComposite topComposite;
    private static InstanceSelectionChangeListener selectionChangeListener;
    private static SashForm form;
    private static String contextId;
    private boolean useDropDown = false;
    private String viewLayout = "vertical";
    private static final String LAYOUT_HORIZONTAL = "horizontal";
    private static final String LAYOUT_VERTICAL = "vertical";

    public static InstanceServicesComposite getInstanceServicesComposite() {
        return instanceServicesComposite;
    }

    public static void setHelp(String string) {
        contextId = string;
        if (form != null) {
            form.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, contextId);
                }
            });
        }
    }

    public void createPartControl(Composite composite) {
        Object object;
        IConfigurationElement[] iConfigurationElementArray;
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(Messages.InstanceMgtView_2);
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = iConfigurationElementArray2[n2];
            String string = object.getAttribute(Messages.InstanceMgtView_3);
            this.useDropDown = Boolean.parseBoolean(string);
            this.viewLayout = object.getAttribute(Messages.InstanceMgtView_4);
            ++n2;
        }
        form = LAYOUT_VERTICAL.equals(this.viewLayout) ? new SashForm(composite, 512) : new SashForm(composite, 256);
        form.setLayout((Layout)new FillLayout());
        topComposite = new InstanceStatusComposite((Composite)form, this.getViewSite(), this.useDropDown);
        topComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (selectionChangeListener != null) {
                    topComposite.removeInstanceSelectionChangeListener(selectionChangeListener);
                    topComposite.removeDisposeListener(this);
                    selectionChangeListener = null;
                }
            }
        });
        if (selectionChangeListener != null) {
            topComposite.removeInstanceSelectionChangeListener(selectionChangeListener);
        }
        if (!this.useDropDown) {
            object = new InstanceServicesComposite((Composite)form);
            instanceServicesComposite = object;
            form.setWeights(new int[]{60, 40});
            selectionChangeListener = new InstanceSelectionChangeListener((InstanceServicesComposite)((Object)object)){
                private final /* synthetic */ InstanceServicesComposite val$bottomComposite;
                {
                    this.val$bottomComposite = instanceServicesComposite;
                }

                public void instanceSelectionChanged(InstanceSelectionChangeEvent instanceSelectionChangeEvent) {
                    this.val$bottomComposite.setSelectedInstance(instanceSelectionChangeEvent.getInstance());
                }
            };
            topComposite.addInstanceSelectionChangeListener(selectionChangeListener);
        } else {
            form.setWeights(new int[]{100});
        }
        if (contextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, contextId);
        }
    }

    public void setFocus() {
        if (form != null) {
            form.setFocus();
        }
    }

    public static void setSeletectedInstance(IInstance iInstance) {
        selectedInstance = iInstance;
        if (topComposite != null) {
            topComposite.selectInstance(iInstance);
        }
    }

    public static IInstance getSelectedInstance() {
        if (topComposite != null) {
            return topComposite.getSelectedInstance();
        }
        return selectedInstance;
    }

    public static void addInstanceSelectionChangeListener(InstanceSelectionChangeListener instanceSelectionChangeListener) {
        listeners.add(instanceSelectionChangeListener);
    }

    public static void removeInstanceSelectionChangeListener(InstanceSelectionChangeListener instanceSelectionChangeListener) {
        listeners.remove(instanceSelectionChangeListener);
    }

    protected static void notifyInstanceSelectionChangeListeners(IInstance iInstance) {
        InstanceSelectionChangeEvent instanceSelectionChangeEvent = new InstanceSelectionChangeEvent(iInstance);
        for (InstanceSelectionChangeListener instanceSelectionChangeListener : listeners) {
            instanceSelectionChangeListener.instanceSelectionChanged(instanceSelectionChangeEvent);
        }
    }

    public void dispose() {
        if (topComposite != null) {
            topComposite.removeListener();
        }
        super.dispose();
    }
}

