/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.internal.ui.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rephraserengine.internal.ui.search.ISearchContentProvider;
import org.eclipse.rephraserengine.ui.search.SearchResult;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class SearchTreeContentProvider
implements ITreeContentProvider,
ISearchContentProvider {
    private TreeViewer viewer;
    private SearchResult result;
    private Map<Object, Set<Object>> tree = new HashMap<Object, Set<Object>>();

    public Object[] getChildren(Object parentElement) {
        Set<Object> children = this.tree.get(parentElement);
        if (children == null) {
            return new Object[0];
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        for (Object parent : this.tree.keySet()) {
            Set<Object> children = this.tree.get(parent);
            if (!children.contains(element)) continue;
            return parent;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.tree.get(element) != null;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren((Object)this.result);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)viewer;
        this.result = (SearchResult)((Object)newInput);
        this.tree.clear();
        if (this.result != null) {
            Object[] elements = this.result.getElements();
            int i = 0;
            while (i < elements.length) {
                this.insertSearchElement((IFile)elements[i]);
                ++i;
            }
        }
    }

    private void insertChild(Object parent, Object child) {
        Set<Object> children;
        Object l_parent = parent;
        if (l_parent == null) {
            l_parent = this.result;
        }
        if ((children = this.tree.get(l_parent)) == null) {
            children = new HashSet<Object>();
            this.tree.put(l_parent, children);
        }
        children.add(child);
    }

    private void insertSearchElement(IFile element) {
        IContainer l_cur = element.getParent();
        this.insertChild(l_cur, element);
        while (l_cur != null) {
            this.insertChild(l_cur.getParent(), l_cur);
            l_cur = l_cur.getParent();
        }
    }

    public void elementsChanged(Object[] elements) {
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                IFile element = (IFile)elements[i];
                if (this.result.getMatchCount(element) > 0) {
                    this.insertSearchElement(element);
                } else {
                    this.remove(element);
                }
                ++i;
            }
        }
        Display d = PlatformUI.getWorkbench().getDisplay();
        d.asyncExec(new Runnable(){

            public void run() {
                if (!SearchTreeContentProvider.this.viewer.getTree().isDisposed()) {
                    SearchTreeContentProvider.this.viewer.refresh();
                }
            }
        });
    }

    public void clear() {
        this.tree.clear();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                SearchTreeContentProvider.this.viewer.refresh();
            }
        });
    }

    protected void remove(Object element) {
        Object parent = this.getParent(element);
        if (parent == null) {
            return;
        }
        Set<Object> siblings = this.tree.get(parent);
        siblings.remove(element);
        if (siblings.isEmpty()) {
            this.remove(parent);
            this.tree.remove(parent);
        }
    }
}

