/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.internal.core.MakeTargetManager;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.etfw.IToolLaunchConfigurationConstants;
import org.eclipse.ptp.etfw.internal.ToolStep;
import org.eclipse.ptp.etfw.toolopts.BuildTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderTool
extends ToolStep
implements IToolLaunchConfigurationConstants {
    private String progPath = null;
    private boolean runbuilt = false;
    private IConfiguration newBuildConfig = null;
    private String buildConf = null;
    private IConfiguration olddefbuildconf = null;
    private IManagedBuildInfo buildInfo = null;
    private Map<String, String> buildMods = null;
    private String newname = null;
    private String binary = null;
    private BuildTool tool = null;
    private boolean isManaged;
    public IConfiguration selectedconf = null;

    public BuilderTool(ILaunchConfiguration conf, BuildTool btool, Map<String, String> buildMods) throws CoreException {
        super(conf, "Instrumenting/Building");
        this.buildMods = buildMods;
        this.tool = btool;
        this.initBuild(conf);
    }

    public BuilderTool(ILaunchConfiguration conf, BuildTool btool) throws CoreException {
        super(conf, "Instrumenting/Building");
        this.tool = btool;
        this.initBuild(conf);
    }

    private void initBuild(ILaunchConfiguration conf) throws CoreException {
        this.buildConf = this.configuration.getAttribute("ATTR_PERFORMANCEBUILD_CONFIGURATION_NAME", null);
        if (this.tool == null) {
            return;
        }
        this.buildInfo = ManagedBuildManager.getBuildInfo((IResource)this.thisCProject.getResource());
        this.olddefbuildconf = this.buildInfo.getDefaultConfiguration();
        this.isManaged = this.olddefbuildconf.isManagedBuildOn();
        this.runbuilt = this.isManaged ? this.initMMBuild() : this.initSMBuild();
    }

    public boolean getBuildSuccessful() {
        return this.runbuilt;
    }

    public String getOutputLocation() {
        return this.outputLocation;
    }

    public String getProgramPath() {
        return this.progPath;
    }

    public void buildIndstrumented(IProgressMonitor monitor) throws Exception {
        if (this.tool != null) {
            if (!this.isManaged) {
                this.standardMakeBuild(monitor);
            } else if (this.runbuilt) {
                this.runbuilt = this.initMMBuildConf();
                if (this.runbuilt) {
                    this.runbuilt = this.managedMakeBuild(monitor);
                }
            }
        }
    }

    public void standardMakeBuild(IProgressMonitor monitor) throws CoreException {
        File compilerInclude = new File(String.valueOf(this.projectLocation) + File.separator + "eclipse.inc");
        File compilerDef = new File(String.valueOf(this.projectLocation) + File.separator + "eclipse.inc.default");
        try {
            if (compilerInclude.exists()) {
                int len;
                FileInputStream in = new FileInputStream(compilerInclude);
                FileOutputStream out = new FileOutputStream(compilerDef);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
            BufferedWriter makeOut = new BufferedWriter(new FileWriter(compilerInclude));
            String allargs = this.getToolArguments(this.tool.getGlobalCompiler(), this.configuration);
            makeOut.write(String.valueOf(this.getToolCommand(this.tool.getCcCompiler(), this.configuration)) + " " + allargs + "\n");
            makeOut.write(String.valueOf(this.getToolCommand(this.tool.getCxxCompiler(), this.configuration)) + " " + allargs + "\n");
            makeOut.write(String.valueOf(this.getToolCommand(this.tool.getF90Compiler(), this.configuration)) + " " + allargs + "\n");
            makeOut.write(String.valueOf(this.getToolCommand(this.tool.getUPCCompiler(), this.configuration)) + " " + allargs + "\n");
            makeOut.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        MakeTargetManager targetMan = new MakeTargetManager();
        targetMan.startup();
        IMakeTarget[] targs = targetMan.getTargets((IContainer)this.thisProject);
        IMakeTarget select = null;
        int i = 0;
        while (i < targs.length) {
            if (targs[i].getName().equals("all")) {
                select = targs[i];
                break;
            }
            ++i;
        }
        if (select == null) {
            System.out.println("No Make Target: all");
            this.runbuilt = false;
            return;
        }
        select.build(monitor);
        targetMan.shutdown();
        if (compilerDef.exists()) {
            try {
                int len;
                FileInputStream in = new FileInputStream(compilerDef);
                FileOutputStream out = new FileOutputStream(compilerInclude);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.runbuilt = true;
    }

    private boolean initSMBuild() throws CoreException {
        if (this.buildInfo == null || !this.buildInfo.isValid()) {
            System.out.println("No info!!!");
            return false;
        }
        IConfiguration[] buildconfigs = this.buildInfo.getManagedProject().getConfigurations();
        int i = 0;
        while (i < buildconfigs.length) {
            if (buildconfigs[i].getName().equals(this.buildConf)) {
                IConfiguration cfr_ignored_0 = buildconfigs[i];
                break;
            }
            ++i;
        }
        this.progPath = this.olddefbuildconf.getEditableBuilder().getBuildLocation() + "?";
        this.progPath = String.valueOf(this.newname) + File.separator + this.binary;
        if (this.configuration.getAttribute("perf_executable_path_tag_for_path_value", null) != null) {
            this.outputLocation = this.thisProject.getFile(this.newname).getLocation().toOSString();
        }
        return true;
    }

    private boolean initMMBuild() throws CoreException {
        if (this.buildInfo == null || !this.buildInfo.isValid()) {
            System.out.println("No info!!!");
            return false;
        }
        IManagedProject managedBuildProj = this.buildInfo.getManagedProject();
        if (managedBuildProj == null) {
            System.out.println("No managed project!!!");
            return false;
        }
        this.binary = this.buildInfo.getBuildArtifactName();
        String bextension = this.buildInfo.getBuildArtifactExtension();
        if (bextension.length() > 0) {
            this.binary = String.valueOf(this.binary) + "." + bextension;
        }
        IConfiguration[] buildconfigs = this.buildInfo.getManagedProject().getConfigurations();
        int i = 0;
        while (i < buildconfigs.length) {
            if (buildconfigs[i].getName().equals(this.buildConf)) {
                this.selectedconf = buildconfigs[i];
                break;
            }
            ++i;
        }
        if (this.selectedconf == null) {
            System.out.println("No Conf Selected");
            return false;
        }
        if (this.selectedconf.getName() == null) {
            System.out.println("Selected conf has no name");
            return false;
        }
        String basename = this.selectedconf.getName();
        this.newname = null;
        String addname = this.configuration.getAttribute("performance_tool_build_configuration_name_modifier." + this.tool.toolID, "PerformanceAnalysis");
        this.newname = String.valueOf(basename) + "_" + addname;
        if (addname.equals("PerformanceAnalysis")) {
            String nameMod = this.tool.toolName;
            if (nameMod == null) {
                nameMod = this.tool.toolID;
            }
            this.newname = String.valueOf(this.newname) + "_" + nameMod;
        }
        this.progPath = String.valueOf(this.newname) + File.separator + this.binary;
        if (this.configuration.getAttribute("perf_executable_path_tag_for_path_value", null) != null) {
            this.outputLocation = this.thisProject.getFile(this.newname).getLocation().toOSString();
        }
        boolean confExists = false;
        IConfiguration[] confs = managedBuildProj.getConfigurations();
        int i2 = 0;
        while (i2 < confs.length) {
            if (confs[i2].getName().equals(this.newname) || confs[i2].getName().indexOf(this.newname) >= 0) {
                confExists = true;
                this.newBuildConfig = confs[i2];
                break;
            }
            ++i2;
        }
        if (!confExists) {
            this.newBuildConfig = managedBuildProj.createConfigurationClone(this.selectedconf, String.valueOf(this.selectedconf.getId()) + "." + ManagedBuildManager.getRandomNumber());
        }
        if (this.newBuildConfig == null) {
            System.out.println("No config!");
            return false;
        }
        return true;
    }

    public boolean initMMBuildConf() throws CoreException, FileNotFoundException {
        int n;
        ITool[] tools;
        if (!this.newBuildConfig.getName().equals(this.newname)) {
            this.newBuildConfig.setName(this.newname);
        }
        IToolChain chain = this.newBuildConfig.getToolChain();
        ITool[] iToolArray = tools = chain.getTools();
        int n2 = tools.length;
        int n3 = 0;
        while (n3 < n2) {
            ITool it = iToolArray[n3];
            IOption[] iOptionArray = it.getOptions();
            n = iOptionArray.length;
            int n4 = 0;
            while (n4 < n) {
                IOption op = iOptionArray[n4];
                if (op == null || op.getName() == null) {
                    // empty if block
                }
                ++n4;
            }
            ++n3;
        }
        String allargs = "";
        if (this.tool.getGlobalCompiler() != null && !this.tool.getGlobalCompiler().equals(this.tool.getCcCompiler())) {
            allargs = this.getToolArguments(this.tool.getGlobalCompiler(), this.configuration);
        }
        int numChanges = 0;
        int i = 0;
        while (i < tools.length) {
            String toolid;
            if (this.buildMods != null) {
                for (String opName : this.buildMods.keySet()) {
                    IOption[] iOptionArray = tools[i].getOptions();
                    int n5 = iOptionArray.length;
                    n = 0;
                    while (n < n5) {
                        IOption op = iOptionArray[n];
                        if (op.getName().equals(opName)) {
                            try {
                                op.setValue(this.buildMods.get(opName));
                            }
                            catch (BuildException e) {
                                e.printStackTrace();
                            }
                        }
                        ++n;
                    }
                }
            }
            if ((toolid = tools[i].getId()).indexOf(".c.") >= 0) {
                numChanges += BuilderTool.modifyCommand(tools[i], this.getToolCommand(this.tool.getCcCompiler(), this.configuration), allargs, this.tool.replaceCompiler);
            }
            if (toolid.indexOf(".cpp.") >= 0) {
                numChanges += BuilderTool.modifyCommand(tools[i], this.getToolCommand(this.tool.getCxxCompiler(), this.configuration), allargs, this.tool.replaceCompiler);
            }
            if (toolid.indexOf(".fortran.") >= 0) {
                numChanges += BuilderTool.modifyCommand(tools[i], this.getToolCommand(this.tool.getF90Compiler(), this.configuration), allargs, this.tool.replaceCompiler);
            }
            if (toolid.indexOf(".upc.") >= 0) {
                numChanges += BuilderTool.modifyCommand(tools[i], this.getToolCommand(this.tool.getUPCCompiler(), this.configuration), allargs, this.tool.replaceCompiler);
            }
            ++i;
        }
        if (numChanges > 0) {
            ManagedBuildManager.saveBuildInfo((IProject)this.thisCProject.getProject(), (boolean)true);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean managedMakeBuild(IProgressMonitor monitor) {
        programPath = this.thisProject.getFile(this.progPath);
        ManagedBuildManager.setDefaultConfiguration((IProject)this.thisCProject.getProject(), (IConfiguration)this.newBuildConfig);
        try {
            this.thisProject.build(6, monitor);
            if (true) ** GOTO lbl19
        }
        catch (Exception v0) {
            return false;
        }
        do {
            if (monitor != null && monitor.isCanceled()) {
                this.restoreBuild();
                this.runbuilt = false;
                throw new OperationCanceledException();
            }
            numMillisecondsToSleep = 1000L;
            try {
                Thread.sleep(numMillisecondsToSleep);
            }
            catch (InterruptedException v1) {}
            programPath = this.thisProject.getFile(this.progPath);
lbl19:
            // 2 sources

        } while (!programPath.exists() || !programPath.getLocation().toFile().exists());
        this.restoreBuild();
        return true;
    }

    private static int modifyCommand(ITool tool, String command, String args, boolean replace) {
        int didChange = 0;
        String toolCommand = tool.getToolCommand();
        if (replace) {
            String newcom = String.valueOf(command) + " " + args;
            if (!newcom.equals(toolCommand)) {
                tool.setToolCommand(String.valueOf(command) + " " + args);
                didChange = 1;
            }
        } else {
            String newcom;
            String oldcom = toolCommand.trim();
            int lastspc = oldcom.lastIndexOf(32);
            if (lastspc >= 0) {
                oldcom = toolCommand.substring(lastspc).trim();
            }
            if (!(newcom = String.valueOf(command) + " " + args + " " + oldcom).equals(toolCommand)) {
                tool.setToolCommand(newcom);
                didChange = 1;
            }
        }
        return didChange;
    }

    public void restoreBuild() {
        if (this.isManaged) {
            ManagedBuildManager.setDefaultConfiguration((IProject)this.thisCProject.getProject(), (IConfiguration)this.olddefbuildconf);
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.buildIndstrumented(monitor);
        }
        catch (Exception e) {
            return new Status(4, "com.ibm.jdg2e.concurrency", 4, "Build Incomplete", (Throwable)e);
        }
        return new Status(0, "com.ibm.jdg2e.concurrency", 0, "Build Successful", null);
    }
}

