/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.lexer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.photran.internal.core.lexer.ASTTokenFactory;
import org.eclipse.photran.internal.core.lexer.CPreprocessingInputStream;
import org.eclipse.photran.internal.core.lexer.CPreprocessorReplacement;
import org.eclipse.photran.internal.core.lexer.FreeFormLexerPhase1;
import org.eclipse.photran.internal.core.lexer.IPreprocessorReplacement;
import org.eclipse.photran.internal.core.lexer.IncludeMap;
import org.eclipse.photran.internal.core.lexer.LexerException;
import org.eclipse.photran.internal.core.lexer.LineAppendingInputStream;
import org.eclipse.photran.internal.core.lexer.ProducerMap;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.lexer.TokenFactory;
import org.eclipse.photran.internal.core.lexer.preprocessor.fortran_include.IncludeLoaderCallback;

public class CPreprocessingFreeFormLexerPhase1
extends FreeFormLexerPhase1 {
    private ProducerMap producerMap;
    private IncludeMap includeMap;
    private ArrayList<Token> processedTokensStack = new ArrayList();
    private Token nextRawToken = null;
    private Token lastToken = null;
    private Token lastReadInFile = null;

    public CPreprocessingFreeFormLexerPhase1(InputStream in, IFile file, String filename, IncludeLoaderCallback callback, boolean accumulateWhitetext) throws IOException {
        this(new CPreprocessingInputStream(file, filename, (InputStream)new LineAppendingInputStream(in)), file, filename, (TokenFactory)ASTTokenFactory.getInstance(), accumulateWhitetext);
    }

    private CPreprocessingFreeFormLexerPhase1(CPreprocessingInputStream cpp, IFile file, String filename, TokenFactory tokenFactory, boolean accumulateWhitetext) {
        super((InputStream)cpp, file, filename, tokenFactory, accumulateWhitetext);
        this.producerMap = cpp.getProducerMap();
        this.includeMap = cpp.getIncludeMap();
        if (!accumulateWhitetext) {
            throw new IllegalArgumentException("C preprocessor can only be used if accumulateWhitetext is true");
        }
    }

    public Token yylex() throws IOException, LexerException {
        Token token;
        if (this.lastReadInFile != null) {
            return this.lastReadInFile;
        }
        if (this.processedTokensStack.size() > 0) {
            Token token2;
            this.lastToken = token2 = this.processedTokensStack.remove(this.processedTokensStack.size() - 1);
            this.setTokenAsCurrent(token2);
            return token2;
        }
        if (this.nextRawToken != null) {
            token = this.nextRawToken;
            this.nextRawToken = null;
        } else {
            token = this.rawYYLex();
        }
        if (token.getTerminal() == Terminal.END_OF_INPUT) {
            if (this.lastToken != null) {
                String appendedWhite;
                String whiteAfter = this.lastToken.getWhiteAfter();
                int whiteStartOffset = this.lastToken.getStreamOffset() + this.lastToken.getText().length();
                int whiteEndOffset = whiteStartOffset + whiteAfter.length();
                if (whiteEndOffset > this.producerMap.getFinalOffset()) {
                    int newLength = this.producerMap.getFinalOffset() - whiteStartOffset;
                    whiteEndOffset = whiteStartOffset + newLength;
                    appendedWhite = whiteAfter.substring(newLength);
                    whiteAfter = whiteAfter.substring(0, newLength);
                } else {
                    appendedWhite = "";
                }
                this.producerMap.setMarkA(whiteStartOffset);
                this.producerMap.setMarkB(whiteEndOffset);
                String newWhiteAfter = this.producerMap.expandWhite(whiteAfter);
                if (newWhiteAfter != null) {
                    this.lastToken.setWhiteAfter(String.valueOf(newWhiteAfter) + appendedWhite);
                }
            }
            this.lastToken = token;
            this.setTokenAsCurrent(token);
            this.lastReadInFile = token;
            return token;
        }
        String whiteBefore = token.getWhiteBefore();
        this.producerMap.setMarkA(token.getStreamOffset() - whiteBefore.length());
        this.producerMap.setMarkB(token.getStreamOffset());
        String newWhiteBefore = this.producerMap.expandWhite(whiteBefore);
        if (newWhiteBefore != null) {
            token.setWhiteBefore(newWhiteBefore);
        }
        String text = token.getText();
        this.producerMap.setMarkA(token.getStreamOffset());
        this.producerMap.setMarkB(token.getStreamOffset() + text.length());
        if (this.producerMap.isMarkBInProducer()) {
            int strLen = token.getText().length();
            ArrayList<Token> postTokens = new ArrayList<Token>();
            do {
                Token postToken;
                if ((postToken = this.rawYYLex()).getTerminal() == Terminal.END_OF_INPUT || this.producerMap.isBreakAfterMarkB(postToken.getStreamOffset())) {
                    this.nextRawToken = postToken;
                    break;
                }
                whiteBefore = postToken.getWhiteBefore();
                postTokens.add(postToken);
                text = postToken.getText();
                this.producerMap.setMarkB(postToken.getStreamOffset() + text.length());
                strLen += whiteBefore.length() + text.length();
            } while (this.producerMap.isMarkBInProducer());
            StringBuffer buffer = new StringBuffer(strLen);
            buffer.append(token.getText());
            int i = 0;
            while (i < postTokens.size()) {
                Token postToken = (Token)postTokens.get(i);
                buffer.append(postToken.getWhiteBefore());
                buffer.append(postToken.getText());
                ++i;
            }
            CPreprocessorReplacement producer = CPreprocessorReplacement.createFor(this.producerMap.expandNormal(buffer.toString()));
            token.setPreprocessorDirective((IPreprocessorReplacement)producer);
            int i2 = postTokens.size() - 1;
            while (i2 >= 0) {
                Token postToken = (Token)postTokens.get(i2);
                postToken.setPreprocessorDirective((IPreprocessorReplacement)producer);
                this.processedTokensStack.add(postToken);
                --i2;
            }
        } else {
            CPreprocessorReplacement producer = CPreprocessorReplacement.createFor(this.producerMap.expandNormal(text));
            if (producer != null) {
                token.setPreprocessorDirective((IPreprocessorReplacement)producer);
            }
        }
        this.lastToken = token;
        this.setTokenAsCurrent(token);
        return token;
    }

    private Token rawYYLex() throws IOException, LexerException {
        Token token = (Token)super.yylex();
        this.includeMap.setStreamOffset(this.lastTokenStreamOffset);
        token.setLine(this.includeMap.getLine());
        token.setCol(this.includeMap.getCol());
        token.setPhysicalFile(this.includeMap.getFileOrIFile());
        token.setFileOffset(this.includeMap.getFileOffset());
        token.setStreamOffset(this.lastTokenStreamOffset);
        token.setLength(this.lastTokenLength);
        return token;
    }

    private void setTokenAsCurrent(Token token) {
        this.lastTokenLine = token.getLine();
        this.lastTokenCol = token.getCol();
        this.lastTokenFile = token.getPhysicalFile();
        this.lastTokenFileOffset = token.getFileOffset();
        this.lastTokenStreamOffset = token.getStreamOffset();
        this.lastTokenLength = token.getLength();
    }
}

