/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.preprocessor.c;

import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.photran.internal.core.preprocessor.c.LocationCtxFile;

class ASTFileLocation
implements IASTFileLocation {
    private LocationCtxFile fLocationCtx;
    private int fOffset;
    private int fLength;

    public ASTFileLocation(LocationCtxFile fileLocationCtx, int startOffset, int length) {
        this.fLocationCtx = fileLocationCtx;
        this.fOffset = startOffset;
        this.fLength = length;
    }

    public String getFileName() {
        return this.fLocationCtx.getFilePath();
    }

    public IASTFileLocation asFileLocation() {
        return this;
    }

    public int getNodeLength() {
        return this.fLength;
    }

    public int getNodeOffset() {
        return this.fOffset;
    }

    public int getEndingLineNumber() {
        int end = this.fLength > 0 ? this.fOffset + this.fLength - 1 : this.fOffset;
        return this.fLocationCtx.getLineNumber(end);
    }

    public int getStartingLineNumber() {
        return this.fLocationCtx.getLineNumber(this.fOffset);
    }

    public char[] getSource() {
        return this.fLocationCtx.getSource(this.fOffset, this.fLength);
    }

    public String toString() {
        return String.valueOf(this.getFileName()) + "[" + this.fOffset + "," + (this.fOffset + this.fLength) + ")";
    }

    public int getSequenceNumber() {
        return this.fLocationCtx.getSequenceNumberForOffset(this.fOffset, true);
    }

    public int getSequenceEndNumber() {
        return this.fLocationCtx.getSequenceNumberForOffset(this.fOffset + this.fLength, true);
    }

    public LocationCtxFile getLocationContext() {
        return this.fLocationCtx;
    }
}

