/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.preprocessor.c;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.photran.internal.core.preprocessor.c.ASTMacroExpansion;
import org.eclipse.photran.internal.core.preprocessor.c.ASTMacroExpansionLocation;
import org.eclipse.photran.internal.core.preprocessor.c.ASTMacroReferenceName;
import org.eclipse.photran.internal.core.preprocessor.c.ImageLocationInfo;
import org.eclipse.photran.internal.core.preprocessor.c.LocationCtx;
import org.eclipse.photran.internal.core.preprocessor.c.LocationCtxContainer;
import org.eclipse.photran.internal.core.preprocessor.c.LocationMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocationCtxMacroExpansion
extends LocationCtx {
    private final LocationMap fLocationMap;
    private final int fLength;
    private final ImageLocationInfo[] fLocationInfos;
    private ASTMacroReferenceName fExpansionName;

    public LocationCtxMacroExpansion(LocationMap map, LocationCtxContainer parent, int parentOffset, int parentEndOffset, int sequenceNumber, int length, ImageLocationInfo[] imageLocations, ASTMacroReferenceName expansionName) {
        super(parent, parentOffset, parentEndOffset, sequenceNumber);
        this.fLocationMap = map;
        this.fLength = length;
        this.fLocationInfos = imageLocations;
        this.fExpansionName = expansionName;
        if (!(expansionName.getParent() instanceof ASTMacroExpansion)) {
            throw new IllegalArgumentException(String.valueOf(expansionName.toString()) + " is not a macro expansion name");
        }
    }

    @Override
    public int getSequenceLength() {
        return this.fLength;
    }

    @Override
    public boolean collectLocations(int start, int length, ArrayList<IASTNodeLocation> locations) {
        int offset = start - this.fSequenceNumber;
        assert (offset >= 0 && length >= 0);
        if (offset + length <= this.fLength) {
            locations.add((IASTNodeLocation)new ASTMacroExpansionLocation(this, offset, length));
            return true;
        }
        locations.add((IASTNodeLocation)new ASTMacroExpansionLocation(this, offset, this.fLength - offset));
        return false;
    }

    public ASTMacroExpansion getExpansion() {
        return (ASTMacroExpansion)this.fExpansionName.getParent();
    }

    public ASTMacroReferenceName getMacroReference() {
        return this.fExpansionName;
    }

    @Override
    public LocationCtxMacroExpansion findEnclosingMacroExpansion(int sequenceNumber, int length) {
        return this;
    }

    public IASTImageLocation getImageLocation(int offset, int length) {
        if (length == 0) {
            return null;
        }
        int end = offset + length;
        int nextToCheck = offset;
        ImageLocationInfo firstInfo = null;
        ImageLocationInfo lastInfo = null;
        ImageLocationInfo[] imageLocationInfoArray = this.fLocationInfos;
        int n = this.fLocationInfos.length;
        int n2 = 0;
        while (n2 < n) {
            ImageLocationInfo info = imageLocationInfoArray[n2];
            if (info.fTokenOffsetInExpansion == nextToCheck) {
                if (firstInfo == null || lastInfo == null) {
                    firstInfo = lastInfo = info;
                } else if (lastInfo.canConcatenate(info)) {
                    lastInfo = info;
                } else {
                    return null;
                }
                if (++nextToCheck == end) {
                    return firstInfo.createLocation(this.fLocationMap, lastInfo);
                }
            } else if (info.fTokenOffsetInExpansion > nextToCheck) {
                return null;
            }
            ++n2;
        }
        return null;
    }
}

