/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.list.SimpleListProperty;
import org.eclipse.core.internal.databinding.beans.BeanPropertyHelper;
import org.eclipse.core.internal.databinding.beans.BeanPropertyListener;

public class BeanListProperty
extends SimpleListProperty {
    private final PropertyDescriptor propertyDescriptor;
    private final Class elementType;

    public BeanListProperty(PropertyDescriptor propertyDescriptor, Class elementType) {
        this.propertyDescriptor = propertyDescriptor;
        this.elementType = elementType == null ? BeanPropertyHelper.getCollectionPropertyElementType(propertyDescriptor) : elementType;
    }

    public Object getElementType() {
        return this.elementType;
    }

    protected List doGetList(Object source) {
        return this.asList(BeanPropertyHelper.readProperty(source, this.propertyDescriptor));
    }

    private List asList(Object propertyValue) {
        if (propertyValue == null) {
            return new ArrayList();
        }
        if (this.propertyDescriptor.getPropertyType().isArray()) {
            return new ArrayList<Object>(Arrays.asList((Object[])propertyValue));
        }
        return (List)propertyValue;
    }

    protected void doSetList(Object source, List list, ListDiff diff) {
        BeanPropertyHelper.writeProperty(source, this.propertyDescriptor, this.convertListToBeanPropertyType(list));
    }

    private Object convertListToBeanPropertyType(List list) {
        Object[] propertyValue = list;
        if (this.propertyDescriptor.getPropertyType().isArray()) {
            Class<?> componentType = this.propertyDescriptor.getPropertyType().getComponentType();
            Object[] array = (Object[])Array.newInstance(componentType, list.size());
            list.toArray(array);
            propertyValue = array;
        }
        return propertyValue;
    }

    public INativePropertyListener adaptListener(ISimplePropertyListener listener) {
        return new BeanPropertyListener((IProperty)this, this.propertyDescriptor, listener){

            protected IDiff computeDiff(Object oldValue, Object newValue) {
                return Diffs.computeListDiff((List)BeanListProperty.this.asList(oldValue), (List)BeanListProperty.this.asList(newValue));
            }
        };
    }

    public String toString() {
        String s = String.valueOf(BeanPropertyHelper.propertyName(this.propertyDescriptor)) + "[]";
        if (this.elementType != null) {
            s = String.valueOf(s) + "<" + BeanPropertyHelper.shortClassName(this.elementType) + ">";
        }
        return s;
    }
}

