/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.services.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ptp.services.ui.ServicesUIPlugin;
import org.eclipse.swt.graphics.Image;

public class ServiceModelImages {
    public static final URL ICON_URL = ServicesUIPlugin.getDefault().getBundle().getEntry("icons/etool16/");
    public static final String IMG_SERVICE = "service.gif";
    public static final String IMG_SERVICE_CATEGORY = "service-category.gif";
    public static final String IMG_SERVICE_DISABLED = "service-disabled.gif";
    private static ImageRegistry imageRegistry = null;

    static {
        ServiceModelImages.createImageDescriptor(ICON_URL, IMG_SERVICE, IMG_SERVICE);
        ServiceModelImages.createImageDescriptor(ICON_URL, IMG_SERVICE_CATEGORY, IMG_SERVICE_CATEGORY);
        ServiceModelImages.createImageDescriptor(ICON_URL, IMG_SERVICE_DISABLED, IMG_SERVICE_DISABLED);
    }

    public static ImageDescriptor createImageDescriptor(URL iconURL, String key, String name) {
        try {
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)ServiceModelImages.getIconURL(iconURL, name));
            ServiceModelImages.addImageDescriptor(key, imageDescriptor);
            return imageDescriptor;
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static Image getImage(String key) {
        return ServiceModelImages.getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return ServiceModelImages.getImageRegistry().getDescriptor(key);
    }

    private static void addImageDescriptor(String key, ImageDescriptor imageDescriptor) {
        ServiceModelImages.getImageRegistry().put(key, imageDescriptor);
    }

    private static URL getIconURL(URL baseURL, String name) throws MalformedURLException {
        if (baseURL == null) {
            throw new MalformedURLException();
        }
        return new URL(baseURL, name);
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }
}

